/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.core;

import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.core.SecurityHeaderBlock;
import com.sun.xml.wss.impl.misc.SOAPElementExtension;
import com.sun.xml.wss.impl.misc.SecurityHeaderBlockImpl;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.soap.Name;
import javax.xml.soap.Node;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;
import org.w3c.dom.TypeInfo;
import org.w3c.dom.UserDataHandler;

public class SecurityHeader
extends SOAPElementExtension
implements SOAPElement {
    private final SOAPElement delegateHeader;
    private Document ownerDoc;
    private static Logger log = Logger.getLogger("javax.enterprise.resource.xml.webservices.security", "com.sun.xml.wss.logging.LogStrings");
    private SOAPElement currentSoapElement;
    private SOAPElement topMostSoapElement;

    public SecurityHeader(SOAPElement delegateHeader) {
        this.delegateHeader = delegateHeader;
        this.ownerDoc = delegateHeader.getOwnerDocument();
        this.topMostSoapElement = this.getFirstChildElement();
        this.currentSoapElement = null;
    }

    public void insertHeaderBlock(SecurityHeaderBlock block) throws XWSSecurityException {
        SOAPElement elementToInsert = block.getAsSoapElement();
        try {
            if (elementToInsert.getOwnerDocument() != this.ownerDoc) {
                elementToInsert = (SOAPElement)this.ownerDoc.importNode((org.w3c.dom.Node)elementToInsert, true);
            }
            this.updateTopMostSoapElement();
            this.insertBefore((org.w3c.dom.Node)elementToInsert, (org.w3c.dom.Node)this.topMostSoapElement);
        }
        catch (DOMException e) {
            log.log(Level.SEVERE, "WSS0376.error.inserting.header", e.getMessage());
            throw new XWSSecurityException((Throwable)e);
        }
        this.topMostSoapElement = elementToInsert;
    }

    public void insertBefore(SecurityHeaderBlock block, org.w3c.dom.Node elem) throws XWSSecurityException {
        SOAPElement elementToInsert = block.getAsSoapElement();
        try {
            if (elementToInsert.getOwnerDocument() != this.ownerDoc) {
                elementToInsert = (SOAPElement)this.ownerDoc.importNode((org.w3c.dom.Node)elementToInsert, true);
            }
        }
        catch (DOMException e) {
            log.log(Level.SEVERE, "WSS0376.error.inserting.header", e.getMessage());
            throw new XWSSecurityException((Throwable)e);
        }
        this.insertBefore((org.w3c.dom.Node)elementToInsert, elem);
    }

    public void appendChild(SecurityHeaderBlock block) throws XWSSecurityException {
        SOAPElement elementToInsert = block.getAsSoapElement();
        try {
            if (elementToInsert.getOwnerDocument() != this.ownerDoc) {
                elementToInsert = (SOAPElement)this.ownerDoc.importNode((org.w3c.dom.Node)elementToInsert, true);
            }
            this.appendChild((org.w3c.dom.Node)elementToInsert);
        }
        catch (DOMException e) {
            log.log(Level.SEVERE, "WSS0376.error.inserting.header", e.getMessage());
            throw new XWSSecurityException((Throwable)e);
        }
    }

    public void insertHeaderBlockElement(SOAPElement blockElement) throws XWSSecurityException {
        try {
            if (blockElement.getOwnerDocument() != this.ownerDoc) {
                blockElement = (SOAPElement)this.ownerDoc.importNode((org.w3c.dom.Node)blockElement, true);
            }
            this.updateTopMostSoapElement();
            this.insertBefore((org.w3c.dom.Node)blockElement, (org.w3c.dom.Node)this.topMostSoapElement);
        }
        catch (DOMException e) {
            log.log(Level.SEVERE, "WSS0376.error.inserting.header", e.getMessage());
            throw new XWSSecurityException((Throwable)e);
        }
        this.topMostSoapElement = blockElement;
    }

    public SecurityHeaderBlock getCurrentHeaderBlock(Class implType) throws XWSSecurityException {
        if (null == this.currentSoapElement) {
            this.currentSoapElement = this.getFirstChildElement();
        } else {
            org.w3c.dom.Node nextChild;
            for (nextChild = this.currentSoapElement.getNextSibling(); null != nextChild && nextChild.getNodeType() != 1; nextChild = nextChild.getNextSibling()) {
            }
            this.currentSoapElement = (SOAPElement)nextChild;
        }
        return SecurityHeaderBlockImpl.fromSoapElement(this.currentSoapElement, implType);
    }

    public SOAPElement getCurrentHeaderBlockElement() {
        if (null == this.currentSoapElement) {
            this.currentSoapElement = this.getFirstChildElement();
        } else {
            org.w3c.dom.Node nextChild;
            for (nextChild = this.currentSoapElement.getNextSibling(); null != nextChild && nextChild.getNodeType() != 1; nextChild = nextChild.getNextSibling()) {
            }
            this.currentSoapElement = (SOAPElement)nextChild;
        }
        return this.currentSoapElement;
    }

    public void setCurrentHeaderElement(SOAPElement currentElement) throws XWSSecurityException {
        if (currentElement != null && currentElement.getParentNode() != this.delegateHeader) {
            log.log(Level.SEVERE, "WSS0396.notchild.securityHeader", new Object[]{currentElement.toString()});
            throw new XWSSecurityException("Element set is not a child of SecurityHeader");
        }
        this.currentSoapElement = currentElement;
    }

    public SOAPElement getCurrentHeaderElement() {
        return this.currentSoapElement;
    }

    public void updateTopMostSoapElement() {
        this.topMostSoapElement = this.getNextSiblingOfTimestamp();
    }

    public SOAPElement getFirstChildElement() {
        Node node;
        Iterator eachChild = this.getChildElements();
        if (eachChild.hasNext()) {
            node = (Node)eachChild.next();
        } else {
            return null;
        }
        while (node.getNodeType() != 1 && eachChild.hasNext()) {
            node = (Node)eachChild.next();
        }
        return (SOAPElement)node;
    }

    public SOAPElement getNextSiblingOfTimestamp() {
        SOAPElement firstElement = this.getFirstChildElement();
        if (firstElement != null && "Timestamp".equals(firstElement.getLocalName())) {
            org.w3c.dom.Node temp = firstElement.getNextSibling();
            if (temp == null) {
                return null;
            }
            while (temp.getNodeType() != 1 && temp.getNextSibling() != null) {
                temp = (Node)temp.getNextSibling();
            }
            while (temp != null && "SignatureConfirmation".equals(temp.getLocalName())) {
                if ((temp = temp.getNextSibling()) == null) {
                    return null;
                }
                while (temp.getNodeType() != 1 && temp.getNextSibling() != null) {
                    temp = (Node)temp.getNextSibling();
                }
            }
            return (SOAPElement)temp;
        }
        return firstElement;
    }

    public SOAPElement getAsSoapElement() {
        return this.delegateHeader;
    }

    public void setRole(String roleURI) {
        throw new UnsupportedOperationException();
    }

    public String getRole() {
        throw new UnsupportedOperationException();
    }

    public void setMustUnderstand(boolean mustUnderstand) {
        throw new UnsupportedOperationException();
    }

    public boolean isMustUnderstand() {
        throw new UnsupportedOperationException();
    }

    public SOAPElement addAttribute(Name arg0, String arg1) throws SOAPException {
        return this.delegateHeader.addAttribute(arg0, arg1);
    }

    public SOAPElement addChildElement(String arg0) throws SOAPException {
        return this.delegateHeader.addChildElement(arg0);
    }

    public SOAPElement addChildElement(String arg0, String arg1) throws SOAPException {
        return this.delegateHeader.addChildElement(arg0, arg1);
    }

    public SOAPElement addChildElement(String arg0, String arg1, String arg2) throws SOAPException {
        return this.delegateHeader.addChildElement(arg0, arg1, arg2);
    }

    public SOAPElement addChildElement(Name arg0) throws SOAPException {
        return this.delegateHeader.addChildElement(arg0);
    }

    public SOAPElement addChildElement(SOAPElement arg0) throws SOAPException {
        return this.delegateHeader.addChildElement(arg0);
    }

    public SOAPElement addNamespaceDeclaration(String arg0, String arg1) throws SOAPException {
        return this.delegateHeader.addNamespaceDeclaration(arg0, arg1);
    }

    public SOAPElement addTextNode(String arg0) throws SOAPException {
        return this.delegateHeader.addTextNode(arg0);
    }

    public org.w3c.dom.Node appendChild(org.w3c.dom.Node arg0) throws DOMException {
        return this.delegateHeader.appendChild(arg0);
    }

    public SOAPElement makeUsable(SOAPElement elem) throws XWSSecurityException {
        SOAPElement elementToInsert = elem;
        try {
            if (elem.getOwnerDocument() != this.ownerDoc) {
                elementToInsert = (SOAPElement)this.ownerDoc.importNode((org.w3c.dom.Node)elem, true);
            }
            return elementToInsert;
        }
        catch (DOMException e) {
            log.log(Level.SEVERE, "WSS0376.error.inserting.header", e.getMessage());
            throw new XWSSecurityException((Throwable)e);
        }
    }

    public org.w3c.dom.Node cloneNode(boolean arg0) {
        return this.delegateHeader.cloneNode(arg0);
    }

    public void detachNode() {
        this.delegateHeader.detachNode();
    }

    public boolean equals(Object obj) {
        return this.delegateHeader.equals(obj);
    }

    public Iterator getAllAttributes() {
        return this.delegateHeader.getAllAttributes();
    }

    public String getAttribute(String arg0) {
        return this.delegateHeader.getAttribute(arg0);
    }

    public Attr getAttributeNode(String arg0) {
        return this.delegateHeader.getAttributeNode(arg0);
    }

    public Attr getAttributeNodeNS(String arg0, String arg1) {
        return this.delegateHeader.getAttributeNodeNS(arg0, arg1);
    }

    public String getAttributeNS(String arg0, String arg1) {
        return this.delegateHeader.getAttributeNS(arg0, arg1);
    }

    public NamedNodeMap getAttributes() {
        return this.delegateHeader.getAttributes();
    }

    public String getAttributeValue(Name arg0) {
        return this.delegateHeader.getAttributeValue(arg0);
    }

    public Iterator getChildElements() {
        return this.delegateHeader.getChildElements();
    }

    public Iterator getChildElements(Name arg0) {
        return this.delegateHeader.getChildElements(arg0);
    }

    public NodeList getChildNodes() {
        return this.delegateHeader.getChildNodes();
    }

    public Name getElementName() {
        return this.delegateHeader.getElementName();
    }

    public NodeList getElementsByTagName(String arg0) {
        return this.delegateHeader.getElementsByTagName(arg0);
    }

    public NodeList getElementsByTagNameNS(String arg0, String arg1) {
        return this.delegateHeader.getElementsByTagNameNS(arg0, arg1);
    }

    public String getEncodingStyle() {
        return this.delegateHeader.getEncodingStyle();
    }

    public org.w3c.dom.Node getFirstChild() {
        return this.delegateHeader.getFirstChild();
    }

    public org.w3c.dom.Node getLastChild() {
        return this.delegateHeader.getLastChild();
    }

    public String getLocalName() {
        return this.delegateHeader.getLocalName();
    }

    public Iterator getNamespacePrefixes() {
        return this.delegateHeader.getNamespacePrefixes();
    }

    public String getNamespaceURI() {
        return this.delegateHeader.getNamespaceURI();
    }

    public String getNamespaceURI(String arg0) {
        return this.delegateHeader.getNamespaceURI(arg0);
    }

    public org.w3c.dom.Node getNextSibling() {
        return this.delegateHeader.getNextSibling();
    }

    public String getNodeName() {
        return this.delegateHeader.getNodeName();
    }

    public short getNodeType() {
        return this.delegateHeader.getNodeType();
    }

    public String getNodeValue() throws DOMException {
        return this.delegateHeader.getNodeValue();
    }

    public Document getOwnerDocument() {
        return this.delegateHeader.getOwnerDocument();
    }

    public SOAPElement getParentElement() {
        return this.delegateHeader.getParentElement();
    }

    public org.w3c.dom.Node getParentNode() {
        return this.delegateHeader.getParentNode();
    }

    public String getPrefix() {
        return this.delegateHeader.getPrefix();
    }

    public org.w3c.dom.Node getPreviousSibling() {
        return this.delegateHeader.getPreviousSibling();
    }

    public String getTagName() {
        return this.delegateHeader.getTagName();
    }

    public String getValue() {
        return this.delegateHeader.getValue();
    }

    public Iterator getVisibleNamespacePrefixes() {
        return this.delegateHeader.getVisibleNamespacePrefixes();
    }

    public boolean hasAttribute(String arg0) {
        return this.delegateHeader.hasAttribute(arg0);
    }

    public boolean hasAttributeNS(String arg0, String arg1) {
        return this.delegateHeader.hasAttributeNS(arg0, arg1);
    }

    public boolean hasAttributes() {
        return this.delegateHeader.hasAttributes();
    }

    public boolean hasChildNodes() {
        return this.delegateHeader.hasChildNodes();
    }

    public int hashCode() {
        return this.delegateHeader.hashCode();
    }

    public org.w3c.dom.Node insertBefore(org.w3c.dom.Node arg0, org.w3c.dom.Node arg1) throws DOMException {
        return this.delegateHeader.insertBefore(arg0, arg1);
    }

    public boolean isSupported(String arg0, String arg1) {
        return this.delegateHeader.isSupported(arg0, arg1);
    }

    public void normalize() {
        this.delegateHeader.normalize();
    }

    public void recycleNode() {
        this.delegateHeader.recycleNode();
    }

    public void removeAttribute(String arg0) throws DOMException {
        this.delegateHeader.removeAttribute(arg0);
    }

    public boolean removeAttribute(Name arg0) {
        return this.delegateHeader.removeAttribute(arg0);
    }

    public Attr removeAttributeNode(Attr arg0) throws DOMException {
        return this.delegateHeader.removeAttributeNode(arg0);
    }

    public void removeAttributeNS(String arg0, String arg1) throws DOMException {
        this.delegateHeader.removeAttributeNS(arg0, arg1);
    }

    public org.w3c.dom.Node removeChild(org.w3c.dom.Node arg0) throws DOMException {
        return this.delegateHeader.removeChild(arg0);
    }

    public void removeContents() {
        this.delegateHeader.removeContents();
    }

    public boolean removeNamespaceDeclaration(String arg0) {
        return this.delegateHeader.removeNamespaceDeclaration(arg0);
    }

    public org.w3c.dom.Node replaceChild(org.w3c.dom.Node arg0, org.w3c.dom.Node arg1) throws DOMException {
        return this.delegateHeader.replaceChild(arg0, arg1);
    }

    public void setAttribute(String arg0, String arg1) throws DOMException {
        this.delegateHeader.setAttribute(arg0, arg1);
    }

    public Attr setAttributeNode(Attr arg0) throws DOMException {
        return this.delegateHeader.setAttributeNode(arg0);
    }

    public Attr setAttributeNodeNS(Attr arg0) throws DOMException {
        return this.delegateHeader.setAttributeNodeNS(arg0);
    }

    public void setAttributeNS(String arg0, String arg1, String arg2) throws DOMException {
        this.delegateHeader.setAttributeNS(arg0, arg1, arg2);
    }

    public void setEncodingStyle(String arg0) throws SOAPException {
        this.delegateHeader.setEncodingStyle(arg0);
    }

    public void setNodeValue(String arg0) throws DOMException {
        this.delegateHeader.setNodeValue(arg0);
    }

    public void setParentElement(SOAPElement arg0) throws SOAPException {
        this.delegateHeader.setParentElement(arg0);
    }

    public void setPrefix(String arg0) throws DOMException {
        this.delegateHeader.setPrefix(arg0);
    }

    public void setValue(String arg0) {
        this.delegateHeader.setValue(arg0);
    }

    public String toString() {
        return this.delegateHeader.toString();
    }

    public String getBaseURI() {
        return this.delegateHeader.getBaseURI();
    }

    public short compareDocumentPosition(org.w3c.dom.Node other) throws DOMException {
        return this.delegateHeader.compareDocumentPosition(other);
    }

    public String getTextContent() throws DOMException {
        return this.delegateHeader.getTextContent();
    }

    public void setTextContent(String textContent) throws DOMException {
        this.delegateHeader.setTextContent(textContent);
    }

    public boolean isSameNode(org.w3c.dom.Node other) {
        return this.delegateHeader.isSameNode(other);
    }

    public String lookupPrefix(String namespaceURI) {
        return this.delegateHeader.lookupPrefix(namespaceURI);
    }

    public boolean isDefaultNamespace(String namespaceURI) {
        return this.delegateHeader.isDefaultNamespace(namespaceURI);
    }

    public String lookupNamespaceURI(String prefix) {
        return this.delegateHeader.lookupNamespaceURI(prefix);
    }

    public boolean isEqualNode(org.w3c.dom.Node arg) {
        return this.delegateHeader.isEqualNode(arg);
    }

    public Object getFeature(String feature, String version) {
        return this.delegateHeader.getFeature(feature, version);
    }

    public Object setUserData(String key, Object data, UserDataHandler handler) {
        return this.delegateHeader.setUserData(key, data, handler);
    }

    public Object getUserData(String key) {
        return this.delegateHeader.getUserData(key);
    }

    public void setIdAttribute(String name, boolean isId) throws DOMException {
        this.delegateHeader.setIdAttribute(name, isId);
    }

    public void setIdAttributeNode(Attr idAttr, boolean isId) throws DOMException {
        this.delegateHeader.setIdAttributeNode(idAttr, isId);
    }

    public void setIdAttributeNS(String namespaceURI, String localName, boolean isId) throws DOMException {
        this.delegateHeader.setIdAttributeNS(namespaceURI, localName, isId);
    }

    public TypeInfo getSchemaTypeInfo() {
        return this.delegateHeader.getSchemaTypeInfo();
    }

    public Iterator getAllAttributesAsQNames() {
        return this.delegateHeader.getAllAttributesAsQNames();
    }
}

