/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rx.rm.runtime;

import com.sun.istack.logging.Logger;
import com.sun.xml.ws.api.pipe.Tube;
import com.sun.xml.ws.assembler.dev.ClientTubelineAssemblyContext;
import com.sun.xml.ws.assembler.dev.ServerTubelineAssemblyContext;
import com.sun.xml.ws.assembler.dev.TubeFactory;
import com.sun.xml.ws.rx.rm.runtime.ClientTube;
import com.sun.xml.ws.rx.rm.runtime.RmConfiguration;
import com.sun.xml.ws.rx.rm.runtime.RmConfigurationFactory;
import com.sun.xml.ws.rx.rm.runtime.ServerTube;
import jakarta.xml.ws.WebServiceException;
import java.util.logging.Level;

public final class RmTubeFactory
implements TubeFactory {
    private static final Logger LOGGER = Logger.getLogger(RmTubeFactory.class);

    public Tube createTube(ClientTubelineAssemblyContext context) throws WebServiceException {
        RmConfiguration configuration = RmConfigurationFactory.INSTANCE.createInstance(context);
        if (configuration.isReliableMessagingEnabled()) {
            if (LOGGER.isLoggable(Level.CONFIG)) {
                LOGGER.config("Creating client-side RM tube with configuration: " + configuration);
            }
            return new ClientTube(configuration, context);
        }
        return context.getTubelineHead();
    }

    public Tube createTube(ServerTubelineAssemblyContext context) throws WebServiceException {
        RmConfiguration configuration = RmConfigurationFactory.INSTANCE.createInstance(context);
        if (configuration.isReliableMessagingEnabled()) {
            if (LOGGER.isLoggable(Level.CONFIG)) {
                LOGGER.config("Creating endpoint-side RM tube with configuration: " + configuration);
            }
            return new ServerTube(configuration, context);
        }
        return context.getTubelineHead();
    }
}

