/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.impl.filter;

import com.sun.xml.ws.security.opt.impl.JAXBFilterProcessingContext;
import com.sun.xml.ws.security.opt.impl.outgoing.SecurityHeader;
import com.sun.xml.ws.security.opt.impl.tokens.SignatureConfirmation;
import com.sun.xml.ws.security.opt.impl.util.NamespaceContextEx;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.core.SignatureConfirmationHeaderBlock;
import com.sun.xml.wss.impl.FilterProcessingContext;
import com.sun.xml.wss.impl.MessageConstants;
import com.sun.xml.wss.impl.SecurableSoapMessage;
import com.sun.xml.wss.logging.impl.filter.LogStringsMessages;
import jakarta.xml.soap.Name;
import jakarta.xml.soap.SOAPElement;
import jakarta.xml.soap.SOAPException;
import jakarta.xml.soap.SOAPFactory;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SignatureConfirmationFilter {
    protected static final Logger log = Logger.getLogger("javax.enterprise.resource.xml.webservices.security", "com.sun.xml.wss.logging.LogStrings");

    public static void process(FilterProcessingContext context) throws XWSSecurityException {
        if (!context.isInboundMessage()) {
            ArrayList scList = (ArrayList)context.getExtraneousProperty("receivedSignValues");
            SignatureConfirmationFilter.setSignConfirmValues(context, scList);
        } else {
            com.sun.xml.wss.core.SecurityHeader secHeader = context.getSecurableSoapMessage().findSecurityHeader();
            if (secHeader == null) {
                log.log(Level.SEVERE, LogStringsMessages.WSS_1428_SIGNATURE_CONFIRMATION_ERROR());
                throw new XWSSecurityException("Message does not confirm to SignatureConfirmation Policy:wsse11:SignatureConfirmation element not found in Header");
            }
            Object temp = context.getExtraneousProperty("SignatureConfirmation");
            ArrayList scList = null;
            if (temp != null && temp instanceof ArrayList) {
                scList = (ArrayList)temp;
            }
            if (scList != null) {
                SignatureConfirmationHeaderBlock signConfirm = null;
                SOAPElement sc = null;
                try {
                    SOAPFactory factory = SOAPFactory.newInstance();
                    Name name = factory.createName("SignatureConfirmation", "wsse11", "http://docs.oasis-open.org/wss/oasis-wss-wssecurity-secext-1.1.xsd");
                    Iterator i = secHeader.getChildElements(name);
                    if (!i.hasNext()) {
                        log.log(Level.SEVERE, LogStringsMessages.WSS_1428_SIGNATURE_CONFIRMATION_ERROR());
                        throw new XWSSecurityException("Message does not confirm to Security Policy:wss11:SignatureConfirmation Element not found");
                    }
                    while (i.hasNext()) {
                        sc = (SOAPElement)i.next();
                        try {
                            signConfirm = new SignatureConfirmationHeaderBlock(sc);
                        }
                        catch (XWSSecurityException xwsse) {
                            log.log(Level.SEVERE, LogStringsMessages.WSS_1435_SIGNATURE_CONFIRMATION_VALIDATION_FAILURE(), xwsse);
                            throw SecurableSoapMessage.newSOAPFaultException(MessageConstants.WSSE_INVALID_SECURITY, "Failure in SignatureConfirmation validation\nMessage is: " + xwsse.getMessage(), xwsse);
                        }
                        String signValue = signConfirm.getSignatureValue();
                        if (signValue == null) {
                            if (!i.hasNext() && scList.isEmpty()) continue;
                            log.log(Level.SEVERE, LogStringsMessages.WSS_1435_SIGNATURE_CONFIRMATION_VALIDATION_FAILURE());
                            throw new XWSSecurityException("Failure in SignatureConfirmation Validation");
                        }
                        if (scList.contains(signValue)) {
                            scList.remove(signValue);
                            continue;
                        }
                        log.log(Level.SEVERE, LogStringsMessages.WSS_1435_SIGNATURE_CONFIRMATION_VALIDATION_FAILURE());
                        throw new XWSSecurityException("Mismatch in SignatureConfirmation Element");
                    }
                }
                catch (SOAPException se) {
                    throw new XWSSecurityException((Throwable)se);
                }
                if (!scList.isEmpty()) {
                    log.log(Level.SEVERE, LogStringsMessages.WSS_1435_SIGNATURE_CONFIRMATION_VALIDATION_FAILURE());
                    throw new XWSSecurityException("Failure in SignatureConfirmation");
                }
                context.setExtraneousProperty("SignatureConfirmation", MessageConstants._EMPTY);
            }
        }
    }

    private static void setSignConfirmValues(FilterProcessingContext context, List scList) throws XWSSecurityException {
        block6: {
            if (scList == null) break block6;
            Iterator it = scList.iterator();
            if (context instanceof JAXBFilterProcessingContext) {
                JAXBFilterProcessingContext optContext = (JAXBFilterProcessingContext)context;
                SecurityHeader secHeader = optContext.getSecurityHeader();
                ((NamespaceContextEx)optContext.getNamespaceContext()).addWSS11NS();
                if (!it.hasNext()) {
                    String id = optContext.generateID();
                    SignatureConfirmation scHeader = new SignatureConfirmation(id, optContext.getSOAPVersion());
                    secHeader.add(scHeader);
                    optContext.getSignatureConfirmationIds().add(id);
                }
                while (it.hasNext()) {
                    byte[] signValue = (byte[])it.next();
                    String id = optContext.generateID();
                    SignatureConfirmation scHeader = new SignatureConfirmation(id, optContext.getSOAPVersion());
                    scHeader.setValue(signValue);
                    secHeader.add(scHeader);
                    optContext.getSignatureConfirmationIds().add(id);
                }
            } else {
                SecurableSoapMessage secureMessage = context.getSecurableSoapMessage();
                com.sun.xml.wss.core.SecurityHeader secHeader = secureMessage.findOrCreateSecurityHeader();
                if (!it.hasNext()) {
                    String id = secureMessage.generateId();
                    SignatureConfirmationHeaderBlock signConfirm = new SignatureConfirmationHeaderBlock(id);
                    secHeader.insertHeaderBlock(signConfirm);
                    context.getSignatureConfirmationIds().add(id);
                }
                while (it.hasNext()) {
                    String signValue = (String)it.next();
                    String id = secureMessage.generateId();
                    SignatureConfirmationHeaderBlock signConfirm = new SignatureConfirmationHeaderBlock(id);
                    signConfirm.setSignatureValue(signValue);
                    secHeader.insertHeaderBlock(signConfirm);
                    context.getSignatureConfirmationIds().add(id);
                }
            }
        }
    }
}

