/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.impl.policy;

import com.sun.xml.ws.policy.AssertionSet;
import com.sun.xml.ws.policy.NestedPolicy;
import com.sun.xml.ws.policy.PolicyAssertion;
import com.sun.xml.ws.policy.sourcemodel.AssertionData;
import com.sun.xml.ws.security.impl.policy.Constants;
import com.sun.xml.ws.security.impl.policy.Issuer;
import com.sun.xml.ws.security.impl.policy.PolicyUtil;
import com.sun.xml.ws.security.policy.SecurityAssertionValidator;
import com.sun.xml.ws.security.policy.SecurityPolicyVersion;
import java.util.Collection;
import java.util.Iterator;
import java.util.logging.Level;
import javax.xml.namespace.QName;

public class SpnegoContextToken
extends PolicyAssertion
implements com.sun.xml.ws.security.policy.SpnegoContextToken,
SecurityAssertionValidator {
    private boolean populated = false;
    private PolicyAssertion rdKey = null;
    private String id;
    private Issuer issuer = null;
    private SecurityAssertionValidator.AssertionFitness fitness = SecurityAssertionValidator.AssertionFitness.IS_VALID;
    private SecurityPolicyVersion spVersion = SecurityPolicyVersion.SECURITYPOLICY200507;
    private final QName itQname;
    private String includeToken;

    public SpnegoContextToken() {
        this.id = PolicyUtil.randomUUID();
        this.itQname = new QName(this.spVersion.namespaceUri, "IncludeToken");
        this.includeToken = this.spVersion.includeTokenAlways;
    }

    public SpnegoContextToken(AssertionData name, Collection<PolicyAssertion> nestedAssertions, AssertionSet nestedAlternative) {
        super(name, nestedAssertions, nestedAlternative);
        this.id = PolicyUtil.randomUUID();
        String nsUri = this.getName().getNamespaceURI();
        this.spVersion = PolicyUtil.getSecurityPolicyVersion(nsUri);
        this.itQname = new QName(this.spVersion.namespaceUri, "IncludeToken");
        this.includeToken = this.spVersion.includeTokenAlways;
    }

    @Override
    public Issuer getIssuer() {
        this.populate();
        return this.issuer;
    }

    @Override
    public boolean isRequireDerivedKeys() {
        this.populate();
        return this.rdKey != null;
    }

    public String getIncludeToken() {
        this.populate();
        return this.includeToken;
    }

    public String getTokenId() {
        return this.id;
    }

    @Override
    public SecurityAssertionValidator.AssertionFitness validate(boolean isServer) {
        return this.populate(isServer);
    }

    private void populate() {
        this.populate(false);
    }

    private synchronized SecurityAssertionValidator.AssertionFitness populate(boolean isServer) {
        if (!this.populated) {
            NestedPolicy policy = this.getNestedPolicy();
            if (this.getAttributeValue(this.itQname) != null) {
                this.includeToken = this.getAttributeValue(this.itQname);
            }
            if (policy == null) {
                if (Constants.logger.getLevel() == Level.FINE) {
                    Constants.logger.log(Level.FINE, "NestedPolicy is null");
                }
                this.populated = true;
                return this.fitness;
            }
            AssertionSet as = policy.getAssertionSet();
            for (PolicyAssertion assertion : as) {
                if (PolicyUtil.isRequireDerivedKeys(assertion, this.spVersion)) {
                    this.rdKey = assertion;
                    continue;
                }
                if (assertion.isOptional()) continue;
                Constants.log_invalid_assertion(assertion, isServer, "SpnegoContextToken");
                this.fitness = SecurityAssertionValidator.AssertionFitness.HAS_UNKNOWN_ASSERTION;
            }
            if (this.hasParameters()) {
                Iterator it = this.getParametersIterator();
                while (it.hasNext()) {
                    PolicyAssertion assertion = (PolicyAssertion)it.next();
                    if (!PolicyUtil.isIssuer(assertion, this.spVersion)) continue;
                    this.issuer = (Issuer)assertion;
                }
            }
            this.populated = true;
        }
        return this.fitness;
    }

    public SecurityPolicyVersion getSecurityPolicyVersion() {
        return this.spVersion;
    }
}

