/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.trust.impl.elements;

import com.sun.istack.NotNull;
import com.sun.xml.ws.api.security.trust.Claims;
import com.sun.xml.ws.api.security.trust.WSTrustException;
import com.sun.xml.ws.policy.Policy;
import com.sun.xml.ws.policy.impl.bindings.AppliesTo;
import com.sun.xml.ws.policy.impl.bindings.PolicyReference;
import com.sun.xml.ws.security.trust.WSTrustVersion;
import com.sun.xml.ws.security.trust.elements.ActAs;
import com.sun.xml.ws.security.trust.elements.AllowPostdating;
import com.sun.xml.ws.security.trust.elements.BinaryExchange;
import com.sun.xml.ws.security.trust.elements.CancelTarget;
import com.sun.xml.ws.security.trust.elements.DelegateTo;
import com.sun.xml.ws.security.trust.elements.Encryption;
import com.sun.xml.ws.security.trust.elements.Entropy;
import com.sun.xml.ws.security.trust.elements.Issuer;
import com.sun.xml.ws.security.trust.elements.Lifetime;
import com.sun.xml.ws.security.trust.elements.OnBehalfOf;
import com.sun.xml.ws.security.trust.elements.Participants;
import com.sun.xml.ws.security.trust.elements.ProofEncryption;
import com.sun.xml.ws.security.trust.elements.RenewTarget;
import com.sun.xml.ws.security.trust.elements.Renewing;
import com.sun.xml.ws.security.trust.elements.RequestSecurityToken;
import com.sun.xml.ws.security.trust.elements.SecondaryParameters;
import com.sun.xml.ws.security.trust.elements.SignChallenge;
import com.sun.xml.ws.security.trust.elements.UseKey;
import com.sun.xml.ws.security.trust.elements.ValidateTarget;
import com.sun.xml.ws.security.trust.impl.bindings.AllowPostdatingType;
import com.sun.xml.ws.security.trust.impl.bindings.BinaryExchangeType;
import com.sun.xml.ws.security.trust.impl.bindings.CancelTargetType;
import com.sun.xml.ws.security.trust.impl.bindings.ClaimsType;
import com.sun.xml.ws.security.trust.impl.bindings.DelegateToType;
import com.sun.xml.ws.security.trust.impl.bindings.EncryptionType;
import com.sun.xml.ws.security.trust.impl.bindings.EntropyType;
import com.sun.xml.ws.security.trust.impl.bindings.LifetimeType;
import com.sun.xml.ws.security.trust.impl.bindings.ObjectFactory;
import com.sun.xml.ws.security.trust.impl.bindings.OnBehalfOfType;
import com.sun.xml.ws.security.trust.impl.bindings.ParticipantsType;
import com.sun.xml.ws.security.trust.impl.bindings.ProofEncryptionType;
import com.sun.xml.ws.security.trust.impl.bindings.RenewTargetType;
import com.sun.xml.ws.security.trust.impl.bindings.RenewingType;
import com.sun.xml.ws.security.trust.impl.bindings.RequestSecurityTokenType;
import com.sun.xml.ws.security.trust.impl.bindings.SignChallengeType;
import com.sun.xml.ws.security.trust.impl.bindings.UseKeyType;
import com.sun.xml.ws.security.trust.impl.elements.AllowPostdatingImpl;
import com.sun.xml.ws.security.trust.impl.elements.BinaryExchangeImpl;
import com.sun.xml.ws.security.trust.impl.elements.CancelTargetImpl;
import com.sun.xml.ws.security.trust.impl.elements.ClaimsImpl;
import com.sun.xml.ws.security.trust.impl.elements.DelegateToImpl;
import com.sun.xml.ws.security.trust.impl.elements.EncryptionImpl;
import com.sun.xml.ws.security.trust.impl.elements.EntropyImpl;
import com.sun.xml.ws.security.trust.impl.elements.LifetimeImpl;
import com.sun.xml.ws.security.trust.impl.elements.OnBehalfOfImpl;
import com.sun.xml.ws.security.trust.impl.elements.ParticipantsImpl;
import com.sun.xml.ws.security.trust.impl.elements.ProofEncryptionImpl;
import com.sun.xml.ws.security.trust.impl.elements.RenewTargetImpl;
import com.sun.xml.ws.security.trust.impl.elements.RenewingImpl;
import com.sun.xml.ws.security.trust.impl.elements.SignChallengeImpl;
import com.sun.xml.ws.security.trust.impl.elements.UseKeyImpl;
import com.sun.xml.ws.security.trust.logging.LogStringsMessages;
import jakarta.xml.bind.JAXBElement;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RequestSecurityTokenImpl
extends RequestSecurityTokenType
implements RequestSecurityToken {
    private static final Logger log = Logger.getLogger("com.sun.xml.ws.security.trust", "com.sun.xml.ws.security.trust.logging.LogStrings");
    private Claims claims = null;
    private Participants participants = null;
    private URI tokenType = null;
    private URI requestType = null;
    private long keySize = 0L;
    private URI keyType = null;
    private URI computedKeyAlgorithm = null;
    private URI signWith = null;
    private URI encryptWith = null;
    private URI authenticationType = null;
    private URI signatureAlgorithm = null;
    private URI encryptionAlgorithm = null;
    private URI canonAlgorithm = null;
    private Lifetime lifetime = null;
    private Entropy entropy = null;
    private AppliesTo appliesTo = null;
    private OnBehalfOf obo = null;
    private SignChallenge signChallenge = null;
    private Encryption encryption = null;
    private UseKey useKey = null;
    private DelegateTo delegateTo = null;
    private RenewTarget renewTarget = null;
    private CancelTarget cancelTarget = null;
    private AllowPostdating apd = null;
    private BinaryExchange binaryExchange = null;
    private Issuer issuer = null;
    private Renewing renewable = null;
    private ProofEncryption proofEncryption = null;
    private boolean forwardable = true;
    private boolean delegatable = false;
    private Policy policy = null;
    private PolicyReference policyRef = null;
    List<Object> extendedElements = new ArrayList<Object>();

    public RequestSecurityTokenImpl() {
        this.setRequestType(URI.create(WSTrustVersion.WS_TRUST_10.getIssueRequestTypeURI()));
    }

    public RequestSecurityTokenImpl(URI tokenType, URI requestType) {
        this.setTokenType(tokenType);
        this.setRequestType(requestType);
    }

    public RequestSecurityTokenImpl(URI tokenType, URI requestType, URI context, AppliesTo scopes, Claims claims, Entropy entropy, Lifetime lifetime, URI algorithm) {
        this.setTokenType(tokenType);
        this.setRequestType(requestType);
        if (context != null) {
            this.setContext(context.toString());
        }
        if (scopes != null) {
            this.setAppliesTo(scopes);
        }
        if (claims != null) {
            this.setClaims(claims);
        }
        if (entropy != null) {
            this.setEntropy(entropy);
        }
        if (lifetime != null) {
            this.setLifetime(lifetime);
        }
        if (algorithm != null) {
            this.setComputedKeyAlgorithm(algorithm);
        }
    }

    public RequestSecurityTokenImpl(URI tokenType, URI requestType, URI context, RenewTarget target, AllowPostdating apd, Renewing renewingInfo) {
        this.setTokenType(tokenType);
        this.setRequestType(requestType);
        if (context != null) {
            this.setContext(context.toString());
        }
        if (context != null) {
            this.setContext(context.toString());
        }
        if (target != null) {
            this.setRenewTarget(target);
        }
        if (apd != null) {
            this.setAllowPostdating(apd);
        }
        if (renewingInfo != null) {
            this.setRenewable(renewingInfo);
        }
    }

    public RequestSecurityTokenImpl(URI tokenType, URI requestType, CancelTarget cancel) {
        this.setTokenType(tokenType);
        this.setRequestType(requestType);
        this.setCancelTarget(cancel);
    }

    public final void setClaims(Claims claims) {
        this.claims = claims;
        JAXBElement<ClaimsType> cElement = new ObjectFactory().createClaims((ClaimsType)claims);
        this.getAny().add(cElement);
    }

    public Claims getClaims() {
        return this.claims;
    }

    public final void setCancelTarget(CancelTarget cTarget) {
        this.cancelTarget = cTarget;
        JAXBElement<CancelTargetType> ctElement = new ObjectFactory().createCancelTarget((CancelTargetType)cTarget);
        this.getAny().add(ctElement);
    }

    public CancelTarget getCancelTarget() {
        return this.cancelTarget;
    }

    public final void setRenewTarget(RenewTarget target) {
        this.renewTarget = target;
        JAXBElement<RenewTargetType> rElement = new ObjectFactory().createRenewTarget((RenewTargetType)target);
        this.getAny().add(rElement);
    }

    public RenewTarget getRenewTarget() {
        return this.renewTarget;
    }

    public final void setValidateTarget(ValidateTarget target) {
        throw new UnsupportedOperationException("Unsupported operation: setValidateTarget");
    }

    public ValidateTarget getValidateTarget() {
        throw new UnsupportedOperationException("Unsupported operation: getValidateTarget");
    }

    public final void setParticipants(Participants participants) {
        this.participants = participants;
        JAXBElement<ParticipantsType> rElement = new ObjectFactory().createParticipants((ParticipantsType)participants);
        this.getAny().add(rElement);
    }

    public Participants getParticipants() {
        return this.participants;
    }

    public URI getTokenType() {
        return this.tokenType;
    }

    public final void setTokenType(URI tokenType) {
        if (tokenType != null) {
            this.tokenType = tokenType;
            JAXBElement<String> ttElement = new ObjectFactory().createTokenType(tokenType.toString());
            this.getAny().add(ttElement);
        }
    }

    public void setSecondaryParameters(SecondaryParameters sp) {
        throw new UnsupportedOperationException("Unsupported operations!");
    }

    public SecondaryParameters getSecondaryParameters() {
        throw new UnsupportedOperationException("Unsupported operations!");
    }

    public URI getRequestType() {
        return this.requestType;
    }

    public final void setRequestType(@NotNull URI requestType) {
        String rtString = requestType.toString();
        if (!(rtString.equalsIgnoreCase(WSTrustVersion.WS_TRUST_10.getIssueRequestTypeURI()) || rtString.equalsIgnoreCase(WSTrustVersion.WS_TRUST_10.getCancelRequestTypeURI()) || rtString.equalsIgnoreCase(WSTrustVersion.WS_TRUST_10.getKeyExchangeRequestTypeURI()) || rtString.equalsIgnoreCase(WSTrustVersion.WS_TRUST_10.getRenewRequestTypeURI()) || rtString.equalsIgnoreCase(WSTrustVersion.WS_TRUST_10.getValidateRequestTypeURI()))) {
            log.log(Level.SEVERE, LogStringsMessages.WST_0024_INVALID_REQUEST_TYPE(rtString));
            throw new RuntimeException(LogStringsMessages.WST_0024_INVALID_REQUEST_TYPE(rtString));
        }
        this.requestType = requestType;
        JAXBElement<String> rtElement = new ObjectFactory().createRequestType(rtString);
        this.getAny().add(rtElement);
    }

    public Lifetime getLifetime() {
        return this.lifetime;
    }

    public final void setLifetime(Lifetime lifetime) {
        this.lifetime = lifetime;
        JAXBElement<LifetimeType> ltElement = new ObjectFactory().createLifetime((LifetimeType)lifetime);
        this.getAny().add(ltElement);
    }

    public Entropy getEntropy() {
        return this.entropy;
    }

    public final void setEntropy(Entropy entropy) {
        this.entropy = entropy;
        JAXBElement<EntropyType> etElement = new ObjectFactory().createEntropy((EntropyType)entropy);
        this.getAny().add(etElement);
    }

    public final void setAppliesTo(AppliesTo appliesTo) {
        this.getAny().add(appliesTo);
        this.appliesTo = appliesTo;
    }

    public AppliesTo getAppliesTo() {
        return this.appliesTo;
    }

    public final void setOnBehalfOf(OnBehalfOf onBehalfOf) {
        this.obo = onBehalfOf;
        JAXBElement<OnBehalfOfType> oboElement = new ObjectFactory().createOnBehalfOf((OnBehalfOfType)onBehalfOf);
        this.getAny().add(oboElement);
    }

    public OnBehalfOf getOnBehalfOf() {
        return this.obo;
    }

    public void setActAs(ActAs actAs) {
        throw new UnsupportedOperationException("Unsupported operation: setActAs");
    }

    public ActAs getActAs() {
        return null;
    }

    public final void setIssuer(Issuer issuer) {
        this.issuer = issuer;
    }

    public Issuer getIssuer() {
        return this.issuer;
    }

    public final void setRenewable(Renewing renew) {
        this.renewable = renew;
        JAXBElement<RenewingType> renewType = new ObjectFactory().createRenewing((RenewingType)renew);
        this.getAny().add(renewType);
    }

    public Renewing getRenewable() {
        return this.renewable;
    }

    public final void setSignChallenge(SignChallenge challenge) {
        this.signChallenge = challenge;
        JAXBElement<SignChallengeType> challengeType = new ObjectFactory().createSignChallenge((SignChallengeType)challenge);
        this.getAny().add(challengeType);
    }

    public SignChallenge getSignChallenge() {
        return this.signChallenge;
    }

    public final void setBinaryExchange(BinaryExchange exchange) {
        this.binaryExchange = exchange;
        JAXBElement<BinaryExchangeType> exchangeType = new ObjectFactory().createBinaryExchange((BinaryExchangeType)exchange);
        this.getAny().add(exchangeType);
    }

    public BinaryExchange getBinaryExchange() {
        return this.binaryExchange;
    }

    public final void setAuthenticationType(URI uri) {
        this.authenticationType = uri;
        JAXBElement<String> atElement = new ObjectFactory().createAuthenticationType(uri.toString());
        this.getAny().add(atElement);
    }

    public URI getAuthenticationType() {
        return this.authenticationType;
    }

    public final void setKeyType(@NotNull URI keytype) {
        this.keyType = keytype;
        JAXBElement<String> ktElement = new ObjectFactory().createKeyType(this.keyType.toString());
        this.getAny().add(ktElement);
    }

    public URI getKeyType() {
        return this.keyType;
    }

    public final void setKeySize(long size) {
        this.keySize = size;
        JAXBElement<Long> ksElement = new ObjectFactory().createKeySize(size);
        this.getAny().add(ksElement);
    }

    public long getKeySize() {
        return this.keySize;
    }

    public final void setSignatureAlgorithm(URI algorithm) {
        this.signatureAlgorithm = algorithm;
        JAXBElement<String> signElement = new ObjectFactory().createSignatureAlgorithm(algorithm.toString());
        this.getAny().add(signElement);
    }

    public URI getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    public final void setEncryptionAlgorithm(URI algorithm) {
        this.encryptionAlgorithm = algorithm;
        JAXBElement<String> encElement = new ObjectFactory().createEncryptionAlgorithm(algorithm.toString());
        this.getAny().add(encElement);
    }

    public URI getEncryptionAlgorithm() {
        return this.encryptionAlgorithm;
    }

    public final void setCanonicalizationAlgorithm(URI algorithm) {
        this.canonAlgorithm = algorithm;
        JAXBElement<String> canonElement = new ObjectFactory().createCanonicalizationAlgorithm(algorithm.toString());
        this.getAny().add(canonElement);
    }

    public URI getCanonicalizationAlgorithm() {
        return this.canonAlgorithm;
    }

    public final void setUseKey(UseKey useKey) {
        this.useKey = useKey;
        JAXBElement<UseKeyType> ukElement = new ObjectFactory().createUseKey((UseKeyType)useKey);
        this.getAny().add(ukElement);
    }

    public UseKey getUseKey() {
        return this.useKey;
    }

    public final void setProofEncryption(ProofEncryption proofEncryption) {
        this.proofEncryption = proofEncryption;
        JAXBElement<ProofEncryptionType> proofElement = new ObjectFactory().createProofEncryption((ProofEncryptionType)proofEncryption);
        this.getAny().add(proofElement);
    }

    public ProofEncryption getProofEncryption() {
        return this.proofEncryption;
    }

    public final void setComputedKeyAlgorithm(@NotNull URI algorithm) {
        if (algorithm != null) {
            String ckaString = algorithm.toString();
            if (!ckaString.equalsIgnoreCase(WSTrustVersion.WS_TRUST_10.getCKHASHalgorithmURI()) && !ckaString.equalsIgnoreCase(WSTrustVersion.WS_TRUST_10.getCKPSHA1algorithmURI())) {
                log.log(Level.SEVERE, LogStringsMessages.WST_0026_INVALID_CK_ALGORITHM(ckaString));
                throw new RuntimeException(LogStringsMessages.WST_0026_INVALID_CK_ALGORITHM(ckaString));
            }
            this.computedKeyAlgorithm = algorithm;
            JAXBElement<String> ckaElement = new ObjectFactory().createComputedKeyAlgorithm(ckaString);
            this.getAny().add(ckaElement);
        }
    }

    public URI getComputedKeyAlgorithm() {
        return this.computedKeyAlgorithm;
    }

    public final void setEncryption(Encryption enc) {
        this.encryption = enc;
        JAXBElement<EncryptionType> encElement = new ObjectFactory().createEncryption((EncryptionType)enc);
        this.getAny().add(encElement);
    }

    public Encryption getEncryption() {
        return this.encryption;
    }

    public final void setSignWith(URI algorithm) {
        this.signWith = algorithm;
        JAXBElement<String> sElement = new ObjectFactory().createSignWith(algorithm.toString());
        this.getAny().add(sElement);
    }

    public URI getSignWith() {
        return this.signWith;
    }

    public final void setEncryptWith(URI algorithm) {
        this.encryptWith = algorithm;
        JAXBElement<String> sElement = new ObjectFactory().createEncryptWith(algorithm.toString());
        this.getAny().add(sElement);
    }

    public URI getEncryptWith() {
        return this.encryptWith;
    }

    public void setKeyWrapAlgorithm(URI algorithm) {
        throw new UnsupportedOperationException("KeyWrapAlgorithm element in WS-Trust Standard version(1.0) is not supported");
    }

    public URI getKeyWrapAlgorithm() {
        throw new UnsupportedOperationException("KeyWrapAlgorithm element in WS-Trust Standard version(1.0) is not supported");
    }

    public final void setDelegateTo(DelegateTo delegateTo) {
        this.delegateTo = delegateTo;
        JAXBElement<DelegateToType> dtElement = new ObjectFactory().createDelegateTo((DelegateToType)delegateTo);
        this.getAny().add(dtElement);
    }

    public DelegateTo getDelegateTo() {
        return this.delegateTo;
    }

    public final void setForwardable(boolean flag) {
        this.forwardable = flag;
        JAXBElement<Boolean> forward = new ObjectFactory().createForwardable(flag);
        this.getAny().add(forward);
    }

    public boolean getForwardable() {
        return this.forwardable;
    }

    public final void setDelegatable(boolean flag) {
        this.delegatable = flag;
        JAXBElement<Boolean> del = new ObjectFactory().createDelegatable(flag);
        this.getAny().add(del);
    }

    public boolean getDelegatable() {
        return this.delegatable;
    }

    public final void setPolicy(Policy policy) {
        this.policy = policy;
        this.getAny().add(policy);
    }

    public Policy getPolicy() {
        return this.policy;
    }

    public final void setPolicyReference(PolicyReference policyRef) {
        this.policyRef = policyRef;
        this.getAny().add(policyRef);
    }

    public PolicyReference getPolicyReference() {
        return this.policyRef;
    }

    public AllowPostdating getAllowPostdating() {
        return this.apd;
    }

    public final void setAllowPostdating(AllowPostdating allowPostdating) {
        this.apd = allowPostdating;
        JAXBElement<AllowPostdatingType> allowPd = new ObjectFactory().createAllowPostdating((AllowPostdatingType)this.apd);
        this.getAny().add(allowPd);
    }

    public RequestSecurityTokenImpl(RequestSecurityTokenType rstType) throws URISyntaxException, WSTrustException {
        this.context = rstType.getContext();
        List<Object> list = rstType.getAny();
        for (int i = 0; i < list.size(); ++i) {
            if (list.get(i) instanceof AppliesTo) {
                this.setAppliesTo((AppliesTo)list.get(i));
                continue;
            }
            if (list.get(i) instanceof JAXBElement) {
                JAXBElement obj = (JAXBElement)list.get(i);
                String local = obj.getName().getLocalPart();
                if (local.equalsIgnoreCase("RequestType")) {
                    this.setRequestType(new URI((String)obj.getValue()));
                    continue;
                }
                if (local.equalsIgnoreCase("KeySize")) {
                    this.setKeySize((Long)obj.getValue());
                    continue;
                }
                if (local.equalsIgnoreCase("KeyType")) {
                    this.setKeyType(new URI((String)obj.getValue()));
                    continue;
                }
                if (local.equalsIgnoreCase("ComputedKeyAlgorithm")) {
                    this.setComputedKeyAlgorithm(new URI((String)obj.getValue()));
                    continue;
                }
                if (local.equalsIgnoreCase("TokenType")) {
                    this.setTokenType(new URI((String)obj.getValue()));
                    continue;
                }
                if (local.equalsIgnoreCase("AuthenticationType")) {
                    this.setAuthenticationType(new URI((String)obj.getValue()));
                    continue;
                }
                if (local.equalsIgnoreCase("Lifetime")) {
                    LifetimeType ltType = (LifetimeType)obj.getValue();
                    this.setLifetime(new LifetimeImpl(ltType.getCreated(), ltType.getExpires()));
                    continue;
                }
                if (local.equalsIgnoreCase("Entropy")) {
                    EntropyType eType = (EntropyType)obj.getValue();
                    this.setEntropy(new EntropyImpl(eType));
                    continue;
                }
                if (local.equalsIgnoreCase("Forwardable")) {
                    this.setForwardable((Boolean)obj.getValue());
                    continue;
                }
                if (local.equalsIgnoreCase("Delegatable")) {
                    this.setDelegatable((Boolean)obj.getValue());
                    continue;
                }
                if (local.equalsIgnoreCase("SignWith")) {
                    this.setSignWith(new URI((String)obj.getValue()));
                    continue;
                }
                if (local.equalsIgnoreCase("EncryptWith")) {
                    this.setEncryptWith(new URI((String)obj.getValue()));
                    continue;
                }
                if (local.equalsIgnoreCase("SignatureAlgorithm")) {
                    this.setSignatureAlgorithm(new URI((String)obj.getValue()));
                    continue;
                }
                if (local.equalsIgnoreCase("EncryptionAlgorithm")) {
                    this.setEncryptionAlgorithm(new URI((String)obj.getValue()));
                    continue;
                }
                if (local.equalsIgnoreCase("CanonicalizationAlgorithm")) {
                    this.setCanonicalizationAlgorithm(new URI((String)obj.getValue()));
                    continue;
                }
                if (local.equalsIgnoreCase("AllowPostdating")) {
                    this.setAllowPostdating(new AllowPostdatingImpl());
                    continue;
                }
                if (local.equalsIgnoreCase("SignChallenge")) {
                    this.setSignChallenge(new SignChallengeImpl());
                    continue;
                }
                if (local.equalsIgnoreCase("BinaryExchange")) {
                    BinaryExchangeType bcType = (BinaryExchangeType)obj.getValue();
                    this.setBinaryExchange(new BinaryExchangeImpl(bcType));
                    continue;
                }
                if (local.equalsIgnoreCase("Issuer")) continue;
                if (local.equalsIgnoreCase("Claims")) {
                    ClaimsType cType = (ClaimsType)obj.getValue();
                    this.setClaims(new ClaimsImpl(cType));
                    continue;
                }
                if (local.equalsIgnoreCase("Participants")) {
                    ParticipantsType psType = (ParticipantsType)obj.getValue();
                    this.setParticipants(new ParticipantsImpl(psType));
                    continue;
                }
                if (local.equalsIgnoreCase("Renewing")) {
                    this.setRenewable(new RenewingImpl());
                    continue;
                }
                if (local.equalsIgnoreCase("ProofEncryption")) {
                    ProofEncryptionType peType = (ProofEncryptionType)obj.getValue();
                    this.setProofEncryption(new ProofEncryptionImpl(peType));
                    continue;
                }
                if (local.equalsIgnoreCase("Policy")) {
                    this.setPolicy((Policy)obj.getValue());
                    continue;
                }
                if (local.equalsIgnoreCase("PolicyReference")) {
                    this.setPolicyReference((PolicyReference)obj.getValue());
                    continue;
                }
                if (local.equalsIgnoreCase("AppliesTo")) {
                    this.setAppliesTo((AppliesTo)obj.getValue());
                    continue;
                }
                if (local.equalsIgnoreCase("OnBehalfOf")) {
                    OnBehalfOfType oboType = (OnBehalfOfType)obj.getValue();
                    this.setOnBehalfOf(new OnBehalfOfImpl(oboType));
                    continue;
                }
                if (local.equalsIgnoreCase("Encryption")) {
                    EncryptionType encType = (EncryptionType)obj.getValue();
                    this.setEncryption(new EncryptionImpl(encType));
                    continue;
                }
                if (local.equalsIgnoreCase("UseKey")) {
                    UseKeyType ukType = (UseKeyType)obj.getValue();
                    this.setUseKey(new UseKeyImpl(ukType));
                    continue;
                }
                if (local.equalsIgnoreCase("DelegateTo")) {
                    DelegateToType dtType = (DelegateToType)obj.getValue();
                    this.setDelegateTo(new DelegateToImpl(dtType));
                    continue;
                }
                if (local.equalsIgnoreCase("RenewTarget")) {
                    RenewTargetType rtType = (RenewTargetType)obj.getValue();
                    this.setRenewTarget(new RenewTargetImpl(rtType));
                    continue;
                }
                if (local.equalsIgnoreCase("CancelTarget")) {
                    CancelTargetType ctType = (CancelTargetType)obj.getValue();
                    this.setCancelTarget(new CancelTargetImpl(ctType));
                    continue;
                }
                if (local.equalsIgnoreCase("AppliesTo")) {
                    this.setAppliesTo((AppliesTo)obj.getValue());
                    continue;
                }
                this.getAny().add(list.get(i));
                this.extendedElements.add(list.get(i));
                continue;
            }
            this.getAny().add(list.get(i));
            this.extendedElements.add(list.get(i));
        }
    }

    public List<Object> getExtensionElements() {
        return this.extendedElements;
    }
}

