/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsclient;

import com.sun.messaging.jmq.io.ReadOnlyPacket;
import com.sun.messaging.jmq.io.ReadWritePacket;
import com.sun.messaging.jmq.jmsclient.Debug;
import com.sun.messaging.jmq.jmsclient.MessageQueue;
import com.sun.messaging.jmq.jmsclient.PriorityQueue;
import com.sun.messaging.jmq.jmsclient.SequentialQueue;
import com.sun.messaging.jmq.jmsclient.Traceable;
import java.io.PrintStream;
import java.util.Hashtable;
import java.util.Vector;

class SessionQueue
implements Traceable {
    private MessageQueue queue = null;
    protected boolean isLocked = false;
    private boolean sessionIsStopped = false;
    protected boolean isClosed = false;
    protected boolean listenerIsSetLate = false;
    protected boolean debug = Debug.debug;
    private long constructTime = 0L;
    private static String USE_SEQUENTIAL = System.getProperty("imq.useSequentialQueue");

    protected synchronized void enqueueNotify(Object pkt) {
        this.enqueue(pkt);
        this.notifyAll();
    }

    public SessionQueue() {
        this.queue = USE_SEQUENTIAL == null ? new PriorityQueue() : new SequentialQueue();
    }

    public SessionQueue(boolean useSequential, int size) {
        this.queue = useSequential ? new SequentialQueue(size) : new PriorityQueue();
    }

    protected synchronized void validateQueue() {
        if (this.constructTime == 0L) {
            this.constructTime = System.currentTimeMillis();
        }
        if (this.queue == null) {
            long diff = System.currentTimeMillis() - this.constructTime;
            throw new Error("JVM Error. Message Queue is null. Create time: " + this.constructTime + " duration: " + diff);
        }
    }

    protected int size() {
        return this.queue.size();
    }

    protected boolean isEmpty() {
        if (this.queue == null) {
            this.validateQueue();
        }
        return this.queue.isEmpty();
    }

    protected void clear() {
        this.queue.clear();
    }

    protected Object[] toArray() {
        return this.queue.toArray();
    }

    protected boolean remove(Object obj) {
        return this.queue.remove(obj);
    }

    protected void enqueue(Object nobj) {
        this.queue.enqueue(nobj);
        if (this.debug) {
            Debug.println(this);
        }
    }

    protected void enqueueFirst(Object nobj) {
        this.queue.enqueueFirst(nobj);
        if (this.debug) {
            Debug.println(this);
        }
    }

    protected Object dequeue() {
        Object obj = null;
        if (!this.queue.isEmpty()) {
            obj = this.queue.dequeue();
        }
        if (this.debug) {
            Debug.println(this);
        }
        return obj;
    }

    protected synchronized Object dequeueWait(long timeout) {
        while (this.isEmpty() || this.isLocked) {
            if (this.isClosed) {
                return null;
            }
            if (this.isLocked) {
                this.setSessionIsStopped(true);
            }
            if (this.listenerIsSetLate) {
                return null;
            }
            try {
                this.wait(timeout);
                if (!this.isEmpty() || this.isLocked || timeout <= 0L) continue;
                return null;
            }
            catch (InterruptedException e) {
                Debug.printStackTrace(e);
            }
        }
        return this.dequeue();
    }

    protected synchronized Object dequeueWait() {
        return this.dequeueWait(0L);
    }

    protected synchronized void setIsLocked(boolean state) {
        this.isLocked = state;
        this.notifyAll();
    }

    protected synchronized boolean getIsLocked() {
        return this.isLocked;
    }

    protected synchronized void setSessionIsStopped(boolean state) {
        if (this.debug) {
            Debug.println("session reader is stopped: " + state);
        }
        this.sessionIsStopped = state;
        this.notifyAll();
    }

    protected synchronized void waitUntilSessionStopped() {
        try {
            while (!this.isClosed && this.isLocked && !this.sessionIsStopped) {
                this.wait();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected synchronized void stop(boolean doWait) {
        this.setIsLocked(true);
        if (doWait) {
            this.waitUntilSessionStopped();
        } else {
            this.sessionIsStopped = true;
        }
    }

    protected synchronized void start() {
        this.setIsLocked(false);
        this.setSessionIsStopped(false);
    }

    protected synchronized void close() {
        this.isClosed = true;
        this.setIsLocked(false);
        if (this.debug) {
            Debug.println("Session queue closed ...");
        }
    }

    protected synchronized boolean waitMaxInterval(long interval) {
        long endtime = System.currentTimeMillis() + interval;
        long waittime = interval;
        while (!(this.isClosed || this.isLocked || this.sessionIsStopped)) {
            try {
                this.wait(waittime);
                long currtime = System.currentTimeMillis();
                if (currtime >= endtime) {
                    return true;
                }
                waittime = endtime - currtime;
            }
            catch (InterruptedException e) {
                return false;
            }
        }
        return false;
    }

    protected boolean getIsClosed() {
        return this.isClosed;
    }

    public String toString() {
        StringBuffer strbuf = null;
        int cntr = 0;
        strbuf = new StringBuffer(this.getClass().getName() + ": \n");
        Object[] objs = this.toArray();
        for (cntr = 0; cntr < objs.length; ++cntr) {
            Object tmp = objs[cntr];
            strbuf.append("Element " + cntr + " :" + tmp.toString() + "\n");
        }
        return strbuf.toString();
    }

    protected synchronized void setListenerLateNotify() {
        this.listenerIsSetLate = true;
        this.notifyAll();
    }

    protected synchronized void setListenerLate(boolean state) {
        this.listenerIsSetLate = state;
    }

    protected synchronized boolean isListenerSetLate() {
        return this.listenerIsSetLate;
    }

    @Override
    public void dump(PrintStream ps) {
        ps.println("------ SessionQueue dump ------");
        ps.println("queue size: " + this.size());
        for (Object element : this.queue.toArray()) {
            if (element instanceof ReadWritePacket) {
                ((ReadWritePacket)element).dump(ps);
                continue;
            }
            if (element == null || !(element instanceof Traceable)) continue;
            ((Traceable)element).dump(ps);
        }
    }

    protected Hashtable getDebugState(boolean verbose) {
        Hashtable<String, Object> ht = new Hashtable<String, Object>();
        ht.put("isLocked", this.isLocked);
        ht.put("sessionIsStopped", this.sessionIsStopped);
        ht.put("isClosed", this.isClosed);
        ht.put("listenerIsSetLate", this.listenerIsSetLate);
        ht.put("constructTime", this.constructTime);
        ht.put("queueSize", this.queue.size());
        if (verbose) {
            Vector<String> v = new Vector<String>();
            Object[] objs = this.queue.toArray();
            int osize = objs.length;
            Object o = null;
            for (int i = 0; i < osize; ++i) {
                o = objs[i];
                if (o instanceof ReadOnlyPacket) {
                    v.add(((ReadOnlyPacket)o).getMessageID());
                    continue;
                }
                v.add(o.toString());
            }
            ht.put("queue", v);
        }
        return ht;
    }
}

