/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsclient;

import com.sun.messaging.AdministeredObject;
import com.sun.messaging.jmq.jmsclient.ConnectException;
import com.sun.messaging.jmq.jmsclient.ConnectionHandler;
import com.sun.messaging.jmq.jmsclient.ConnectionImpl;
import com.sun.messaging.jmq.jmsclient.Debug;
import com.sun.messaging.jmq.jmsclient.ExceptionHandler;
import com.sun.messaging.jmq.jmsclient.MQAddress;
import com.sun.messaging.jmq.jmsclient.MQAddressList;
import com.sun.messaging.jmq.jmsclient.StreamHandler;
import com.sun.messaging.jmq.jmsclient.StreamHandlerFactory;
import com.sun.messaging.jms.JMSException;
import java.net.MalformedURLException;
import java.util.StringTokenizer;
import java.util.logging.Level;

public class ConnectionInitiator {
    private ConnectionImpl connection = null;
    private MQAddressList addrList = null;
    private String addrListString = null;
    private boolean useAddressList = false;
    private int nextStart = 0;
    private int reconnectDelay = 3000;
    private int reconnectRetries = 0;
    private int addressListIterations = 0;
    private boolean debug = Debug.debug;
    private static final String PRIORITY = "PRIORITY";
    private static final String RANDOM = "RANDOM";
    private static final String JMS_SERVICE_NAME = "jms";
    private String defaultService = "jms";
    private static final String SSLJMS_SERVICE_NAME = "ssljms";
    public static final int HA_RECONNECT_DELAY = 3000;
    private boolean useStaticAddressList = false;
    private boolean isJMSService = true;
    private volatile boolean shouldRedirect = false;
    private boolean isRedirected = false;
    private String redirectURL = null;

    public ConnectionInitiator(ConnectionImpl connection) throws javax.jms.JMSException, MalformedURLException {
        this.connection = connection;
        this.init();
    }

    private void init() throws javax.jms.JMSException, MalformedURLException {
        if (this.debug) {
            Debug.println("In ConnectionInitiator.init()");
        }
        this.useStaticAddressList = Boolean.getBoolean("imq.useStaticAddressList");
        String prop = this.connection.getTrimmedProperty("imqReconnectInterval");
        if (prop != null) {
            this.reconnectDelay = Integer.parseInt(prop);
            if (this.connection.isConnectedToHABroker && this.reconnectDelay < 3000) {
                this.reconnectDelay = 3000;
            }
        } else if (this.connection.isConnectedToHABroker) {
            this.reconnectDelay = 3000;
        }
        if ((prop = this.connection.getTrimmedProperty("imqReconnectAttempts")) != null) {
            this.reconnectRetries = Integer.parseInt(prop);
        }
        if ((prop = this.connection.getTrimmedProperty("imqAddressListIterations")) != null) {
            this.addressListIterations = Integer.parseInt(prop);
        }
        prop = this.connection.getTrimmedProperty("imqAddressList");
        this.addrList = this.createAddressList(prop);
        this.setDefaultService(this.addrList);
    }

    protected ConnectionHandler createConnection() throws javax.jms.JMSException {
        return this.createConnection(false);
    }

    protected ConnectionHandler reconnect() throws javax.jms.JMSException, MalformedURLException {
        ConnectionHandler handler = null;
        if (this.debug) {
            Debug.println("In ConnectionInitiator.reconnect()");
        }
        if (this.connection.isConnectedToHABroker && this.reconnectDelay < 3000) {
            this.reconnectDelay = 3000;
        }
        if (this.shouldRedirect) {
            handler = this.redirect();
        } else {
            Debug.println("*** Old broker list: " + this.connection.savedJMQBrokerList);
            Debug.println("*** New broker list: " + this.connection.JMQBrokerList);
            if (this.connection.shouldUpdateAddressList()) {
                if (this.debug) {
                    Debug.println("*** updating broker address list: " + this.connection.JMQBrokerList);
                }
                this.resetAddressList(this.connection.JMQBrokerList);
                this.connection.savedJMQBrokerList = this.connection.JMQBrokerList;
            }
            handler = this.createConnection(true);
        }
        return handler;
    }

    private ConnectionHandler createConnection(boolean isReconnect) throws javax.jms.JMSException {
        ConnectionHandler ch = null;
        ch = this.useAddressList ? this.createConnectionNew(isReconnect) : this.createConnectionOld(isReconnect);
        if (ch == null && this.debug) {
            Debug.println("*** ConnectionInitiator.createConnection() returning null ConnectionHandler ...");
        }
        return ch;
    }

    private ConnectionHandler createConnectionNew(boolean isReconnect) throws javax.jms.JMSException {
        if (this.debug) {
            Debug.println("In ConnectionInitiator.createConnectionNew()");
        }
        if (isReconnect && this.connection.isConnectedToHABroker) {
            this.addressListIterations = -1;
        }
        Exception[] elist = new Exception[this.addrList.size()];
        String[] alist = new String[this.addrList.size()];
        for (int i = 0; this.addressListIterations <= 0 || i < this.addressListIterations; ++i) {
            for (int j = 0; j < this.addrList.size(); ++j) {
                int currentIndex = (this.nextStart + j) % this.addrList.size();
                MQAddress addr = (MQAddress)this.addrList.get(currentIndex);
                try {
                    ConnectionHandler connHandler = this.createConnection(addr);
                    this.nextStart = this.getNextStartIndex(isReconnect, currentIndex);
                    return connHandler;
                }
                catch (Exception e) {
                    if (this.connection.isCloseCalled) {
                        if (e instanceof javax.jms.JMSException) {
                            throw (javax.jms.JMSException)e;
                        }
                        ExceptionHandler.handleConnectException(e, null);
                    }
                    if (this.debug) {
                        Debug.printStackTrace(e);
                    }
                    elist[j] = e;
                    alist[j] = addr.toString();
                    if (j == this.addrList.size() - 1) continue;
                    try {
                        Thread.sleep(this.reconnectDelay);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    continue;
                }
            }
            if (i == this.addressListIterations - 1) continue;
            try {
                Thread.sleep(this.reconnectDelay);
                continue;
            }
            catch (Exception j) {
                // empty catch block
            }
        }
        if (elist.length == 1) {
            MQAddress addr = (MQAddress)this.addrList.get(0);
            String url = addr.getURL();
            ExceptionHandler.handleConnectException(elist[0], url);
            return null;
        }
        String errorString = AdministeredObject.cr.getKString("C4003", "[" + this.addrListString + "]");
        ConnectException ce = new ConnectException(errorString, "C4003", elist, alist);
        ExceptionHandler.handleConnectException(ce, "");
        return null;
    }

    private ConnectionHandler createConnectionOld(boolean isReconnect) throws javax.jms.JMSException {
        if (this.debug) {
            Debug.println("In ConnectionInitiator.createConnectionOld()");
        }
        int count = 0;
        while (true) {
            if (this.connection.isCloseCalled) {
                String errstr = AdministeredObject.cr.getKString("C4062");
                JMSException jmse = new JMSException(errstr, "C4062");
                ExceptionHandler.throwJMSException(jmse);
            }
            ++count;
            try {
                if (isReconnect) {
                    this.sleep(this.reconnectDelay);
                }
                return this.openConnection();
            }
            catch (javax.jms.JMSException jmse) {
                if (!isReconnect) {
                    throw jmse;
                }
                this.triggerConnectionReconnectFailedEvent(jmse);
                if (this.reconnectRetries <= 0 || count < this.reconnectRetries) continue;
                throw jmse;
            }
            break;
        }
    }

    private void sleep(long time) {
        try {
            Thread.sleep(time);
        }
        catch (Exception e) {
            ExceptionHandler.logCaughtException(e);
        }
    }

    private ConnectionHandler openConnection() throws javax.jms.JMSException {
        try {
            String handler = this.connection.getProperty("imqConnectionHandler");
            StreamHandler sh = StreamHandlerFactory.getStreamHandler(handler);
            return sh.openConnection(this.connection);
        }
        catch (Exception e) {
            javax.jms.JMSException jmse = null;
            if (e instanceof javax.jms.JMSException) {
                jmse = (javax.jms.JMSException)e;
            } else {
                jmse = ExceptionHandler.getJMSException(e, "C4038", false);
                jmse.setLinkedException(e);
            }
            ExceptionHandler.throwJMSException(jmse);
            return null;
        }
    }

    public boolean getUseAddressList() {
        return this.useAddressList;
    }

    public int getAddrListSize() {
        int size = 0;
        if (this.addrList != null) {
            size = this.addrList.size();
        }
        return size;
    }

    private void setBehavior(MQAddressList aList) throws javax.jms.JMSException {
        this.useAddressList = false;
        if (aList != null && aList.size() > 0) {
            this.useAddressList = true;
            String prop = this.connection.getProperty("imqAddressListBehavior");
            if (PRIORITY.equalsIgnoreCase(prop)) {
                aList.setBehavior(1);
            } else if (RANDOM.equalsIgnoreCase(prop)) {
                aList.setBehavior(2);
            } else {
                JMSException jmse = new JMSException("Bad imqAddressListBehavior value : " + prop);
                ExceptionHandler.throwJMSException(jmse);
            }
            if (this.debug) {
                Debug.println("Address list : \n" + aList);
            }
        }
    }

    private void validate(MQAddressList aList) throws javax.jms.JMSException {
    }

    private MQAddressList createAddressList(String addrString) throws javax.jms.JMSException, MalformedURLException {
        MQAddressList aList = null;
        this.addrListString = addrString;
        if (addrString != null && !addrString.equals("")) {
            aList = MQAddressList.createMQAddressList(addrString);
            this.validate(this.addrList);
        }
        this.setBehavior(aList);
        this.nextStart = 0;
        return aList;
    }

    private void setDefaultService(MQAddressList aList) {
        Debug.println("*** set default service with address list: " + aList);
        if (aList != null && aList.size() > 0) {
            MQAddress addr = (MQAddress)aList.get(0);
            this.defaultService = addr.getServiceName();
        } else {
            this.defaultService = this.connection.getTrimmedProperty("imqBrokerServiceName");
            if (this.defaultService == null) {
                this.defaultService = JMS_SERVICE_NAME;
            }
        }
        this.isJMSService = JMS_SERVICE_NAME.equalsIgnoreCase(this.defaultService);
        if (this.debug) {
            Debug.println("*** default service name: " + this.defaultService);
        }
    }

    public String getDefaultServiceName() {
        return this.defaultService;
    }

    public void resetAddressList(String alString) throws javax.jms.JMSException, MalformedURLException {
        boolean resetAddr = false;
        if (this.useStaticAddressList) {
            return;
        }
        if (alString == null || alString.length() < 5) {
            return;
        }
        Debug.println("*** isJMSService: " + this.isJMSService);
        Debug.println("*** defaultService: " + this.defaultService);
        if (this.isJMSService) {
            this.addrListString = alString;
            this.addrList = this.createAddressList(alString);
            resetAddr = true;
        } else if (SSLJMS_SERVICE_NAME.equalsIgnoreCase(this.defaultService)) {
            String newAddrList;
            this.addrListString = newAddrList = ConnectionInitiator.appendServiceName(alString, SSLJMS_SERVICE_NAME);
            this.addrList = this.createAddressList(newAddrList);
            resetAddr = true;
        }
        if (this.debug && resetAddr) {
            Debug.println("**** address list reset: " + this.addrListString);
        }
    }

    public static String appendServiceName(String addrString, String serviceName) {
        StringBuffer sb = new StringBuffer();
        StringTokenizer st = new StringTokenizer(addrString, " ,");
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            sb.append(s);
            if (s.indexOf(47, 5) < 0) {
                sb.append('/');
            }
            sb.append(serviceName);
            if (!st.hasMoreTokens()) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    private ConnectionHandler redirect() throws javax.jms.JMSException {
        ConnectionHandler connHandler = null;
        try {
            connHandler = this.doRedirect();
        }
        catch (Exception e) {
            connHandler = this.createConnectionNew(true);
        }
        return connHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConnectionHandler doRedirect() throws javax.jms.JMSException {
        ConnectionHandler connHandler = null;
        String newaddr = this.redirectURL;
        try {
            if (!this.isJMSService) {
                StringBuffer sb = new StringBuffer();
                sb.append(this.redirectURL);
                if (this.redirectURL.indexOf(47, 5) < 0) {
                    sb.append('/');
                }
                sb.append(SSLJMS_SERVICE_NAME);
                newaddr = sb.toString();
            }
            if (this.debug) {
                Debug.info("**** ConnectionInitiator: redirecting connection: " + newaddr);
            }
            MQAddress mqaddr = MQAddress.createMQAddress(newaddr);
            String handler = mqaddr.getHandlerClass();
            StreamHandler sh = StreamHandlerFactory.getStreamHandler(handler);
            connHandler = sh.openConnection(mqaddr, this.connection);
            this.isRedirected = true;
            if (this.debug) {
                Debug.info("**** ConnectionInitiator: conn redirected: " + newaddr);
            }
        }
        catch (javax.jms.JMSException jmse) {
            throw jmse;
        }
        catch (Exception e) {
            ExceptionHandler.handleConnectException(e, this.connection.getLastContactedBrokerAddress());
        }
        finally {
            this.shouldRedirect = false;
        }
        return connHandler;
    }

    public void setRedirectURL(String url) {
        this.shouldRedirect = true;
        this.redirectURL = url;
        String msg = "RedirectURL=" + url;
        ConnectionImpl.connectionLogger.log(Level.INFO, msg);
    }

    public boolean isBrokerRedirected() {
        if (this.isRedirected) {
            this.isRedirected = false;
            return true;
        }
        return false;
    }

    private ConnectionHandler createConnection(MQAddress address) throws javax.jms.JMSException {
        ConnectionHandler connHandler = null;
        if (this.debug) {
            Debug.println("Create connection with MQ address: " + address);
        }
        if (this.debug) {
            Debug.println("Reconnect retries: " + this.reconnectRetries);
        }
        boolean keepTrying = true;
        int ct = 0;
        while (keepTrying) {
            javax.jms.JMSException jmse;
            if (this.connection.isCloseCalled) {
                if (this.debug) {
                    Debug.println("#### connection.isClosed = true");
                }
                String errstr = AdministeredObject.cr.getKString("C4062");
                jmse = new JMSException(errstr, "C4062");
                ExceptionHandler.throwJMSException(jmse);
            }
            try {
                if (this.debug) {
                    Debug.println("#### Connecting to :" + address + "  counter: " + ct);
                }
                String handler = address.getHandlerClass();
                StreamHandler sh = StreamHandlerFactory.getStreamHandler(handler);
                connHandler = sh.openConnection(address, this.connection);
                return connHandler;
            }
            catch (Exception e) {
                ++ct;
                if (this.debug) {
                    Debug.println("\nConnection Attempt failed.\n, Address = " + address + ", attempt# = " + ct);
                    Debug.printStackTrace(e);
                }
                jmse = this.getJMSException(e);
                this.triggerConnectionReconnectFailedEvent(jmse);
                if (!(e instanceof javax.jms.JMSException)) {
                    ExceptionHandler.logCaughtException(e);
                }
                if (this.reconnectRetries < 0 || ct < this.reconnectRetries) {
                    this.sleepReconnectDelay();
                    continue;
                }
                ExceptionHandler.throwJMSException(jmse);
            }
        }
        if (connHandler == null) {
            Debug.info("**** error: Connection handler is null ****");
        }
        return connHandler;
    }

    private void sleepReconnectDelay() {
        try {
            Thread.sleep(this.reconnectDelay);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private javax.jms.JMSException getJMSException(Exception e) {
        if (e instanceof javax.jms.JMSException) {
            return (javax.jms.JMSException)e;
        }
        javax.jms.JMSException jmse = ExceptionHandler.getJMSException(e, "C4038", false);
        jmse.setLinkedException(e);
        return jmse;
    }

    private void triggerConnectionReconnectFailedEvent(javax.jms.JMSException jmse) {
        this.connection.triggerConnectionReconnectFailedEvent(jmse);
    }

    private int getNextStartIndex(boolean isReconnect, int currentIndex) {
        int next = currentIndex;
        next = this.reconnectRetries > 0 ? currentIndex : (isReconnect ? (this.connection.failoverEnabled ? (currentIndex + 1) % this.addrList.size() : currentIndex) : (currentIndex + 1) % this.addrList.size());
        return next;
    }
}

