/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsclient;

import com.sun.messaging.jmq.io.Status;
import com.sun.messaging.jmq.jmsclient.ConnectionImpl;
import com.sun.messaging.jmq.jmsclient.Debug;
import com.sun.messaging.jmq.jmsclient.RemoteAcknowledgeException;
import com.sun.messaging.jmq.jmsclient.SessionImpl;
import com.sun.messaging.jmq.jmsclient.XAResourceForJMQ;
import com.sun.messaging.jmq.jmsclient.XAResourceForRA;
import com.sun.messaging.jmq.jmsclient.XAResourceMap;
import com.sun.messaging.jmq.jmsclient.XAResourceMapForRAMC;
import com.sun.messaging.jmq.util.JMQXid;
import com.sun.messaging.jmq.util.XidImpl;
import com.sun.messaging.jms.ra.api.JMSRAManagedConnection;
import com.sun.messaging.jms.ra.api.JMSRAResourceAdapter;
import com.sun.messaging.jms.ra.api.JMSRASessionAdapter;
import com.sun.messaging.jms.ra.api.JMSRAXASession;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.JMSException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class XAResourceForMC
implements XAResource,
XAResourceForJMQ {
    private ConnectionImpl epConnection;
    private long resourceManagerId = 0L;
    private int transactionTimeout = 0;
    private JMSRAManagedConnection mc;
    private int id;
    private long transactionID = -1L;
    private JMQXid jmqXid = null;
    protected boolean started = false;
    protected boolean active = false;
    public static final int CREATED = 0;
    public static final int STARTED = 1;
    public static final int FAILED = 2;
    public static final int INCOMPLETE = 3;
    public static final int COMPLETE = 4;
    public static final int PREPARED = 5;
    private int resourceState = 0;
    private static Hashtable xaTable = new Hashtable();
    private static final transient String _className = "com.sun.messaging.jmq.jmsclient.XAResourceForMC";
    private static final transient String _lgrName = "com.sun.messaging.jmq.jmsclient.XAResourceForMC";
    private static final transient Logger _logger = Logger.getLogger("com.sun.messaging.jmq.jmsclient.XAResourceForMC");
    private static final transient String _lgrMIDPrefix = "MQJMSRA_XARMC";
    private static final transient String _lgrMID_EET = "MQJMSRA_XARMC1001: ";
    private static final transient String _lgrMID_INF = "MQJMSRA_XARMC1101: ";
    private static final transient String _lgrMID_WRN = "MQJMSRA_XARMC2001: ";
    private static final transient String _lgrMID_ERR = "MQJMSRA_XARMC3001: ";
    private static final transient String _lgrMID_EXC = "MQJMSRA_XARMC4001: ";

    public XAResourceForMC(JMSRAManagedConnection mc, ConnectionImpl raConnection, ConnectionImpl epConnection) throws JMSException {
        this.mc = mc;
        this.id = mc.getMCId();
        this.epConnection = epConnection;
        if (raConnection == null) {
            System.err.println("MQRA:XARFMC:constr:raConnectionNull:unable to acquire RMId:assuming distinct");
        } else if (raConnection._isClosed()) {
            System.err.println("MQRA:XARFMC:constr:raConnectionClosed:unable to acquire RMId:assuming distinct");
        } else {
            try {
                this.resourceManagerId = raConnection.getProtocolHandler().generateUID();
            }
            catch (Exception e) {
                System.err.println("MQRA:XARFMC:constr:Exc aquiring RMId:assume distinct");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void commit(Xid foreignXid, boolean onePhase) throws XAException {
        XAException xae;
        Exception rbrollbackex;
        boolean rbrollback;
        JMQXid jmqXid;
        block31: {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("MQJMSRA_XARMC1101: XAResourceForMC (" + this.hashCode() + ") Commit  " + this.printXid(foreignXid) + " (onePhase=" + onePhase + ")");
            }
            jmqXid = new JMQXid(foreignXid);
            boolean checkrollback = false;
            rbrollback = false;
            rbrollbackex = null;
            try {
                if (!this.epConnection._isClosed()) {
                    if (onePhase) {
                        if (this.epConnection.isConnectedToHABroker()) {
                            this.HAOnePhaseCommit(foreignXid, jmqXid);
                        } else {
                            try {
                                this.epConnection.getProtocolHandler().commit(0L, 0x40000000, jmqXid);
                            }
                            catch (JMSException e) {
                                checkrollback = true;
                                throw e;
                            }
                        }
                    } else if (this.epConnection.isConnectedToHABroker()) {
                        this.HATwoPhaseCommit(jmqXid);
                    } else {
                        this.epConnection.getProtocolHandler().commit(0L, 0, jmqXid);
                    }
                    JMSRASessionAdapter sa = this.mc.getConnectionAdapter().getJMSRASessionAdapter();
                    if (sa != null) {
                        sa.getJMSRAXASession().finishXATransactionForMC();
                    }
                    this.active = false;
                    break block31;
                }
                System.err.println("MQRA:XARFMC:commit:ConnectionClosed:throw XAExc txn:1p=" + onePhase + ":xid=" + jmqXid.toString());
                XAException xae2 = new XAException(-7);
                throw xae2;
            }
            catch (XAException xaexception) {
                throw xaexception;
            }
            catch (Exception jmse) {
                Exception e1;
                System.err.println("MQRA:XARFMC:commit:XAException-Exception=" + jmse.getMessage());
                Debug.printStackTrace(jmse);
                if (jmse instanceof RemoteAcknowledgeException && checkrollback) {
                    rbrollbackex = jmse;
                    rbrollback = true;
                }
                if (!rbrollback && checkrollback && jmse instanceof JMSException && ((JMSException)jmse).getErrorCode().equals("C4036") && (e1 = ((JMSException)jmse).getLinkedException()) != null && e1 instanceof JMSException && !((JMSException)e1).getErrorCode().equals(Status.getString(404))) {
                    SessionImpl.sessionLogger.log(Level.WARNING, "Exception on 1-phase commit transaction " + jmqXid + ", will rollback", jmse);
                    rbrollbackex = jmse;
                    rbrollback = true;
                }
                if (!rbrollback) {
                    XAException xae3 = new XAException(-7);
                    xae3.initCause(jmse);
                    throw xae3;
                }
            }
            finally {
                if (!rbrollback) {
                    boolean throwExceptionIfNotFound = false;
                    JMQXid savedXid = this.jmqXid;
                    XAResourceForJMQ[] resources = XAResourceMapForRAMC.getXAResources(this.jmqXid, throwExceptionIfNotFound);
                    for (int i = 0; i < resources.length; ++i) {
                        XAResourceForJMQ xari = resources[i];
                        try {
                            xari.clearTransactionInfo();
                            continue;
                        }
                        catch (JMSException jmse) {
                            System.err.println("MQRA:XARFMC:commit:XAException-Exception=" + jmse.getMessage());
                            Debug.printStackTrace(jmse);
                            XAException xae4 = new XAException(-7);
                            xae4.initCause(jmse);
                            throw xae4;
                        }
                    }
                    XAResourceMapForRAMC.unregister(savedXid);
                }
            }
        }
        if (!rbrollback) {
            this.removeXid(jmqXid);
            return;
        }
        try {
            this.rollback(foreignXid, XAResourceMap.MAXROLLBACKS, XAResourceMap.DMQ_ON_MAXROLLBACKS);
            xae = new XAException(100);
            xae.initCause(rbrollbackex);
        }
        catch (Exception e) {
            SessionImpl.sessionLogger.log(Level.SEVERE, "Exception on rollback transaction " + jmqXid + " after 1-phase-commit failure", e);
            xae = new XAException(-7);
            xae.initCause(rbrollbackex);
        }
        throw xae;
    }

    private void HAOnePhaseCommit(Xid foreignXid, JMQXid jmqXid) throws JMSException, XAException {
        int tstate = 1;
        try {
            this.prepare(foreignXid, true);
            tstate = 2;
            if (this.isXATracking()) {
                xaTable.put(jmqXid, XAResourceForRA.XA_PREPARE);
            }
            this.epConnection.getProtocolHandler().commit(0L, 0, jmqXid, true);
        }
        catch (Exception jmse) {
            this.checkCommitStatus(jmse, tstate, jmqXid, true);
        }
        this.removeXid(jmqXid);
    }

    private void HATwoPhaseCommit(JMQXid jmqXid) throws JMSException, XAException {
        try {
            this.epConnection.getProtocolHandler().commit(0L, 0, jmqXid);
        }
        catch (JMSException jmse) {
            if (this.isXATracking()) {
                Integer ts = (Integer)xaTable.get(jmqXid);
                if (ts != null && ts == 2) {
                    this.checkCommitStatus(jmse, 2, jmqXid, false);
                }
            }
            throw jmse;
        }
        this.removeXid(jmqXid);
    }

    private void checkPrepareStatus(XAException xae, JMQXid jmqXid) throws XAException {
        if (!this.epConnection.imqReconnect) {
            throw xae;
        }
        try {
            SessionImpl.yield();
            this.epConnection.checkReconnecting(null);
            if (this.epConnection.isCloseCalled || this.epConnection.connectionIsBroken) {
                throw xae;
            }
            this.verifyPrepare(jmqXid);
        }
        catch (XAException xae2) {
            throw xae2;
        }
        catch (Exception e) {
            XAException xae3 = new XAException(-7);
            xae3.initCause(e);
            throw xae3;
        }
    }

    private void verifyPrepare(JMQXid jmqXid) throws XAException, JMSException {
        SessionImpl.sessionLogger.log(Level.INFO, "XA verifyPrepare(), jmqXid: " + jmqXid);
        int state = this.epConnection.protocolHandler.verifyHATransaction(0L, 1, jmqXid);
        switch (state) {
            case 6: {
                SessionImpl.sessionLogger.log(Level.INFO, "transaction in prepared state: " + this.transactionID);
                return;
            }
        }
        XAException xae = new XAException(100);
        throw xae;
    }

    private void checkCommitStatus(Exception cause, int tstate, JMQXid jmqXid, boolean onePhase) throws JMSException, XAException {
        try {
            this.doCheckCommitStatus(cause, tstate, jmqXid, onePhase);
        }
        catch (Exception ex) {
            if (ex instanceof JMSException) {
                throw (JMSException)ex;
            }
            if (ex instanceof XAException) {
                throw (XAException)ex;
            }
            XAException xae = new XAException(-7);
            xae.initCause(ex);
            throw xae;
        }
    }

    private void doCheckCommitStatus(Exception ex, int tstate, JMQXid jmqXid, boolean onePhase) throws Exception {
        if (!this.epConnection.imqReconnect) {
            throw ex;
        }
        SessionImpl.yield();
        this.epConnection.checkReconnecting(null);
        if (this.epConnection.isCloseCalled || this.epConnection.connectionIsBroken) {
            throw ex;
        }
        this.verifyTransaction(tstate, jmqXid, onePhase);
    }

    private void verifyTransaction(int tstate, JMQXid jmqXid, boolean onePhase) throws JMSException, XAException {
        int state = this.epConnection.protocolHandler.verifyHATransaction(0L, tstate, jmqXid);
        switch (state) {
            case 7: {
                return;
            }
            case 6: {
                try {
                    SessionImpl.sessionLogger.log(Level.INFO, "XA verifyTransaction(): transaction is in prepred state, committing the transaction: " + this.transactionID);
                    this.epConnection.getProtocolHandler().commit(0L, 0, jmqXid, onePhase);
                    SessionImpl.sessionLogger.log(Level.INFO, "XA verifyTransaction(): prepared transaction committed successfully: " + this.transactionID);
                    return;
                }
                catch (JMSException jmse) {
                    SessionImpl.yield();
                    this.epConnection.checkReconnecting(null);
                    throw jmse;
                }
            }
        }
        XAException xae = new XAException(100);
        throw xae;
    }

    @Override
    public synchronized void end(Xid foreignXid, int flags) throws XAException {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("MQJMSRA_XARMC1101: XAResourceForMC (" + this.hashCode() + ") End     " + this.printXid(foreignXid) + this.printFlags(flags));
        }
        JMQXid jmqXid = new JMQXid(foreignXid);
        this.resourceState = this.isFail(flags) ? 2 : (this.isSuspend(flags) ? 3 : 4);
        if (JMSRAResourceAdapter.isRevert6882044()) {
            this.sendEndToBroker(flags, false, jmqXid);
        } else if (this.resourceState == 4) {
            boolean allComplete = true;
            XAResourceForJMQ[] resources = XAResourceMapForRAMC.getXAResources(jmqXid, true);
            for (int i = 0; i < resources.length; ++i) {
                XAResourceForJMQ xari = resources[i];
                if (xari.isComplete()) continue;
                allComplete = false;
            }
            if (allComplete) {
                this.sendEndToBroker(flags, false, jmqXid);
            } else {
                this.sendEndToBroker(flags, true, jmqXid);
            }
        } else if (this.resourceState == 2) {
            this.sendEndToBroker(flags, false, jmqXid);
        } else if (this.resourceState == 3) {
            // empty if block
        }
        this.started = false;
        if (this.isXATracking()) {
            xaTable.put(jmqXid, XAResourceForRA.XA_END);
        }
    }

    private void sendEndToBroker(int flags, boolean jmqnoop, JMQXid jmqXid) throws XAException {
        try {
            this.epConnection.protocolHandler.endTransaction(0L, jmqnoop, flags, jmqXid);
            JMSRASessionAdapter sa = this.mc.getConnectionAdapter().getJMSRASessionAdapter();
            if (sa != null) {
                sa.getJMSRAXASession().finishXATransactionForMC();
            }
        }
        catch (Exception jmse) {
            System.err.println("MQRA:XARFMC:end:XAException-Exception=" + jmse.getMessage());
            Debug.printStackTrace(jmse);
            XAException xae = new XAException(-7);
            xae.initCause(jmse);
            throw xae;
        }
    }

    @Override
    public void forget(Xid foreignXid) throws XAException {
        XidImpl xidToForget = new XidImpl(foreignXid);
        XAResourceMapForRAMC.unregister(xidToForget);
        if (this.jmqXid != null && this.jmqXid.equals(xidToForget)) {
            try {
                this.clearTransactionInfo();
            }
            catch (JMSException jmse) {
                System.err.println("MQRA:XARFMC:forget:XAException-Exception=" + jmse.getMessage());
                Debug.printStackTrace(jmse);
                XAException xae = new XAException(-7);
                xae.initCause(jmse);
                throw xae;
            }
        }
    }

    @Override
    public int getTransactionTimeout() throws XAException {
        return this.transactionTimeout;
    }

    @Override
    public boolean isSameRM(XAResource foreignXaRes) throws XAException {
        if (foreignXaRes instanceof XAResourceForMC || foreignXaRes instanceof XAResourceForRA) {
            return this.isSameJMQRM((XAResourceForJMQ)((Object)foreignXaRes));
        }
        return false;
    }

    @Override
    public boolean isSameJMQRM(XAResourceForJMQ xaResource) {
        boolean result = JMSRAResourceAdapter.isSameRMAllowed() ? this.getBrokerSessionID() != 0L && this.getBrokerSessionID() == xaResource.getBrokerSessionID() : false;
        return result;
    }

    @Override
    public long getBrokerSessionID() {
        return this.epConnection.getBrokerSessionID();
    }

    @Override
    public synchronized int prepare(Xid foreignXid) throws XAException {
        int result = 0;
        try {
            this.prepare(foreignXid, false);
        }
        catch (XAException xae) {
            if (this.epConnection.isConnectedToHABroker) {
                this.checkPrepareStatus(xae, this.jmqXid);
            }
            throw xae;
        }
        if (this.isXATracking()) {
            xaTable.put(this.jmqXid, XAResourceForRA.XA_PREPARE);
        }
        return result;
    }

    private synchronized int prepare(Xid foreignXid, boolean onePhase) throws XAException {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("MQJMSRA_XARMC1101: XAResourceForMC (" + this.hashCode() + ") Prepare     " + this.printXid(foreignXid));
        }
        int result = 0;
        JMQXid jmqXid = new JMQXid(foreignXid);
        try {
            if (this.epConnection._isClosed()) {
                System.err.println("MQRA:XARFMC:prepare:ConnectionClosed:Rollback txn:xid=" + jmqXid.toString());
                XAException xae = new XAException(-7);
                throw xae;
            }
            this.epConnection.getProtocolHandler().prepare(0L, jmqXid, onePhase);
        }
        catch (Exception jmse) {
            System.err.println("MQRA:XARFMC:prepare:XAException-Exception=" + jmse.getMessage());
            Debug.printStackTrace(jmse);
            XAException xae = new XAException(-7);
            xae.initCause(jmse);
            throw xae;
        }
        this.resourceState = 5;
        return result;
    }

    @Override
    public Xid[] recover(int flags) throws XAException {
        JMQXid[] result = null;
        try {
            if (!this.epConnection._isClosed()) {
                result = this.epConnection.getProtocolHandler().recover(flags);
            }
        }
        catch (Exception jmse) {
            System.err.println("MQRA:XARFMC:recover:XAException-Exception=" + jmse.getMessage());
            Debug.printStackTrace(jmse);
            XAException xae = new XAException(-7);
            xae.initCause(jmse);
            throw xae;
        }
        return result;
    }

    @Override
    public synchronized void rollback(Xid foreignXid) throws XAException {
        this.rollback(foreignXid, -1, false);
    }

    private synchronized void rollback(Xid foreignXid, int maxRollbacks, boolean dmqOnMaxRollbacks) throws XAException {
        JMQXid jmqXid;
        block16: {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("MQJMSRA_XARMC1101: XAResourceForMC (" + this.hashCode() + ") Rollback  " + this.printXid(foreignXid) + ")");
            }
            jmqXid = new JMQXid(foreignXid);
            JMSRAXASession xas = null;
            JMSRASessionAdapter sa = null;
            try {
                if (!this.epConnection._isClosed()) {
                    sa = this.mc.getConnectionAdapter().getJMSRASessionAdapter();
                    if (this.epConnection.isConnectedToHABroker()) {
                        this.HARollback(jmqXid, maxRollbacks, dmqOnMaxRollbacks);
                    } else {
                        this.epConnection.getProtocolHandler().rollbackXA(0L, jmqXid, true, false, maxRollbacks, dmqOnMaxRollbacks);
                    }
                    if (sa != null) {
                        sa.getJMSRAXASession().finishXATransactionForMC();
                    }
                    this.active = false;
                    break block16;
                }
                System.err.println("MQRA:XARFMC:rollback:ConnectionClosed:Rollback txn:xid=" + jmqXid.toString());
                XAException xae = new XAException(-7);
                throw xae;
            }
            catch (Exception jmse) {
                System.err.println("MQRA:XARFMC:rollback:XAException-Exception=" + jmse.getMessage());
                Debug.printStackTrace(jmse);
                XAException xae = new XAException(-7);
                xae.initCause(jmse);
                throw xae;
            }
            finally {
                if (sa != null && (xas = sa.getJMSRAXASession()) != null) {
                    xas.setFailoverOccurred(false);
                }
                boolean throwExceptionIfNotFound = false;
                JMQXid savedXid = this.jmqXid;
                XAResourceForJMQ[] resources = XAResourceMapForRAMC.getXAResources(this.jmqXid, throwExceptionIfNotFound);
                for (int i = 0; i < resources.length; ++i) {
                    XAResourceForJMQ xari = resources[i];
                    try {
                        xari.clearTransactionInfo();
                        continue;
                    }
                    catch (JMSException jmse) {
                        System.err.println("MQRA:XARFMC:rollback:XAException-Exception=" + jmse.getMessage());
                        Debug.printStackTrace(jmse);
                        XAException xae = new XAException(-7);
                        xae.initCause(jmse);
                        throw xae;
                    }
                }
                XAResourceMapForRAMC.unregister(savedXid);
            }
        }
        this.removeXid(jmqXid);
    }

    private void HARollback(JMQXid jmqXid, int maxRollbacks, boolean dmqOnMaxRollbacks) throws JMSException, XAException {
        try {
            this.epConnection.getProtocolHandler().rollbackXA(0L, jmqXid, true, false, maxRollbacks, dmqOnMaxRollbacks);
        }
        catch (JMSException jmse) {
            SessionImpl.yield();
            this.epConnection.checkReconnecting(null);
            if (this.epConnection.isCloseCalled || this.epConnection.connectionIsBroken) {
                throw jmse;
            }
            this.retryRollBack(jmqXid, maxRollbacks, dmqOnMaxRollbacks);
        }
        this.removeXid(jmqXid);
    }

    private void retryRollBack(JMQXid jmqXid, int maxRollbacks, boolean dmqOnMaxRollbacks) throws JMSException, XAException {
        try {
            this.epConnection.getProtocolHandler().rollbackXA(0L, jmqXid, true, true, maxRollbacks, dmqOnMaxRollbacks);
        }
        catch (JMSException jmse) {
            if (this.isXATracking()) {
                Integer tstate = (Integer)xaTable.get(jmqXid);
                if (tstate != null && tstate != 2) {
                    ConnectionImpl.connectionLogger.log(Level.WARNING, jmse.toString());
                }
                throw jmse;
            }
            throw jmse;
        }
    }

    @Override
    public boolean setTransactionTimeout(int transactionTimeout) throws XAException {
        return false;
    }

    @Override
    public synchronized void start(Xid foreignXid, int flags) throws XAException {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("MQJMSRA_XARMC1101: XAResourceForMC (" + this.hashCode() + ") Start   " + this.printXid(foreignXid) + this.printFlags(flags));
        }
        JMQXid jmqXid = new JMQXid(foreignXid);
        if (!this.isResume(flags) || JMSRAResourceAdapter.isRevert6882044()) {
            try {
                this.transactionID = this.epConnection.protocolHandler.startTransaction(this.transactionID, flags, jmqXid);
                this.jmqXid = jmqXid;
                JMSRASessionAdapter sa = this.mc.getConnectionAdapter().getJMSRASessionAdapter();
                if (sa != null) {
                    sa.getJMSRAXASession().initXATransactionForMC(this.transactionID);
                }
            }
            catch (Exception jmse) {
                System.err.println("MQRA:XARFMC:start:XAException-Exception=" + jmse.getMessage());
                Debug.printStackTrace(jmse);
                XAException xae = new XAException(-7);
                xae.initCause(jmse);
                throw xae;
            }
            XAResourceMapForRAMC.register(jmqXid, this, this.isJoin(flags));
        }
        this.started = true;
        this.active = true;
        this.resourceState = 1;
        if (this.isXATracking()) {
            xaTable.put(jmqXid, XAResourceForRA.XA_START);
        }
    }

    public int getId() {
        return this.id;
    }

    public synchronized long getTransactionID() {
        return this.transactionID;
    }

    public boolean started() {
        return this.started;
    }

    public boolean isActive() {
        return this.active;
    }

    @Override
    public void clearTransactionInfo() throws JMSException {
        this.mc.getConnectionAdapter().closeForPoolingIfClosed();
        this.resourceState = 0;
    }

    private boolean isXATracking() {
        return this.epConnection.isConnectedToHABroker() && XAResourceForRA.XATracking;
    }

    private void removeXid(JMQXid jmqXid) {
        if (this.isXATracking()) {
            xaTable.remove(jmqXid);
        }
    }

    private boolean isJoin(int flags) {
        return (flags & 0x200000) == 0x200000;
    }

    private boolean isResume(int flags) {
        return (flags & 0x8000000) == 0x8000000;
    }

    private boolean isFail(int flags) {
        return (flags & 0x20000000) == 0x20000000;
    }

    private boolean isSuspend(int flags) {
        return (flags & 0x2000000) == 0x2000000;
    }

    private String printXid(Xid foreignXid) {
        return "(GlobalTransactionID=" + foreignXid.getGlobalTransactionId() + ", BranchQualifier=" + foreignXid.getBranchQualifier() + ") ";
    }

    private String printFlags(int flags) {
        String result = "(Flags: ";
        if (this.isJoin(flags)) {
            result = result + "JOIN ";
        }
        if (this.isNoFlags(flags)) {
            result = result + "TMNOFLAGS ";
        }
        if (this.isFail(flags)) {
            result = result + "TMFAIL ";
        }
        if (this.isOnePhase(flags)) {
            result = result + "TMONEPHASE ";
        }
        if (this.isResume(flags)) {
            result = result + "TMRESUME ";
        }
        if (this.isSuccess(flags)) {
            result = result + "TMSUCCESS ";
        }
        if (this.isSuspend(flags)) {
            result = result + "TMSUSPEND ";
        }
        if (this.isTMENDRSCAN(flags)) {
            result = result + "TMENDRSCAN ";
        }
        if (this.TMSTARTRSCAN(flags)) {
            result = result + "TMSTARTRSCAN ";
        }
        result = result + ")";
        return result;
    }

    private boolean isNoFlags(int flags) {
        return (flags & 0) == 0;
    }

    private boolean isOnePhase(int flags) {
        return (flags & 0x40000000) == 0x40000000;
    }

    private boolean isSuccess(int flags) {
        return (flags & 0x4000000) == 0x4000000;
    }

    private boolean isTMENDRSCAN(int flags) {
        return (flags & 0x800000) == 0x800000;
    }

    private boolean TMSTARTRSCAN(int flags) {
        return (flags & 0x1000000) == 0x1000000;
    }

    @Override
    public boolean isComplete() {
        return this.resourceState == 4;
    }
}

