/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.cluster.manager.ha;

import com.sun.messaging.jmq.io.MQAddress;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.cluster.api.BrokerState;
import com.sun.messaging.jmq.jmsserver.cluster.api.BrokerStatus;
import com.sun.messaging.jmq.jmsserver.cluster.api.ClusteredBroker;
import com.sun.messaging.jmq.jmsserver.cluster.api.ha.HAClusteredBroker;
import com.sun.messaging.jmq.jmsserver.cluster.manager.AutoClusterBrokerMap;
import com.sun.messaging.jmq.jmsserver.cluster.manager.ClusterManagerImpl;
import com.sun.messaging.jmq.jmsserver.cluster.manager.ClusterReason;
import com.sun.messaging.jmq.jmsserver.cluster.manager.ha.HAClusteredBrokerImpl;
import com.sun.messaging.jmq.jmsserver.cluster.manager.ha.JDBCHABrokerInfoMap;
import com.sun.messaging.jmq.jmsserver.config.PropertyUpdateException;
import com.sun.messaging.jmq.jmsserver.persist.api.StoreManager;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.UID;
import java.net.MalformedURLException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.inject.Singleton;
import org.jvnet.hk2.annotations.Service;

@Service(name="com.sun.messaging.jmq.jmsserver.cluster.manager.ha.HAClusterManagerImpl")
@Singleton
public class HAClusterManagerImpl
extends ClusterManagerImpl {
    protected String localBrokerId = null;
    protected int VERSION = 500;
    protected UID localSessionUID = null;

    @Override
    public boolean isHA() {
        if (!this.initialized) {
            throw new RuntimeException("Cluster not initialized");
        }
        return true;
    }

    @Override
    public void reloadConfig() throws BrokerException {
        if (!this.initialized) {
            throw new RuntimeException("Cluster not initialized");
        }
        String[] props = new String[]{"imq.cluster.url"};
        this.config.reloadProps(Globals.getConfigName(), props, false);
    }

    @Override
    protected Map initAllBrokers(MQAddress myaddr) throws BrokerException {
        return this.newHABrokerInfoMap();
    }

    @Override
    public String initialize(MQAddress address) throws BrokerException {
        this.logger.log(4, "initializingCluster at " + address);
        this.localBrokerId = Globals.getBrokerID();
        if (this.localBrokerId == null) {
            throw new BrokerException(Globals.getBrokerResources().getKString("B3093", "null"));
        }
        String mbroker = this.config.getProperty("imq.cluster.masterbroker");
        if (mbroker != null) {
            this.logger.log(16, Globals.getBrokerResources().getKString("B2194", "imq.cluster.masterbroker=" + mbroker));
        }
        super.initialize(address);
        return this.localBrokerId;
    }

    protected void checkStore() throws BrokerException {
        if (!StoreManager.isConfiguredJDBCStore()) {
            throw new BrokerException(Globals.getBrokerResources().getKString("B3221"));
        }
    }

    @Override
    protected boolean allowMasterBroker() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected LinkedHashSet parseBrokerList() throws MalformedURLException {
        String propfileSetting = this.config.getProperty("imq.cluster.brokerlist");
        String cmdlineSetting = this.config.getProperty("imq.cluster.brokerlist.manual");
        if (propfileSetting != null) {
            this.logger.log(8, "B1192", "imq.cluster.brokerlist");
        }
        if (cmdlineSetting != null) {
            this.logger.log(8, "B1192", "imq.cluster.brokerlist.manual");
        }
        LinkedHashSet<MQAddress> brokers = new LinkedHashSet<MQAddress>();
        Map map = this.allBrokers;
        synchronized (map) {
            for (Object obj : this.allBrokers.values()) {
                HAClusteredBroker hab = (HAClusteredBroker)obj;
                if (hab.isLocalBroker()) continue;
                brokers.add(hab.getBrokerURL());
            }
        }
        return brokers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String addBroker(MQAddress URL2, boolean isLocal, boolean isConfig, UID brokerUID) throws NoSuchElementException, BrokerException {
        if (!this.initialized) {
            throw new RuntimeException("Cluster not initialized");
        }
        String brokerid = null;
        ClusteredBroker cb = null;
        if (isLocal) {
            brokerid = this.localBrokerId;
            cb = this.getBroker(brokerid);
            if (cb == null) {
                cb = this.newHAClusteredBroker(brokerid, URL2, this.VERSION, BrokerState.INITIALIZING, brokerUID);
                ((HAClusteredBrokerImpl)cb).setIsLocal(true);
                cb.setInstanceName(Globals.getConfigName());
            } else {
                ((HAClusteredBrokerImpl)cb).setIsLocal(true);
                cb.setInstanceName(Globals.getConfigName());
            }
            Map map = this.allBrokers;
            synchronized (map) {
                this.allBrokers.put(brokerid, cb);
            }
        } else {
            brokerid = this.lookupBrokerID(URL2);
            if (brokerid != null) {
                cb = this.getBroker(brokerid);
            }
        }
        if (brokerUID != null) {
            cb.setBrokerSessionUID(brokerUID);
        }
        if (brokerid == null) {
            throw new NoSuchElementException(Globals.getBrokerResources().getKString("B3169", URL2));
        }
        if (isLocal) {
            cb.setStatus(257, null);
        } else {
            this.updateBroker(cb);
        }
        this.brokerChanged(ClusterReason.ADDED, cb.getBrokerName(), null, cb, cb.getBrokerSessionUID(), null);
        return brokerid;
    }

    protected HAClusteredBroker newHAClusteredBroker(String brokerid, MQAddress url, int version, BrokerState state, UID session) throws BrokerException {
        return new HAClusteredBrokerImpl(brokerid, url, version, state, session, this);
    }

    @Override
    protected ClusteredBroker updateBrokerOnActivation(ClusteredBroker broker, Object userData) {
        return this.updateBroker(broker);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClusteredBroker updateBroker(ClusteredBroker broker) {
        Map map = this.allBrokers;
        synchronized (map) {
            return (HAClusteredBroker)((AutoClusterBrokerMap)((Object)this.allBrokers)).get(broker.getBrokerName(), true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deactivateBroker(String brokerid, Object userData) throws NoSuchElementException {
        if (!this.initialized) {
            throw new RuntimeException("Cluster not initialized");
        }
        ClusteredBroker cb = this.getBroker(brokerid);
        if (cb == null) {
            throw new NoSuchElementException("Unknown brokerid " + brokerid);
        }
        cb.setInstanceName(null);
        HAClusterManagerImpl hAClusterManagerImpl = this;
        synchronized (hAClusterManagerImpl) {
            cb.setStatus(BrokerStatus.setBrokerLinkIsDown(cb.getStatus()), userData);
        }
    }

    @Override
    public String lookupStoreSessionOwner(UID uid) {
        try {
            return Globals.getStore().getStoreSessionOwner(uid.longValue());
        }
        catch (Exception ex) {
            this.logger.logStack(16, ex.getMessage(), ex);
            return null;
        }
    }

    @Override
    public String getStoreSessionCreator(UID uid) {
        try {
            return Globals.getStore().getStoreSessionCreator(uid.longValue());
        }
        catch (Exception ex) {
            this.logger.logStack(8, ex.getMessage(), ex);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String lookupBrokerID(MQAddress address) {
        try {
            Map map = this.allBrokers;
            synchronized (map) {
                ((AutoClusterBrokerMap)((Object)this.allBrokers)).updateMap();
            }
        }
        catch (BrokerException e) {
            this.logger.logStack(16, e.getMessage(), e);
        }
        return super.lookupBrokerID(address);
    }

    @Override
    public int getConfigBrokerCount() {
        return super.getKnownBrokerCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator getKnownBrokers(boolean refresh) {
        Map map;
        if (!this.initialized) {
            throw new RuntimeException("Cluster not initialized");
        }
        HashSet brokers = null;
        if (refresh) {
            try {
                map = this.allBrokers;
                synchronized (map) {
                    ((AutoClusterBrokerMap)((Object)this.allBrokers)).updateMap(true);
                }
            }
            catch (BrokerException ex) {
                this.logger.logStack(16, ex.getMessage(), ex);
            }
        }
        map = this.allBrokers;
        synchronized (map) {
            brokers = new HashSet(this.allBrokers.values());
        }
        return brokers.iterator();
    }

    @Override
    public Iterator getConfigBrokers() {
        return this.getKnownBrokers(true);
    }

    @Override
    protected void addSupportedStoreSessionUID(UID uid) {
        super.addSupportedStoreSessionUID(uid);
    }

    @Override
    protected void masterBrokerChanged(String mbroker) {
        throw new UnsupportedOperationException("Can not use/set/ change masterbroker");
    }

    @Override
    public void validate(String name, String value) throws PropertyUpdateException {
        if (name.equals("imq.cluster.masterbroker")) {
            throw new PropertyUpdateException(Globals.getBrokerResources().getKString("B4250"));
        }
        super.validate(name, value);
    }

    @Override
    public ClusteredBroker getLocalBroker() {
        return super.getLocalBroker();
    }

    protected String getLocalBrokerName() {
        return this.localBroker;
    }

    @Override
    public UID getStoreSessionUID() {
        if (this.localSessionUID == null) {
            this.localSessionUID = ((HAClusteredBroker)this.getLocalBroker()).getStoreSessionUID();
        }
        return this.localSessionUID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ClusteredBroker getBroker(String brokerid) {
        ClusteredBroker cb = super.getBroker(brokerid);
        if (cb != null) {
            return cb;
        }
        try {
            Map map = this.allBrokers;
            synchronized (map) {
                ((AutoClusterBrokerMap)((Object)this.allBrokers)).updateMap(true);
            }
        }
        catch (BrokerException ex) {
            this.logger.logStack(16, ex.getMessage(), ex);
        }
        return super.getBroker(brokerid);
    }

    protected Map newHABrokerInfoMap() throws BrokerException {
        return new JDBCHABrokerInfoMap(this);
    }
}

