/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.common.handlers;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.cluster.api.BrokerState;
import com.sun.messaging.jmq.jmsserver.cluster.api.ClusterManager;
import com.sun.messaging.jmq.jmsserver.cluster.api.ClusteredBroker;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.data.PacketHandler;
import com.sun.messaging.jmq.jmsserver.service.ConsumerInfoNotifyManager;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;

public class InfoRequestHandler
extends PacketHandler {
    private Logger logger = Globals.getLogger();
    public static final int REQUEST_STATUS_INFO = 1;
    public static final int REQUEST_CLUSTER_INFO = 2;
    public static final int REQUEST_CONSUMER_INFO = 3;
    static final int INITIALIZING = 1;
    static final int RUNNING = 2;
    static final int QUIESCE_STARTED = 3;
    static final int QUIESCE_COMPLETE = 4;
    static final int FAILOVER_STARTED = 5;
    static final int FAILOVER_COMPLETE = 6;
    static final int SHUTDOWN_STARTED = 7;
    static final int SHUTDOWN_COMPLETE = 8;

    @Override
    public boolean handle(IMQConnection con, Packet msg) throws BrokerException {
        Hashtable pktprops = null;
        try {
            pktprops = msg.getProperties();
        }
        catch (Exception ex) {
            this.logger.logStack(16, "INFO-REQUEST Packet.getProperties()", ex);
            pktprops = new Hashtable();
        }
        Integer level = (Integer)pktprops.get("JMQRequestType");
        if (level == null) {
            this.logger.log(8, "No JMQRequestType set ");
            level = -1;
        }
        if (level == 3) {
            String destName = (String)pktprops.get("JMQDestination");
            int destType = (Integer)pktprops.get("JMQDestType");
            Boolean offb = (Boolean)pktprops.get("JMQRequestOff");
            boolean off = offb == null ? false : offb;
            DestinationUID duid = DestinationUID.getUID(destName, destType);
            if (off) {
                con.removeConsumerInfoRequest(duid);
            } else {
                con.addConsumerInfoRequest(duid);
            }
            ConsumerInfoNotifyManager cm = Globals.getConnectionManager().getConsumerInfoNotifyManager();
            cm.consumerInfoRequested(con, duid, destType);
            return true;
        }
        InfoRequestHandler.sendInfoPacket(level, con, msg.getConsumerID());
        return true;
    }

    public static void sendInfoPacket(int requestType, IMQConnection con, long consumerUID) {
        Logger logger = Globals.getLogger();
        ClusterManager cfg = Globals.getClusterManager();
        String reason = null;
        int status = 200;
        Packet pkt = new Packet(con.useDirectBuffers());
        pkt.setPacketType(73);
        pkt.setConsumerID(consumerUID);
        Hashtable<String, Object> replyprops = new Hashtable<String, Object>();
        Hashtable bodyProperties = null;
        if (cfg == null) {
            status = 500;
            reason = "Internal Error: NOT VALID CLUSTER ";
            logger.log(8, reason);
        } else if (requestType == 1) {
            ClusteredBroker cb = cfg.getLocalBroker();
            bodyProperties = InfoRequestHandler.getInfo(cb);
            try {
                if (cb.getState() == BrokerState.SHUTDOWN_STARTED) {
                    long timeout = Globals.getBrokerStateHandler().getShutdownRemaining();
                    bodyProperties.put("ShutdownMS", timeout);
                }
            }
            catch (BrokerException ex) {
                logger.logStack(16, "INFO-REQUEST", ex);
            }
        } else if (requestType == 2) {
            bodyProperties = InfoRequestHandler.getAllInfo();
        } else {
            status = 400;
            reason = "Internal Error: Bad JMQRequestType set " + requestType;
            logger.log(8, reason);
        }
        String list = null;
        if (cfg != null) {
            Iterator itr = cfg.getKnownBrokers(true);
            HashSet<String> s = new HashSet<String>();
            while (itr.hasNext()) {
                ClusteredBroker cb = (ClusteredBroker)itr.next();
                s.add(cb.getBrokerURL().toString());
            }
            itr = s.iterator();
            while (itr.hasNext()) {
                if (list == null) {
                    list = itr.next().toString();
                    continue;
                }
                list = list + "," + itr.next().toString();
            }
            if (list != null) {
                replyprops.put("JMQBrokerList", list);
            }
        }
        if (bodyProperties != null) {
            try {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(bos);
                oos.writeObject(bodyProperties);
                oos.flush();
                bos.flush();
                pkt.setMessageBody(bos.toByteArray());
                bos.close();
            }
            catch (Exception ex) {
                logger.logStack(16, "INFO-REQUEST", ex);
            }
        }
        replyprops.put("JMQRequestType", requestType);
        replyprops.put("JMQStatus", status);
        if (reason != null) {
            replyprops.put("JMQReason", reason);
        }
        pkt.setProperties(replyprops);
        con.sendControlMessage(pkt);
    }

    static Hashtable getAllInfo() {
        ClusterManager cfg = Globals.getClusterManager();
        if (cfg == null) {
            return null;
        }
        Iterator itr = cfg.getKnownBrokers(true);
        Hashtable<String, Object> ht = new Hashtable<String, Object>();
        String nameList = "";
        while (itr.hasNext()) {
            ClusteredBroker bc = (ClusteredBroker)itr.next();
            nameList = nameList.length() == 0 ? bc.getBrokerName() : nameList + "," + bc.getBrokerName();
            ht.put(bc.getBrokerName(), InfoRequestHandler.getInfo(bc));
        }
        ht.put("BrokerIDs", nameList);
        return ht;
    }

    static Hashtable getInfo(ClusteredBroker bc) {
        BrokerState state = null;
        Logger logger = Globals.getLogger();
        try {
            state = bc.getState();
        }
        catch (BrokerException ex) {
            logger.logStack(16, "INFO-REQUEST", ex);
            state = BrokerState.INITIALIZING;
        }
        Hashtable<String, Object> ht = new Hashtable<String, Object>();
        ht.put("BrokerID", bc.getBrokerName());
        ht.put("brokerURL", bc.getBrokerURL().toString());
        ht.put("State", InfoRequestHandler.mapStateToInt(state));
        ht.put("StateString", state.toString());
        ht.put("isLocal", bc.isLocalBroker());
        return ht;
    }

    static int mapStateToInt(BrokerState state) {
        if (state == BrokerState.INITIALIZING) {
            return 1;
        }
        if (state == BrokerState.OPERATING) {
            return 2;
        }
        if (state == BrokerState.QUIESCE_STARTED) {
            return 3;
        }
        if (state == BrokerState.QUIESCE_COMPLETED) {
            return 4;
        }
        if (state == BrokerState.SHUTDOWN_STARTED) {
            return 7;
        }
        if (state == BrokerState.SHUTDOWN_FAILOVER) {
            return 8;
        }
        if (state == BrokerState.SHUTDOWN_COMPLETE) {
            return 8;
        }
        if (state == BrokerState.FAILOVER_PENDING) {
            return 5;
        }
        if (state == BrokerState.FAILOVER_STARTED) {
            return 5;
        }
        if (state == BrokerState.FAILOVER_COMPLETE) {
            return 6;
        }
        if (state == BrokerState.FAILOVER_FAILED) {
            return 6;
        }
        return 0;
    }
}

