/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data.handlers.admin;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.io.Status;
import com.sun.messaging.jmq.jmsserver.Broker;
import com.sun.messaging.jmq.jmsserver.BrokerStateHandler;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.cluster.api.ClusterManager;
import com.sun.messaging.jmq.jmsserver.core.BrokerMQAddress;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.AdminCmdHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.AdminDataHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.ExclusiveRequest;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsservice.BrokerEvent;
import com.sun.messaging.jmq.util.admin.MessageType;
import java.util.Hashtable;

public class ChangeClusterMasterBrokerHandler
extends AdminCmdHandler {
    private static boolean DEBUG = ChangeClusterMasterBrokerHandler.getDEBUG();

    public ChangeClusterMasterBrokerHandler(AdminDataHandler parent) {
        super(parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean handle(IMQConnection con, Packet cmd_msg, Hashtable cmd_props) {
        int status = 200;
        String emsg = null;
        if (DEBUG) {
            this.logger.log(8, this.getClass().getName() + ": " + cmd_props);
        }
        boolean notificationOnly = false;
        boolean fromJMSRA = false;
        String oldmb = (String)cmd_props.get("JMQClusterOldMasterBroker");
        String newmb = (String)cmd_props.get("JMQClusterNewMasterBroker");
        Object val = cmd_props.get("JMQJMSRAManagedBroker");
        if (val != null && Boolean.valueOf(val.toString()).booleanValue()) {
            fromJMSRA = true;
        }
        if ((val = cmd_props.get("JMQJMSRANotificationOnly")) != null && Boolean.valueOf(val.toString()).booleanValue() && fromJMSRA && Globals.isJMSRAManagedBroker()) {
            notificationOnly = true;
        }
        this.logger.log(8, Globals.getBrokerResources().getKString("B1382", MessageType.getString(96) + "[" + "JMQClusterNewMasterBroker" + "=" + newmb + ", " + "JMQClusterOldMasterBroker" + "=" + oldmb + "]" + (fromJMSRA ? "JMSRA" : "") + (notificationOnly ? "(JMQJMSRANotificationOnly)" : "")));
        if (Globals.getHAEnabled()) {
            status = 412;
            emsg = this.rb.getKString("B3262", MessageType.getString(96));
            this.logger.log(32, emsg);
            this.sendReply(status, emsg, con, cmd_msg);
            return true;
        }
        if (Globals.useSharedConfigRecord()) {
            status = 412;
            emsg = this.rb.getKString("B3271", MessageType.getString(96));
            this.logger.log(32, emsg);
            this.sendReply(status, emsg, con, cmd_msg);
            return true;
        }
        try {
            BrokerStateHandler.setExclusiveRequestLock(ExclusiveRequest.CHANGE_MASTER_BROKER);
        }
        catch (Throwable t) {
            status = 412;
            if (t instanceof BrokerException) {
                status = ((BrokerException)t).getStatusCode();
            }
            emsg = MessageType.getString(96) + ": " + Status.getString(status) + " - " + t.getMessage();
            this.logger.log(32, emsg);
            status = 412;
            this.sendReply(status, emsg, con, cmd_msg);
            return true;
        }
        try {
            if (!Globals.dynamicChangeMasterBrokerEnabled()) {
                throw new BrokerException(Globals.getBrokerResources().getKString("B4356"), 405);
            }
            if (newmb == null) {
                throw new IllegalArgumentException("null JMQClusterNewMasterBroker");
            }
            if (!fromJMSRA && Globals.isJMSRAManagedBroker()) {
                throw new IllegalAccessException(Globals.getBrokerResources().getKString("B4354"));
            }
            ClusterManager cm = Globals.getClusterManager();
            BrokerMQAddress self = (BrokerMQAddress)cm.getMQAddress();
            BrokerMQAddress master = cm.getMasterBroker() == null ? null : (BrokerMQAddress)cm.getMasterBroker().getBrokerURL();
            BrokerMQAddress newmba = BrokerMQAddress.createAddress(newmb);
            BrokerMQAddress oldmba = null;
            if (oldmb != null) {
                oldmba = BrokerMQAddress.createAddress(oldmb);
            }
            if (notificationOnly) {
                if (master == null) {
                    emsg = "IllegalStateException for notification " + MessageType.getString(96) + ": No master broker";
                    this.logger.log(32, emsg);
                    this.sendReply(500, emsg, con, cmd_msg);
                    Broker.getBroker().exit(1, emsg, BrokerEvent.Type.ERROR);
                    throw new IllegalStateException(emsg);
                }
                if (newmba.equals(self) && !master.equals(self)) {
                    emsg = "IllegalStateException for notification " + MessageType.getString(96) + ": This broker, which has master broker " + master + ", is not the master broker as expected";
                    this.logger.log(32, emsg);
                    this.sendReply(500, emsg, con, cmd_msg);
                    Broker.getBroker().exit(1, emsg, BrokerEvent.Type.ERROR);
                    boolean bl = true;
                    return bl;
                }
                if (oldmba != null && oldmba.equals(self) && !master.equals(newmba)) {
                    emsg = "IllegalStateException for notification " + MessageType.getString(96) + ": This broker, which is the old master broker " + oldmba + ", does not have " + newmba + " as the master broker as expected";
                    this.logger.log(32, emsg);
                    this.sendReply(500, emsg, con, cmd_msg);
                    Broker.getBroker().exit(1, emsg, BrokerEvent.Type.ERROR);
                    boolean bl = true;
                    return bl;
                }
                this.sendReply(200, null, con, cmd_msg);
                boolean bl = true;
                return bl;
            }
            if (master == null) {
                throw new BrokerException(Globals.getBrokerResources().getKString("B4333"), 412);
            }
            if (newmba.equals(master)) {
                this.logger.log(8, Globals.getBrokerResources().getKString("B1379", newmba));
                this.sendReply(200, null, con, cmd_msg);
                boolean bl = true;
                return bl;
            }
            if (oldmba == null) {
                oldmba = master;
            }
            if (!oldmba.equals(master)) {
                throw new BrokerException(Globals.getBrokerResources().getKString("B4337", oldmba.toString(), master), 412);
            }
            if (!self.equals(master)) {
                if (!Globals.isJMSRAManagedBroker()) {
                    throw new BrokerException(Globals.getBrokerResources().getKString("B4339", master.toString()), 405);
                }
                this.sendReply(200, null, con, cmd_msg);
                boolean bl = true;
                return bl;
            }
            Globals.getClusterBroadcast().changeMasterBroker(newmba, oldmba);
            this.sendReply(200, null, con, cmd_msg);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            status = 500;
            emsg = e.getMessage();
            if (e instanceof BrokerException) {
                status = ((BrokerException)e).getStatusCode();
                emsg = emsg + "[" + Status.getString(status) + "]";
            }
            this.logger.logStack(32, emsg, e);
            this.sendReply(status, emsg, con, cmd_msg);
            boolean bl = true;
            return bl;
        }
        finally {
            BrokerStateHandler.unsetExclusiveRequestLock(ExclusiveRequest.CHANGE_MASTER_BROKER);
        }
    }

    private void sendReply(int status, String emsg, IMQConnection con, Packet cmd_msg) {
        Packet reply = new Packet(con.useDirectBuffers());
        reply.setPacketType(5);
        ChangeClusterMasterBrokerHandler.setProperties(reply, 97, status, emsg);
        this.parent.sendReply(con, cmd_msg, reply);
    }
}

