/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.api;

import com.sun.messaging.jmq.jmsserver.BrokerStateHandler;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.config.BrokerConfig;
import com.sun.messaging.jmq.jmsserver.persist.api.Store;
import com.sun.messaging.jmq.jmsserver.persist.api.TxnLoggingStore;
import com.sun.messaging.jmq.jmsserver.persist.api.sharecc.ShareConfigChangeStore;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.log.Logger;
import java.lang.annotation.Annotation;

public class StoreManager {
    private static final String PERSIST_PROP_PREFIX = "imq.persist.";
    private static final String CLASS_PROP = ".class";
    public static final String STORE_TYPE_PROP = "imq.persist.store";
    private static final String TXNLOG_ENABLED_PROP = "imq.persist.file.txnLog.enabled";
    public static final String NEW_TXNLOG_ENABLED_PROP = "imq.persist.file.newTxnLog.enabled";
    public static final boolean NEW_TXNLOG_ENABLED_PROP_DEFAULT = true;
    private static final String COHERENCE_SERVER_ENABLED_PROP = "imq.persist.coherenceServer.enabled";
    private static final boolean COHERENCE_SERVER_ENABLED_DEFAULT = false;
    public static final String BDB_REPLICATION_PROP_PREFIX = "imq.persist.bdb.replication.";
    public static final String BDB_REPLICATION_ENABLED_PROP = "imq.persist.bdb.replication.enabled";
    public static final String BDB_ACTIVE_REPLICA_PROP = "imq.persist.bdb.replication.activeReplica";
    public static final String BDB_SHARED_FS_PROP = "imq.persist.bdb.sharedfs";
    public static final boolean BDB_SHARED_FS_DEFAULT = false;
    public static final boolean BDB_ACTIVE_REPLICA_DEFAULT = true;
    public static final boolean BDB_REPLICATION_ENABLED_DEFAULT = false;
    private static final String DEFAULT_STORE_TYPE = "file";
    private static final String DEFAULT_FILESTORE_CLASS = "com.sun.messaging.jmq.jmsserver.persist.file.FileStore";
    private static final String DEFAULT_JDBCSTORE_CLASS = "com.sun.messaging.jmq.jmsserver.persist.jdbc.JDBCStore";
    private static final String DEFAULT_INMEMORYSTORE_CLASS = "com.sun.messaging.jmq.jmsserver.persist.inmemory.InMemoryStore";
    private static final String DEFAULT_COHERENCESTORE_CLASS = "com.sun.messaging.jmq.jmsserver.persist.coherence.CoherenceStore";
    private static final String DEFAULT_BDBSTORE_CLASS = "com.sun.messaging.jmq.jmsserver.persist.bdb.BDBStore";
    public static final String PARTITION_MODE_PROP = "imq.persist.partitionMode.enabled";
    private static Boolean isConfiguredFileStore = null;
    private static Boolean isConfiguredJDBCStore = null;
    private static Boolean isConfiguredBDBStore = null;
    private static Boolean isConfiguredCoherenceStore = null;
    private static Boolean txnLogEnabled = null;
    private static Boolean newTxnLogEnabled = null;
    private static Store store = null;
    private static ShareConfigChangeStore shareccStore = null;

    public static synchronized Store getStore() throws BrokerException {
        Logger logger = Globals.getLogger();
        BrokerResources br = Globals.getBrokerResources();
        if (store == null) {
            if (BrokerStateHandler.isShuttingDown()) {
                throw new BrokerException(Globals.getBrokerResources().getKString("B4140"), "B4140");
            }
            BrokerConfig config = Globals.getConfig();
            String type = config.getProperty(STORE_TYPE_PROP, DEFAULT_STORE_TYPE);
            if (Store.getDEBUG()) {
                logger.log(4, "imq.persist.store=" + type);
            }
            String classname = config.getProperty(PERSIST_PROP_PREFIX + type + CLASS_PROP);
            isConfiguredFileStore = false;
            isConfiguredJDBCStore = false;
            isConfiguredBDBStore = false;
            if (classname == null || classname.equals("")) {
                if (type.equals(DEFAULT_STORE_TYPE)) {
                    classname = DEFAULT_FILESTORE_CLASS;
                    isConfiguredFileStore = true;
                } else if (type.equals("jdbc")) {
                    classname = DEFAULT_JDBCSTORE_CLASS;
                    isConfiguredJDBCStore = true;
                } else if (type.equals("inmemory")) {
                    classname = DEFAULT_INMEMORYSTORE_CLASS;
                } else if (type.equals("coherence")) {
                    classname = DEFAULT_COHERENCESTORE_CLASS;
                    isConfiguredCoherenceStore = true;
                } else if (type.equals("bdb")) {
                    classname = DEFAULT_BDBSTORE_CLASS;
                    isConfiguredBDBStore = true;
                } else {
                    classname = null;
                }
            }
            if (classname == null) {
                throw new BrokerException(br.getString("B3005", type));
            }
            if (Store.getDEBUG()) {
                logger.log(4, PERSIST_PROP_PREFIX + type + CLASS_PROP + "=" + classname);
            }
            try {
                boolean reload = false;
                do {
                    store = Globals.isNucleusManagedBroker() ? (Store)Globals.getHabitat().getService(Store.class, classname, new Annotation[0]) : (Store)Class.forName(classname).newInstance();
                    txnLogEnabled = config.getBooleanProperty(TXNLOG_ENABLED_PROP, false);
                    newTxnLogEnabled = config.getBooleanProperty(NEW_TXNLOG_ENABLED_PROP, true);
                    if (!isConfiguredFileStore.booleanValue()) {
                        if (txnLogEnabled.booleanValue()) {
                            logger.log(16, Globals.getBrokerResources().getKString("B2219", "imq.persist.file.txnLog.enabled=true"));
                        }
                        if (newTxnLogEnabled.booleanValue()) {
                            logger.log(16, Globals.getBrokerResources().getKString("B2219", "imq.persist.file.newTxnLog.enabled=true"));
                        }
                        break;
                    }
                    Globals.isMinimumPersistLevel2();
                    if (Globals.isNewTxnLogEnabled()) {
                        return store;
                    }
                    if (reload) {
                        if (((TxnLoggingStore)((Object)store)).initTxnLogger()) {
                            throw new BrokerException(br.getString("B3228"));
                        }
                        break;
                    }
                    reload = ((TxnLoggingStore)((Object)store)).initTxnLogger();
                    if (!reload) continue;
                    store.close();
                    store = null;
                } while (reload);
            }
            catch (Exception e) {
                if (e instanceof BrokerException) {
                    throw (BrokerException)e;
                }
                throw new BrokerException(br.getString("B3006"), e);
            }
        }
        return store;
    }

    public static boolean isConfiguredFileStore() {
        Boolean isfs = isConfiguredFileStore;
        if (isfs != null) {
            return isfs;
        }
        String type = Globals.getConfig().getProperty(STORE_TYPE_PROP, DEFAULT_STORE_TYPE);
        return type.equals(DEFAULT_STORE_TYPE);
    }

    public static boolean isConfiguredJDBCStore() {
        Boolean isjdbc = isConfiguredJDBCStore;
        if (isjdbc != null) {
            return isjdbc;
        }
        String type = Globals.getConfig().getProperty(STORE_TYPE_PROP, DEFAULT_STORE_TYPE);
        return type.equals("jdbc");
    }

    public static boolean isConfiguredBDBStore() {
        Boolean isbdb = isConfiguredBDBStore;
        if (isbdb != null) {
            return isbdb;
        }
        String type = Globals.getConfig().getProperty(STORE_TYPE_PROP, DEFAULT_STORE_TYPE);
        return type.equals("bdb");
    }

    public static boolean isConfiguredCoherenceStore() {
        Boolean isch = isConfiguredCoherenceStore;
        if (isch != null) {
            return isch;
        }
        String type = Globals.getConfig().getProperty(STORE_TYPE_PROP, DEFAULT_STORE_TYPE);
        return type.equals("coherence");
    }

    public static boolean bdbREPEnabled() {
        return StoreManager.isConfiguredBDBStore() && Globals.getConfig().getBooleanProperty(BDB_REPLICATION_ENABLED_PROP, false);
    }

    public static boolean isConfiguredBDBSharedFS() {
        return StoreManager.isConfiguredBDBStore() && Globals.getConfig().getBooleanProperty(BDB_SHARED_FS_PROP, false);
    }

    public static boolean isConfiguredCoherenceServer() {
        return StoreManager.isConfiguredCoherenceStore() || Globals.getConfig().getBooleanProperty(COHERENCE_SERVER_ENABLED_PROP, false);
    }

    public static boolean isConfiguredPartitionMode(boolean deft) {
        return Globals.getConfig().getBooleanProperty(PARTITION_MODE_PROP, deft);
    }

    public static boolean txnLogEnabled() {
        if (!StoreManager.isConfiguredFileStore()) {
            return false;
        }
        Boolean tloge = txnLogEnabled;
        if (tloge != null) {
            return tloge;
        }
        return Globals.getConfig().getBooleanProperty(TXNLOG_ENABLED_PROP, false);
    }

    public static boolean newTxnLogEnabled() {
        if (!StoreManager.isConfiguredFileStore()) {
            return false;
        }
        Boolean ntloge = newTxnLogEnabled;
        if (ntloge != null) {
            return ntloge;
        }
        return Globals.getConfig().getBooleanProperty(NEW_TXNLOG_ENABLED_PROP, true);
    }

    public static synchronized ShareConfigChangeStore getShareConfigChangeStore() throws BrokerException {
        if (BrokerStateHandler.isShuttingDown()) {
            throw new BrokerException(Globals.getBrokerResources().getKString("B4140"), "B4140");
        }
        if (shareccStore == null) {
            shareccStore = ShareConfigChangeStore.getStore();
        }
        return shareccStore;
    }

    public static synchronized void releaseStore(boolean cleanup) {
        if (store != null) {
            if (!store.isClosed()) {
                store.close(cleanup);
            }
            store = null;
        }
        if (shareccStore != null) {
            shareccStore.close();
            shareccStore = null;
        }
        isConfiguredFileStore = null;
        txnLogEnabled = null;
        newTxnLogEnabled = null;
    }

    public static Store getStoreForTonga(String jdbcLockStoreProp, String dbpoolNumConnProp) throws BrokerException {
        BrokerConfig config = Globals.getConfig();
        String type = config.getProperty(STORE_TYPE_PROP, DEFAULT_STORE_TYPE);
        if (type.equals("jdbc")) {
            config.put(jdbcLockStoreProp, "false");
            config.put(dbpoolNumConnProp, "2");
        }
        return StoreManager.getStore();
    }
}

