/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.jdbc;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.persist.api.Store;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.BaseDAOImpl;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DBManager;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.PropertyDAO;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.Util;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;

class PropertyDAOImpl
extends BaseDAOImpl
implements PropertyDAO {
    private final String tableName;
    private final String insertSQL;
    private final String updateSQL;
    private final String deleteSQL;
    private final String selectSQL;
    private final String selectAllNamesSQL;
    private final String selectAllSQL;

    PropertyDAOImpl() throws BrokerException {
        DBManager dbMgr = DBManager.getDBManager();
        this.tableName = dbMgr.getTableName("MQPROP41");
        this.insertSQL = new StringBuffer(128).append("INSERT INTO ").append(this.tableName).append(" ( ").append("PROPNAME").append(", ").append("PROPVALUE").append(") VALUES ( ?, ? )").toString();
        this.updateSQL = new StringBuffer(128).append("UPDATE ").append(this.tableName).append(" SET ").append("PROPVALUE").append(" = ?").append(" WHERE ").append("PROPNAME").append(" = ?").toString();
        this.deleteSQL = new StringBuffer(128).append("DELETE FROM ").append(this.tableName).append(" WHERE ").append("PROPNAME").append(" = ?").toString();
        this.selectSQL = new StringBuffer(128).append("SELECT ").append("PROPVALUE").append(" FROM ").append(this.tableName).append(" WHERE ").append("PROPNAME").append(" = ?").toString();
        this.selectAllNamesSQL = new StringBuffer(128).append("SELECT ").append("PROPNAME").append(" FROM ").append(this.tableName).toString();
        this.selectAllSQL = new StringBuffer(128).append("SELECT ").append("PROPNAME").append(", ").append("PROPVALUE").append(" FROM ").append(this.tableName).toString();
    }

    @Override
    public final String getTableNamePrefix() {
        return "MQPROP41";
    }

    @Override
    public final String getTableName() {
        return this.tableName;
    }

    @Override
    public void update(Connection conn, String name, Object value) throws BrokerException {
        boolean myConn = false;
        String sql = null;
        PreparedStatement pstmt = null;
        Exception myex = null;
        try {
            DBManager dbMgr = DBManager.getDBManager();
            if (conn == null) {
                conn = dbMgr.getConnection(true);
                myConn = true;
            }
            if (this.hasProperty(conn, name)) {
                if (value != null) {
                    sql = this.updateSQL;
                    pstmt = DBManager.createPreparedStatement(conn, sql);
                    Util.setObject(pstmt, 1, value);
                    pstmt.setString(2, name);
                    pstmt.executeUpdate();
                } else {
                    sql = this.deleteSQL;
                    pstmt = DBManager.createPreparedStatement(conn, sql);
                    pstmt.setString(1, name);
                    pstmt.executeUpdate();
                }
            } else if (value != null) {
                sql = this.insertSQL;
                pstmt = DBManager.createPreparedStatement(conn, sql);
                pstmt.setString(1, name);
                Util.setObject(pstmt, 2, value);
                pstmt.executeUpdate();
            }
        }
        catch (Exception e) {
            myex = e;
            try {
                if (conn != null && !conn.getAutoCommit()) {
                    conn.rollback();
                }
            }
            catch (SQLException rbe) {
                this.logger.log(32, "B4080", rbe);
            }
            if (e instanceof BrokerException) {
                throw (BrokerException)e;
            }
            Exception ex = e instanceof IOException ? DBManager.wrapIOException("[" + sql + "]", (IOException)e) : (e instanceof SQLException ? DBManager.wrapSQLException("[" + sql + "]", (SQLException)e) : e);
            throw new BrokerException(this.br.getKString("B4112", name), ex);
        }
        finally {
            if (myConn) {
                Util.close(null, pstmt, conn, myex);
            } else {
                Util.close(null, pstmt, null, myex);
            }
        }
    }

    @Override
    public void delete(Connection conn, String name) throws BrokerException {
        block12: {
            Exception myex;
            PreparedStatement pstmt;
            block11: {
                boolean myConn = false;
                pstmt = null;
                myex = null;
                try {
                    DBManager dbMgr = DBManager.getDBManager();
                    if (conn == null) {
                        conn = dbMgr.getConnection(true);
                        myConn = true;
                    }
                    pstmt = DBManager.createPreparedStatement(conn, this.deleteSQL);
                    pstmt.setString(1, name);
                    pstmt.executeUpdate();
                    if (!myConn) break block11;
                }
                catch (Exception e) {
                    try {
                        myex = e;
                        try {
                            if (conn != null && !conn.getAutoCommit()) {
                                conn.rollback();
                            }
                        }
                        catch (SQLException rbe) {
                            this.logger.log(32, "B4080", rbe);
                        }
                        if (e instanceof BrokerException) {
                            throw (BrokerException)e;
                        }
                        Exception ex = e instanceof SQLException ? DBManager.wrapSQLException("[" + this.deleteSQL + "]", (SQLException)e) : e;
                        throw new BrokerException(this.br.getKString("B4232", name), ex);
                    }
                    catch (Throwable throwable) {
                        if (myConn) {
                            Util.close(null, pstmt, conn, myex);
                        } else {
                            Util.close(null, pstmt, null, myex);
                        }
                        throw throwable;
                    }
                }
                Util.close(null, pstmt, conn, myex);
                break block12;
            }
            Util.close(null, pstmt, null, myex);
        }
    }

    @Override
    public void deleteAll(Connection conn) throws BrokerException {
        if (Globals.getHAEnabled()) {
            return;
        }
        String whereClause = new StringBuffer(128).append("PROPNAME").append(" <> '").append("imq.bridge.jmsbridge.tables").append("'").toString();
        super.deleteAll(conn, whereClause, null, 0);
    }

    @Override
    public Object getProperty(Connection conn, String name) throws BrokerException {
        Object propObj;
        block15: {
            Exception myex;
            ResultSet rs;
            PreparedStatement pstmt;
            block14: {
                propObj = null;
                boolean myConn = false;
                pstmt = null;
                rs = null;
                myex = null;
                try {
                    DBManager dbMgr = DBManager.getDBManager();
                    if (conn == null) {
                        conn = dbMgr.getConnection(true);
                        myConn = true;
                    }
                    pstmt = DBManager.createPreparedStatement(conn, this.selectSQL);
                    pstmt.setString(1, name);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        try {
                            propObj = Util.readObject(rs, 1);
                        }
                        catch (IOException e) {
                            this.logger.logStack(32, "B4126", name, (Throwable)e);
                        }
                    }
                    if (!myConn) break block14;
                }
                catch (Exception e) {
                    try {
                        myex = e;
                        try {
                            if (conn != null && !conn.getAutoCommit()) {
                                conn.rollback();
                            }
                        }
                        catch (SQLException rbe) {
                            this.logger.log(32, "B4080[" + this.selectSQL + "]", rbe);
                        }
                        if (e instanceof BrokerException) {
                            throw (BrokerException)e;
                        }
                        Exception ex = e instanceof SQLException ? DBManager.wrapSQLException("[" + this.selectSQL + "]", (SQLException)e) : e;
                        throw new BrokerException(this.br.getKString("B4231", name), ex);
                    }
                    catch (Throwable throwable) {
                        if (myConn) {
                            Util.close(rs, pstmt, conn, myex);
                        } else {
                            Util.close(rs, pstmt, null, myex);
                        }
                        throw throwable;
                    }
                }
                Util.close(rs, pstmt, conn, myex);
                break block15;
            }
            Util.close(rs, pstmt, null, myex);
        }
        return propObj;
    }

    @Override
    public List getPropertyNames(Connection conn) throws BrokerException {
        ArrayList<String> list;
        block13: {
            Exception myex;
            ResultSet rs;
            PreparedStatement pstmt;
            block12: {
                list = new ArrayList<String>();
                boolean myConn = false;
                pstmt = null;
                rs = null;
                myex = null;
                try {
                    DBManager dbMgr = DBManager.getDBManager();
                    if (conn == null) {
                        conn = dbMgr.getConnection(true);
                        myConn = true;
                    }
                    pstmt = DBManager.createPreparedStatement(conn, this.selectAllNamesSQL);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        String name = rs.getString(1);
                        list.add(name);
                    }
                    if (!myConn) break block12;
                }
                catch (Exception e) {
                    try {
                        myex = e;
                        try {
                            if (conn != null && !conn.getAutoCommit()) {
                                conn.rollback();
                            }
                        }
                        catch (SQLException rbe) {
                            this.logger.log(32, "B4080[" + this.selectAllNamesSQL + "]", rbe);
                        }
                        if (e instanceof BrokerException) {
                            throw (BrokerException)e;
                        }
                        Exception ex = e instanceof SQLException ? DBManager.wrapSQLException("[" + this.selectAllNamesSQL + "]", (SQLException)e) : e;
                        throw new BrokerException(this.br.getKString("B4113"), ex);
                    }
                    catch (Throwable throwable) {
                        if (myConn) {
                            Util.close(rs, pstmt, conn, myex);
                        } else {
                            Util.close(rs, pstmt, null, myex);
                        }
                        throw throwable;
                    }
                }
                Util.close(rs, pstmt, conn, myex);
                break block13;
            }
            Util.close(rs, pstmt, null, myex);
        }
        return list;
    }

    @Override
    public Properties getProperties(Connection conn) throws BrokerException {
        Properties props;
        block16: {
            Exception myex;
            ResultSet rs;
            PreparedStatement pstmt;
            block15: {
                props = new Properties();
                boolean myConn = false;
                pstmt = null;
                rs = null;
                myex = null;
                try {
                    DBManager dbMgr = DBManager.getDBManager();
                    if (conn == null) {
                        conn = dbMgr.getConnection(true);
                        myConn = true;
                    }
                    pstmt = DBManager.createPreparedStatement(conn, this.selectAllSQL);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        String name = rs.getString("PROPNAME");
                        try {
                            Object obj = Util.readObject(rs, 2);
                            props.put(name, obj);
                        }
                        catch (IOException e) {
                            this.logger.logStack(32, "B4126", name, (Throwable)e);
                        }
                    }
                    if (Store.getDEBUG()) {
                        this.logger.log(4, "LOADED " + props.size() + " PROPERTIES FROM DATABASE");
                    }
                    if (!myConn) break block15;
                }
                catch (Exception e) {
                    try {
                        myex = e;
                        try {
                            if (conn != null && !conn.getAutoCommit()) {
                                conn.rollback();
                            }
                        }
                        catch (SQLException rbe) {
                            this.logger.log(32, "B4080[" + this.selectAllSQL + "]", rbe);
                        }
                        if (e instanceof BrokerException) {
                            throw (BrokerException)e;
                        }
                        Exception ex = e instanceof SQLException ? DBManager.wrapSQLException("[" + this.selectAllSQL + "]", (SQLException)e) : e;
                        throw new BrokerException(this.br.getKString("B4113"), ex);
                    }
                    catch (Throwable throwable) {
                        if (myConn) {
                            Util.close(rs, pstmt, conn, myex);
                        } else {
                            Util.close(rs, pstmt, null, myex);
                        }
                        throw throwable;
                    }
                }
                Util.close(rs, pstmt, conn, myex);
                break block16;
            }
            Util.close(rs, pstmt, null, myex);
        }
        return props;
    }

    @Override
    public boolean hasProperty(Connection conn, String name) throws BrokerException {
        boolean found;
        block13: {
            Exception myex;
            ResultSet rs;
            PreparedStatement pstmt;
            block12: {
                found = false;
                boolean myConn = false;
                pstmt = null;
                rs = null;
                myex = null;
                try {
                    DBManager dbMgr = DBManager.getDBManager();
                    if (conn == null) {
                        conn = dbMgr.getConnection(true);
                        myConn = true;
                    }
                    pstmt = DBManager.createPreparedStatement(conn, this.selectSQL);
                    pstmt.setString(1, name);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        found = true;
                    }
                    if (!myConn) break block12;
                }
                catch (Exception e) {
                    try {
                        myex = e;
                        try {
                            if (conn != null && !conn.getAutoCommit()) {
                                conn.rollback();
                            }
                        }
                        catch (SQLException rbe) {
                            this.logger.log(32, "B4080[" + this.selectSQL + "]", rbe);
                        }
                        if (e instanceof BrokerException) {
                            throw (BrokerException)e;
                        }
                        Exception ex = e instanceof SQLException ? DBManager.wrapSQLException("[" + this.selectSQL + "]", (SQLException)e) : e;
                        throw new BrokerException(this.br.getKString("B4231", name), ex);
                    }
                    catch (Throwable throwable) {
                        if (myConn) {
                            Util.close(rs, pstmt, conn, myex);
                        } else {
                            Util.close(rs, pstmt, null, myex);
                        }
                        throw throwable;
                    }
                }
                Util.close(rs, pstmt, conn, myex);
                break block13;
            }
            Util.close(rs, pstmt, null, myex);
        }
        return found;
    }

    @Override
    public HashMap getDebugInfo(Connection conn) {
        HashMap<String, String> map = new HashMap<String, String>();
        int count = -1;
        try {
            count = this.getRowCount(null, null);
        }
        catch (Exception e) {
            this.logger.log(32, e.getMessage(), e.getCause());
        }
        map.put("Properties(" + this.tableName + ")", String.valueOf(count));
        return map;
    }
}

