/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.service;

import com.sun.messaging.jmq.jmsserver.service.Service;
import com.sun.messaging.jmq.jmsserver.service.ServiceFactory;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import java.io.IOException;

class ServiceInfo {
    Service service;
    ServiceFactory handler;

    public ServiceInfo(Service service, ServiceFactory handler) {
        this.service = service;
        this.handler = handler;
    }

    public Service getService() {
        return this.service;
    }

    public ServiceFactory getServiceFactory() {
        return this.handler;
    }

    public int getState() {
        return this.service.getState();
    }

    public int getServiceType() {
        return this.service.getServiceType();
    }

    public void start(boolean pauseAtStart) throws BrokerException {
        this.handler.updateService(this.service);
        this.handler.startMonitoringService(this.service);
        this.service.startService(pauseAtStart);
    }

    public void stop(boolean all) throws BrokerException {
        this.service.stopService(all);
        this.handler.stopMonitoringService(this.service);
    }

    public void pause(boolean all) throws BrokerException {
        this.service.pauseService(all);
    }

    public void stopNewConnections() {
        try {
            this.service.stopNewConnections();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void startNewConnections() {
        try {
            this.service.startNewConnections();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void resume() throws BrokerException {
        this.service.resumeService();
    }

    public void destroy() throws BrokerException {
        this.stop(true);
        this.service.destroyService();
    }
}

