/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.admin.apps.console;

import com.sun.messaging.jmq.Version;
import com.sun.messaging.jmq.admin.apps.console.AController;
import com.sun.messaging.jmq.admin.apps.console.AExplorer;
import com.sun.messaging.jmq.admin.apps.console.AGraphics;
import com.sun.messaging.jmq.admin.apps.console.AInspector;
import com.sun.messaging.jmq.admin.apps.console.AMenuBar;
import com.sun.messaging.jmq.admin.apps.console.AStatusArea;
import com.sun.messaging.jmq.admin.apps.console.AToolBar;
import com.sun.messaging.jmq.admin.apps.console.ActionManager;
import com.sun.messaging.jmq.admin.apps.console.AdminApp;
import com.sun.messaging.jmq.admin.apps.console.BrokerListCObj;
import com.sun.messaging.jmq.admin.apps.console.ConsoleBrokerAdminManager;
import com.sun.messaging.jmq.admin.apps.console.ConsoleHelp;
import com.sun.messaging.jmq.admin.apps.console.ConsoleObj;
import com.sun.messaging.jmq.admin.apps.console.ConsoleObjStoreManager;
import com.sun.messaging.jmq.admin.apps.console.ObjStoreListCObj;
import com.sun.messaging.jmq.admin.bkrutil.BrokerAdmin;
import com.sun.messaging.jmq.admin.resources.AdminConsoleResources;
import com.sun.messaging.jmq.admin.resources.AdminResources;
import com.sun.messaging.jmq.admin.util.Globals;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JSplitPane;

public class AdminConsole
extends JFrame
implements AdminApp {
    private static final long serialVersionUID = -7522190888587622654L;
    private static AdminConsoleResources acr = Globals.getAdminConsoleResources();
    private static AdminResources ar = Globals.getAdminResources();
    private AMenuBar menuBar = null;
    private AToolBar toolBar = null;
    private AExplorer explorer = null;
    private AInspector inspector = null;
    private AStatusArea statusArea = null;
    private ActionManager actionMgr = null;
    private AController controller = null;
    private ObjStoreListCObj oslCObj = null;
    private BrokerListCObj blCObj = null;
    private ConsoleObj selObj = null;
    public static final String CONSOLE_VERSION1 = "-v";
    public static final String CONSOLE_VERSION2 = "-version";
    public static final String OPTION_HELP1 = "-h";
    public static final String OPTION_HELP2 = "-help";
    public static final String OPTION_DEBUG = "-debug";
    public static final String OPTION_VERBOSE = "-verbose";
    public static final String OPTION_VARHOME = "-varhome";
    public static final String OPTION_RECV_TIMEOUT = "-rtm";
    public static final String OPTION_NUM_RETRIES = "-rtr";
    public static final String OPTION_JAVAHOME = "-javahome";
    private static String[] close;

    public AdminConsole() {
        super("");
        this.setTitle(acr.getString("A1200", Globals.getVersion().getProductName()));
        this.initMgrs();
        this.initGui();
        this.controller.init();
    }

    @Override
    public Frame getFrame() {
        return this;
    }

    @Override
    public AMenuBar getMenubar() {
        return this.menuBar;
    }

    @Override
    public AToolBar getToolbar() {
        return this.toolBar;
    }

    @Override
    public AExplorer getExplorer() {
        return this.explorer;
    }

    @Override
    public AInspector getInspector() {
        return this.inspector;
    }

    @Override
    public AStatusArea getStatusArea() {
        return this.statusArea;
    }

    @Override
    public ActionManager getActionManager() {
        return this.actionMgr;
    }

    @Override
    public ObjStoreListCObj getObjStoreListCObj() {
        return this.oslCObj;
    }

    @Override
    public BrokerListCObj getBrokerListCObj() {
        return this.blCObj;
    }

    @Override
    public void setSelectedObj(ConsoleObj obj) {
        this.selObj = obj;
    }

    @Override
    public ConsoleObj getSelectedObj() {
        return this.selObj;
    }

    @Override
    public void setSelectedObjs(ConsoleObj[] obj) {
    }

    @Override
    public ConsoleObj[] getSelectedObjs() {
        return null;
    }

    private void initMgrs() {
        ConsoleObjStoreManager osMgr = ConsoleObjStoreManager.getConsoleObjStoreManager();
        this.oslCObj = new ObjStoreListCObj(osMgr);
        ConsoleBrokerAdminManager baMgr = new ConsoleBrokerAdminManager();
        this.blCObj = new BrokerListCObj(baMgr);
    }

    private void initGui() {
        this.getContentPane().setLayout(new BorderLayout());
        this.actionMgr = new ActionManager();
        this.menuBar = new AMenuBar(this.actionMgr);
        this.toolBar = new AToolBar(this.actionMgr);
        this.explorer = new AExplorer(this.actionMgr, this.oslCObj, this.blCObj);
        this.inspector = new AInspector();
        this.statusArea = new AStatusArea();
        this.controller = new AController(this);
        this.explorer.addAdminEventListener(this.controller);
        this.inspector.addAdminEventListener(this.controller);
        this.actionMgr.addAdminEventListener(this.controller);
        this.actionMgr.setActiveActions(0);
        this.setJMenuBar(this.menuBar);
        this.getContentPane().add((Component)this.toolBar, "North");
        JSplitPane splitPane = new JSplitPane(1);
        splitPane.setDividerLocation(200);
        splitPane.setOneTouchExpandable(true);
        splitPane.setPreferredSize(new Dimension(750, 450));
        splitPane.setTopComponent(this.explorer);
        splitPane.setBottomComponent(this.inspector);
        JSplitPane splitPane2 = new JSplitPane(0);
        splitPane2.setOneTouchExpandable(true);
        splitPane2.setTopComponent(splitPane);
        splitPane2.setBottomComponent(this.statusArea);
        this.getContentPane().add((Component)splitPane2, "Center");
        this.statusArea.appendText(acr.getString("A1200", Globals.getVersion().getProductName()) + "\n");
        this.setIconImage(AGraphics.adminImages[0].getImage());
    }

    private static void processCmdlineArgs(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            String val;
            if (args[i].equals(CONSOLE_VERSION1) || args[i].equals(CONSOLE_VERSION2)) {
                AdminConsole.printBanner();
                AdminConsole.printVersion();
                System.exit(0);
                continue;
            }
            if (args[i].equals(OPTION_HELP1) || args[i].equals(OPTION_HELP2)) {
                AdminConsole.printHelp();
                System.exit(0);
                continue;
            }
            if (args[i].equals(OPTION_DEBUG)) {
                BrokerAdmin.setDebug(true);
                continue;
            }
            if (args[i].equals(OPTION_RECV_TIMEOUT)) {
                if (i == args.length - 1) {
                    Globals.stdErrPrintln(ar.getString("A1001"), acr.getKString("A1509", args[i]), false);
                    System.exit(1);
                }
                val = args[++i];
                long longVal = 0L;
                try {
                    longVal = Long.parseLong(val);
                }
                catch (Exception e) {
                    Globals.stdErrPrintln(ar.getString("A1001"), acr.getKString("A3062", val), false);
                    System.exit(1);
                }
                BrokerAdmin.setDefaultTimeout(longVal * 1000L);
                continue;
            }
            if (args[i].equals(OPTION_NUM_RETRIES)) {
                if (i == args.length - 1) {
                    Globals.stdErrPrintln(ar.getString("A1001"), acr.getKString("A1509", args[i]), false);
                    System.exit(1);
                }
                val = args[++i];
                int intVal = 0;
                try {
                    intVal = Integer.parseInt(val);
                }
                catch (Exception e) {
                    Globals.stdErrPrintln(ar.getString("A1001"), acr.getKString("A3075", val), false);
                    System.exit(1);
                }
                BrokerAdmin.setDefaultNumRetries(intVal);
                continue;
            }
            if (args[i].equals(OPTION_JAVAHOME)) {
                if (i == args.length - 1) {
                    Globals.stdErrPrintln(ar.getString("A1001"), acr.getKString("A1509", args[i]), false);
                    System.exit(1);
                }
                ++i;
                continue;
            }
            if (args[i].equals(OPTION_VERBOSE)) continue;
            if (args[i].equals(OPTION_VARHOME)) {
                ++i;
                continue;
            }
            Globals.stdErrPrintln(ar.getString("A1001"), acr.getKString("A1510", args[i]), false);
            System.exit(1);
        }
    }

    private static void printVersion() {
        Version version = Globals.getVersion();
        Globals.stdOutPrintln(version.getVersion());
        Globals.stdOutPrintln(ar.getString("A1065") + System.getProperty("java.version") + " " + System.getProperty("java.vendor") + " " + System.getProperty("java.home"));
        Globals.stdOutPrintln(ar.getString("A1066") + System.getProperty("java.class.path"));
    }

    private static void printHelp() {
        Globals.stdOutPrintln(acr.getString("A1508"));
    }

    private static void printBanner() {
        Version version = new Version(false);
        Globals.stdOutPrintln(version.getBanner(false));
    }

    public static void main(String[] args) {
        AdminConsole.processCmdlineArgs(args);
        AGraphics.loadImages();
        ConsoleHelp.loadHelp();
        AdminConsole frame = new AdminConsole();
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        frame.pack();
        frame.setVisible(true);
        if (!ConsoleHelp.helpLoaded()) {
            Object s1 = acr.getString("A3084");
            String s2 = acr.getString("A1522") + ": " + acr.getString("A1218", "A3084");
            Exception e = ConsoleHelp.getHelpLoadException();
            if (e != null) {
                s1 = (String)s1 + "\n" + e.toString();
            }
            JOptionPane.showOptionDialog(frame, s1, s2, 0, 0, null, close, close[0]);
        }
    }

    static {
        String[] stringArray = new String[1];
        stringArray[0] = acr.getString("A1081");
        close = stringArray;
    }
}

