/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.admin.apps.console;

import com.sun.messaging.jmq.admin.apps.console.AdminDialog;
import com.sun.messaging.jmq.admin.apps.console.ObjStoreListCObj;
import com.sun.messaging.jmq.admin.apps.console.util.LabelValuePanel;
import com.sun.messaging.jmq.admin.apps.console.util.LabelledComponent;
import com.sun.messaging.jmq.admin.objstore.ObjStoreManager;
import com.sun.messaging.jmq.admin.resources.AdminConsoleResources;
import com.sun.messaging.jmq.admin.util.Globals;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.File;
import java.net.URI;
import java.util.Enumeration;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;

public class ObjStoreDialog
extends AdminDialog
implements ListSelectionListener {
    private static final long serialVersionUID = 1800350885238627037L;
    protected JTextField osText;
    protected LabelValuePanel lvp;
    protected ObjStoreManager osMgr = null;
    protected Properties jndiProps = new Properties();
    protected JComboBox comboBox;
    protected JCheckBox checkBox;
    protected PropsTableModel model;
    protected JButton addButton;
    protected JButton delButton;
    protected JButton chgButton;
    protected boolean dirty = false;
    protected JTextField valueText;
    protected JTable table;
    protected JTextArea ta;
    private boolean editable;
    private static AdminConsoleResources acr = Globals.getAdminConsoleResources();
    private static String[] close;
    private static String[] columnNames;

    public ObjStoreDialog(Frame parent, String title, ObjStoreListCObj oslCObj) {
        super(parent, title, 81);
        if (oslCObj != null) {
            this.osMgr = oslCObj.getObjStoreManager();
        }
    }

    public ObjStoreDialog(Frame parent, String title, int whichButtons, ObjStoreListCObj oslCObj) {
        super(parent, title, whichButtons);
        if (oslCObj != null) {
            this.osMgr = oslCObj.getObjStoreManager();
        }
    }

    @Override
    public JPanel createWorkPanel() {
        String[] jndiPropNames = new String[]{"java.naming.factory.initial", "java.naming.factory.object", "java.naming.factory.state", "java.naming.factory.url.pkgs", "java.naming.provider.url", "java.naming.dns.url", "java.naming.authoritative", "java.naming.batchsize", "java.naming.referral", "java.naming.security.protocol", "java.naming.security.authentication", "java.naming.security.principal", "java.naming.security.credentials", "java.naming.language", "java.naming.applet"};
        boolean propsDlg = false;
        if (this.getTitle().equals(acr.getString("A1309"))) {
            propsDlg = true;
        }
        JPanel workPanel = new JPanel();
        workPanel.setLayout(new BorderLayout());
        JPanel panel1 = new JPanel();
        GridBagLayout gridbag = new GridBagLayout();
        panel1.setLayout(gridbag);
        GridBagConstraints c = new GridBagConstraints();
        JPanel osPanel = new JPanel();
        GridBagLayout gb = new GridBagLayout();
        osPanel.setLayout(gb);
        GridBagConstraints c1 = new GridBagConstraints();
        JLabel storeLabel = new JLabel(acr.getString("A1310") + ":");
        c1.gridx = 0;
        c1.gridy = 0;
        c1.anchor = 12;
        gridbag.setConstraints(storeLabel, c1);
        osPanel.add(storeLabel);
        this.osText = new JTextField(25);
        ObjStoreDocumentListener docListener = new ObjStoreDocumentListener();
        this.osText.getDocument().addDocumentListener(docListener);
        c1.gridx = 1;
        c1.gridy = 0;
        c1.anchor = 17;
        c1.insets = new Insets(0, 5, 0, 0);
        gb.setConstraints(this.osText, c1);
        osPanel.add(this.osText);
        c.gridx = 0;
        c.gridy = 0;
        c1.anchor = 17;
        panel1.add(osPanel);
        this.checkBox = propsDlg ? new JCheckBox(acr.getString("A1210"), true) : new JCheckBox(acr.getString("A1209"), true);
        this.checkBox.addActionListener(this);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 3;
        c.insets = new Insets(0, 0, 0, 0);
        c.anchor = 17;
        gridbag.setConstraints(this.checkBox, c);
        JSeparator separator = new JSeparator();
        c.gridx = 0;
        c.gridy = 2;
        c.anchor = 10;
        c.fill = 2;
        c.insets = new Insets(5, 0, 5, 0);
        gridbag.setConstraints(separator, c);
        panel1.add(separator);
        JLabel jndiLabel = new JLabel(acr.getString("A1312"));
        c.gridx = 0;
        c.gridy = 3;
        c.gridwidth = 3;
        c.anchor = 17;
        c.insets = new Insets(0, 0, 0, 0);
        c.fill = 0;
        gridbag.setConstraints(jndiLabel, c);
        panel1.add(jndiLabel);
        LabelledComponent[] items = new LabelledComponent[3];
        this.comboBox = new JComboBox<String>(jndiPropNames);
        this.comboBox.addActionListener(this);
        items[0] = new LabelledComponent(acr.getString("A1205") + ":", this.comboBox);
        this.valueText = new JTextField(40);
        this.valueText.getDocument().addDocumentListener(docListener);
        items[1] = new LabelledComponent(acr.getString("A1206") + ":", this.valueText);
        this.model = new PropsTableModel();
        this.table = new JTable(this.model);
        this.table.setSelectionMode(0);
        ListSelectionModel lsm = this.table.getSelectionModel();
        lsm.addListSelectionListener(this);
        JScrollPane scrollPane = new JScrollPane(this.table);
        scrollPane.setHorizontalScrollBarPolicy(30);
        items[2] = new LabelledComponent(" ", scrollPane);
        this.lvp = new LabelValuePanel(items, 5, 5);
        c.gridx = 0;
        c.gridy = 4;
        c.gridwidth = 2;
        c.anchor = 10;
        gridbag.setConstraints(this.lvp, c);
        panel1.add(this.lvp);
        int width = this.valueText.getPreferredSize().width;
        this.table.getRowHeight();
        this.table.setPreferredScrollableViewportSize(new Dimension(width, 8 * this.table.getRowHeight()));
        JPanel buttonPanel = new JPanel();
        this.addButton = new JButton(acr.getString("A1083"));
        this.addButton.addActionListener(this);
        this.delButton = new JButton(acr.getString("A1084"));
        this.delButton.addActionListener(this);
        this.delButton.setEnabled(false);
        this.chgButton = new JButton(acr.getString("A1085"));
        this.chgButton.addActionListener(this);
        this.chgButton.setEnabled(false);
        buttonPanel.setLayout(new GridLayout(3, 1, 5, 5));
        buttonPanel.add(this.addButton);
        buttonPanel.add(this.delButton);
        buttonPanel.add(this.chgButton);
        c.gridx = 2;
        c.gridy = 4;
        c.gridwidth = 1;
        c.anchor = 18;
        c.insets = new Insets(items[0].getPreferredSize().height + items[1].getPreferredSize().height + 20, 0, 0, 0);
        gridbag.setConstraints(buttonPanel, c);
        panel1.add(buttonPanel);
        String s = acr.getString("A2000");
        this.ta = new JTextArea(s);
        this.ta.setLineWrap(true);
        this.ta.setWrapStyleWord(true);
        Color bgColor = panel1.getBackground();
        this.ta.setBackground(bgColor);
        Color fgColor = jndiLabel.getForeground();
        this.ta.setForeground(fgColor);
        this.ta.setFont(jndiLabel.getFont());
        int width1 = storeLabel.getPreferredSize().width + 5 + this.osText.getPreferredSize().width;
        int width2 = this.lvp.getPreferredSize().width;
        if (width1 >= width2) {
            this.ta.setSize(width1, 1);
        } else {
            this.ta.setSize(width2, 1);
        }
        this.ta.setEditable(false);
        Dimension textSize = this.ta.getPreferredSize();
        this.ta.setSize(textSize);
        c.gridx = 0;
        c.gridy = 5;
        c.gridwidth = 3;
        c.anchor = 17;
        c.insets = new Insets(5, 0, 5, 0);
        gridbag.setConstraints(this.ta, c);
        panel1.add(this.ta);
        workPanel.add((Component)panel1, "North");
        return workPanel;
    }

    @Override
    public void doOK() {
    }

    @Override
    public void doApply() {
    }

    @Override
    public void doReset() {
    }

    @Override
    public void doCancel() {
    }

    @Override
    public void doClose() {
    }

    @Override
    public void doClear() {
        this.jndiProps.clear();
        this.osText.setText("");
        this.checkBox.setSelected(true);
        this.comboBox.setSelectedIndex(0);
        this.valueText.setText("");
        this.delButton.setEnabled(false);
        this.chgButton.setEnabled(false);
        this.model.fireTableChanged(new TableModelEvent(this.model));
        this.osText.requestFocus();
        this.dirty = false;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.addButton) {
            this.doAdd();
        } else if (source == this.delButton) {
            this.doDelete();
        } else if (source == this.chgButton) {
            this.doChange();
        } else if (source == this.comboBox) {
            this.doComboBox();
            this.dirty = true;
        } else if (source == this.checkBox) {
            this.dirty = true;
        } else {
            super.actionPerformed(e);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        ListSelectionModel lsm = (ListSelectionModel)e.getSource();
        boolean isAdjusting = e.getValueIsAdjusting();
        if (!isAdjusting) {
            if (lsm.isSelectionEmpty()) {
                this.delButton.setEnabled(false);
                this.chgButton.setEnabled(false);
            } else {
                int selectedRow = lsm.getMinSelectionIndex();
                String selectedItem = (String)this.model.getValueAt(selectedRow, 0);
                this.comboBox.setSelectedItem(selectedItem);
                this.valueText.setText(this.jndiProps.getProperty(selectedItem));
                if (this.isEditable()) {
                    this.delButton.setEnabled(true);
                    this.chgButton.setEnabled(true);
                }
            }
        }
    }

    public void doAdd() {
        String propName;
        String value = this.valueText.getText().trim();
        if (value == null || value.equals("")) {
            JOptionPane.showOptionDialog(this, acr.getString("A3001", this.comboBox.getSelectedItem()), acr.getString("A1088") + ": " + acr.getString("A1218", "A3001"), 0, 0, null, close, close[0]);
            this.valueText.requestFocus();
            return;
        }
        String checkValue = this.jndiProps.getProperty((String)this.comboBox.getSelectedItem());
        if (checkValue != null) {
            JOptionPane.showOptionDialog(this, acr.getString("A3003", this.comboBox.getSelectedItem()), acr.getString("A1088") + ": " + acr.getString("A1218", "A3003"), 0, 0, null, close, close[0]);
            return;
        }
        if (((String)this.comboBox.getSelectedItem()).equals("java.naming.provider.url")) {
            this.verifyProviderURL(value);
        }
        this.jndiProps.setProperty((String)this.comboBox.getSelectedItem(), value);
        int index = 0;
        Enumeration<?> e = this.jndiProps.propertyNames();
        while (e.hasMoreElements() && !(propName = (String)e.nextElement()).equals(this.comboBox.getSelectedItem())) {
            ++index;
        }
        this.model.fireTableRowsInserted(index, index);
        this.table.setRowSelectionInterval(index, index);
    }

    public void doDelete() {
        String propName;
        int index = 0;
        Enumeration<?> e = this.jndiProps.propertyNames();
        while (e.hasMoreElements() && !(propName = (String)e.nextElement()).equals(this.comboBox.getSelectedItem())) {
            ++index;
        }
        this.jndiProps.remove(this.comboBox.getSelectedItem());
        this.model.fireTableRowsDeleted(index, index);
        this.addButton.setEnabled(true);
        this.delButton.setEnabled(false);
        this.chgButton.setEnabled(false);
        this.valueText.setText("");
    }

    public void doChange() {
        String propName;
        String value = this.valueText.getText().trim();
        if (value == null || value.equals("")) {
            JOptionPane.showOptionDialog(this, acr.getString("A3001", this.comboBox.getSelectedItem()), acr.getString("A1088") + ": " + acr.getString("A1218", "A3001"), 0, 0, null, close, close[0]);
            this.valueText.requestFocus();
            return;
        }
        if (((String)this.comboBox.getSelectedItem()).equals("java.naming.provider.url")) {
            this.verifyProviderURL(value);
        }
        int index = 0;
        Enumeration<?> e = this.jndiProps.propertyNames();
        while (e.hasMoreElements() && !(propName = (String)e.nextElement()).equals(this.comboBox.getSelectedItem())) {
            ++index;
        }
        this.jndiProps.setProperty((String)this.comboBox.getSelectedItem(), value);
        this.model.fireTableRowsUpdated(index, index);
    }

    public void doComboBox() {
        String name = (String)this.comboBox.getSelectedItem();
        if (this.jndiProps == null) {
            this.valueText.setText("");
        }
        if (name != null) {
            String value = this.jndiProps.getProperty(name);
            this.valueText.setText(this.jndiProps.getProperty(name));
            if (value != null) {
                String propName;
                int index = 0;
                Enumeration<?> e = this.jndiProps.propertyNames();
                while (e.hasMoreElements() && !(propName = (String)e.nextElement()).equals(name)) {
                    ++index;
                }
                this.table.setRowSelectionInterval(index, index);
                if (this.isEditable()) {
                    this.addButton.setEnabled(false);
                    this.delButton.setEnabled(true);
                    this.chgButton.setEnabled(true);
                }
            } else if (this.isEditable()) {
                this.addButton.setEnabled(true);
                this.delButton.setEnabled(false);
                this.chgButton.setEnabled(false);
            }
        } else if (name == null && this.isEditable()) {
            this.addButton.setEnabled(true);
            this.delButton.setEnabled(false);
            this.chgButton.setEnabled(false);
        }
    }

    protected int checkMandatoryProps() {
        String[] mandatoryNames = new String[]{"java.naming.factory.initial", "java.naming.provider.url"};
        for (int i = 0; i < mandatoryNames.length; ++i) {
            String propName = this.jndiProps.getProperty(mandatoryNames[i]);
            if (propName == null) {
                JOptionPane.showOptionDialog(this, acr.getString("A3021", mandatoryNames[i]), acr.getString("A1128") + ": " + acr.getString("A1218", "A3021"), 0, 0, null, close, close[0]);
                this.comboBox.setSelectedItem(mandatoryNames[i]);
                this.valueText.requestFocus();
                return 0;
            }
            if (!mandatoryNames[i].equals("java.naming.factory.initial")) continue;
            try {
                Class.forName(propName);
                continue;
            }
            catch (ClassNotFoundException e) {
                JOptionPane.showOptionDialog(this, acr.getString("A3022", propName, mandatoryNames[i]), acr.getString("A1128") + ": " + acr.getString("A1218", "A3022"), 0, 0, null, close, close[0]);
                this.comboBox.setSelectedItem(mandatoryNames[i]);
                this.valueText.requestFocus();
                return 0;
            }
        }
        return 1;
    }

    protected String getDefaultStoreName(String baseName) {
        if (this.osMgr.getStore(baseName) == null) {
            return baseName;
        }
        for (int i = 1; i < 1000; ++i) {
            String newStr = baseName + i;
            if (this.osMgr.getStore(newStr) != null) continue;
            return newStr;
        }
        return "";
    }

    protected boolean isEditable() {
        return this.editable;
    }

    protected void setEditable(boolean editable) {
        this.editable = editable;
        if (editable) {
            this.osText.setEditable(true);
            this.valueText.setEditable(true);
            this.addButton.setEnabled(true);
            this.delButton.setEnabled(true);
            this.chgButton.setEnabled(true);
            this.ta.setText(acr.getString("A2000"));
        } else {
            this.osText.setEditable(false);
            this.valueText.setEditable(false);
            this.addButton.setEnabled(false);
            this.delButton.setEnabled(false);
            this.chgButton.setEnabled(false);
            this.ta.setText(acr.getString("A2001"));
        }
    }

    private void verifyProviderURL(String value) {
        boolean fileURL = false;
        File file = null;
        String facInit = this.jndiProps.getProperty("java.naming.factory.initial");
        if (facInit != null && !facInit.equals("") && facInit.equals("com.sun.jndi.fscontext.RefFSContextFactory")) {
            fileURL = true;
        }
        if (!fileURL && value.startsWith("file:")) {
            fileURL = true;
        }
        if (fileURL) {
            try {
                URI uri = new URI(value);
                file = new File(uri);
            }
            catch (Exception e) {
                try {
                    file = new File(value);
                }
                catch (Exception ex) {
                    file = null;
                }
            }
            if (file != null && !file.isDirectory()) {
                JOptionPane.showOptionDialog(this, acr.getString("A2004", "java.naming.provider.url", value), acr.getString("A1088") + ": " + acr.getString("A1516", "A2004"), 0, 2, null, close, close[0]);
            }
        }
    }

    static {
        String[] stringArray = new String[1];
        stringArray[0] = acr.getString("A1081");
        close = stringArray;
        String[] stringArray2 = new String[2];
        stringArray2[0] = acr.getString("A1205");
        stringArray2[1] = acr.getString("A1206");
        columnNames = stringArray2;
    }

    class ObjStoreDocumentListener
    implements DocumentListener {
        ObjStoreDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            ObjStoreDialog.this.dirty = true;
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            ObjStoreDialog.this.dirty = true;
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            ObjStoreDialog.this.dirty = true;
        }
    }

    class PropsTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = -6685250332698377866L;

        PropsTableModel() {
        }

        @Override
        public int getColumnCount() {
            return columnNames.length;
        }

        @Override
        public int getRowCount() {
            if (ObjStoreDialog.this.jndiProps == null) {
                return 0;
            }
            return ObjStoreDialog.this.jndiProps.size();
        }

        @Override
        public String getColumnName(int col) {
            return columnNames[col];
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (ObjStoreDialog.this.jndiProps == null) {
                return "";
            }
            int i = 0;
            Enumeration<?> e = ObjStoreDialog.this.jndiProps.propertyNames();
            while (e.hasMoreElements()) {
                String propName = (String)e.nextElement();
                if (col == 0 && i == row) {
                    return propName;
                }
                if (col == 1 && i == row) {
                    return ObjStoreDialog.this.jndiProps.getProperty(propName);
                }
                ++i;
            }
            return "";
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
        }
    }
}

