/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.admin.apps.console;

import com.sun.messaging.jmq.admin.apps.console.ObjStoreCObj;
import com.sun.messaging.jmq.admin.apps.console.ObjStoreDialog;
import com.sun.messaging.jmq.admin.apps.console.ObjStoreListCObj;
import com.sun.messaging.jmq.admin.apps.console.event.ObjAdminEvent;
import com.sun.messaging.jmq.admin.objstore.ObjStore;
import com.sun.messaging.jmq.admin.objstore.ObjStoreAttrs;
import com.sun.messaging.jmq.admin.resources.AdminConsoleResources;
import com.sun.messaging.jmq.admin.util.Globals;
import java.awt.Frame;
import java.util.Enumeration;
import javax.swing.JOptionPane;

public class ObjStorePropsDialog
extends ObjStoreDialog {
    private static final long serialVersionUID = -8353001964928282780L;
    private static AdminConsoleResources acr = Globals.getAdminConsoleResources();
    private static String[] close;
    private ObjStoreCObj osCObj;

    public ObjStorePropsDialog(Frame parent, ObjStoreListCObj oslCObj) {
        super(parent, acr.getString("A1309"), 113, oslCObj);
        this.setHelpId("object_store_properties");
    }

    @Override
    public void doOK() {
        String osName = null;
        osName = this.osText.getText();
        if ((osName = osName.trim()).equals("")) {
            JOptionPane.showOptionDialog(this, acr.getString("A3004"), acr.getString("A1309") + ": " + acr.getString("A1218", "A3004"), 0, 0, null, close, close[0]);
            this.osText.requestFocus();
            return;
        }
        ObjStoreAttrs osa = this.constructAttrs(osName);
        if (osa == null) {
            return;
        }
        ObjAdminEvent oae = new ObjAdminEvent(this, 2);
        oae.setObjStoreID(osName);
        oae.setObjStore(this.osCObj.getObjStore());
        oae.setObjStoreAttrs(osa);
        oae.setConnectAttempt(false);
        oae.setOKAction(true);
        this.fireAdminEventDispatched(oae);
    }

    @Override
    public void doApply() {
    }

    @Override
    public void doReset() {
    }

    @Override
    public void doCancel() {
        this.setVisible(false);
    }

    @Override
    public void doClose() {
        this.setVisible(false);
    }

    @Override
    public void doClear() {
    }

    public void show(ObjStoreCObj osCObj) {
        this.osCObj = osCObj;
        ObjStore os = osCObj.getObjStore();
        this.checkBox.setSelected(true);
        ObjStoreAttrs attrs = os.getObjStoreAttrs();
        this.jndiProps.clear();
        if (attrs != null) {
            Enumeration e = attrs.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                this.jndiProps.setProperty(key, (String)attrs.get(key));
            }
            this.model.fireTableRowsInserted(0, attrs.size() - 1);
            if (attrs.size() >= 1) {
                this.table.setRowSelectionInterval(0, 0);
            }
        } else {
            this.comboBox.setSelectedIndex(0);
            this.delButton.setEnabled(false);
            this.chgButton.setEnabled(false);
            this.model.fireTableDataChanged();
            this.valueText.requestFocus();
        }
        this.osText.setText(os.getID());
        if (os.isOpen()) {
            this.setEditable(false);
        } else {
            this.setEditable(true);
        }
        this.setVisible(true);
    }

    private ObjStoreAttrs constructAttrs(String osName) {
        ObjStore os = this.osCObj.getObjStore();
        String prevOsName = os.getID();
        if (!prevOsName.equals(osName) && this.osMgr != null && this.osMgr.getStore(osName) != null) {
            JOptionPane.showOptionDialog(this, acr.getString("A3002", osName), acr.getString("A1309") + ": " + acr.getString("A1218", "A3002"), 0, 0, null, close, close[0]);
            this.osText.requestFocus();
            this.osText.selectAll();
            return null;
        }
        ObjStoreAttrs osa = new ObjStoreAttrs(osName, osName);
        if (this.jndiProps == null) {
            return osa;
        }
        if (this.checkMandatoryProps() == 0) {
            return null;
        }
        Enumeration<?> e = this.jndiProps.propertyNames();
        while (e.hasMoreElements()) {
            String propName = (String)e.nextElement();
            osa.put(propName, this.jndiProps.getProperty(propName));
        }
        return osa;
    }

    @Override
    protected void setEditable(boolean editable) {
        if (editable) {
            this.okButton.setVisible(true);
            this.closeButton.setVisible(false);
            this.cancelButton.setVisible(true);
            this.buttonPanel.doLayout();
        } else {
            this.okButton.setVisible(false);
            this.closeButton.setVisible(true);
            this.cancelButton.setVisible(false);
            this.buttonPanel.doLayout();
        }
        super.setEditable(editable);
    }

    static {
        String[] stringArray = new String[1];
        stringArray[0] = acr.getString("A1081");
        close = stringArray;
    }
}

