/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.admin.bkrutil;

import com.sun.messaging.jmq.admin.bkrutil.BrokerAdminConn;
import com.sun.messaging.jmq.admin.bkrutil.BrokerAdminException;
import com.sun.messaging.jmq.admin.event.BrokerCmdStatusEvent;
import com.sun.messaging.jmq.admin.event.CommonCmdStatusEvent;
import com.sun.messaging.jmq.admin.util.CommonGlobals;
import com.sun.messaging.jmq.admin.util.Globals;
import com.sun.messaging.jmq.util.DestMetricsCounters;
import com.sun.messaging.jmq.util.MetricCounters;
import com.sun.messaging.jmq.util.admin.DestinationInfo;
import com.sun.messaging.jmq.util.admin.DurableInfo;
import com.sun.messaging.jmq.util.admin.ServiceInfo;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.ObjectMessage;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import java.util.function.Consumer;

public class BrokerAdmin
extends BrokerAdminConn {
    private Object aObj = null;
    private BrokerCmdStatusEvent statusEvent = null;

    public BrokerAdmin(String brokerAddress, String username, String passwd, int timeout, boolean useSSL) throws BrokerAdminException {
        this(brokerAddress, username, passwd, timeout, false, -1, -1L, useSSL);
    }

    public BrokerAdmin(String brokerHost, int brokerPort, String username, String passwd, long timeout, boolean reconnect, int reconnectRetries, long reconnectDelay) throws BrokerAdminException {
        super(brokerHost, brokerPort, username, passwd, timeout, reconnect, reconnectRetries, reconnectDelay);
    }

    public BrokerAdmin(String brokerAddress, String username, String passwd, long timeout, boolean reconnect, int reconnectRetries, long reconnectDelay, boolean useSSL) throws BrokerAdminException {
        super(brokerAddress, username, passwd, timeout, reconnect, reconnectRetries, reconnectDelay, useSSL);
    }

    public BrokerAdmin(Properties brokerAttrs, String username, String passwd, long timeout) throws BrokerAdminException {
        super(brokerAttrs, username, passwd, timeout);
    }

    @Override
    public String getAdminQueueDest() {
        return "__JMQAdmin";
    }

    @Override
    public String getAdminMessagePropNameMessageType() {
        return "JMQMessageType";
    }

    @Override
    public String getAdminMessagePropNameErrorString() {
        return "JMQErrorString";
    }

    @Override
    public String getAdminMessagePropNameStatus() {
        return "JMQStatus";
    }

    @Override
    public int getAdminMessageStatusOK() {
        return 200;
    }

    @Override
    public int getAdminMessageTypeSHUTDOWN_REPLY() {
        return 39;
    }

    @Override
    public CommonCmdStatusEvent newCommonCmdStatusEvent(int type) {
        return new BrokerCmdStatusEvent(this, this, type);
    }

    @Override
    public CommonCmdStatusEvent getCurrentStatusEvent() {
        return this.statusEvent;
    }

    @Override
    public void clearStatusEvent() {
        this.statusEvent = null;
    }

    private BrokerCmdStatusEvent createStatusEvent(int type, int replyType, String replyTypeString) {
        CommonCmdStatusEvent cse = this.newCommonCmdStatusEvent(type);
        cse.setReplyType(replyType);
        cse.setReplyTypeString(replyTypeString);
        return (BrokerCmdStatusEvent)cse;
    }

    public void sendHelloMessage() throws BrokerAdminException {
        if (BrokerAdmin.getDebug()) {
            Globals.stdOutPrintln("***** sendHelloMessage *****");
        }
        ObjectMessage mesg = null;
        this.checkIfBusy();
        try {
            mesg = this.session.createObjectMessage();
            mesg.setJMSReplyTo(this.replyQueue);
            mesg.setIntProperty("JMQMessageType", 28);
            this.statusEvent = this.createStatusEvent(22, 29, "HELLO_REPLY");
            if (BrokerAdmin.getDebug()) {
                this.printMsgType(28, "HELLO");
                Globals.stdOutPrintln("\tJMQProtocolLevel=102");
            }
            this.sender.send(mesg);
        }
        catch (Exception e) {
            this.handleSendExceptions(e);
        }
    }

    public void receiveHelloReplyMessage() throws BrokerAdminException {
        if (BrokerAdmin.getDebug()) {
            Globals.stdOutPrintln("***** receiveHelloReplyMessage() *****");
        }
        Message mesg = null;
        try {
            mesg = this.receiveCheckMessageTimeout(false);
            mesg.acknowledge();
            this.clearStatusEvent();
            this.checkReplyTypeStatus(mesg, 29, "HELLO_REPLY");
            this.isConnected = true;
        }
        catch (Exception e) {
            this.handleReceiveExceptions(e);
        }
    }

    public void sendGetServicesMessage(String svcName) throws BrokerAdminException {
        if (BrokerAdmin.getDebug()) {
            Globals.stdOutPrintln("***** sendGetServicesMessage *****");
        }
        ObjectMessage mesg = null;
        this.checkIfBusy();
        try {
            mesg = this.session.createObjectMessage();
            mesg.setJMSReplyTo(this.replyQueue);
            mesg.setIntProperty("JMQMessageType", 26);
            if (svcName != null) {
                mesg.setStringProperty("JMQServiceName", svcName);
                this.statusEvent = this.createStatusEvent(1, 27, "GET_SERVICES_REPLY");
            } else {
                this.statusEvent = this.createStatusEvent(2, 27, "GET_SERVICES_REPLY");
            }
            this.statusEvent.setServiceName(svcName);
            if (BrokerAdmin.getDebug()) {
                this.printMsgType(26, "GET_SERVICES");
                if (svcName != null) {
                    Globals.stdOutPrintln("\tJMQServiceName=" + svcName);
                }
            }
            this.sender.send(mesg);
        }
        catch (Exception e) {
            this.handleSendExceptions(e);
        }
    }

    public Vector receiveGetServicesReplyMessage() throws BrokerAdminException {
        return this.receiveGetServicesReplyMessage(true);
    }

    public Vector receiveGetServicesReplyMessage(boolean waitForResponse) throws BrokerAdminException {
        if (BrokerAdmin.getDebug()) {
            Globals.stdOutPrintln("***** receiveGetServicesReplyMessage *****");
        }
        ObjectMessage mesg = null;
        try {
            mesg = (ObjectMessage)this.receiveCheckMessageTimeout(false, waitForResponse);
            mesg.acknowledge();
            this.clearStatusEvent();
            this.checkReplyTypeStatus(mesg, 27, "GET_SERVICES_REPLY");
            Serializable obj = mesg.getObject();
            if (obj != null && obj instanceof Vector) {
                if (BrokerAdmin.getDebug()) {
                    this.printServiceInfoList((Vector)obj);
                }
                return (Vector)obj;
            }
        }
        catch (Exception e) {
            this.handleReceiveExceptions(e);
        }
        return null;
    }

    public void sendPauseMessage(String svcName) throws BrokerAdminException {
        if (BrokerAdmin.getDebug()) {
            Globals.stdOutPrintln("***** sendPauseMessage *****");
        }
        ObjectMessage mesg = null;
        this.checkIfBusy();
        try {
            mesg = this.session.createObjectMessage();
            mesg.setJMSReplyTo(this.replyQueue);
            mesg.setIntProperty("JMQMessageType", 30);
            mesg.setStringProperty("JMQPauseTarget", "JMQServiceName");
            if (svcName != null) {
                mesg.setStringProperty("JMQServiceName", svcName);
                this.statusEvent = this.createStatusEvent(3, 31, "PAUSE_REPLY");
                this.statusEvent.setServiceName(svcName);
            } else {
                this.statusEvent = this.createStatusEvent(4, 31, "PAUSE_REPLY");
            }
            if (BrokerAdmin.getDebug()) {
                this.printMsgType(30, "PAUSE");
                if (svcName != null) {
                    Globals.stdOutPrintln("\tJMQServiceName=" + svcName);
                }
            }
            this.sender.send(mesg);
        }
        catch (Exception e) {
            this.handleSendExceptions(e);
        }
    }

    public void sendPauseMessage(String dstName, int dstType, int pauseType) throws BrokerAdminException {
        if (BrokerAdmin.getDebug()) {
            Globals.stdOutPrintln("***** sendPauseMessage *****");
        }
        ObjectMessage mesg = null;
        this.checkIfBusy();
        try {
            mesg = this.session.createObjectMessage();
            mesg.setJMSReplyTo(this.replyQueue);
            mesg.setIntProperty("JMQMessageType", 30);
            mesg.setStringProperty("JMQPauseTarget", "JMQDestination");
            if (dstName != null) {
                mesg.setStringProperty("JMQDestination", dstName);
                mesg.setIntProperty("JMQDestType", dstType);
            }
            if (pauseType != -1) {
                mesg.setIntProperty("JMQDestState", pauseType);
            }
            this.statusEvent = this.createStatusEvent(28, 31, "PAUSE_REPLY");
            this.statusEvent.setDestinationName(dstName);
            if (BrokerAdmin.getDebug()) {
                this.printMsgType(30, "PAUSE");
                Globals.stdOutPrintln("\tJMQDestination=" + dstName);
                Globals.stdOutPrintln("\tJMQDestType=" + dstType);
                Globals.stdOutPrintln("\tJMQDestState=" + pauseType);
            }
            this.sender.send(mesg);
        }
        catch (Exception e) {
            this.handleSendExceptions(e);
        }
    }

    public void receivePauseReplyMessage() throws BrokerAdminException {
        if (BrokerAdmin.getDebug()) {
            Globals.stdOutPrintln("***** receivePauseReplyMessage *****");
        }
        Message mesg = null;
        try {
            mesg = this.receiveCheckMessageTimeout(false);
            mesg.acknowledge();
            this.clearStatusEvent();
            this.checkReplyTypeStatus(mesg, 31, "PAUSE_REPLY");
        }
        catch (Exception e) {
            this.handleReceiveExceptions(e);
        }
    }

    public void sendResetBrokerMessage(String resetType) throws BrokerAdminException {
        if (BrokerAdmin.getDebug()) {
            Globals.stdOutPrintln("***** sendResetBrokerMessage *****");
        }
        ObjectMessage mesg = null;
        this.checkIfBusy();
        try {
            mesg = this.session.createObjectMessage();
            mesg.setJMSReplyTo(this.replyQueue);
            mesg.setIntProperty("JMQMessageType", 84);
            if (resetType != null) {
                mesg.setStringProperty("JMQResetType", resetType);
            }
            this.statusEvent = this.createStatusEvent(42, 85, "RESET_BROKER_REPLY");
            if (BrokerAdmin.getDebug()) {
                this.printMsgType(84, "RESET_BROKER");
                Globals.stdOutPrintln("\tJMQResetType=" + resetType);
            }
            this.sender.send(mesg);
        }
        catch (Exception e) {
            this.handleSendExceptions(e);
        }
    }

    public void receiveResetBrokerReplyMessage() throws BrokerAdminException {
        if (BrokerAdmin.getDebug()) {
            Globals.stdOutPrintln("***** receiveResetBrokerReplyMessage *****");
        }
        Message mesg = null;
        try {
            mesg = this.receiveCheckMessageTimeout(false);
            mesg.acknowledge();
            this.clearStatusEvent();
            this.checkReplyTypeStatus(mesg, 85, "RESET_BROKER_REPLY");
        }
        catch (Exception e) {
            this.handleReceiveExceptions(e);
        }
    }

    public void sendCheckpointBrokerMessage() throws BrokerAdminException {
        if (BrokerAdmin.getDebug()) {
            Globals.stdOutPrintln("***** sendCheckpointBrokerMessage *****");
        }
        ObjectMessage mesg = null;
        this.checkIfBusy();
        try {
            mesg = this.session.createObjectMessage();
            mesg.setJMSReplyTo(this.replyQueue);
            mesg.setIntProperty("JMQMessageType", 92);
            this.statusEvent = this.createStatusEvent(45, 93, "CHECKPOINT_BROKER_REPLY");
            if (BrokerAdmin.getDebug()) {
                this.printMsgType(92, "CHECKPOINT_BROKER");
            }
            this.sender.send(mesg);
        }
        catch (Exception e) {
            this.handleSendExceptions(e);
        }
    }

    public void receiveCheckpointBrokerReplyMessage() throws BrokerAdminException {
        if (BrokerAdmin.getDebug()) {
            Globals.stdOutPrintln("***** receiveCheckpointBrokerReplyMessage *****");
        }
        Message mesg = null;
        try {
            mesg = this.receiveCheckMessageTimeout(false);
            mesg.acknowledge();
            this.clearStatusEvent();
            this.checkReplyTypeStatus(mesg, 93, "CHECKPOINT_BROKER_REPLY");
        }
        catch (Exception e) {
            this.handleReceiveExceptions(e);
        }
    }

    public void sendResumeMessage(String svcName) throws BrokerAdminException {
        if (BrokerAdmin.getDebug()) {
            Globals.stdOutPrintln("***** sendResumeMessage *****");
        }
        ObjectMessage mesg = null;
        this.checkIfBusy();
        try {
            mesg = this.session.createObjectMessage();
            mesg.setJMSReplyTo(this.replyQueue);
            mesg.setIntProperty("JMQMessageType", 36);
            mesg.setStringProperty("JMQPauseTarget", "JMQServiceName");
            if (svcName != null) {
                mesg.setStringProperty("JMQServiceName", svcName);
                this.statusEvent = this.createStatusEvent(5, 37, "RESUME_REPLY");
                this.statusEvent.setServiceName(svcName);
            } else {
                this.statusEvent = this.createStatusEvent(6, 37, "RESUME_REPLY");
            }
            if (BrokerAdmin.getDebug()) {
                this.printMsgType(36, "RESUME");
                if (svcName != null) {
                    Globals.stdOutPrintln("\tJMQServiceName=" + svcName);
                }
            }
            this.sender.send(mesg);
        }
        catch (Exception e) {
            this.handleSendExceptions(e);
        }
    }

    public void sendResumeMessage(String dstName, int dstType) throws BrokerAdminException {
        if (BrokerAdmin.getDebug()) {
            Globals.stdOutPrintln("***** sendResumeMessage *****");
        }
        ObjectMessage mesg = null;
        this.checkIfBusy();
        try {
            mesg = this.session.createObjectMessage();
            mesg.setJMSReplyTo(this.replyQueue);
            mesg.setIntProperty("JMQMessageType", 36);
            mesg.setStringProperty("JMQPauseTarget", "JMQDestination");
            if (dstName != null) {
                mesg.setStringProperty("JMQDestination", dstName);
                mesg.setIntProperty("JMQDestType", dstType);
            }
            this.statusEvent = this.createStatusEvent(29, 37, "RESUME_REPLY");
            this.statusEvent.setDestinationName(dstName);
            if (BrokerAdmin.getDebug()) {
                this.printMsgType(36, "RESUME");
                Globals.stdOutPrintln("\tJMQDestination=" + dstName);
                Globals.stdOutPrintln("\tJMQDestType=" + dstType);
            }
            this.sender.send(mesg);
        }
        catch (Exception e) {
            this.handleSendExceptions(e);
        }
    }

    public void receiveResumeReplyMessage() throws BrokerAdminException {
        if (BrokerAdmin.getDebug()) {
            Globals.stdOutPrintln("***** receiveResumeReplyMessage *****");
        }
        Message mesg = null;
        try {
            mesg = this.receiveCheckMessageTimeout(false);
            mesg.acknowledge();
            this.clearStatusEvent();
            this.checkReplyTypeStatus(mesg, 37, "RESUME_REPLY");
        }
        catch (Exception e) {
            this.handleReceiveExceptions(e);
        }
    }

    public void sendQuiesceMessage() throws BrokerAdminException {
        if (BrokerAdmin.getDebug()) {
            Globals.stdOutPrintln("***** sendQuiesceMessage *****");
        }
        ObjectMessage mesg = null;
        this.checkIfBusy();
        try {
            mesg = this.session.createObjectMessage();
            mesg.setJMSReplyTo(this.replyQueue);
            mesg.setIntProperty("JMQMessageType", 74);
            this.statusEvent = this.createStatusEvent(36, 75, "QUIESCE_BROKER_REPLY");
            if (BrokerAdmin.getDebug()) {
                this.printMsgType(74, "QUIESCE_BROKER");
            }
            this.sender.send(mesg);
        }
        catch (Exception e) {
            this.handleSendExceptions(e);
        }
    }

    public void receiveQuiesceReplyMessage() throws BrokerAdminException {
        if (BrokerAdmin.getDebug()) {
            Globals.stdOutPrintln("***** receiveQuiesceReplyMessage *****");
        }
        Message mesg = null;
        try {
            mesg = this.receiveCheckMessageTimeout(false);
            mesg.acknowledge();
            this.clearStatusEvent();
            this.checkReplyTypeStatus(mesg, 75, "QUIESCE_BROKER_REPLY");
        }
        catch (Exception e) {
            this.handleReceiveExceptions(e);
        }
    }

    public void sendUnquiesceMessage() throws BrokerAdminException {
        if (BrokerAdmin.getDebug()) {
            Globals.stdOutPrintln("***** sendUnquiesceMessage *****");
        }
        ObjectMessage mesg = null;
        this.checkIfBusy();
        try {
            mesg = this.session.createObjectMessage();
            mesg.setJMSReplyTo(this.replyQueue);
            mesg.setIntProperty("JMQMessageType", 82);
            this.statusEvent = this.createStatusEvent(41, 83, "UNQUIESCE_BROKER_REPLY");
            if (BrokerAdmin.getDebug()) {
                this.printMsgType(82, "UNQUIESCE_BROKER");
            }
            this.sender.send(mesg);
        }
        catch (Exception e) {
            this.handleSendExceptions(e);
        }
    }

    public void receiveUnquiesceReplyMessage() throws BrokerAdminException {
        if (BrokerAdmin.getDebug()) {
            Globals.stdOutPrintln("***** receiveUnquiesceReplyMessage *****");
        }
        Message mesg = null;
        try {
            mesg = this.receiveCheckMessageTimeout(false);
            mesg.acknowledge();
            this.clearStatusEvent();
            this.checkReplyTypeStatus(mesg, 83, "UNQUIESCE_BROKER_REPLY");
        }
        catch (Exception e) {
            this.handleReceiveExceptions(e);
        }
    }

    public void sendTakeoverMessage(String brokerID) throws BrokerAdminException {
        if (BrokerAdmin.getDebug()) {
            Globals.stdOutPrintln("***** sendTakeoverMessage *****");
        }
        ObjectMessage mesg = null;
        this.checkIfBusy();
        try {
            mesg = this.session.createObjectMessage();
            mesg.setJMSReplyTo(this.replyQueue);
            mesg.setIntProperty("JMQMessageType", 76);
            mesg.setStringProperty("JMQBrokerID", brokerID);
            this.statusEvent = this.createStatusEvent(37, 77, "TAKEOVER_BROKER_REPLY");
            if (BrokerAdmin.getDebug()) {
                this.printMsgType(76, "TAKEOVER_BROKER");
                Globals.stdOutPrintln("\tJMQBrokerID = " + brokerID);
            }
            this.sender.send(mesg);
        }
        catch (Exception e) {
            this.handleSendExceptions(e);
        }
    }

    public void receiveTakeoverReplyMessage() throws BrokerAdminException {
        if (BrokerAdmin.getDebug()) {
            Globals.stdOutPrintln("***** receiveTakeoverReplyMessage *****");
        }
        Message mesg = null;
        try {
            mesg = this.receiveCheckMessageTimeout(false);
            mesg.acknowledge();
            this.clearStatusEvent();
            this.checkReplyTypeStatus(mesg, 77, "TAKEOVER_BROKER_REPLY");
        }
        catch (Exception e) {
            this.handleReceiveExceptions(e);
        }
    }

    public void sendMigrateStoreMessage(String brokerID, String partition) throws BrokerAdminException {
        if (BrokerAdmin.getDebug()) {
            Globals.stdOutPrintln("***** sendMigrateStoreMessage *****");
        }
        ObjectMessage mesg = null;
        this.checkIfBusy();
        try {
            mesg = this.session.createObjectMessage();
            mesg.setJMSReplyTo(this.replyQueue);
            mesg.setIntProperty("JMQMessageType", 98);
            if (brokerID != null) {
                mesg.setStringProperty("JMQBrokerID", brokerID);
            }
            if (partition != null) {
                mesg.setStringProperty("JMQMigrateStorePartition", partition);
            }
            this.statusEvent = this.createStatusEvent(47, 99, "MIGRATESTORE_BROKER_REPLY");
            if (BrokerAdmin.getDebug()) {
                this.printMsgType(98, "MIGRATESTORE_BROKER");
                Globals.stdOutPrintln("\tJMQBrokerID = " + brokerID);
            }
            this.sender.send(mesg);
        }
        catch (Exception e) {
            this.handleSendExceptions(e);
        }
    }

    public String receiveMigrateStoreReplyMessage() throws BrokerAdminException {
        if (BrokerAdmin.getDebug()) {
            Globals.stdOutPrintln("***** receiveMigrateStoreReplyMessage *****");
        }
        Message mesg = null;
        try {
            mesg = this.receiveCheckMessageTimeout(false);
            mesg.acknowledge();
            this.clearStatusEvent();
            this.checkReplyTypeStatus(mesg, 99, "MIGRATESTORE_BROKER_REPLY");
            Object bk = mesg.getStringProperty("JMQBrokerID");
            String hp = mesg.getStringProperty("JMQMQAddress");
            if (bk != null) {
                bk = (String)bk + (String)(hp == null ? "" : "[" + hp + "]");
            }
            return bk;
        }
        catch (Exception e) {
            this.handleReceiveExceptions(e);
            return null;
        }
    }

    public void sendGetDestinationsMessage(String dstName, int dstType) throws BrokerAdminException {
        this.sendGetDestinationsMessage(dstName, dstType, false, false);
    }

    public void sendGetDestinationsMessage(String dstName, int dstType, boolean showpartition, boolean loaddestination) throws BrokerAdminException {
        if (BrokerAdmin.getDebug()) {
            Globals.stdOutPrintln("***** sendGetDestinationsMessage *****");
        }
        ObjectMessage mesg = null;
        this.checkIfBusy();
        try {
            mesg = this.session.createObjectMessage();
            mesg.setJMSReplyTo(this.replyQueue);
            mesg.setIntProperty("JMQMessageType", 20);
            if (showpartition) {
                mesg.setBooleanProperty("JMQShowPartition", true);
            }
            if (loaddestination) {
                mesg.setBooleanProperty("JMQLoadDestination", true);
            }
            if (dstName != null) {
                mesg.setStringProperty("JMQDestination", dstName);
                mesg.setIntProperty("JMQDestType", dstType);
                this.statusEvent = this.createStatusEvent(7, 21, "GET_DESTINATIONS_REPLY");
                this.statusEvent.setDestinationName(dstName);
            } else {
                this.statusEvent = this.createStatusEvent(8, 21, "GET_DESTINATIONS_REPLY");
            }
            if (BrokerAdmin.getDebug()) {
                this.printMsgType(20, "GET_DESTINATIONS");
                if (dstName != null) {
                    Globals.stdOutPrintln("\tJMQDestination=" + dstName);
                    Globals.stdOutPrintln("\tJMQDestType=" + dstType);
                }
            }
            this.sender.send(mesg);
        }
        catch (Exception e) {
            this.handleSendExceptions(e);
        }
    }

    public Vector receiveGetDestinationsReplyMessage() throws BrokerAdminException {
        return this.receiveGetDestinationsReplyMessage(true);
    }

    public Vector receiveGetDestinationsReplyMessage(boolean waitForResponse) throws BrokerAdminException {
        if (BrokerAdmin.getDebug()) {
            Globals.stdOutPrintln("***** receiveGetDestinationsReplyMessage *****");
        }
        ObjectMessage mesg = null;
        try {
            mesg = (ObjectMessage)this.receiveCheckMessageTimeout(false, waitForResponse);
            mesg.acknowledge();
            this.clearStatusEvent();
            this.checkReplyTypeStatus(mesg, 21, "GET_DESTINATIONS_REPLY");
            Serializable obj = mesg.getObject();
            if (obj != null && obj instanceof Vector) {
                if (BrokerAdmin.getDebug()) {
                    this.printDestinationInfoList((Vector)obj);
                }
                return (Vector)obj;
            }
        }
        catch (Exception e) {
            this.handleReceiveExceptions(e);
        }
        return null;
    }

    public void sendCreateDestinationMessage(DestinationInfo dstInfo) throws BrokerAdminException {
        if (BrokerAdmin.getDebug()) {
            Globals.stdOutPrintln("***** sendCreateDestinationMessage *****");
        }
        ObjectMessage mesg = null;
        this.checkIfBusy();
        try {
            mesg = this.session.createObjectMessage();
            mesg.setJMSReplyTo(this.replyQueue);
            mesg.setIntProperty("JMQMessageType", 10);
            mesg.setObject(dstInfo);
            this.statusEvent = this.createStatusEvent(9, 11, "CREATE_DESTINATION_REPLY");
            this.statusEvent.setDestinationInfo(dstInfo);
            if (BrokerAdmin.getDebug()) {
                this.printMsgType(10, "CREATE_DESTINATION");
                this.printDestinationInfo(dstInfo);
            }
            this.sender.send(mesg);
        }
        catch (Exception e) {
            this.handleSendExceptions(e);
        }
    }

    public void receiveCreateDestinationReplyMessage() throws BrokerAdminException {
        if (BrokerAdmin.getDebug()) {
            Globals.stdOutPrintln("***** receiveCreateDestinationReplyMessage *****");
        }
        Message mesg = null;
        try {
            mesg = this.receiveCheckMessageTimeout(false);
            mesg.acknowledge();
            this.clearStatusEvent();
            this.checkReplyTypeStatus(mesg, 11, "CREATE_DESTINATION_REPLY");
        }
        catch (Exception e) {
            this.handleReceiveExceptions(e);
        }
    }

    public void sendDestroyDestinationMessage(String dstName, int dstType) throws BrokerAdminException {
        if (BrokerAdmin.getDebug()) {
            Globals.stdOutPrintln("***** sendDestroyDestinationMessage *****");
        }
        ObjectMessage mesg = null;
        this.checkIfBusy();
        try {
            mesg = this.session.createObjectMessage();
            mesg.setJMSReplyTo(this.replyQueue);
            mesg.setIntProperty("JMQMessageType", 12);
            mesg.setStringProperty("JMQDestination", dstName);
            mesg.setIntProperty("JMQDestType", dstType);
            this.statusEvent = this.createStatusEvent(0, 13, "DESTROY_DESTINATION_REPLY");
            this.statusEvent.setDestinationName(dstName);
            if (BrokerAdmin.getDebug()) {
                this.printMsgType(12, "DESTROY_DESTINATION");
                Globals.stdOutPrintln("\tJMQDestination=" + dstName);
                Globals.stdOutPrintln("\tJMQDestType=" + dstType);
            }
            this.sender.send(mesg);
        }
        catch (Exception e) {
            this.handleSendExceptions(e);
        }
    }

    public void receiveDestroyDestinationReplyMessage() throws BrokerAdminException {
        if (BrokerAdmin.getDebug()) {
            Globals.stdOutPrintln("***** receiveDestroyDestinationReplyMessage *****");
        }
        Message mesg = null;
        try {
            mesg = this.receiveCheckMessageTimeout(false);
            mesg.acknowledge();
            this.clearStatusEvent();
            this.checkReplyTypeStatus(mesg, 13, "DESTROY_DESTINATION_REPLY");
        }
        catch (Exception e) {
            this.handleReceiveExceptions(e);
        }
    }

    public void sendPurgeDestinationMessage(String dstName, int dstType) throws BrokerAdminException {
        if (BrokerAdmin.getDebug()) {
            Globals.stdOutPrintln("***** sendPurgeDestinationMessage *****");
        }
        ObjectMessage mesg = null;
        this.checkIfBusy();
        try {
            mesg = this.session.createObjectMessage();
            mesg.setJMSReplyTo(this.replyQueue);
            mesg.setIntProperty("JMQMessageType", 32);
            mesg.setStringProperty("JMQDestination", dstName);
            mesg.setIntProperty("JMQDestType", dstType);
            this.statusEvent = this.createStatusEvent(10, 33, "PURGE_DESTINATION_REPLY");
            this.statusEvent.setDestinationName(dstName);
            if (BrokerAdmin.getDebug()) {
                this.printMsgType(32, "PURGE_DESTINATION");
                Globals.stdOutPrintln("\tJMQDestination=" + dstName);
                Globals.stdOutPrintln("\tJMQDestType=" + dstType);
            }
            this.sender.send(mesg);
        }
        catch (Exception e) {
            this.handleSendExceptions(e);
        }
    }

    public void receivePurgeDestinationReplyMessage() throws BrokerAdminException {
        if (BrokerAdmin.getDebug()) {
            Globals.stdOutPrintln("***** receivePurgeDestinationReplyMessage *****");
        }
        Message mesg = null;
        try {
            mesg = this.receiveCheckMessageTimeout(false);
            mesg.acknowledge();
            this.clearStatusEvent();
            this.checkReplyTypeStatus(mesg, 33, "PURGE_DESTINATION_REPLY");
        }
        catch (Exception e) {
            this.handleReceiveExceptions(e);
        }
    }

    public void sendGetBrokerPropsMessage() throws BrokerAdminException {
        if (BrokerAdmin.getDebug()) {
            Globals.stdOutPrintln("***** sendGetBrokerPropsMessage *****");
        }
        ObjectMessage mesg = null;
        this.checkIfBusy();
        try {
            mesg = this.session.createObjectMessage();
            mesg.setJMSReplyTo(this.replyQueue);
            mesg.setIntProperty("JMQMessageType", 54);
            this.statusEvent = this.createStatusEvent(11, 55, "GET_BROKER_PROPS_REPLY");
            if (BrokerAdmin.getDebug()) {
                this.printMsgType(54, "GET_BROKER_PROPS");
            }
            this.sender.send(mesg);
        }
        catch (Exception e) {
            this.handleSendExceptions(e);
        }
    }

    public Properties receiveGetBrokerPropsReplyMessage() throws BrokerAdminException {
        return this.receiveGetBrokerPropsReplyMessage(true);
    }

    public Properties receiveGetBrokerPropsReplyMessage(boolean waitForResponse) throws BrokerAdminException {
        if (BrokerAdmin.getDebug()) {
            Globals.stdOutPrintln("***** receiveGetBrokerPropsReplyMessage *****");
        }
        ObjectMessage mesg = null;
        try {
            mesg = (ObjectMessage)this.receiveCheckMessageTimeout(false, waitForResponse);
            mesg.acknowledge();
            this.clearStatusEvent();
            this.checkReplyTypeStatus(mesg, 55, "GET_BROKER_PROPS_REPLY");
            Serializable obj = mesg.getObject();
            if (obj != null && obj instanceof Properties) {
                return (Properties)obj;
            }
        }
        catch (Exception e) {
            this.handleReceiveExceptions(e);
        }
        return null;
    }

    public void sendUpdateBrokerPropsMessage(Properties props) throws BrokerAdminException {
        if (BrokerAdmin.getDebug()) {
            Globals.stdOutPrintln("***** sendUpdateBrokerPropsMessage *****");
        }
        ObjectMessage mesg = null;
        this.checkIfBusy();
        try {
            mesg = this.session.createObjectMessage();
            mesg.setJMSReplyTo(this.replyQueue);
            mesg.setIntProperty("JMQMessageType", 56);
            mesg.setObject(props);
            this.statusEvent = this.createStatusEvent(12, 57, "UPDATE_BROKER_PROPS_REPLY");
            if (BrokerAdmin.getDebug()) {
                this.printMsgType(56, "UPDATE_BROKER_PROPS");
                Globals.stdOutPrintln("\tProperties=" + props.toString());
            }
            this.sender.send(mesg);
        }
        catch (Exception e) {
            this.handleSendExceptions(e);
        }
    }

    public void receiveUpdateBrokerPropsReplyMessage() throws BrokerAdminException {
        if (BrokerAdmin.getDebug()) {
            Globals.stdOutPrintln("***** receiveUpdateBrokerPropsReplyMessage *****");
        }
        Message mesg = null;
        try {
            mesg = this.receiveCheckMessageTimeout(false);
            mesg.acknowledge();
            this.clearStatusEvent();
            this.checkReplyTypeStatus(mesg, 57, "UPDATE_BROKER_PROPS_REPLY");
        }
        catch (Exception e) {
            this.handleReceiveExceptions(e);
        }
    }

    public void sendUpdateDestinationMessage(DestinationInfo dstInfo) throws BrokerAdminException {
        if (BrokerAdmin.getDebug()) {
            Globals.stdOutPrintln("***** sendUpdateDestinationMessage *****");
        }
        ObjectMessage mesg = null;
        this.checkIfBusy();
        try {
            mesg = this.session.createObjectMessage();
            mesg.setJMSReplyTo(this.replyQueue);
            mesg.setIntProperty("JMQMessageType", 40);
            mesg.setObject(dstInfo);
            this.statusEvent = this.createStatusEvent(13, 41, "UPDATE_DESTINATION_REPLY");
            this.statusEvent.setDestinationInfo(dstInfo);
            if (BrokerAdmin.getDebug()) {
                this.printMsgType(40, "UPDATE_DESTINATION");
                this.printDestinationInfo(dstInfo);
            }
            this.sender.send(mesg);
        }
        catch (Exception e) {
            this.handleSendExceptions(e);
        }
    }

    public void receiveUpdateDestinationReplyMessage() throws BrokerAdminException {
        if (BrokerAdmin.getDebug()) {
            Globals.stdOutPrintln("***** receiveUpdateDestinationReplyMessage *****");
        }
        Message mesg = null;
        try {
            mesg = this.receiveCheckMessageTimeout(false);
            mesg.acknowledge();
            this.clearStatusEvent();
            this.checkReplyTypeStatus(mesg, 41, "UPDATE_DESTINATION_REPLY");
        }
        catch (Exception e) {
            this.handleReceiveExceptions(e);
        }
    }

    public void sendUpdateServiceMessage(ServiceInfo svcInfo) throws BrokerAdminException {
        if (BrokerAdmin.getDebug()) {
            Globals.stdOutPrintln("***** sendUpdateServiceMessage *****");
        }
        ObjectMessage mesg = null;
        this.checkIfBusy();
        try {
            mesg = this.session.createObjectMessage();
            mesg.setJMSReplyTo(this.replyQueue);
            mesg.setIntProperty("JMQMessageType", 46);
            mesg.setObject(svcInfo);
            this.statusEvent = this.createStatusEvent(14, 47, "UPDATE_SERVICE_REPLY");
            this.statusEvent.setServiceInfo(svcInfo);
            if (BrokerAdmin.getDebug()) {
                this.printMsgType(46, "UPDATE_SERVICE");
                this.printServiceInfo(svcInfo);
            }
            this.sender.send(mesg);
        }
        catch (Exception e) {
            this.handleSendExceptions(e);
        }
    }

    public void receiveUpdateServiceReplyMessage() throws BrokerAdminException {
        if (BrokerAdmin.getDebug()) {
            Globals.stdOutPrintln("***** receiveUpdateServiceReplyMessage *****");
        }
        Message mesg = null;
        try {
            mesg = this.receiveCheckMessageTimeout(false);
            mesg.acknowledge();
            this.clearStatusEvent();
            this.checkReplyTypeStatus(mesg, 47, "UPDATE_SERVICE_REPLY");
        }
        catch (Exception e) {
            this.handleReceiveExceptions(e);
        }
    }

    public void sendShutdownMessage(boolean restart) throws BrokerAdminException {
        this.sendShutdownMessage(restart, false);
    }

    public void sendShutdownMessage(boolean restart, boolean kill) throws BrokerAdminException {
        this.sendShutdownMessage(restart, kill, false, -1);
    }

    public void sendShutdownMessage(boolean restart, boolean kill, boolean noFailover, int time) throws BrokerAdminException {
        if (BrokerAdmin.getDebug()) {
            Globals.stdOutPrintln("***** sendShutdownMessage *****");
        }
        ObjectMessage mesg = null;
        this.checkIfBusy();
        try {
            mesg = this.session.createObjectMessage();
            mesg.setJMSReplyTo(this.replyQueue);
            mesg.setIntProperty("JMQMessageType", 38);
            if (restart) {
                this.statusEvent = this.createStatusEvent(15, 39, "SHUTDOWN_REPLY");
                mesg.setBooleanProperty("JMQRestart", true);
            } else {
                this.statusEvent = this.createStatusEvent(16, 39, "SHUTDOWN_REPLY");
                mesg.setBooleanProperty("JMQNoFailover", noFailover);
                if (time > 0) {
                    mesg.setIntProperty("JMQTime", time);
                }
            }
            if (kill) {
                mesg.setBooleanProperty("JMQKill", true);
            }
            if (BrokerAdmin.getDebug()) {
                this.printMsgType(38, "SHUTDOWN");
                if (restart) {
                    Globals.stdOutPrintln("\tJMQRestart=true");
                } else {
                    Globals.stdOutPrintln("\tJMQNoFailover=" + noFailover);
                    Globals.stdOutPrintln("\tJMQTime=" + time);
                }
                if (kill) {
                    Globals.stdOutPrintln("\tJMQKill=true");
                }
            }
            this.sender.send(mesg);
        }
        catch (Exception e) {
            this.handleSendExceptions(e);
        }
    }

    public void receiveShutdownReplyMessage() throws BrokerAdminException {
        if (BrokerAdmin.getDebug()) {
            Globals.stdOutPrintln("***** receiveShutdownReplyMessage *****");
        }
        Message mesg = null;
        try {
            mesg = this.receiver.receive(this.timeout);
            this.checkReplyTypeStatus(mesg, 39, "SHUTDOWN_REPLY");
        }
        catch (JMSException jMSException) {
        }
        catch (Exception e) {
            this.handleReceiveExceptions(e);
        }
    }

    public void sendGetDurablesMessage(String topicName, String durName) throws BrokerAdminException {
        if (BrokerAdmin.getDebug()) {
            Globals.stdOutPrintln("***** sendGetDurablesMessage *****");
        }
        ObjectMessage mesg = null;
        this.checkIfBusy();
        try {
            mesg = this.session.createObjectMessage();
            mesg.setJMSReplyTo(this.replyQueue);
            mesg.setIntProperty("JMQMessageType", 22);
            if (topicName != null) {
                mesg.setStringProperty("JMQDestination", topicName);
            }
            if (durName != null) {
                mesg.setStringProperty("JMQDurableName", durName);
            }
            this.statusEvent = this.createStatusEvent(17, 23, "GET_DURABLES_REPLY");
            this.statusEvent.setDestinationName(topicName);
            this.statusEvent.setDurableName(durName);
            if (BrokerAdmin.getDebug()) {
                this.printMsgType(22, "GET_DURABLES");
                Globals.stdOutPrintln("\tJMQDestination=" + topicName);
                if (durName != null) {
                    Globals.stdOutPrintln("\tJMQDurableName=" + durName);
                }
            }
            this.sender.send(mesg);
        }
        catch (Exception e) {
            this.handleSendExceptions(e);
        }
    }

    public Vector receiveGetDurablesReplyMessage() throws BrokerAdminException {
        return this.receiveGetDurablesReplyMessage(true);
    }

    public Vector receiveGetDurablesReplyMessage(boolean waitForResponse) throws BrokerAdminException {
        if (BrokerAdmin.getDebug()) {
            Globals.stdOutPrintln("***** receiveGetDurablesReplyMessage *****");
        }
        ObjectMessage mesg = null;
        try {
            mesg = (ObjectMessage)this.receiveCheckMessageTimeout(false, waitForResponse);
            mesg.acknowledge();
            this.clearStatusEvent();
            this.checkReplyTypeStatus(mesg, 23, "GET_DURABLES_REPLY");
            Serializable obj = mesg.getObject();
            if (obj != null && obj instanceof Vector) {
                if (BrokerAdmin.getDebug()) {
                    this.printDurableInfoList((Vector)obj);
                }
                return (Vector)obj;
            }
        }
        catch (Exception e) {
            this.handleReceiveExceptions(e);
        }
        return null;
    }

    public void sendDestroyDurableMessage(String durName, String clientID) throws BrokerAdminException {
        if (BrokerAdmin.getDebug()) {
            Globals.stdOutPrintln("***** sendDestroyDurableMessage *****");
        }
        ObjectMessage mesg = null;
        this.checkIfBusy();
        try {
            mesg = this.session.createObjectMessage();
            mesg.setJMSReplyTo(this.replyQueue);
            mesg.setIntProperty("JMQMessageType", 14);
            mesg.setStringProperty("JMQDurableName", durName);
            if (clientID != null) {
                mesg.setStringProperty("JMQClientID", clientID);
            }
            this.statusEvent = this.createStatusEvent(18, 15, "DESTROY_DURABLE_REPLY");
            this.statusEvent.setDurableName(durName);
            this.statusEvent.setClientID(clientID);
            if (BrokerAdmin.getDebug()) {
                this.printMsgType(14, "DESTROY_DURABLE");
                Globals.stdOutPrintln("\tJMQDurableName=" + durName);
                Globals.stdOutPrintln("\tJMQClientID=" + clientID);
            }
            this.sender.send(mesg);
        }
        catch (Exception e) {
            this.handleSendExceptions(e);
        }
    }

    public void sendPurgeDurableMessage(String durName, String clientID) throws BrokerAdminException {
        if (BrokerAdmin.getDebug()) {
            Globals.stdOutPrintln("***** sendPurgeDurableMessage *****");
        }
        ObjectMessage mesg = null;
        this.checkIfBusy();
        try {
            mesg = this.session.createObjectMessage();
            mesg.setJMSReplyTo(this.replyQueue);
            mesg.setIntProperty("JMQMessageType", 66);
            mesg.setStringProperty("JMQDurableName", durName);
            if (clientID != null) {
                mesg.setStringProperty("JMQClientID", clientID);
            }
            this.statusEvent = this.createStatusEvent(27, 67, "PURGE_DURABLE_REPLY");
            this.statusEvent.setDurableName(durName);
            this.statusEvent.setClientID(clientID);
            if (BrokerAdmin.getDebug()) {
                this.printMsgType(66, "PURGE_DURABLE");
                Globals.stdOutPrintln("\tJMQDurableName=" + durName);
                Globals.stdOutPrintln("\tJMQClientID=" + clientID);
            }
            this.sender.send(mesg);
        }
        catch (Exception e) {
            this.handleSendExceptions(e);
        }
    }

    public void receiveDestroyDurableReplyMessage() throws BrokerAdminException {
        if (BrokerAdmin.getDebug()) {
            Globals.stdOutPrintln("***** receiveDestroyDurableReplyMessage *****");
        }
        Message mesg = null;
        try {
            mesg = this.receiveCheckMessageTimeout(false);
            mesg.acknowledge();
            this.clearStatusEvent();
            this.checkReplyTypeStatus(mesg, 15, "DESTROY_DURABLE_REPLY");
        }
        catch (Exception e) {
            this.handleReceiveExceptions(e);
        }
    }

    public void receivePurgeDurableReplyMessage() throws BrokerAdminException {
        if (BrokerAdmin.getDebug()) {
            Globals.stdOutPrintln("***** receivePurgeDurableReplyMessage *****");
        }
        Message mesg = null;
        try {
            mesg = this.receiveCheckMessageTimeout(false);
            mesg.acknowledge();
            this.clearStatusEvent();
            this.checkReplyTypeStatus(mesg, 67, "PURGE_DURABLE_REPLY");
        }
        catch (Exception e) {
            this.handleReceiveExceptions(e);
        }
    }

    public void sendGetMetricsMessage(String svcName) throws BrokerAdminException {
        if (BrokerAdmin.getDebug()) {
            Globals.stdOutPrintln("***** sendGetMetricsMessage *****");
        }
        ObjectMessage mesg = null;
        this.checkIfBusy();
        try {
            mesg = this.session.createObjectMessage();
            mesg.setJMSReplyTo(this.replyQueue);
            mesg.setIntProperty("JMQMessageType", 52);
            if (svcName != null) {
                mesg.setStringProperty("JMQServiceName", svcName);
                this.statusEvent = this.createStatusEvent(19, 53, "GET_METRICS_REPLY");
                this.statusEvent.setServiceName(svcName);
            } else {
                this.statusEvent = this.createStatusEvent(20, 53, "GET_METRICS_REPLY");
            }
            if (BrokerAdmin.getDebug()) {
                this.printMsgType(52, "GET_METRICS");
                if (svcName != null) {
                    Globals.stdOutPrintln("\tJMQServiceName=" + svcName);
                }
            }
            this.sender.send(mesg);
        }
        catch (Exception e) {
            this.handleSendExceptions(e);
        }
    }

    public void sendGetMetricsMessage(String dstName, int dstType) throws BrokerAdminException {
        if (BrokerAdmin.getDebug()) {
            Globals.stdOutPrintln("***** sendGetMetricsMessage *****");
        }
        ObjectMessage mesg = null;
        this.checkIfBusy();
        try {
            mesg = this.session.createObjectMessage();
            mesg.setJMSReplyTo(this.replyQueue);
            mesg.setIntProperty("JMQMessageType", 52);
            mesg.setStringProperty("JMQDestination", dstName);
            mesg.setIntProperty("JMQDestType", dstType);
            this.statusEvent = this.createStatusEvent(30, 53, "GET_METRICS_REPLY");
            if (BrokerAdmin.getDebug()) {
                this.printMsgType(52, "GET_METRICS");
                Globals.stdOutPrintln("\tJMQDestination=" + dstName);
                Globals.stdOutPrintln("\tJMQDestType=" + dstType);
            }
            this.sender.send(mesg);
        }
        catch (Exception e) {
            this.handleSendExceptions(e);
        }
    }

    public Object receiveGetMetricsReplyMessage() throws BrokerAdminException {
        if (BrokerAdmin.getDebug()) {
            Globals.stdOutPrintln("***** receiveGetMetricsReplyMessage *****");
        }
        ObjectMessage mesg = null;
        try {
            mesg = (ObjectMessage)this.receiveCheckMessageTimeout(false);
            mesg.acknowledge();
            this.clearStatusEvent();
            this.checkReplyTypeStatus(mesg, 53, "GET_METRICS_REPLY");
            String metricType = mesg.getStringProperty("JMQBodyType");
            Serializable obj = mesg.getObject();
            if (obj != null) {
                if ("DESTINATION".equals(metricType) && obj instanceof DestMetricsCounters) {
                    return obj;
                }
                if ((metricType == null || "SERVICE".equals(metricType)) && obj instanceof MetricCounters) {
                    return obj;
                }
            }
        }
        catch (Exception e) {
            this.handleReceiveExceptions(e);
        }
        return null;
    }

    public void sendReloadClusterMessage() throws BrokerAdminException {
        if (BrokerAdmin.getDebug()) {
            Globals.stdOutPrintln("***** sendReloadClusterMessage *****");
        }
        ObjectMessage mesg = null;
        this.checkIfBusy();
        try {
            mesg = this.session.createObjectMessage();
            mesg.setJMSReplyTo(this.replyQueue);
            mesg.setIntProperty("JMQMessageType", 58);
            this.statusEvent = this.createStatusEvent(21, 59, "RELOAD_CLUSTER_REPLY");
            if (BrokerAdmin.getDebug()) {
                this.printMsgType(58, "RELOAD_CLUSTER");
            }
            this.sender.send(mesg);
        }
        catch (Exception e) {
            this.handleSendExceptions(e);
        }
    }

    public void receiveReloadClusterReplyMessage() throws BrokerAdminException {
        if (BrokerAdmin.getDebug()) {
            Globals.stdOutPrintln("***** receiveReloadClusterReplyMessage *****");
        }
        Message mesg = null;
        try {
            mesg = this.receiveCheckMessageTimeout(false);
            mesg.acknowledge();
            this.clearStatusEvent();
            this.checkReplyTypeStatus(mesg, 59, "RELOAD_CLUSTER_REPLY");
        }
        catch (Exception e) {
            this.handleReceiveExceptions(e);
        }
    }

    public void sendClusterChangeMasterMessage(Properties props) throws BrokerAdminException {
        if (BrokerAdmin.getDebug()) {
            Globals.stdOutPrintln("***** sendClusterChangeMasterMessage *****");
        }
        ObjectMessage mesg = null;
        this.checkIfBusy();
        try {
            mesg = this.session.createObjectMessage();
            mesg.setJMSReplyTo(this.replyQueue);
            mesg.setIntProperty("JMQMessageType", 96);
            mesg.setStringProperty("JMQClusterNewMasterBroker", props.getProperty("imq.cluster.masterbroker"));
            mesg.setObject(props);
            this.statusEvent = this.createStatusEvent(46, 97, "CHANGE_CLUSTER_MASTER_BROKER_REPLY");
            if (BrokerAdmin.getDebug()) {
                this.printMsgType(96, "CHANGE_CLUSTER_MASTER_BROKER");
                Globals.stdOutPrintln("\tProperties=" + props.toString());
            }
            this.sender.send(mesg);
        }
        catch (Exception e) {
            this.handleSendExceptions(e);
        }
    }

    public void receiveClusterChangeMasterReplyMessage() throws BrokerAdminException {
        if (BrokerAdmin.getDebug()) {
            Globals.stdOutPrintln("***** receiveClusterChangeMasterReplyMessage *****");
        }
        Message mesg = null;
        try {
            mesg = this.receiveCheckMessageTimeout(false);
            mesg.acknowledge();
            this.clearStatusEvent();
            this.checkReplyTypeStatus(mesg, 97, "CHANGE_CLUSTER_MASTER_BROKER_REPLY");
        }
        catch (Exception e) {
            this.handleReceiveExceptions(e);
        }
    }

    public void sendGetClusterMessage(boolean listBkr) throws BrokerAdminException {
        if (BrokerAdmin.getDebug()) {
            Globals.stdOutPrintln("***** sendGetClusterMessage *****");
        }
        ObjectMessage mesg = null;
        this.checkIfBusy();
        try {
            mesg = this.session.createObjectMessage();
            mesg.setJMSReplyTo(this.replyQueue);
            mesg.setIntProperty("JMQMessageType", 78);
            this.statusEvent = listBkr ? this.createStatusEvent(38, 79, "GET_CLUSTER_REPLY") : this.createStatusEvent(11, 79, "GET_CLUSTER_REPLY");
            if (BrokerAdmin.getDebug()) {
                this.printMsgType(78, "GET_CLUSTER");
            }
            this.sender.send(mesg);
        }
        catch (Exception e) {
            this.handleSendExceptions(e);
        }
    }

    public Vector receiveGetClusterReplyMessage() throws BrokerAdminException {
        return this.receiveGetClusterReplyMessage(true);
    }

    public Vector receiveGetClusterReplyMessage(boolean waitForResponse) throws BrokerAdminException {
        if (BrokerAdmin.getDebug()) {
            Globals.stdOutPrintln("***** receiveGetClusterReplyMessage *****");
        }
        ObjectMessage mesg = null;
        try {
            mesg = (ObjectMessage)this.receiveCheckMessageTimeout(false, waitForResponse);
            mesg.acknowledge();
            this.clearStatusEvent();
            this.checkReplyTypeStatus(mesg, 79, "GET_CLUSTER_REPLY");
            Serializable obj = mesg.getObject();
            if (obj != null && obj instanceof Vector) {
                if (BrokerAdmin.getDebug()) {
                    this.printClusterList((Vector)obj);
                }
                return (Vector)obj;
            }
        }
        catch (Exception e) {
            this.handleReceiveExceptions(e);
        }
        return null;
    }

    public void sendGetJMXConnectorsMessage(String name) throws BrokerAdminException {
        if (BrokerAdmin.getDebug()) {
            Globals.stdOutPrintln("***** sendGetJMXConnectorsMessage *****");
        }
        ObjectMessage mesg = null;
        this.checkIfBusy();
        try {
            mesg = this.session.createObjectMessage();
            mesg.setJMSReplyTo(this.replyQueue);
            mesg.setIntProperty("JMQMessageType", 80);
            this.statusEvent = this.createStatusEvent(39, 81, "GET_JMX_REPLY");
            if (BrokerAdmin.getDebug()) {
                this.printMsgType(80, "GET_JMX");
            }
            this.sender.send(mesg);
        }
        catch (Exception e) {
            this.handleSendExceptions(e);
        }
    }

    public Vector receiveGetJMXConnectorsReplyMessage() throws BrokerAdminException {
        return this.receiveGetJMXConnectorsReplyMessage(true);
    }

    public Vector receiveGetJMXConnectorsReplyMessage(boolean waitForResponse) throws BrokerAdminException {
        if (BrokerAdmin.getDebug()) {
            Globals.stdOutPrintln("***** receiveGetJMXConnectorsReplyMessage *****");
        }
        ObjectMessage mesg = null;
        try {
            mesg = (ObjectMessage)this.receiveCheckMessageTimeout(false, waitForResponse);
            mesg.acknowledge();
            this.clearStatusEvent();
            this.checkReplyTypeStatus(mesg, 81, "GET_JMX_REPLY");
            Serializable obj = mesg.getObject();
            if (obj != null && obj instanceof Vector) {
                if (BrokerAdmin.getDebug()) {
                    this.printJMXList((Vector)obj);
                }
                return (Vector)obj;
            }
        }
        catch (Exception e) {
            this.handleReceiveExceptions(e);
        }
        return null;
    }

    public void sendGetMessagesMessage(String dstName, int dstType, boolean getBody, String msgID, Long startMessageIndex, Long maxNumMsgsRetrieved) throws BrokerAdminException {
        if (BrokerAdmin.getDebug()) {
            Globals.stdOutPrintln("***** sendGetMessagesMessage *****");
        }
        ObjectMessage mesg = null;
        this.checkIfBusy();
        try {
            mesg = this.session.createObjectMessage();
            mesg.setJMSReplyTo(this.replyQueue);
            mesg.setIntProperty("JMQMessageType", 86);
            mesg.setStringProperty("JMQDestination", dstName);
            mesg.setIntProperty("JMQDestType", dstType);
            mesg.setBooleanProperty("JMQGetMessageBody", getBody);
            if (msgID != null) {
                mesg.setStringProperty("JMQMessageID", msgID);
            }
            if (startMessageIndex != null) {
                mesg.setLongProperty("JMQStartMessageIndex", startMessageIndex);
            }
            if (maxNumMsgsRetrieved != null) {
                mesg.setLongProperty("JMQMaxNumMsgsRetrieved", maxNumMsgsRetrieved);
            }
            this.statusEvent = this.createStatusEvent(43, 87, "GET_MESSAGE_REPLY");
            if (BrokerAdmin.getDebug()) {
                this.printMsgType(86, "GET_MESSAGES");
            }
            this.sender.send(mesg);
        }
        catch (Exception e) {
            this.handleSendExceptions(e);
        }
    }

    public Vector receiveGetMessagesReplyMessage() throws BrokerAdminException {
        return this.receiveGetMessagesReplyMessage(true);
    }

    public Vector receiveGetMessagesReplyMessage(boolean waitForResponse) throws BrokerAdminException {
        if (BrokerAdmin.getDebug()) {
            Globals.stdOutPrintln("***** receiveGetMessagesReplyMessage *****");
        }
        ObjectMessage mesg = null;
        try {
            mesg = (ObjectMessage)this.receiveCheckMessageTimeout(false, waitForResponse);
            mesg.acknowledge();
            this.clearStatusEvent();
            this.checkReplyTypeStatus(mesg, 87, "GET_MESSAGES_REPLY");
            Serializable obj = mesg.getObject();
            if (obj != null && obj instanceof Vector) {
                return (Vector)obj;
            }
        }
        catch (Exception e) {
            this.handleReceiveExceptions(e);
        }
        return null;
    }

    public void sendDestroyMessagesMessage(String dstName, int dstType, String msgID) throws BrokerAdminException {
        if (BrokerAdmin.getDebug()) {
            Globals.stdOutPrintln("***** sendDestroyMessagesMessage *****");
        }
        ObjectMessage mesg = null;
        this.checkIfBusy();
        try {
            mesg = this.session.createObjectMessage();
            mesg.setJMSReplyTo(this.replyQueue);
            mesg.setIntProperty("JMQMessageType", 88);
            mesg.setStringProperty("JMQDestination", dstName);
            mesg.setIntProperty("JMQDestType", dstType);
            if (msgID != null) {
                mesg.setStringProperty("JMQMessageID", msgID);
            }
            this.statusEvent = this.createStatusEvent(44, 89, "DELETE_MESSAGE_REPLY");
            if (BrokerAdmin.getDebug()) {
                this.printMsgType(88, "DELETE_MESSAGE");
            }
            this.sender.send(mesg);
        }
        catch (Exception e) {
            this.handleSendExceptions(e);
        }
    }

    public void receiveDestroyMessagesReplyMessage() throws BrokerAdminException {
        this.receiveDestroyMessagesReplyMessage(true);
    }

    public void receiveDestroyMessagesReplyMessage(boolean waitForResponse) throws BrokerAdminException {
        if (BrokerAdmin.getDebug()) {
            Globals.stdOutPrintln("***** receiveDestroyMessagesReplyMessage *****");
        }
        ObjectMessage mesg = null;
        try {
            mesg = (ObjectMessage)this.receiveCheckMessageTimeout(false, waitForResponse);
            mesg.acknowledge();
            this.clearStatusEvent();
            this.checkReplyTypeStatus(mesg, 89, "DELETE_MESSAGE_REPLY");
        }
        catch (Exception e) {
            this.handleReceiveExceptions(e);
        }
    }

    public void sendCommitTxnMessage(Long tid) throws BrokerAdminException {
        if (BrokerAdmin.getDebug()) {
            Globals.stdOutPrintln("***** sendCommitTxnMessage *****");
        }
        ObjectMessage mesg = null;
        this.checkIfBusy();
        try {
            mesg = this.session.createObjectMessage();
            mesg.setJMSReplyTo(this.replyQueue);
            mesg.setIntProperty("JMQMessageType", 62);
            mesg.setLongProperty("JMQTransactionID", tid);
            this.statusEvent = this.createStatusEvent(23, 63, "COMMIT_TRANSACTION_REPLY");
            if (BrokerAdmin.getDebug()) {
                this.printMsgType(62, "COMMIT_TRANSACTION");
                Globals.stdOutPrintln("\tJMQTransactionID=" + tid);
            }
            this.sender.send(mesg);
        }
        catch (Exception e) {
            this.handleSendExceptions(e);
        }
    }

    public void receiveCommitTxnReplyMessage() throws BrokerAdminException {
        if (BrokerAdmin.getDebug()) {
            Globals.stdOutPrintln("***** receiveCommitTxnReplyMessage *****");
        }
        Message mesg = null;
        try {
            mesg = this.receiveCheckMessageTimeout(false);
            mesg.acknowledge();
            this.clearStatusEvent();
            this.checkReplyTypeStatus(mesg, 63, "COMMIT_TRANSACTION_REPLY");
        }
        catch (Exception e) {
            this.handleReceiveExceptions(e);
        }
    }

    public void sendRollbackTxnMessage(Long tid, boolean processActiveConsumers) throws BrokerAdminException {
        if (BrokerAdmin.getDebug()) {
            Globals.stdOutPrintln("***** sendRollbackTxnMessage *****");
        }
        ObjectMessage mesg = null;
        this.checkIfBusy();
        try {
            mesg = this.session.createObjectMessage();
            mesg.setJMSReplyTo(this.replyQueue);
            mesg.setIntProperty("JMQMessageType", 64);
            mesg.setLongProperty("JMQTransactionID", tid);
            if (processActiveConsumers) {
                mesg.setBooleanProperty("JMQProcessActiveConsumers", true);
            }
            this.statusEvent = this.createStatusEvent(24, 65, "ROLLBACK_TRANSACTION_REPLY");
            if (BrokerAdmin.getDebug()) {
                this.printMsgType(64, "ROLLBACK_TRANSACTION");
                Globals.stdOutPrintln("\tJMQTransactionID=" + tid);
            }
            this.sender.send(mesg);
        }
        catch (Exception e) {
            this.handleSendExceptions(e);
        }
    }

    public void receiveRollbackTxnReplyMessage() throws BrokerAdminException {
        if (BrokerAdmin.getDebug()) {
            Globals.stdOutPrintln("***** receiveRollbackTxnReplyMessage *****");
        }
        Message mesg = null;
        try {
            mesg = this.receiveCheckMessageTimeout(false);
            mesg.acknowledge();
            this.clearStatusEvent();
            this.checkReplyTypeStatus(mesg, 65, "ROLLBACK_TRANSACTION_REPLY");
        }
        catch (Exception e) {
            this.handleReceiveExceptions(e);
        }
    }

    public void sendGetTxnsMessage(Long tid, boolean showpartition) throws BrokerAdminException {
        this.sendGetTxnsMessage(true, tid, showpartition);
    }

    public void sendGetTxnsMessage(boolean showpartition) throws BrokerAdminException {
        this.sendGetTxnsMessage(false, null, showpartition);
    }

    private void sendGetTxnsMessage(boolean tid_specified, Long tid, boolean showpartition) throws BrokerAdminException {
        if (BrokerAdmin.getDebug()) {
            Globals.stdOutPrintln("***** sendGetTxnsMessage *****");
        }
        ObjectMessage mesg = null;
        this.checkIfBusy();
        try {
            mesg = this.session.createObjectMessage();
            mesg.setJMSReplyTo(this.replyQueue);
            mesg.setIntProperty("JMQMessageType", 60);
            if (showpartition) {
                mesg.setBooleanProperty("JMQShowPartition", true);
            }
            if (tid_specified) {
                mesg.setLongProperty("JMQTransactionID", tid);
                this.statusEvent = this.createStatusEvent(26, 61, "GET_TRANSACTIONS_REPLY");
            } else {
                this.statusEvent = this.createStatusEvent(25, 61, "GET_TRANSACTIONS_REPLY");
            }
            if (BrokerAdmin.getDebug()) {
                this.printMsgType(60, "GET_TRANSACTIONS");
                Globals.stdOutPrintln("\tJMQTransactionID=");
                if (tid_specified) {
                    Globals.stdOutPrintln(tid.toString());
                } else {
                    Globals.stdOutPrintln("NOT SPECIFIED");
                }
            }
            this.sender.send(mesg);
        }
        catch (Exception e) {
            this.handleSendExceptions(e);
        }
    }

    public Vector receiveGetTxnsReplyMessage() throws BrokerAdminException {
        return this.receiveGetTxnsReplyMessage(true);
    }

    public Vector receiveGetTxnsReplyMessage(boolean waitForResponse) throws BrokerAdminException {
        if (BrokerAdmin.getDebug()) {
            Globals.stdOutPrintln("***** receiveGetTxnsReplyMessage *****");
        }
        ObjectMessage mesg = null;
        try {
            mesg = (ObjectMessage)this.receiveCheckMessageTimeout(false, waitForResponse);
            mesg.acknowledge();
            this.clearStatusEvent();
            this.checkReplyTypeStatus(mesg, 61, "GET_TRANSACTIONS_REPLY");
            Serializable obj = mesg.getObject();
            if (BrokerAdmin.getDebug()) {
                int quantity = 0;
                Globals.stdOutPrintln("obj returned: " + obj);
                try {
                    quantity = mesg.getIntProperty("JMQQuantity");
                }
                catch (JMSException jmse) {
                    Globals.stdOutPrintln("failed to get JMQ_QUANTITY: " + jmse);
                }
                Globals.stdOutPrintln("JMQ_QUANTTY: " + quantity);
            }
            if (obj != null && obj instanceof Vector) {
                if (BrokerAdmin.getDebug()) {
                    this.printTxnInfoList((Vector)obj);
                }
                return (Vector)obj;
            }
        }
        catch (Exception e) {
            this.handleReceiveExceptions(e);
        }
        return null;
    }

    public void sendCompactDestinationMessage(String dstName, int dstType) throws BrokerAdminException {
        if (BrokerAdmin.getDebug()) {
            Globals.stdOutPrintln("***** sendCompactDestinationMessage *****");
        }
        ObjectMessage mesg = null;
        this.checkIfBusy();
        try {
            mesg = this.session.createObjectMessage();
            mesg.setJMSReplyTo(this.replyQueue);
            mesg.setIntProperty("JMQMessageType", 68);
            if (dstName != null) {
                mesg.setStringProperty("JMQDestination", dstName);
            }
            if (dstType != -1) {
                mesg.setIntProperty("JMQDestType", dstType);
            }
            this.statusEvent = this.createStatusEvent(32, 69, "COMPACT_DESTINATION_REPLY");
            this.statusEvent.setDestinationName(dstName);
            if (BrokerAdmin.getDebug()) {
                this.printMsgType(68, "COMPACT_DESTINATION");
                Globals.stdOutPrintln("\tJMQDestination=" + dstName);
                Globals.stdOutPrintln("\tJMQDestType=" + dstType);
            }
            this.sender.send(mesg);
        }
        catch (Exception e) {
            this.handleSendExceptions(e);
        }
    }

    public void receiveCompactDestinationReplyMessage() throws BrokerAdminException {
        if (BrokerAdmin.getDebug()) {
            Globals.stdOutPrintln("***** receiveCompactDestinationReplyMessage *****");
        }
        Message mesg = null;
        try {
            mesg = this.receiveCheckMessageTimeout(false);
            mesg.acknowledge();
            this.clearStatusEvent();
            this.checkReplyTypeStatus(mesg, 69, "COMPACT_DESTINATION_REPLY");
        }
        catch (Exception e) {
            this.handleReceiveExceptions(e);
        }
    }

    public void sendGetConnectionsMessage(String svcName, Long cxnId) throws BrokerAdminException {
        if (BrokerAdmin.getDebug()) {
            Globals.stdOutPrintln("***** sendGetConnectionsMessage *****");
        }
        ObjectMessage mesg = null;
        this.checkIfBusy();
        try {
            mesg = this.session.createObjectMessage();
            mesg.setJMSReplyTo(this.replyQueue);
            mesg.setIntProperty("JMQMessageType", 16);
            if (cxnId != null) {
                this.statusEvent = this.createStatusEvent(34, 17, "GET_CONNECTIONS_REPLY");
                mesg.setLongProperty("JMQConnectionID", cxnId);
            } else {
                this.statusEvent = this.createStatusEvent(33, 17, "GET_CONNECTIONS_REPLY");
            }
            if (svcName != null) {
                mesg.setStringProperty("JMQServiceName", svcName);
                this.statusEvent.setServiceName(svcName);
            }
            if (BrokerAdmin.getDebug()) {
                this.printMsgType(16, "GET_CONNECTIONS");
                if (svcName != null) {
                    Globals.stdOutPrintln("\tJMQServiceName=" + svcName);
                }
                if (cxnId != null) {
                    Globals.stdOutPrintln("\tJMQConnectionID=" + cxnId);
                }
            }
            this.sender.send(mesg);
        }
        catch (Exception e) {
            this.handleSendExceptions(e);
        }
    }

    public Vector receiveGetConnectionsReplyMessage() throws BrokerAdminException {
        return this.receiveGetConnectionsReplyMessage(true);
    }

    public Vector receiveGetConnectionsReplyMessage(boolean waitForResponse) throws BrokerAdminException {
        if (BrokerAdmin.getDebug()) {
            Globals.stdOutPrintln("***** receiveGetConnectionsReplyMessage *****");
        }
        ObjectMessage mesg = null;
        try {
            mesg = (ObjectMessage)this.receiveCheckMessageTimeout(false, waitForResponse);
            mesg.acknowledge();
            this.clearStatusEvent();
            this.checkReplyTypeStatus(mesg, 17, "GET_CONNECTIONS_REPLY");
            Serializable obj = mesg.getObject();
            if (obj != null && obj instanceof Vector) {
                if (BrokerAdmin.getDebug()) {
                    this.printConnectionInfoList((Vector)obj);
                }
                return (Vector)obj;
            }
        }
        catch (Exception e) {
            this.handleReceiveExceptions(e);
        }
        return null;
    }

    public void sendDestroyConnectionMessage(Long cxnId) throws BrokerAdminException {
        if (BrokerAdmin.getDebug()) {
            Globals.stdOutPrintln("***** sendDestroyConnectionMessage *****");
        }
        ObjectMessage mesg = null;
        this.checkIfBusy();
        try {
            mesg = this.session.createObjectMessage();
            mesg.setJMSReplyTo(this.replyQueue);
            mesg.setIntProperty("JMQMessageType", 70);
            if (cxnId != null) {
                this.statusEvent = this.createStatusEvent(40, 71, "DESTROY_CONNECTION_REPLY");
                mesg.setLongProperty("JMQConnectionID", cxnId);
            }
            if (BrokerAdmin.getDebug()) {
                this.printMsgType(70, "DESTROY_CONNECTION");
                if (cxnId != null) {
                    Globals.stdOutPrintln("\tJMQConnectionID=" + cxnId);
                }
            }
            this.sender.send(mesg);
        }
        catch (Exception e) {
            this.handleSendExceptions(e);
        }
    }

    public void receiveDestroyConnectionReplyMessage() throws BrokerAdminException {
        if (BrokerAdmin.getDebug()) {
            Globals.stdOutPrintln("***** receiveDestroyConnectionReplyMessage *****");
        }
        Message mesg = null;
        try {
            mesg = this.receiveCheckMessageTimeout(false);
            mesg.acknowledge();
            this.clearStatusEvent();
            this.checkReplyTypeStatus(mesg, 71, "DESTROY_CONNECTION_REPLY");
        }
        catch (Exception e) {
            this.handleReceiveExceptions(e);
        }
    }

    public void sendDebugMessage(String cmd, String cmdarg, String target, String targetType, Properties optionalProps) throws BrokerAdminException {
        if (BrokerAdmin.getDebug()) {
            Globals.stdOutPrintln("***** sendDebugMessage *****");
        }
        ObjectMessage mesg = null;
        this.checkIfBusy();
        try {
            mesg = this.session.createObjectMessage();
            mesg.setJMSReplyTo(this.replyQueue);
            mesg.setIntProperty("JMQMessageType", 72);
            if (cmd != null) {
                mesg.setStringProperty("JMQCommand", cmd);
            }
            if (cmdarg != null) {
                mesg.setStringProperty("JMQCommandArg", cmdarg);
            }
            if (target != null) {
                mesg.setStringProperty("JMQTarget", target);
            }
            if (targetType != null) {
                mesg.setStringProperty("JMQTargetType", targetType);
            }
            if (optionalProps != null) {
                mesg.setObject(optionalProps);
            }
            this.statusEvent = this.createStatusEvent(35, 73, "DEBUG_REPLY");
            if (BrokerAdmin.getDebug()) {
                this.printMsgType(72, "DEBUG");
            }
            this.sender.send(mesg);
        }
        catch (Exception e) {
            this.handleSendExceptions(e);
        }
    }

    public Hashtable receiveDebugReplyMessage() throws BrokerAdminException {
        return this.receiveDebugReplyMessage(true);
    }

    public Hashtable receiveDebugReplyMessage(boolean waitForResponse) throws BrokerAdminException {
        if (BrokerAdmin.getDebug()) {
            Globals.stdOutPrintln("***** receiveDebugReplyMessage *****");
        }
        ObjectMessage mesg = null;
        try {
            mesg = (ObjectMessage)this.receiveCheckMessageTimeout(false, waitForResponse);
            mesg.acknowledge();
            this.clearStatusEvent();
            this.checkReplyTypeStatus(mesg, 73, "DEBUG_REPLY");
            Serializable obj = mesg.getObject();
            if (obj != null && obj instanceof Hashtable) {
                return (Hashtable)obj;
            }
        }
        catch (Exception e) {
            this.handleReceiveExceptions(e);
        }
        return null;
    }

    private void printMsgType(int msgType, String msgTypeString) {
        Globals.stdOutPrintln("\tJMQMessageType=" + msgType + "(" + msgTypeString + ")");
    }

    private void printDestinationInfoList(Vector v) {
        Enumeration e = v.elements();
        Globals.stdOutPrintln("\t************************");
        while (e.hasMoreElements()) {
            Object o = e.nextElement();
            if (!(o instanceof DestinationInfo)) {
                Globals.stdOutPrintln("\tprintDestinationInfoList: Vector contained object of type: " + o.getClass().getName());
                Globals.stdOutPrintln("\t************************");
                return;
            }
            DestinationInfo dInfo = (DestinationInfo)o;
            this.printDestinationInfo(dInfo);
            if (!e.hasMoreElements()) continue;
            Globals.stdOutPrintln("");
        }
        Globals.stdOutPrintln("\t************************");
    }

    private void printDestinationInfo(DestinationInfo dstInfo) {
        Globals.stdOutPrintln("\tDestinationInfo:");
        Globals.stdOutPrintln("\t  name=" + dstInfo.name);
        Globals.stdOutPrintln("\t  type=" + dstInfo.type);
        Globals.stdOutPrintln("\t  nMessages=" + dstInfo.nMessages);
        Globals.stdOutPrintln("\t  nMessageBytes=" + dstInfo.nMessageBytes);
        Globals.stdOutPrintln("\t  nConsumers=" + dstInfo.nConsumers);
        Globals.stdOutPrintln("\t  maxMessages=" + dstInfo.maxMessages);
        Globals.stdOutPrintln("\t  maxMessageBytes=" + dstInfo.maxMessageBytes);
        Globals.stdOutPrintln("\t  maxMessageSize=" + dstInfo.maxMessageSize);
        Globals.stdOutPrintln("\t  maxFailoverConsumers=" + dstInfo.maxFailoverConsumers);
        Globals.stdOutPrintln("\t  maxActiveConsumers=" + dstInfo.maxActiveConsumers);
        Globals.stdOutPrintln("\t  destScope=" + dstInfo.destScope);
        Globals.stdOutPrintln("\t  destLimitBehavior=" + dstInfo.destLimitBehavior);
        Globals.stdOutPrintln("\t  destCDP=" + dstInfo.destCDP);
        Globals.stdOutPrintln("\t  maxPrefetch=" + dstInfo.maxPrefetch);
        Globals.stdOutPrintln("\t  maxProducers=" + dstInfo.maxProducers);
        Globals.stdOutPrintln("\t  autocreated=" + dstInfo.autocreated);
        Globals.stdOutPrintln("\t  naConsumers=" + dstInfo.naConsumers);
        Globals.stdOutPrintln("\t  nfConsumers=" + dstInfo.nfConsumers);
        Globals.stdOutPrintln("\t  destState=" + dstInfo.destState);
    }

    private void printServiceInfoList(Vector v) {
        Enumeration e = v.elements();
        Globals.stdOutPrintln("\t************************");
        while (e.hasMoreElements()) {
            Object o = e.nextElement();
            if (!(o instanceof ServiceInfo)) {
                Globals.stdOutPrintln("\tprintServiceInfoList: Vector contained object of type: " + o.getClass().getName());
                Globals.stdOutPrintln("\t************************");
                return;
            }
            ServiceInfo svcInfo = (ServiceInfo)o;
            this.printServiceInfo(svcInfo);
            if (!e.hasMoreElements()) continue;
            Globals.stdOutPrintln("");
        }
        Globals.stdOutPrintln("\t************************");
    }

    private void printServiceInfo(ServiceInfo svcInfo) {
        Globals.stdOutPrintln("\tServiceInfo:");
        Globals.stdOutPrintln("\t  name=" + svcInfo.name);
        Globals.stdOutPrintln("\t  protocol=" + svcInfo.protocol);
        Globals.stdOutPrintln("\t  type=" + svcInfo.type);
        Globals.stdOutPrintln("\t  state=" + svcInfo.state);
        Globals.stdOutPrintln("\t  nConnections=" + svcInfo.nConnections);
        Globals.stdOutPrintln("\t  currentThreads=" + svcInfo.currentThreads);
        Globals.stdOutPrintln("\t  dynamicPort=" + svcInfo.dynamicPort);
        Globals.stdOutPrintln("\t  metrics=" + svcInfo.metrics);
        Globals.stdOutPrintln("\t  port=" + svcInfo.port);
        Globals.stdOutPrintln("\t  minThreads=" + svcInfo.minThreads);
        Globals.stdOutPrintln("\t  maxThreads=" + svcInfo.maxThreads);
    }

    private void printConnectionInfoList(Vector v) {
        Enumeration e = v.elements();
        Globals.stdOutPrintln("\t************************");
        while (e.hasMoreElements()) {
            Object o = e.nextElement();
            if (!(o instanceof Hashtable)) {
                Globals.stdOutPrintln("\tprintConnectionInfoList: Vector contained object of type: " + o.getClass().getName() + "(expected java.util.Hashtable)");
                Globals.stdOutPrintln("\t************************");
                return;
            }
            Hashtable cxnInfo = (Hashtable)o;
            this.printConnectionInfo(cxnInfo);
            if (!e.hasMoreElements()) continue;
            Globals.stdOutPrintln("");
        }
        Globals.stdOutPrintln("\t************************");
    }

    private void printConnectionInfo(Hashtable cxnInfo) {
        BrokerAdmin.print(cxnInfo, "\tConnection Info:", "\t  ", "=", CommonGlobals::stdOutPrintln);
    }

    private void printDurableInfoList(Vector v) {
        Enumeration e = v.elements();
        Globals.stdOutPrintln("\t************************");
        while (e.hasMoreElements()) {
            Object o = e.nextElement();
            if (!(o instanceof DurableInfo)) {
                Globals.stdOutPrintln("\tprintDurableInfoList: Vector contained object of type: " + o.getClass().getName());
                Globals.stdOutPrintln("\t************************");
                return;
            }
            DurableInfo durInfo = (DurableInfo)o;
            this.printDurableInfo(durInfo);
            if (!e.hasMoreElements()) continue;
            Globals.stdOutPrintln("");
        }
        Globals.stdOutPrintln("\t************************");
    }

    private void printDurableInfo(DurableInfo durInfo) {
        Globals.stdOutPrintln("\tDurableInfo:");
        Globals.stdOutPrintln("\t  name=" + durInfo.name);
        Globals.stdOutPrintln("\t  clientID=" + durInfo.clientID);
        Globals.stdOutPrintln("\t  isDurable=" + durInfo.isDurable);
        Globals.stdOutPrintln("\t  nMessages=" + durInfo.nMessages);
        Globals.stdOutPrintln("\t  isActive=" + durInfo.isActive);
        Globals.stdOutPrintln("\t  ConsumerInfo=" + durInfo.consumer);
    }

    private void printTxnInfoList(Vector v) {
        Enumeration e = v.elements();
        Globals.stdOutPrintln("\t************************");
        while (e.hasMoreElements()) {
            Object o = e.nextElement();
            if (!(o instanceof Hashtable)) {
                Globals.stdOutPrintln("\tprintTxnInfoList: Vector contained object of type: " + o.getClass().getName() + "(expected java.util.Hashtable)");
                Globals.stdOutPrintln("\t************************");
                return;
            }
            Hashtable txnInfo = (Hashtable)o;
            this.printTxnInfo(txnInfo);
            if (!e.hasMoreElements()) continue;
            Globals.stdOutPrintln("");
        }
        Globals.stdOutPrintln("\t************************");
    }

    private void printTxnInfo(Hashtable txnInfo) {
        BrokerAdmin.print(txnInfo, "\tTransaction Info:", "\t  ", "=", CommonGlobals::stdOutPrintln);
    }

    private void printClusterList(Vector v) {
        Enumeration e = v.elements();
        Globals.stdOutPrintln("\t************************");
        while (e.hasMoreElements()) {
            Object o = e.nextElement();
            if (!(o instanceof Hashtable)) {
                Globals.stdOutPrintln("\tprintClusterList: Vector contained object of type: " + o.getClass().getName() + "(expected java.util.Hashtable)");
                Globals.stdOutPrintln("\t************************");
                return;
            }
            Hashtable bkrClsInfo = (Hashtable)o;
            this.printBkrClsInfo(bkrClsInfo);
            if (!e.hasMoreElements()) continue;
            Globals.stdOutPrintln("");
        }
        Globals.stdOutPrintln("\t************************");
    }

    private void printBkrClsInfo(Hashtable bkrClsInfo) {
        BrokerAdmin.print(bkrClsInfo, "\tBroker Cluster Info:", "\t  ", "=", CommonGlobals::stdOutPrintln);
    }

    private void printJMXList(Vector v) {
        Enumeration e = v.elements();
        Globals.stdOutPrintln("\t************************");
        while (e.hasMoreElements()) {
            Object o = e.nextElement();
            if (!(o instanceof Hashtable)) {
                Globals.stdOutPrintln("\tprintJMXList: Vector contained object of type: " + o.getClass().getName() + "(expected java.util.Hashtable)");
                Globals.stdOutPrintln("\t************************");
                return;
            }
            Hashtable jmxInfo = (Hashtable)o;
            this.printJMXInfo(jmxInfo);
            if (!e.hasMoreElements()) continue;
            Globals.stdOutPrintln("");
        }
        Globals.stdOutPrintln("\t************************");
    }

    private void printJMXInfo(Hashtable jmxInfo) {
        BrokerAdmin.print(jmxInfo, "\tJMX Connector Info:", "\t  ", "=", CommonGlobals::stdOutPrintln);
    }

    static void print(Hashtable table, String title, String keyValPrefix, String keyValSeparator, Consumer<String> printer) {
        printer.accept(title);
        table.forEach((key, value) -> printer.accept(keyValPrefix + key + keyValSeparator + value));
    }

    public void setAssociatedObj(Object obj) {
        this.aObj = obj;
    }

    public Object getAssociatedObj() {
        return this.aObj;
    }
}

