/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.core;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.config.BrokerConfig;
import com.sun.messaging.jmq.jmsserver.config.ConfigListener;
import com.sun.messaging.jmq.jmsserver.config.PropertyUpdateException;
import com.sun.messaging.jmq.jmsserver.core.Consumer;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationList;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.core.PacketReference;
import com.sun.messaging.jmq.jmsserver.core.QueueInfo;
import com.sun.messaging.jmq.jmsserver.core.SelectorFilter;
import com.sun.messaging.jmq.jmsserver.service.Connection;
import com.sun.messaging.jmq.jmsserver.service.ConnectionUID;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.DestMetricsCounters;
import com.sun.messaging.jmq.util.DestType;
import com.sun.messaging.jmq.util.lists.EventType;
import com.sun.messaging.jmq.util.lists.Filter;
import com.sun.messaging.jmq.util.lists.NFLPriorityFifoSet;
import com.sun.messaging.jmq.util.lists.Reason;
import com.sun.messaging.jmq.util.lists.SubSet;
import com.sun.messaging.jmq.util.lists.WeakValueHashMap;
import com.sun.messaging.jmq.util.selector.SelectorFormatException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class Queue
extends Destination {
    static final long serialVersionUID = 3396316998214097558L;
    private static Object NULL_OBJECT = new Object();
    private static boolean DEBUG = false;
    private transient NFLPriorityFifoSet<PacketReference> pending = null;
    private transient SubSet pendingSubset = null;
    private transient HashSet delivered = null;
    protected transient Map<String, SubSet> views = null;
    private boolean localDeliveryPreferred = false;
    private int maxActiveCount = 1;
    private int maxFailoverCount = 0;
    private int maxSize = this.maxActiveCount < 0 || this.maxFailoverCount < 0 ? -1 : this.maxActiveCount + this.maxFailoverCount;
    private transient Vector consumerPositions = null;
    private transient Map allConsumers = null;
    private transient int activeConsumerCnt = 0;
    private transient int failoverConsumerCnt = 0;
    private transient int localActiveConsumerCnt = 0;
    private transient int hwActiveCount = 0;
    private transient int hwFailoverCount = 0;
    private transient float activeAverage = 0.0f;
    private transient float failoverAverage = 0.0f;
    private transient int activeSampleCnt = 0;
    private transient int failoverSampleCnt = 0;
    public static final String MAX_ACTIVE = "max_active";
    public static final String MAX_FAILOVER = "max_failover";
    public static final String LOCAL_DELIVERY = "local_delivery_preferred";
    public static final int DEFAULT_MAX_ACTIVE_CONSUMERS = -1;
    public static final String MAX_ACTIVE_CNT = "imq.autocreate.queue.maxNumActiveConsumers";
    private static String MAX_FAILOVER_CNT = "imq.autocreate.queue.maxNumBackupConsumers";
    private static int defaultMaxActiveCount = Globals.getConfig().getIntProperty("imq.autocreate.queue.maxNumActiveConsumers", -1);
    private static int defaultMaxFailoverCount = Globals.getConfig().getIntProperty(MAX_FAILOVER_CNT, 0);
    private static Set queueConsumer = null;
    private static int QUEUE_DEFAULT_PREFETCH = Globals.getConfig().getIntProperty("imq.autocreate.queue.consumerFlowLimit", 1000);
    private static boolean QUEUE_LDP = Globals.getConfig().getBooleanProperty("imq.autocreate.queue.localDeliveryPreferred", false);
    private static ConfigListener cl = new ConfigListener(){

        @Override
        public void validate(String name, String value) throws PropertyUpdateException {
            if (name.equals(Queue.MAX_ACTIVE_CNT)) {
                try {
                    Integer.parseInt(value);
                }
                catch (Exception ex) {
                    throw new PropertyUpdateException("bad value " + value + " expected integer", ex);
                }
            }
            if (name.equals(MAX_FAILOVER_CNT)) {
                try {
                    Integer.parseInt(value);
                }
                catch (Exception ex) {
                    throw new PropertyUpdateException("bad value " + value + " expected integer", ex);
                }
            }
        }

        @Override
        public boolean update(String name, String value) {
            BrokerConfig cfg = Globals.getConfig();
            if (name.equals(Queue.MAX_ACTIVE_CNT)) {
                defaultMaxActiveCount = cfg.getIntProperty(Queue.MAX_ACTIVE_CNT);
            } else if (name.equals(MAX_FAILOVER_CNT)) {
                defaultMaxFailoverCount = cfg.getIntProperty(MAX_FAILOVER_CNT);
            }
            return true;
        }
    };

    @Override
    public void unload(boolean refs) {
        super.unload(refs);
        if (refs) {
            this.pending.clear();
            this.delivered.clear();
        }
    }

    @Override
    public void sort(Comparator c) {
        this.pending.sort(c);
    }

    @Override
    public PacketReference peekNext() {
        try {
            if (!this.loaded) {
                this.load();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.pending.peekNext();
    }

    @Override
    public int getUnackSize(Set msgset) {
        throw new UnsupportedOperationException("Unsupported operation: getUnackSize(Set)");
    }

    @Override
    public int getUnackSize() {
        int size = this.destMessages.size() - this.pending.size();
        if (size < 0) {
            this.logger.log(4, "Unexpected size for destination " + this + " [size,pending]=[" + this.destMessages.size() + "," + this.pending.size() + "]");
            size = 0;
        }
        return size;
    }

    public static Hashtable getAllDebugState() {
        Hashtable<String, String> ht = new Hashtable<String, String>();
        ht.put("maxNumActiveConsumers", String.valueOf(defaultMaxActiveCount));
        ht.put("maxNumBackupConsumers", String.valueOf(defaultMaxFailoverCount));
        ht.put("consumerFlowLimit", String.valueOf(QUEUE_DEFAULT_PREFETCH));
        ht.put("localDeliveryPreferred", String.valueOf(QUEUE_LDP));
        return ht;
    }

    @Override
    public Hashtable getDebugMessages(boolean full) {
        Hashtable ht = super.getDebugMessages(full);
        Vector<String> p = new Vector<String>();
        for (PacketReference pr : this.pending) {
            p.add(full ? pr.getPacket().dumpPacketString() : pr.getPacket().toString());
        }
        ht.put("PendingList", p);
        return ht;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Hashtable getDebugState() {
        Hashtable ht = super.getDebugState();
        Vector<Object> v = null;
        Object object = this.consumerPositions;
        synchronized (object) {
            v = new Vector<Object>(this.consumerPositions.size());
            for (int i = 0; i < v.size(); ++i) {
                Object o = this.consumerPositions.get(i);
                v.add(o == NULL_OBJECT ? "none" : String.valueOf(((ConsumerUID)o).longValue()));
            }
        }
        ht.put("ConsumerPositions", v);
        ht.put("pendingCnt", String.valueOf(this.pending.size()));
        if (DEBUG && DestinationList.DEBUG_LISTS) {
            ht.put("pending", this.pending.toDebugString());
        }
        ht.put("deliveredCnt", String.valueOf(this.delivered.size()));
        ht.put("localDeliveryPreferred", String.valueOf(this.localDeliveryPreferred));
        ht.put("maxActiveCount", String.valueOf(this.maxActiveCount));
        ht.put("maxFailoverCount", String.valueOf(this.maxFailoverCount));
        ht.put("maxSize", String.valueOf(this.maxSize));
        object = this.allConsumers;
        synchronized (object) {
            v = new Vector(this.allConsumers.size());
            for (QueueInfo qi : this.allConsumers.values()) {
                String info = qi.consumer.getConsumerUID().longValue() + "[" + qi.position + "," + (qi.active ? "active" : "inactive") + "," + (qi.local ? "local" : "remote") + "," + (qi.consumingMsgs ? "consuming" : "passive") + "]";
                v.add(info);
            }
        }
        ht.put("allConsumers", v);
        ht.put("activeConsumerCnt", String.valueOf(this.activeConsumerCnt));
        ht.put("failoverConsumerCnt", String.valueOf(this.failoverConsumerCnt));
        ht.put("localActiveConsumerCnt", String.valueOf(this.localActiveConsumerCnt));
        return ht;
    }

    public static void init() {
        queueConsumer = new HashSet();
        queueConsumer.add(PacketReference.getQueueUID());
        Globals.getConfig().addListener(MAX_ACTIVE_CNT, cl);
        Globals.getConfig().addListener(MAX_FAILOVER_CNT, cl);
    }

    static void clear() {
        queueConsumer = null;
        Globals.getConfig().removeListener(MAX_ACTIVE_CNT, cl);
        Globals.getConfig().removeListener(MAX_FAILOVER_CNT, cl);
    }

    protected Queue(DestinationUID uid) {
        super(uid);
    }

    protected Queue(String destination, int type, boolean store, ConnectionUID id, boolean autocreate, DestinationList dl) throws BrokerException, IOException {
        super(destination, type, store, id, autocreate, dl);
        this.maxPrefetch = QUEUE_DEFAULT_PREFETCH;
        this.pending = new NFLPriorityFifoSet(11, false);
        this.delivered = new HashSet();
        this.localDeliveryPreferred = QUEUE_LDP;
        this.consumerPositions = new Vector();
        this.allConsumers = new LinkedHashMap();
        this.views = new WeakValueHashMap<String, SubSet>("Views");
        this.destMessages.addEventListener(this, EventType.SET_CHANGED, this);
        this.setDefaultCounts(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DestMetricsCounters getMetrics() {
        DestMetricsCounters dmc = super.getMetrics();
        Queue queue = this;
        synchronized (queue) {
            dmc.setActiveConsumers(this.activeConsumerCnt);
            dmc.setFailoverConsumers(this.failoverConsumerCnt);
            dmc.setHWActiveConsumers(this.hwActiveCount);
            dmc.setHWFailoverConsumers(this.hwFailoverCount);
            dmc.setAvgActiveConsumers((int)this.activeAverage);
            dmc.setAvgFailoverConsumers((int)this.failoverAverage);
        }
        return dmc;
    }

    @Override
    protected void getDestinationProps(Map m) {
        super.getDestinationProps(m);
        m.put(MAX_ACTIVE, this.maxActiveCount);
        m.put(MAX_FAILOVER, this.maxFailoverCount);
        m.put(LOCAL_DELIVERY, this.localDeliveryPreferred);
    }

    @Override
    public void setDestinationProperties(Map m) throws BrokerException {
        if (m.get(MAX_ACTIVE) != null) {
            try {
                this.setMaxActiveConsumers((Integer)m.get(MAX_ACTIVE));
            }
            catch (BrokerException ex) {
                this.logger.logStack(16, "setMaxActiveConsumers()", ex);
            }
        }
        if (m.get(MAX_FAILOVER) != null) {
            try {
                this.setMaxFailoverConsumers((Integer)m.get(MAX_FAILOVER));
            }
            catch (BrokerException ex) {
                this.logger.logStack(16, "setMaxFailoverConsumers", ex);
            }
        }
        if (m.get(LOCAL_DELIVERY) != null) {
            boolean local = (Boolean)m.get(LOCAL_DELIVERY);
            this.setClusterDeliveryPolicy(local ? 1 : 2);
        }
        super.setDestinationProperties(m);
    }

    private void setDefaultCounts(int type) throws BrokerException {
        int active = 0;
        int failover = 0;
        if (DestType.isSingle(type)) {
            active = 1;
            failover = 0;
        } else if (DestType.isFailover(type)) {
            active = 1;
            failover = -1;
        } else if (DestType.isRRobin(type)) {
            active = -1;
            failover = 0;
        } else {
            active = defaultMaxActiveCount;
            failover = defaultMaxFailoverCount;
        }
        this.setMaxActiveConsumers(active);
        this.setMaxFailoverConsumers(failover);
        int n = this.maxSize = this.maxActiveCount < 0 || this.maxFailoverCount < 0 ? -1 : this.maxActiveCount + this.maxFailoverCount;
        if (this.maxSize != -1) {
            try {
                this.setMaxConsumers(this.maxSize);
            }
            catch (BrokerException ex) {
                this.logger.logStack(16, "setMaxConsumers()", ex);
            }
        }
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        this.pending = new NFLPriorityFifoSet(11, false);
        this.delivered = new HashSet();
        this.consumerPositions = new Vector();
        this.allConsumers = new LinkedHashMap();
        this.views = new WeakValueHashMap<String, SubSet>("views");
        this.destMessages.addEventListener(this, EventType.SET_CHANGED, null);
        if (this.maxActiveCount == 0 && this.maxFailoverCount == 0) {
            try {
                this.setDefaultCounts(this.type);
            }
            catch (Exception ex) {
                this.logger.logStack(16, "setDefaultCounts()", ex);
            }
        }
    }

    @Override
    public Set routeAndMoveMessage(PacketReference oldRef, PacketReference newRef) throws IOException, BrokerException {
        try {
            PacketReference.moveMessage(this.pstore, oldRef, newRef, queueConsumer);
        }
        catch (BrokerException ex) {
            throw ex;
        }
        catch (RuntimeException ex) {
            throw new BrokerException(ex.toString(), ex);
        }
        Destination odest = oldRef.getDestination();
        if (odest instanceof Queue) {
            ((Queue)odest).pending.remove(oldRef);
        }
        this.pending.add(10 - newRef.getPriority(), newRef);
        return null;
    }

    @Override
    public Set routeNewMessage(PacketReference ref) throws BrokerException {
        try {
            ref.store(queueConsumer);
        }
        catch (BrokerException ex) {
            throw ex;
        }
        catch (RuntimeException ex) {
            throw new BrokerException(ex.toString(), ex);
        }
        this.pending.add(10 - ref.getPriority(), ref);
        return null;
    }

    @Override
    public void routeNewMessageWithDeliveryDelay(PacketReference ref) throws BrokerException {
        try {
            ref.store(queueConsumer);
        }
        catch (BrokerException ex) {
            throw ex;
        }
        catch (RuntimeException ex) {
            throw new BrokerException(ex.toString(), ex);
        }
    }

    @Override
    public ConsumerUID[] calculateStoredInterests(PacketReference ref) throws BrokerException, SelectorFormatException {
        ConsumerUID[] storedInterests = null;
        try {
            storedInterests = ref.getRoutingForStore(queueConsumer);
        }
        catch (RuntimeException ex) {
            throw new BrokerException(ex.toString(), ex);
        }
        return storedInterests;
    }

    @Override
    public void unrouteLoadedTransactionAckMessage(PacketReference ref, ConsumerUID consumer) throws BrokerException {
        boolean removed = this.pending.remove(ref);
        Globals.getLogger().log(4, " removing from pending " + ref + " result=" + removed);
    }

    @Override
    public void forwardOrphanMessage(PacketReference ref, ConsumerUID consumer) throws BrokerException {
        if (ref.getOrder() == null) {
            this.pending.add(10 - ref.getPriority(), ref);
        } else {
            ArrayList<PacketReference> a = new ArrayList<PacketReference>();
            a.add(ref);
            this.forwardOrphanMessages(a, consumer);
            a.clear();
        }
    }

    @Override
    public void forwardOrphanMessages(Collection refs, ConsumerUID consumer) throws BrokerException {
        this.pending.addAllOrdered(refs);
    }

    @Override
    public void forwardMessage(Set consumers, PacketReference ref) {
    }

    @Override
    public void forwardDeliveryDelayedMessage(Set<ConsumerUID> consumers, PacketReference ref) throws BrokerException {
        this.pending.add(10 - ref.getPriority(), ref);
    }

    @Override
    protected ConsumerUID[] routeLoadedTransactionMessage(PacketReference ref) throws BrokerException, SelectorFormatException {
        ConsumerUID[] id = new ConsumerUID[]{PacketReference.getQueueUID()};
        return id;
    }

    @Override
    public void eventOccured(EventType type, Reason r, Object target, Object oldval, Object newval, Object userdata) {
        if (type == EventType.SET_CHANGED) {
            assert (target == this.destMessages);
            if (newval == null) {
                Map.Entry me = (Map.Entry)oldval;
                this.pending.remove(me.getValue());
                this.delivered.remove(me.getValue());
            }
        }
        super.eventOccured(type, r, target, oldval, newval, userdata);
    }

    @Override
    public int getClusterDeliveryPolicy() {
        return this.localDeliveryPreferred ? 1 : 2;
    }

    public static int getDefaultMaxActiveConsumers() {
        return defaultMaxActiveCount;
    }

    public static int getDefaultMaxFailoverConsumers() {
        return defaultMaxFailoverCount;
    }

    @Override
    public int getMaxActiveConsumers() {
        return this.maxActiveCount;
    }

    @Override
    public int getMaxFailoverConsumers() {
        return this.maxFailoverCount;
    }

    @Override
    public int getActiveConsumerCount() {
        return this.activeConsumerCnt;
    }

    @Override
    public int getFailoverConsumerCount() {
        return this.failoverConsumerCnt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set getActiveConsumers() {
        HashSet<Consumer> set = new HashSet<Consumer>();
        Map map = this.allConsumers;
        synchronized (map) {
            for (QueueInfo info : this.allConsumers.values()) {
                if (!info.active) continue;
                set.add(info.consumer);
            }
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set getFailoverConsumers() {
        HashSet<Consumer> set = new HashSet<Consumer>();
        Map map = this.allConsumers;
        synchronized (map) {
            for (QueueInfo info : this.allConsumers.values()) {
                if (info.active) continue;
                set.add(info.consumer);
            }
        }
        return set;
    }

    @Override
    public void setMaxActiveConsumers(int count) throws BrokerException {
        if (count == 0) {
            throw new BrokerException("Max Active Consumer count can not be 0");
        }
        Integer oldVal = this.maxActiveCount;
        this.maxActiveCount = count < -1 ? -1 : count;
        this.maxSize = this.maxActiveCount < 0 || this.maxFailoverCount < 0 ? -1 : this.maxActiveCount + this.maxFailoverCount;
        this.setMaxConsumers(this.maxSize);
        this.consumerListChanged();
        this.notifyAttrUpdated(512, oldVal, this.maxActiveCount);
    }

    @Override
    public void setMaxFailoverConsumers(int count) throws BrokerException {
        Integer oldVal = this.maxFailoverCount;
        this.maxFailoverCount = count;
        this.maxSize = this.maxActiveCount < 0 || this.maxFailoverCount < 0 ? -1 : this.maxActiveCount + this.maxFailoverCount;
        this.setMaxConsumers(this.maxSize);
        this.consumerListChanged();
        this.notifyAttrUpdated(1024, oldVal, this.maxFailoverCount);
    }

    @Override
    public void setClusterDeliveryPolicy(int policy) {
        boolean oldpolicy = this.localDeliveryPreferred;
        if (policy == 1) {
            this.localDeliveryPreferred = true;
        } else {
            assert (policy == 2);
            this.localDeliveryPreferred = false;
        }
        try {
            this.consumerListChanged();
            this.notifyAttrUpdated(256, oldpolicy, this.localDeliveryPreferred);
        }
        catch (BrokerException ex) {
            this.logger.log(8, "XXX - internal error handling delivery policy change ", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setPosition(ConsumerUID cuid, int position) {
        Vector vector = this.consumerPositions;
        synchronized (vector) {
            for (int i = this.consumerPositions.size(); i <= position; ++i) {
                this.consumerPositions.add(NULL_OBJECT);
            }
            this.consumerPositions.set(position, cuid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getPosition(ConsumerUID cuid, boolean local, boolean activeOnly) throws BrokerException {
        int position = 0;
        int lastposition = 0;
        int positioncnt = 0;
        boolean gotPosition = false;
        while (!gotPosition) {
            Vector vector = this.consumerPositions;
            synchronized (vector) {
                position = this.consumerPositions.indexOf(NULL_OBJECT, position);
                if (position == -1 && (this.maxSize == -1 || this.consumerPositions.size() < this.maxSize)) {
                    this.consumerPositions.add(NULL_OBJECT);
                    position = this.consumerPositions.size() - 1;
                }
                if (position == -1) {
                    break;
                }
                if (activeOnly && position >= this.maxActiveCount) {
                    position = -1;
                    break;
                }
            }
            if (local && !this.getIsLocal()) {
                if (Globals.getClusterBroadcast().getConsumerLock(cuid, this.getDestinationUID(), position, this.maxSize, cuid.getConnectionUID())) {
                    ConsumerUID o = this.consumerPositions.set(position, cuid);
                    if (o != NULL_OBJECT && o != null) {
                        this.logger.log(4, "after lock, object unexpectly changed  position " + o + " at position " + position);
                    }
                    gotPosition = true;
                    continue;
                }
                if (position == lastposition) {
                    if (++positioncnt > 10) {
                        this.logger.log(4, "Could not get position " + position + " in queue " + this + " for consumer " + cuid + " trying the next available position");
                    }
                } else if (position != lastposition) {
                    positioncnt = 0;
                }
                lastposition = ++position;
                continue;
            }
            vector = this.consumerPositions;
            synchronized (vector) {
                ConsumerUID o = this.consumerPositions.set(position, cuid);
                if (o != NULL_OBJECT && o != null) {
                    this.logger.log(4, "during set: object unexpectly changed  in getPosition for " + o + " at position " + position);
                }
            }
            gotPosition = true;
        }
        return position;
    }

    @Override
    public Consumer addConsumer(Consumer consumer, boolean local, Connection conn) throws BrokerException, SelectorFormatException {
        return this.addConsumer(consumer, local, conn, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Consumer addConsumer(Consumer consumer, boolean local, Connection conn, boolean loadIfActive) throws BrokerException, SelectorFormatException {
        consumer.setStoredConsumerUID(PacketReference.getQueueUID());
        super.addConsumer(consumer, local, conn, loadIfActive);
        if (!local && this.getIsLocal()) {
            throw new BrokerException("Internal Error " + this + " trying to add remote consumer to local dest", 409);
        }
        if (consumer.lockPosition == -1) {
            consumer.lockPosition = this.getPosition(consumer.getConsumerUID(), local, false);
        } else {
            this.setPosition(consumer.getConsumerUID(), consumer.lockPosition);
        }
        if (consumer.lockPosition == -1) {
            Object[] args = new String[]{this.getName(), String.valueOf(this.maxActiveCount), String.valueOf(this.maxFailoverCount)};
            throw new BrokerException(Globals.getBrokerResources().getKString("B4006", args), 409);
        }
        QueueInfo qinfo = new QueueInfo();
        qinfo.position = consumer.lockPosition;
        qinfo.consumer = consumer;
        qinfo.local = local;
        qinfo.active = this.maxActiveCount == -1 || consumer.lockPosition < this.maxActiveCount;
        Object object = this.allConsumers;
        synchronized (object) {
            this.allConsumers.put(consumer.getConsumerUID(), qinfo);
        }
        object = this;
        synchronized (object) {
            if (qinfo.local) {
                ++this.localActiveConsumerCnt;
            }
            if (qinfo.active) {
                this.updateActive(true);
            } else {
                this.updateFailover(true);
            }
            boolean hasLocal = this.localActiveConsumerCnt > 0;
            qinfo.consumingMsgs = hasLocal && this.localDeliveryPreferred && !local ? false : qinfo.active;
            this.makeActive(consumer);
            consumer.setIsActiveConsumer(qinfo.consumingMsgs);
            if (this.localDeliveryPreferred && local && this.localActiveConsumerCnt == 1 && this.activeConsumerCnt > this.localActiveConsumerCnt) {
                this.consumerListChanged();
            }
        }
        this.notifyConsumerAdded(consumer, conn);
        return consumer;
    }

    @Override
    public void removeConsumer(ConsumerUID cid, boolean local) throws BrokerException {
        this.removeConsumer(cid, null, false, local);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeConsumer(ConsumerUID cid, Map remotePendings, boolean remoteCleanup, boolean local) throws BrokerException {
        super.removeConsumer(cid, remotePendings, remoteCleanup, local);
        QueueInfo c = null;
        Object object = this.allConsumers;
        synchronized (object) {
            c = (QueueInfo)this.allConsumers.remove(cid);
        }
        if (c == null) {
            this.notifyConsumerRemoved();
            return;
        }
        object = this;
        synchronized (object) {
            this.makeInactive();
        }
        if (c.local && !this.getIsLocal()) {
            Globals.getClusterBroadcast().unlockConsumer(cid, this.getDestinationUID(), c.position);
        }
        object = this;
        synchronized (object) {
            Object o = this.consumerPositions.set(c.position, NULL_OBJECT);
            if (!cid.equals(o)) {
                this.logger.log(4, "object changed during remove of " + o + " at position " + c.position);
            }
            if (c.active) {
                if (c.local) {
                    --this.localActiveConsumerCnt;
                }
                this.updateActive(false);
            } else {
                this.updateFailover(false);
            }
        }
        this.consumerListChanged();
        this.notifyConsumerRemoved();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void makeActive(Consumer consumer) {
        if (consumer.getSelector() == null) {
            if (this.pendingSubset == null) {
                this.pendingSubset = this.pending.subSet((Filter)null);
            }
            consumer.setParentList(this.pstore, this.pendingSubset);
        } else {
            SubSet<PacketReference> set = null;
            Map<String, SubSet> map = this.views;
            synchronized (map) {
                set = this.views.get(consumer.getSelectorStr());
                if (set == null) {
                    SelectorFilter sf = new SelectorFilter(consumer.getSelectorStr(), consumer.getSelector());
                    set = this.pending.subSet(sf);
                    this.views.put(consumer.getSelectorStr(), set);
                }
            }
            consumer.setParentList(this.pstore, set);
        }
    }

    private void makeInactive() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void consumerListChanged() throws BrokerException {
        if (this.activeConsumerCnt == this.maxActiveCount && this.getConsumerCount() == 0) {
            return;
        }
        boolean lookRemote = !this.localDeliveryPreferred || this.localActiveConsumerCnt == 0;
        Map map = this.allConsumers;
        synchronized (map) {
            for (QueueInfo qi : this.allConsumers.values()) {
                int pos;
                if (qi.active) {
                    if (qi.position >= this.maxActiveCount && this.maxActiveCount != -1) {
                        if (this.failoverConsumerCnt >= this.maxFailoverCount) continue;
                        qi.consumingMsgs = false;
                        qi.active = false;
                        qi.consumer.setIsActiveConsumer(false);
                        this.updateActive(false);
                        this.updateFailover(true);
                        continue;
                    }
                    if (qi.local) {
                        assert (qi.consumingMsgs);
                        continue;
                    }
                    assert (!qi.local);
                    if (lookRemote) {
                        if (qi.consumingMsgs) continue;
                        qi.consumingMsgs = true;
                        qi.consumer.setIsActiveConsumer(true);
                        continue;
                    }
                    if (qi.consumingMsgs) {
                        qi.consumingMsgs = false;
                        qi.consumer.setIsActiveConsumer(false);
                        continue;
                    }
                    qi.consumer.setIsActiveConsumer(false);
                    continue;
                }
                if (qi.position < this.maxActiveCount) {
                    qi.active = true;
                    qi.consumingMsgs = qi.local || lookRemote;
                    qi.consumer.setIsActiveConsumer(qi.consumingMsgs);
                    this.updateActive(true);
                    this.updateFailover(false);
                    this.logger.log(8, "B1133", (Object)String.valueOf(qi.consumer.getConsumerUID().longValue()), qi.consumer.getDestinationUID().getName());
                    continue;
                }
                if (this.activeConsumerCnt >= this.maxActiveCount || (pos = this.getPosition(qi.consumer.getConsumerUID(), qi.local, true)) == -1) continue;
                if (!this.getIsLocal()) {
                    Globals.getClusterBroadcast().unlockConsumer(qi.consumer.getConsumerUID(), this.getDestinationUID(), qi.position);
                }
                Object o = this.consumerPositions.set(qi.position, NULL_OBJECT);
                if (!qi.consumer.getConsumerUID().equals(o)) {
                    this.logger.log(4, "failover update: object unexpected changed  position " + o + " at position " + qi.position + " new pos " + pos);
                }
                qi.position = pos;
                qi.consumingMsgs = qi.local || lookRemote;
                qi.consumer.setIsActiveConsumer(qi.consumingMsgs);
                qi.active = true;
                this.updateActive(true);
                this.updateFailover(false);
                this.logger.log(8, "B1133", (Object)String.valueOf(qi.consumer.getConsumerUID().longValue()), qi.consumer.getDestinationUID().getName());
                if (!qi.consumingMsgs) continue;
                this.makeActive(qi.consumer);
            }
        }
    }

    private synchronized void updateActive(boolean increment) {
        this.activeConsumerCnt = increment ? ++this.activeConsumerCnt : --this.activeConsumerCnt;
        if (this.activeConsumerCnt > this.hwActiveCount) {
            this.hwActiveCount = this.activeConsumerCnt;
        }
        this.activeAverage = ((float)this.activeSampleCnt * this.activeAverage + (float)this.activeConsumerCnt) / ((float)this.activeSampleCnt + 1.0f);
        ++this.activeSampleCnt;
    }

    private synchronized void updateFailover(boolean increment) {
        this.failoverConsumerCnt = increment ? ++this.failoverConsumerCnt : --this.failoverConsumerCnt;
        if (this.failoverConsumerCnt > this.hwFailoverCount) {
            this.hwFailoverCount = this.failoverConsumerCnt;
        }
        this.failoverAverage = ((float)this.failoverSampleCnt * this.failoverAverage + (float)this.failoverConsumerCnt) / ((float)this.failoverSampleCnt + 1.0f);
        ++this.failoverSampleCnt;
    }

    @Override
    public int getSharedConsumerFlowLimit() {
        return this.getMaxPrefetch();
    }

    @Override
    public void purgeDestination(boolean noerrnotfound) throws BrokerException {
        super.purgeDestination(noerrnotfound);
        this.pending.clear();
    }

    @Override
    public void purgeDestination(Filter criteria) throws BrokerException {
        super.purgeDestination(criteria);
        Set<PacketReference> s = this.pending.getAll(criteria);
        for (PacketReference o : s) {
            this.pending.remove(o);
        }
    }
}

