/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.multibroker;

import com.sun.messaging.jmq.io.GPacket;
import com.sun.messaging.jmq.jmsserver.Broker;
import com.sun.messaging.jmq.jmsserver.BrokerStateHandler;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.Subscription;
import com.sun.messaging.jmq.jmsserver.multibroker.ChangeRecordCallback;
import com.sun.messaging.jmq.jmsserver.multibroker.DestinationUpdateChangeRecord;
import com.sun.messaging.jmq.jmsserver.multibroker.InterestUpdateChangeRecord;
import com.sun.messaging.jmq.jmsserver.multibroker.MessageBusCallback;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ClusterDestInfo;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ClusterSubscriptionInfo;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ProtocolGlobals;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.RaptorProtocol;
import com.sun.messaging.jmq.jmsserver.persist.api.ChangeRecordInfo;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsservice.BrokerEvent;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.UUID;

public class ChangeRecord {
    private static boolean DEBUG = Globals.getConfig().getBooleanProperty("imq.debug.com.sun.messaging.jmq.jmsserver.multibroker.ChangeRecord") || Globals.getLogger().getLevel() <= 4;
    public static final int TYPE_RESET_PERSISTENCE = 31;
    public static final String UUID_PROPERTY = "UUID";
    private GPacket gp;
    private boolean discard = false;
    protected int operation = 31;

    public static ChangeRecord makeChangeRecord(byte[] rec) throws IOException {
        return ChangeRecord.makeChangeRecord(rec, null);
    }

    public static ChangeRecord makeChangeRecord(byte[] rec, String uuid) throws IOException {
        ByteArrayInputStream bis = new ByteArrayInputStream(rec);
        GPacket pkt = GPacket.getInstance();
        pkt.read(bis);
        if (uuid != null) {
            pkt.putProp(UUID_PROPERTY, uuid);
        }
        return ChangeRecord.makeChangeRecord(pkt);
    }

    public static ChangeRecord makeChangeRecord(GPacket pkt) {
        ChangeRecord cr = null;
        if (pkt.getType() == 5 || pkt.getType() == 7) {
            cr = new InterestUpdateChangeRecord(pkt);
        } else if (pkt.getType() == 13 || pkt.getType() == 15) {
            cr = new DestinationUpdateChangeRecord(pkt);
        } else if (pkt.getType() == 31) {
            cr = new ChangeRecord();
        } else {
            throw new RuntimeException("Unexpected change record type in packet " + ProtocolGlobals.getPacketTypeString(pkt.getType()));
        }
        cr.gp = pkt;
        cr.discard = false;
        return cr;
    }

    public byte[] getBytes() throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        this.gp.write(bos);
        bos.flush();
        return bos.toByteArray();
    }

    public String getUniqueKey() {
        return "???";
    }

    public boolean isAddOp() {
        return false;
    }

    public int getOperation() {
        return this.operation;
    }

    public boolean isDuraAdd() {
        return this.getOperation() == 5;
    }

    public boolean isDiscard() {
        return this.discard;
    }

    public void setDiscard(boolean b) {
        this.discard = b;
    }

    public String getUUID() {
        return (String)this.gp.getProp(UUID_PROPERTY);
    }

    public int getPacketType() {
        return this.gp.getType();
    }

    public void transferFlag(ChangeRecordInfo cri) {
    }

    public String toString() {
        return this.getUniqueKey() + ", isAddOp() = " + this.isAddOp();
    }

    public static synchronized void syncChangeRecord(ChangeRecordCallback cb, MessageBusCallback mbcb, RaptorProtocol proto, boolean fromStart) throws BrokerException {
        Long seq = null;
        String resetUUID = null;
        if (fromStart) {
            seq = ChangeRecord.retrieveLastSeq();
            resetUUID = ChangeRecord.retrieveLastResetUUID();
        } else if (cb.getLastSyncedChangeRecord() != null) {
            seq = cb.getLastSyncedChangeRecord().getSeq();
            resetUUID = cb.getLastSyncedChangeRecord().getResetUUID();
        }
        List<ChangeRecordInfo> records = null;
        try {
            records = Globals.getStore().getShareConfigChangeStore().getChangeRecordsSince(seq, resetUUID, fromStart);
        }
        catch (BrokerException e) {
            if (e.getStatusCode() == 412) {
                Globals.getLogger().logStack(32, e.getMessage(), e);
                Broker broker = Broker.getBroker();
                Globals.getBrokerStateHandler();
                broker.exit(BrokerStateHandler.getRestartCode(), e.getMessage(), BrokerEvent.Type.RESTART, null, false, true, false);
            }
            throw e;
        }
        ChangeRecord.processChangeRecords(records, cb, mbcb, proto);
    }

    private static void storeLastSeq(Long seq) {
        try {
            Globals.getStore().updateProperty("ShareConfigRecord.lastSequenceNumber", seq, true);
        }
        catch (Exception e) {
            Globals.getLogger().logStack(16, Globals.getBrokerResources().getKString("B2239", String.valueOf(seq), e.getMessage()), e);
        }
    }

    private static void storeLastResetUUID(String uuid) {
        try {
            Globals.getStore().updateProperty("ShareConfigRecord.lastResetUUID", uuid, true);
        }
        catch (Exception e) {
            Globals.getLogger().logStack(16, Globals.getBrokerResources().getKString("B2240", uuid, e.getMessage()), e);
        }
    }

    private static Long retrieveLastSeq() {
        Long seq = null;
        try {
            seq = (Long)Globals.getStore().getProperty("ShareConfigRecord.lastSequenceNumber");
        }
        catch (Exception e) {
            Logger logger = Globals.getLogger();
            Globals.getLogger();
            logger.log(16, "Unable to retrieve property ShareConfigRecord.lastSequenceNumber");
        }
        return seq;
    }

    private static String retrieveLastResetUUID() {
        String uuid = null;
        try {
            uuid = (String)Globals.getStore().getProperty("ShareConfigRecord.lastResetUUID");
        }
        catch (Exception e) {
            Logger logger = Globals.getLogger();
            Globals.getLogger();
            logger.log(16, "Unable to retrieve property ShareConfigRecord.lastResetUUID");
        }
        return uuid;
    }

    public static synchronized void recordUpdateDestination(Destination d, ChangeRecordCallback cb) throws BrokerException {
        ClusterDestInfo cdi = ClusterDestInfo.newInstance(d);
        GPacket gp = cdi.getGPacket((short)13, true);
        ChangeRecordInfo cri = ChangeRecord.storeChangeRecord(gp, cb);
        d.setCurrentChangeRecordInfo(13, cri);
    }

    public static void recordRemoveDestination(Destination d, ChangeRecordCallback cb) throws BrokerException {
        ClusterDestInfo cdi = ClusterDestInfo.newInstance(d);
        GPacket gp = cdi.getGPacket((short)15, true);
        ChangeRecordInfo cri = ChangeRecord.storeChangeRecord(gp, cb);
        d.setCurrentChangeRecordInfo(13, cri);
    }

    public static void recordCreateSubscription(Subscription sub, ChangeRecordCallback cb) throws BrokerException {
        ClusterSubscriptionInfo csi = ClusterSubscriptionInfo.newInstance(sub);
        GPacket gp = csi.getGPacket((short)5, true);
        ChangeRecordInfo cri = ChangeRecord.storeChangeRecord(gp, cb);
        sub.setCurrentChangeRecordInfo(5, cri);
    }

    public static void recordUnsubscribe(Subscription sub, ChangeRecordCallback cb) throws BrokerException {
        ClusterSubscriptionInfo csi = ClusterSubscriptionInfo.newInstance(sub);
        GPacket gp = csi.getGPacket((short)7, true);
        ChangeRecordInfo cri = ChangeRecord.storeChangeRecord(gp, cb);
        sub.setCurrentChangeRecordInfo(7, cri);
    }

    public static void storeResetRecordIfNecessary(ChangeRecordCallback cb) throws BrokerException {
        GPacket gp = GPacket.getInstance();
        gp.setType((short)31);
        ChangeRecord.storeChangeRecord(gp, cb);
    }

    private static synchronized ChangeRecordInfo storeChangeRecord(GPacket gp, ChangeRecordCallback cb) throws BrokerException {
        String uuid = UUID.randomUUID().toString();
        gp.putProp(UUID_PROPERTY, uuid);
        ChangeRecord cr = ChangeRecord.makeChangeRecord(gp);
        ChangeRecordInfo rec = null;
        try {
            rec = new ChangeRecordInfo(null, uuid, cr.getBytes(), cr.getOperation(), cr.getUniqueKey(), System.currentTimeMillis());
            rec.setDuraAdd(cr.isDuraAdd());
            cr.transferFlag(rec);
        }
        catch (Exception e) {
            throw new BrokerException(e.toString(), e);
        }
        if (gp.getType() == 31) {
            Globals.getStore().getShareConfigChangeStore().storeResetRecord(rec, true, true);
            return null;
        }
        String resetUUID = null;
        if (cb.getLastSyncedChangeRecord() != null) {
            resetUUID = cb.getLastSyncedChangeRecord().getResetUUID();
        }
        if (resetUUID == null && cb.getLastStoredChangeRecord() != null) {
            resetUUID = cb.getLastStoredChangeRecord().getResetUUID();
        }
        rec.setResetUUID(resetUUID);
        rec = Globals.getStore().getShareConfigChangeStore().storeChangeRecord(rec, true);
        cb.setLastStoredChangeRecord(rec);
        return rec;
    }

    private static void processChangeRecords(List<ChangeRecordInfo> records, ChangeRecordCallback cb, MessageBusCallback mbcb, RaptorProtocol proto) throws BrokerException {
        Globals.getLogger().log(8, Globals.getBrokerResources().getKString("B1361", records.size()));
        boolean resetFlag = false;
        if (records.size() > 0 && records.get(0).isSelectAll()) {
            resetFlag = true;
        }
        String resetUUID = null;
        try {
            ArrayList<GPacket> l = new ArrayList<GPacket>();
            for (int i = 0; i < records.size(); ++i) {
                ByteArrayInputStream bis = new ByteArrayInputStream(records.get(i).getRecord());
                DataInputStream dis = new DataInputStream(bis);
                GPacket gp = GPacket.getInstance();
                gp.read(dis);
                if (gp.getType() != records.get(i).getType()) {
                    throw new BrokerException(Globals.getBrokerResources().getKString("B4318", ProtocolGlobals.getPacketTypeString(gp.getType()), records.get(i).toString()));
                }
                if (gp.getType() == 31) {
                    String uuid = records.get(i).getUUID();
                    if (resetUUID != null && !resetUUID.equals(uuid)) {
                        throw new BrokerException(Globals.getBrokerResources().getKString("B4319", ProtocolGlobals.getPacketTypeString(31), "[" + resetUUID + ", " + uuid + "]"));
                    }
                    if (resetUUID == null) {
                        resetUUID = uuid;
                    }
                }
                if (resetFlag) {
                    l.add(gp);
                    continue;
                }
                proto.handleGPacket(mbcb, Globals.getMyAddress(), gp);
            }
            if (resetFlag) {
                proto.applyPersistentStateChanges(Globals.getMyAddress(), l);
            }
            if (records.size() > 0) {
                ChangeRecordInfo rec = records.get(records.size() - 1);
                cb.setLastSyncedChangeRecord(rec);
                ChangeRecord.storeLastSeq(rec.getSeq());
                if (resetFlag && resetUUID != null) {
                    rec.setResetUUID(resetUUID);
                    ChangeRecord.storeLastResetUUID(resetUUID);
                }
            }
        }
        catch (Throwable t) {
            Globals.getLogger().logStack(32, Globals.getBrokerResources().getKString("B3254", t.getMessage()), t);
            if (t instanceof BrokerException) {
                throw (BrokerException)t;
            }
            throw new BrokerException(t.getMessage(), t);
        }
    }

    public static ChangeRecordInfo makeResetRecord(boolean withUUID) {
        if (DEBUG) {
            Globals.getLogger().log(8, "ChangeRecord.makeResetRecord(" + withUUID + ")");
        }
        ChangeRecordInfo cri = new ChangeRecordInfo();
        GPacket gp = GPacket.getInstance();
        gp.setType((short)31);
        if (withUUID) {
            String uuid = UUID.randomUUID().toString();
            gp.putProp(UUID_PROPERTY, uuid);
            cri.setUUID(uuid);
        }
        cri.setTimestamp(System.currentTimeMillis());
        ChangeRecord cr = ChangeRecord.makeChangeRecord(gp);
        cri.setUKey(cr.getUniqueKey());
        try {
            cri.setRecord(cr.getBytes());
        }
        catch (Exception e) {
            Globals.getLogger().log(32, "Unexpected exception in makeResetRecord(" + withUUID + "):" + e.toString());
        }
        return cri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void backupRecords(List<ChangeRecordInfo> records, String fileName, boolean throwEx) throws BrokerException {
        Logger logger = Globals.getLogger();
        if (DEBUG) {
            logger.logToAll(8, "ChangeRecord.backup(" + fileName + ")");
        }
        BrokerResources br = Globals.getBrokerResources();
        int loglevel = throwEx ? 32 : 16;
        FileOutputStream fos = null;
        FilterOutputStream dos = null;
        try {
            File f = new File(fileName);
            if (!f.createNewFile()) {
                String emsg = br.getKString("B2055", fileName);
                logger.logToAll(loglevel, emsg);
                if (throwEx) {
                    throw new BrokerException(emsg);
                }
                return;
            }
            fos = new FileOutputStream(f);
            dos = new DataOutputStream(fos);
            ArrayList<ChangeRecord> recordList = ChangeRecord.compressRecords(records);
            ((DataOutputStream)dos).writeInt(ProtocolGlobals.getCurrentVersion());
            ((DataOutputStream)dos).writeUTF("imq.cluster.masterbroker.backup");
            ChangeRecordInfo cri = ChangeRecord.makeResetRecord(true);
            byte[] rst = cri.getRecord();
            ((DataOutputStream)dos).writeInt(rst.length);
            ((DataOutputStream)dos).write(rst, 0, rst.length);
            if (DEBUG) {
                logger.logToAll(8, "ChangeRecord.backupRecords backup record " + cri);
            }
            ChangeRecord cr = null;
            for (int i = 0; i < recordList.size(); ++i) {
                cr = recordList.get(i);
                if (cr.isDiscard()) continue;
                byte[] rec = cr.getBytes();
                ((DataOutputStream)dos).writeInt(rec.length);
                ((DataOutputStream)dos).write(rec, 0, rec.length);
                if (!DEBUG) continue;
                logger.logToAll(8, "ChangeRecord.backupRecords() backup record " + cr);
            }
            ((DataOutputStream)dos).writeInt(0);
            logger.logToAll(8, "B1346", fileName);
        }
        catch (Exception e) {
            String emsg = br.getKString("B2056", e.getMessage());
            logger.logStack(throwEx ? 32 : 16, emsg, e);
            if (throwEx) {
                throw new BrokerException(emsg);
            }
        }
        finally {
            if (dos != null) {
                try {
                    dos.close();
                }
                catch (Exception exception) {}
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Exception exception) {}
            }
        }
        if (DEBUG) {
            logger.logToAll(8, "ChanageRecord.backup complete");
        }
    }

    public static ArrayList<ChangeRecord> compressRecords(List<ChangeRecordInfo> records) throws Exception {
        ArrayList<ChangeRecord> recordList = new ArrayList<ChangeRecord>();
        LinkedHashMap<String, ChangeRecord> recordMap = new LinkedHashMap<String, ChangeRecord>();
        Logger logger = Globals.getLogger();
        if (DEBUG) {
            logger.logToAll(8, "ChangeRecord.compressRecords: compress " + records.size() + " change records");
        }
        for (int i = 0; i < records.size(); ++i) {
            byte[] rec = records.get(i).getRecord();
            ChangeRecord cr = ChangeRecord.makeChangeRecord(rec, records.get(i).getUUID());
            if (DEBUG) {
                logger.logToAll(8, "ChangeRecord.compressRecords: #" + i + " " + records.get(i) + " " + ProtocolGlobals.getPacketTypeString(cr.getOperation()) + " key=" + cr.getUniqueKey());
            }
            recordList.add(cr);
            ChangeRecord prev = (ChangeRecord)recordMap.get(cr.getUniqueKey());
            if (prev != null) {
                prev.setDiscard(true);
                if (DEBUG) {
                    logger.logToAll(8, ">>>>ChangeRecord.compressRecords: discard previous record " + ProtocolGlobals.getPacketTypeString(prev.getOperation()) + " key=" + cr.getUniqueKey());
                }
            }
            if (!cr.isAddOp()) {
                cr.setDiscard(true);
                if (DEBUG) {
                    logger.logToAll(8, ">>>>ChangeRecord.compressRecords: discard this non-add record ");
                }
            }
            recordMap.put(cr.getUniqueKey(), cr);
        }
        return recordList;
    }

    public static List<ChangeRecordInfo> prepareRestoreRecords(String fileName) throws Exception {
        Logger logger = Globals.getLogger();
        BrokerResources br = Globals.getBrokerResources();
        if (DEBUG) {
            logger.logToAll(8, "ChangeRecord.prepareRestoreRecords from file " + fileName);
        }
        FileInputStream fis = null;
        FilterInputStream dis = null;
        try {
            int recsize;
            File f = new File(fileName);
            if (!f.exists()) {
                String emsg = br.getKString("B2057", fileName);
                logger.log(16, emsg);
                throw new BrokerException(emsg);
            }
            fis = new FileInputStream(f);
            dis = new DataInputStream(fis);
            int curversion = ((DataInputStream)dis).readInt();
            String sig = ((DataInputStream)dis).readUTF();
            if (!sig.equals("imq.cluster.masterbroker.backup")) {
                String emsg = br.getKString("B2058", fileName);
                logger.logToAll(16, emsg);
                throw new BrokerException(emsg);
            }
            if (curversion < 350 || curversion > ProtocolGlobals.getCurrentVersion()) {
                String emsg = br.getKString("B2059", String.valueOf(curversion), String.valueOf(ProtocolGlobals.getCurrentVersion()));
                logger.logToAll(32, emsg);
                throw new BrokerException(emsg);
            }
            ArrayList<ChangeRecordInfo> records = new ArrayList<ChangeRecordInfo>();
            while ((recsize = ((DataInputStream)dis).readInt()) != 0) {
                byte[] rec = new byte[recsize];
                ((DataInputStream)dis).readFully(rec, 0, recsize);
                ChangeRecordInfo cri = new ChangeRecordInfo();
                cri.setRecord(rec);
                ChangeRecord cr = ChangeRecord.makeChangeRecord(rec);
                cri.setType(cr.getPacketType());
                cri.setUKey(cr.getUniqueKey());
                cri.setDuraAdd(cr.isDuraAdd());
                if (Globals.useSharedConfigRecord()) {
                    String uuid = cr.getUUID();
                    if (uuid == null) {
                        uuid = UUID.randomUUID().toString();
                    }
                    cri.setUUID(uuid);
                }
                records.add(cri);
                if (!DEBUG) continue;
                logger.logToAll(8, "ChangeRecord.prepareRestoreRecords restore record " + cri);
            }
            dis.close();
            fis.close();
            logger.logToAll(8, br.getKString("B1372", String.valueOf(records.size()), fileName));
            ArrayList<ChangeRecordInfo> arrayList = records;
            return arrayList;
        }
        catch (Exception e) {
            String emsg = br.getKString("B2060", fileName, e.getMessage());
            logger.logStack(32, emsg, e);
            throw e;
        }
        finally {
            if (dis != null) {
                try {
                    dis.close();
                }
                catch (Exception exception) {}
            }
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

