/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.multibroker.raptor;

import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ClusterConsumerInfo;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Iterator;

public class ProtocolConsumerUIDIterator
implements Iterator {
    private int count = 0;
    private int count_read = 0;
    private DataInputStream dis = null;
    private BrokerAddress from = null;

    public ProtocolConsumerUIDIterator(byte[] payload, int count, BrokerAddress from) {
        ByteArrayInputStream bis = new ByteArrayInputStream(payload);
        this.dis = new DataInputStream(bis);
        this.count = count;
        this.count_read = 0;
        this.from = from;
    }

    public ProtocolConsumerUIDIterator(DataInputStream dis, int count) {
        this.dis = dis;
        this.count = count;
        this.count_read = 0;
    }

    @Override
    public boolean hasNext() {
        if (this.count_read < 0) {
            throw new IllegalStateException("ConsumerUIDIterator");
        }
        return this.count_read < this.count;
    }

    public Object next() throws RuntimeException {
        try {
            ConsumerUID cid = ClusterConsumerInfo.readConsumerUID(this.dis);
            if (this.from != null) {
                cid.setBrokerAddress(this.from);
            }
            ++this.count_read;
            return cid;
        }
        catch (IOException e) {
            this.count_read = -1;
            throw new RuntimeException(e);
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Not supported");
    }
}

