/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.net.http;

import com.sun.messaging.jmq.httptunnel.api.server.HttpTunnelServerDriver;
import com.sun.messaging.jmq.httptunnel.api.server.HttpTunnelServerSocket;
import com.sun.messaging.jmq.httptunnel.api.share.HttpTunnelSocket;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.net.Protocol;
import com.sun.messaging.jmq.jmsserver.net.ProtocolCallback;
import com.sun.messaging.jmq.jmsserver.net.ProtocolStreams;
import com.sun.messaging.jmq.jmsserver.net.http.HTTPStreams;
import java.io.IOException;
import java.net.InetAddress;
import java.nio.channels.spi.AbstractSelectableChannel;
import java.util.Map;

public class HTTPProtocol
implements Protocol {
    protected static final int defaultPullPeriod = -1;
    protected static final int defaultConnectionTimeout = 300;
    protected String servletHost = null;
    protected int servletPort = -1;
    protected int pullPeriod = -1;
    protected int connectionTimeout = 300;
    protected int rxBufSize = Globals.getConfig().getIntProperty("imq.httptunnel.rxBufSize", 0);
    protected ProtocolCallback cb = null;
    protected Object callback_data = null;
    protected int inputBufferSize = 2048;
    protected int outputBufferSize = 2048;
    protected HttpTunnelServerDriver driver = null;
    protected volatile HttpTunnelServerSocket serversocket = null;
    protected String driverClass = "com.sun.messaging.jmq.httptunnel.tunnel.server.HttpTunnelServerDriverImpl";
    protected String serverSocketClass = "com.sun.messaging.jmq.httptunnel.tunnel.server.HttpTunnelServerSocketImpl";

    @Override
    public void registerProtocolCallback(ProtocolCallback cb, Object callback_data) {
        this.cb = cb;
        this.callback_data = callback_data;
    }

    protected void notifyProtocolCallback() {
        if (this.cb != null) {
            this.cb.socketUpdated(this.callback_data, this.getLocalPort(), null);
        }
    }

    @Override
    public String getHostName() {
        return null;
    }

    @Override
    public boolean canPause() {
        return true;
    }

    @Override
    public AbstractSelectableChannel getChannel() throws IOException {
        return null;
    }

    @Override
    public void configureBlocking(boolean blocking) throws UnsupportedOperationException, IOException {
        throw new UnsupportedOperationException("HttpProtocol is not a channel, can not change blocking state");
    }

    protected void createDriver() throws IOException {
        String name = InetAddress.getLocalHost().getHostName() + ":" + Globals.getConfigName();
        if (this.servletHost != null || this.servletPort != -1) {
            int port;
            String host = this.servletHost;
            if (host == null) {
                host = InetAddress.getLocalHost().getHostAddress();
            }
            if ((port = this.servletPort) == -1) {
                port = 7675;
            }
            InetAddress paddr = InetAddress.getLocalHost();
            InetAddress saddr = InetAddress.getByName(host);
            InetAddress laddr = InetAddress.getByName("localhost");
            if (port == Globals.getPortMapper().getPort() && (saddr.equals(paddr) || saddr.equals(laddr))) {
                throw new IOException(Globals.getBrokerResources().getString("B4130"));
            }
            try {
                this.driver = (HttpTunnelServerDriver)Class.forName(this.driverClass).newInstance();
            }
            catch (Exception e) {
                throw new IOException(e.getMessage(), e);
            }
            this.driver.init(name, host, port);
            this.driver.start();
        } else {
            try {
                this.driver = (HttpTunnelServerDriver)Class.forName(this.driverClass).newInstance();
            }
            catch (Exception e) {
                throw new IOException(e.getMessage(), e);
            }
            this.driver.init(name);
            this.driver.start();
        }
        this.driver.setInactiveConnAbortInterval(this.connectionTimeout);
        this.driver.setRxBufSize(this.rxBufSize);
    }

    protected HttpTunnelServerSocket createSocket() throws IOException {
        if (this.driver == null) {
            this.createDriver();
        }
        HttpTunnelServerSocket sock = null;
        try {
            sock = (HttpTunnelServerSocket)Class.forName(this.serverSocketClass).newInstance();
        }
        catch (Exception e) {
            throw new IOException(e.getMessage(), e);
        }
        sock.init(this.driver);
        return sock;
    }

    private HTTPStreams createConnection(HttpTunnelSocket socket) {
        return new HTTPStreams(socket, this.inputBufferSize, this.outputBufferSize);
    }

    @Override
    public ProtocolStreams accept() throws IOException {
        if (this.serversocket == null) {
            throw new IOException(Globals.getBrokerResources().getString("B4117", "Unable to accept on un-opened protocol"));
        }
        HttpTunnelSocket s = this.serversocket.accept();
        s.setPullPeriod(this.pullPeriod);
        s.setConnectionTimeout(this.connectionTimeout);
        HTTPStreams streams = this.createConnection(s);
        return streams;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() throws IOException, IllegalStateException {
        if (this.serversocket != null) {
            throw new IOException(Globals.getBrokerResources().getString("B4117", "can not open already opened protocol"));
        }
        if (this.serversocket == null) {
            HTTPProtocol hTTPProtocol = this;
            synchronized (hTTPProtocol) {
                if (this.serversocket == null) {
                    this.serversocket = this.createSocket();
                }
            }
        }
        this.notifyProtocolCallback();
    }

    @Override
    public boolean isOpen() {
        return this.serversocket != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException, IllegalStateException {
        HTTPProtocol hTTPProtocol = this;
        synchronized (hTTPProtocol) {
            if (this.serversocket == null) {
                throw new IOException(Globals.getBrokerResources().getString("B4117", "can not close un-opened protocol"));
            }
            this.serversocket.close();
            this.serversocket = null;
        }
    }

    @Override
    public int getLocalPort() {
        return 0;
    }

    @Override
    public void checkParameters(Map params) throws IllegalArgumentException {
    }

    @Override
    public Map setParameters(Map params) {
        String newServletHost = this.getStringValue("servletHost", params, null);
        int newServletPort = this.getIntValue("servletPort", params, -1);
        this.pullPeriod = this.getIntValue("pullPeriod", params, this.pullPeriod);
        this.connectionTimeout = this.getIntValue("connectionTimeout", params, this.connectionTimeout);
        if (this.servletHost != null && !this.servletHost.equalsIgnoreCase(newServletHost) || this.servletPort != newServletPort) {
            this.servletHost = newServletHost;
            this.servletPort = newServletPort;
        }
        return null;
    }

    private int getIntValue(String propname, Map params, int defval) {
        String propvalstr = (String)params.get(propname);
        if (propvalstr == null) {
            return defval;
        }
        try {
            int val = Integer.parseInt(propvalstr);
            return val;
        }
        catch (Exception ex) {
            return defval;
        }
    }

    private String getStringValue(String propname, Map params, String defval) {
        String propvalstr = (String)params.get(propname);
        if (propvalstr == null) {
            return defval;
        }
        return propvalstr;
    }

    public String toString() {
        return "http [ " + this.serversocket + "]";
    }

    @Override
    public void setNoDelay(boolean set) {
    }

    @Override
    public void setTimeout(int val) {
    }

    @Override
    public void setInputBufferSize(int val) {
        this.inputBufferSize = val;
    }

    @Override
    public void setOutputBufferSize(int val) {
        this.outputBufferSize = val;
    }

    @Override
    public int getInputBufferSize() {
        return this.inputBufferSize;
    }

    @Override
    public int getOutputBufferSize() {
        return this.outputBufferSize;
    }

    @Override
    public boolean getBlocking() {
        return true;
    }
}

