/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.api.sharecc;

import com.sun.messaging.jmq.jmsserver.BrokerStateHandler;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.config.BrokerConfig;
import com.sun.messaging.jmq.jmsserver.persist.api.ChangeRecordInfo;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import jakarta.inject.Singleton;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Properties;
import org.jvnet.hk2.annotations.Contract;

@Contract
@Singleton
public abstract class ShareConfigChangeStore {
    private static boolean DEBUG = false;
    public static final String CLUSTER_SHARECC_PROP_PREFIX = "imq.cluster.sharecc";
    public static final String STORE_TYPE_PROP = "imq.cluster.sharecc.persist";
    public static final String DEFAULT_STORE_TYPE = "jdbc";
    public static final String CREATE_STORE_PROP = "imq.cluster.sharecc.persistCreate";
    public static final boolean CREATE_STORE_PROP_DEFAULT = false;
    private static final String CLASS_PROP_SUFFIX = ".class";
    private static final String DEFAULT_JDBCSTORE_CLASS = "com.sun.messaging.jmq.jmsserver.persist.jdbc.sharecc.JDBCShareConfigChangeStore";
    private static ShareConfigChangeStore store = null;

    public static boolean getDEBUG() {
        return DEBUG;
    }

    public static synchronized ShareConfigChangeStore getStore() throws BrokerException {
        if (store != null) {
            return store;
        }
        if (BrokerStateHandler.isShuttingDown()) {
            throw new BrokerException(Globals.getBrokerResources().getKString("B4140"), "B4140");
        }
        BrokerConfig config = Globals.getConfig();
        String type = config.getProperty(STORE_TYPE_PROP, DEFAULT_STORE_TYPE);
        if (!type.equalsIgnoreCase(DEFAULT_STORE_TYPE)) {
            throw new BrokerException("Not supportedimq.cluster.sharecc.persist=" + type);
        }
        String classprop = "imq.cluster.sharecc.persist." + type + CLASS_PROP_SUFFIX;
        String classname = config.getProperty(classprop);
        if (classname == null || classname.equals("")) {
            classname = DEFAULT_JDBCSTORE_CLASS;
        } else if (!classname.equals(DEFAULT_JDBCSTORE_CLASS)) {
            throw new BrokerException("Not supported " + classprop + "=" + classname);
        }
        try {
            if (Globals.isNucleusManagedBroker()) {
                store = (ShareConfigChangeStore)Globals.getHabitat().getService(ShareConfigChangeStore.class, classname, new Annotation[0]);
                if (store == null) {
                    throw new BrokerException("Class " + classname + " not found");
                }
            } else {
                store = (ShareConfigChangeStore)Class.forName(classname).newInstance();
            }
        }
        catch (Exception e) {
            throw new BrokerException(Globals.getBrokerResources().getKString("B3252", e.getMessage()), e);
        }
        return store;
    }

    public static synchronized void releaseStore(boolean cleanup) {
        if (store != null) {
            store.close();
        }
        store = null;
    }

    public ChangeRecordInfo storeChangeRecord(ChangeRecordInfo rec, boolean sync) throws BrokerException {
        throw new UnsupportedOperationException("Unsupported operation");
    }

    public void storeResetRecord(ChangeRecordInfo rec, boolean canExist, boolean sync) throws BrokerException {
        throw new UnsupportedOperationException("Unsupported operation");
    }

    public List<ChangeRecordInfo> getChangeRecordsSince(Long seq, String resetUUID, boolean canReset) throws BrokerException {
        throw new UnsupportedOperationException("Unsupported operation");
    }

    public List<ChangeRecordInfo> getAllChangeRecords() throws BrokerException {
        throw new UnsupportedOperationException("Unsupported operation");
    }

    public void clearAllChangeRecords(boolean sync) throws BrokerException {
        throw new UnsupportedOperationException("Unsupported operation");
    }

    public abstract Properties getStoreShareProperties();

    public abstract String getVendorPropertySetting();

    public abstract void close();
}

