/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsclient;

import com.sun.messaging.jmq.jmsclient.XAResourceForJMQ;
import com.sun.messaging.jmq.util.XidImpl;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.transaction.xa.XAException;

public class XAResourceMapForRAMC {
    private static HashMap<XidImpl, Set<XAResourceForJMQ>> resourceMap = new HashMap();

    public static synchronized void register(XidImpl xid, XAResourceForJMQ xar, boolean isJoin) throws XAException {
        Set<XAResourceForJMQ> resources = resourceMap.get(xid);
        if (resources == null) {
            if (isJoin) {
                XAException xae = new XAException("Trying to add an XAResource using the JOIN flag when no existing XAResource has been added with this XID");
                xae.errorCode = -5;
                throw xae;
            }
            resources = new HashSet<XAResourceForJMQ>();
            resourceMap.put(xid, resources);
        } else if (!isJoin) {
            XAException xae = new XAException("Trying to add an XAResource to an existing xid without using the JOIN flag");
            xae.errorCode = -8;
            throw xae;
        }
        resources.add(xar);
    }

    public static synchronized void unregister(XidImpl xid) {
        resourceMap.remove(xid);
    }

    public static synchronized void unregisterResource(XAResourceForJMQ xar, XidImpl xid) {
        Set<XAResourceForJMQ> resources = resourceMap.get(xid);
        if (resources != null) {
            resources.remove(xar);
            if (resources.size() == 0) {
                resourceMap.remove(xid);
            }
        }
    }

    public static synchronized XAResourceForJMQ[] getXAResources(XidImpl xid, boolean throwExceptionIfNotFound) throws XAException {
        Set<XAResourceForJMQ> resources = resourceMap.get(xid);
        if (resources == null) {
            if (throwExceptionIfNotFound) {
                XAException xae = new XAException("Unknown XID (was start() called?");
                throw xae;
            }
            return new XAResourceForJMQ[0];
        }
        return resources.toArray(new XAResourceForJMQ[resources.size()]);
    }

    public static boolean isEmpty() {
        return resourceMap.isEmpty();
    }
}

