/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.bridge.service.stomp;

import com.sun.messaging.bridge.api.BridgeContext;
import com.sun.messaging.bridge.api.LogSimpleFormatter;
import com.sun.messaging.bridge.api.MessageTransformer;
import com.sun.messaging.bridge.service.stomp.StompMessageDispatchFilter;
import com.sun.messaging.bridge.service.stomp.StompMessageFilter;
import com.sun.messaging.bridge.service.stomp.resources.StompBridgeResources;
import com.sun.messaging.portunif.PUService;
import com.sun.messaging.portunif.StompProtocolFinder;
import jakarta.jms.Message;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URL;
import java.util.Locale;
import java.util.Properties;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.filterchain.FilterChain;
import org.glassfish.grizzly.filterchain.FilterChainBuilder;
import org.glassfish.grizzly.filterchain.TransportFilter;
import org.glassfish.grizzly.nio.transport.TCPNIOTransport;
import org.glassfish.grizzly.nio.transport.TCPNIOTransportBuilder;
import org.glassfish.grizzly.portunif.PUProtocol;
import org.glassfish.grizzly.ssl.SSLContextConfigurator;
import org.glassfish.grizzly.ssl.SSLEngineConfigurator;
import org.glassfish.grizzly.ssl.SSLFilter;

public class StompServer {
    private static final String PROP_HOSTNAME_SUFFIX = ".hostname";
    private static final String PROP_TCPENABLED_SUFFIX = ".tcp.enabled";
    private static final String PROP_SSLENABLED_SUFFIX = ".tls.enabled";
    private static final String PROP_TCPPORT_SUFFIX = ".tcp.port";
    private static final String PROP_SSLPORT_SUFFIX = ".tls.port";
    private static final String PROP_SSL_REQUIRE_CLIENTAUTH_SUFFIX = ".tls.requireClientAuth";
    private static final String PROP_FLOWLIMIT_SUFFIX = ".consumerFlowLimit";
    private static final String PROP_MSGTRANSFORM_SUFFIX = ".messageTransformer";
    private static final String PROP_LOGFILE_LIMIT_SUFFIX = ".logfile.limit";
    private static final String PROP_LOGFILE_COUNT_SUFFIX = ".logfile.count";
    public static final int DEFAULT_TCPPORT = 7672;
    public static final int DEFAULT_SSLPORT = 7673;
    private static volatile StompBridgeResources _sbr = StompServer.getStompBridgeResources();
    private Logger _logger = null;
    private int TCPPORT = 7672;
    private int SSLPORT = 7673;
    private InetAddress HOST = null;
    private String TCPHOSTNAMEPORT = null;
    private String SSLHOSTNAMEPORT = null;
    private MessageTransformer<Message, Message> _msgTransformer = null;
    private BridgeContext _bc = null;
    private Properties jmsprop = null;
    private boolean _tcpEnabled = false;
    private boolean _sslEnabled = false;
    private boolean _inited = false;
    private TCPNIOTransport _tcpTransport = null;
    private TCPNIOTransport _sslTransport = null;
    private PUProtocol _tcppup = null;
    private PUProtocol _sslpup = null;

    public synchronized void init(BridgeContext bc) throws Exception {
        String p;
        String counts;
        String var;
        File dir;
        String domain;
        this._bc = bc;
        Properties props = bc.getConfig();
        String cn = props.getProperty((domain = props.getProperty("BRIDGE_PROP_PREFIX")) + PROP_MSGTRANSFORM_SUFFIX);
        if (cn != null) {
            this._msgTransformer = (MessageTransformer)Class.forName(cn).newInstance();
        }
        this.jmsprop = new Properties();
        String flowlimit = props.getProperty(domain + PROP_FLOWLIMIT_SUFFIX);
        if (flowlimit != null) {
            this.jmsprop.setProperty("imqConsumerFlowLimit", String.valueOf(Integer.parseInt(flowlimit)));
        }
        this._logger = Logger.getLogger(domain);
        if (bc.isSilentMode()) {
            this._logger.setUseParentHandlers(false);
        }
        if (!(dir = new File(var = bc.getRootDir())).exists() && !dir.mkdirs()) {
            throw new IOException("File.mkdirs(" + var + ")");
        }
        String logfile = var + File.separator + "stomp%g.log";
        int limit = 0;
        int count = 1;
        String limits = props.getProperty(domain + PROP_LOGFILE_LIMIT_SUFFIX);
        if (limits != null) {
            limit = Integer.parseInt(limits);
        }
        if ((counts = props.getProperty(domain + PROP_LOGFILE_COUNT_SUFFIX)) != null) {
            count = Integer.parseInt(counts);
        }
        FileHandler h = new FileHandler(logfile, limit, count, true);
        h.setFormatter(new LogSimpleFormatter(this._logger));
        this._logger.addHandler(h);
        this._logger.log(Level.INFO, StompServer.getStompBridgeResources().getString("BSS1010", domain));
        this._logger.log(Level.INFO, StompServer.getStompBridgeResources().getString("BSS1011", logfile) + "[" + limit + "," + count + "]");
        String v = props.getProperty(domain + PROP_TCPENABLED_SUFFIX, "true");
        if (v != null && Boolean.valueOf(v).booleanValue()) {
            p = props.getProperty(domain + PROP_TCPPORT_SUFFIX, String.valueOf(7672));
            this.TCPPORT = Integer.parseInt(p);
            this._tcpEnabled = true;
        }
        if ((v = props.getProperty(domain + PROP_SSLENABLED_SUFFIX, "false")) != null && Boolean.valueOf(v).booleanValue()) {
            p = props.getProperty(domain + PROP_SSLPORT_SUFFIX, String.valueOf(7673));
            this.SSLPORT = Integer.parseInt(p);
            this._sslEnabled = true;
        }
        if (!this._tcpEnabled && !this._sslEnabled) {
            throw new IllegalArgumentException(StompServer.getStompBridgeResources().getKString("BSS4024"));
        }
        v = props.getProperty(domain + PROP_HOSTNAME_SUFFIX);
        if (v == null || v.length() == 0) {
            v = bc.getBrokerHostName();
        }
        String hn = null;
        if (v != null && v.length() > 0) {
            hn = v;
            this.HOST = InetAddress.getByName(v);
        } else {
            hn = InetAddress.getLocalHost().getCanonicalHostName();
        }
        URL u = new URL("http", hn, this.TCPPORT, "");
        this.TCPHOSTNAMEPORT = u.getHost() + ":" + this.TCPPORT;
        u = new URL("http", hn, this.SSLPORT, "");
        this.SSLHOSTNAMEPORT = u.getHost() + ":" + this.SSLPORT;
        int major = Grizzly.getMajorVersion();
        if (major < 2) {
            Object[] params = new String[]{String.valueOf(major), Grizzly.getDotedVersion(), String.valueOf(1)};
            String emsg = StompServer.getStompBridgeResources().getKString("BSS4036", params);
            this._logger.log(Level.SEVERE, emsg);
            throw new UnsupportedOperationException(emsg);
        }
        this._logger.log(Level.INFO, StompServer.getStompBridgeResources().getString("BSS1024", Grizzly.getDotedVersion()));
        PUService pu = null;
        if (this._bc.doBind() && (this._tcpEnabled || this._sslEnabled)) {
            pu = (PUService)bc.getPUService();
            if (pu == null) {
                if (this._tcpEnabled) {
                    FilterChainBuilder filterChainBuilder = FilterChainBuilder.stateless();
                    filterChainBuilder.add(new TransportFilter());
                    filterChainBuilder.add(new StompMessageFilter(this));
                    filterChainBuilder.add(new StompMessageDispatchFilter(this));
                    this._tcpTransport = TCPNIOTransportBuilder.newInstance().build();
                    this._tcpTransport.setProcessor(filterChainBuilder.build());
                    InetSocketAddress saddr = this.HOST == null ? new InetSocketAddress(this.TCPPORT) : new InetSocketAddress(this.HOST, this.TCPPORT);
                    this._tcpTransport.bind(saddr);
                }
                if (this._sslEnabled) {
                    SSLEngineConfigurator serverConfig = StompServer.initializeSSL(this._bc, domain, props, this._logger);
                    SSLEngineConfigurator clientConfig = serverConfig.copy().setClientMode(true);
                    FilterChainBuilder filterChainBuilder = FilterChainBuilder.stateless();
                    filterChainBuilder.add(new TransportFilter());
                    filterChainBuilder.add(new SSLFilter(serverConfig, clientConfig));
                    filterChainBuilder.add(new StompMessageFilter(this));
                    filterChainBuilder.add(new StompMessageDispatchFilter(this));
                    this._sslTransport = TCPNIOTransportBuilder.newInstance().build();
                    this._sslTransport.setProcessor(filterChainBuilder.build());
                    InetSocketAddress saddr = this.HOST == null ? new InetSocketAddress(this.SSLPORT) : new InetSocketAddress(this.HOST, this.SSLPORT);
                    this._sslTransport.bind(saddr);
                }
            } else {
                if (this._tcpEnabled) {
                    FilterChain puProtocolFilterChain = pu.getPUFilterChainBuilder().add(new StompMessageFilter(this)).add(new StompMessageDispatchFilter(this)).build();
                    StompProtocolFinder pf = new StompProtocolFinder();
                    this._tcppup = new PUProtocol(pf, puProtocolFilterChain);
                }
                if (this._sslEnabled) {
                    Properties sslprops = bc.getDefaultSSLContextConfig();
                    boolean reqcauth = false;
                    v = props.getProperty(domain + PROP_SSL_REQUIRE_CLIENTAUTH_SUFFIX, "false");
                    if (v != null && Boolean.valueOf(v).booleanValue()) {
                        reqcauth = true;
                    }
                    if (!pu.initializeSSL(sslprops, reqcauth, null, this._bc.getPoodleFixEnabled(), this._bc.getKnownSSLEnabledProtocols()) && pu.getSSLClientAuthRequired() != reqcauth) {
                        this._logger.log(Level.WARNING, StompServer.getStompBridgeResources().getString("BSS2016", domain + ".tls.requireClientAuth=" + reqcauth, domain + ".tls.requireClientAuth=" + pu.getSSLClientAuthRequired()));
                    }
                    FilterChain puProtocolFilterChain = pu.getSSLPUFilterChainBuilder().add(new StompMessageFilter(this)).add(new StompMessageDispatchFilter(this)).build();
                    StompProtocolFinder pf = new StompProtocolFinder();
                    this._sslpup = new PUProtocol(pf, puProtocolFilterChain);
                }
            }
        }
        if (this._bc.doBind() && this._tcpEnabled && pu == null) {
            this._bc.registerService("stomp[TCP]", "stomp", this.TCPPORT, null);
        }
        if (this._bc.doBind() && this._sslEnabled && pu == null) {
            this._bc.registerService("stomp[SSL/TLS]", "stomp", this.SSLPORT, null);
        }
        this._inited = true;
    }

    BridgeContext getBridgeContext() {
        return this._bc;
    }

    Properties getJMSConfig() {
        return this.jmsprop;
    }

    private static SSLEngineConfigurator initializeSSL(BridgeContext bc, String domain, Properties props, Logger logger) throws Exception {
        logger.log(Level.INFO, StompServer.getStompBridgeResources().getString("BSS1012"));
        Properties sslprops = bc.getDefaultSSLContextConfig();
        SSLContextConfigurator sslcf = new SSLContextConfigurator();
        sslcf.setKeyManagerFactoryAlgorithm(sslprops.getProperty("ssl.KeyManagerFactory.algorithm"));
        sslcf.setKeyStoreFile(sslprops.getProperty("javax.net.ssl.keyStore"));
        sslcf.setKeyStorePass(sslprops.getProperty("javax.net.ssl.trustStorePassword"));
        sslcf.setKeyStoreType(sslprops.getProperty("javax.net.ssl.keyStoreType"));
        sslcf.setTrustManagerFactoryAlgorithm(sslprops.getProperty("ssl.TrustManagerFactory.algorithm"));
        sslcf.setTrustStoreFile(sslprops.getProperty("javax.net.ssl.trustStore"));
        sslcf.setTrustStorePass(sslprops.getProperty("javax.net.ssl.trustStorePassword"));
        sslcf.setTrustStoreType(sslprops.getProperty("javax.net.ssl.trustStoreType"));
        sslcf.setSecurityProtocol(sslprops.getProperty("securesocket.protocol"));
        boolean reqcauth = false;
        String v = props.getProperty(domain + PROP_SSL_REQUIRE_CLIENTAUTH_SUFFIX, "false");
        if (v != null && Boolean.valueOf(v).booleanValue()) {
            reqcauth = true;
        }
        SSLEngineConfigurator ec = new SSLEngineConfigurator(sslcf.createSSLContext(false), false, reqcauth, reqcauth);
        if (bc.getPoodleFixEnabled()) {
            PUService.applyPoodleFix(ec, bc.getKnownSSLEnabledProtocols(), "StompServer");
        }
        return ec;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void start() throws Exception {
        if (!this._inited || this._bc.doBind() && this._bc.getPUService() == null && this._tcpTransport == null && this._sslTransport == null || this._bc.doBind() && this._bc.getPUService() != null && this._tcppup == null && this._sslpup == null) {
            String emsg = StompServer.getStompBridgeResources().getKString("BSS4025");
            this._logger.log(Level.SEVERE, emsg);
            throw new IllegalStateException(emsg);
        }
        if (!this._bc.doBind()) {
            return;
        }
        PUService pu = (PUService)this._bc.getPUService();
        if (pu != null) {
            try {
                if (this._tcpEnabled) {
                    pu.register(this._tcppup, null);
                    this._logger.log(Level.INFO, StompServer.getStompBridgeResources().getString("BSS1013", "TCP", pu.getBindSocketAddress()));
                }
                if (!this._sslEnabled) return;
                pu.registerSSL(this._sslpup, null);
                this._logger.log(Level.INFO, StompServer.getStompBridgeResources().getString("BSS1013", "SSL/TLS", pu.getBindSocketAddress()));
                return;
            }
            catch (Exception e) {
                this._logger.log(Level.SEVERE, e.getMessage(), e);
                try {
                    this.stop();
                    throw e;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw e;
            }
        }
        try {
            if (this._tcpEnabled) {
                this._tcpTransport.start();
                this._logger.log(Level.INFO, StompServer.getStompBridgeResources().getString("BSS1013", "TCP", this.TCPHOSTNAMEPORT));
            }
            if (!this._sslEnabled) return;
            this._sslTransport.start();
            this._logger.log(Level.INFO, StompServer.getStompBridgeResources().getString("BSS1013", "SSL/TLS", this.SSLHOSTNAMEPORT));
            return;
        }
        catch (Exception e) {
            this._logger.log(Level.SEVERE, e.getMessage(), e);
            try {
                this.stop();
                throw e;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw e;
        }
    }

    public synchronized void stop() throws Exception {
        if (!this._inited || this._bc.doBind() && this._bc.getPUService() == null && this._tcpTransport == null && this._sslTransport == null || this._bc.doBind() && this._bc.getPUService() != null && this._tcppup == null && this._sslpup == null) {
            String emsg = StompServer.getStompBridgeResources().getKString("BSS4025");
            this._logger.log(Level.SEVERE, emsg);
            throw new IllegalStateException(emsg);
        }
        if (!this._bc.doBind()) {
            return;
        }
        this._logger.log(Level.INFO, StompServer.getStompBridgeResources().getString("BSS1015"));
        PUService pu = (PUService)this._bc.getPUService();
        if (pu != null) {
            Exception e;
            block18: {
                e = null;
                if (this._tcpEnabled) {
                    try {
                        pu.deregister(this._tcppup);
                    }
                    catch (Exception ee) {
                        e = ee;
                    }
                }
                if (this._sslEnabled) {
                    try {
                        pu.deregisterSSL(this._sslpup);
                    }
                    catch (Exception ee) {
                        if (e != null) break block18;
                        e = ee;
                    }
                }
            }
            if (e != null) {
                this._logger.log(Level.SEVERE, e.getMessage(), e);
                throw e;
            }
        } else {
            Exception e;
            block19: {
                e = null;
                if (this._tcpEnabled) {
                    try {
                        this._tcpTransport.shutdownNow();
                    }
                    catch (Exception ee) {
                        e = ee;
                    }
                }
                if (this._sslEnabled) {
                    try {
                        this._sslTransport.shutdownNow();
                    }
                    catch (Exception ee) {
                        if (e != null) break block19;
                        e = ee;
                    }
                }
            }
            if (e != null) {
                this._logger.log(Level.SEVERE, e.getMessage(), e);
                throw e;
            }
        }
        this._logger.log(Level.INFO, StompServer.getStompBridgeResources().getString("BSS1016"));
    }

    protected Logger getLogger() {
        return this._logger;
    }

    protected MessageTransformer<Message, Message> getMessageTransformer() {
        return this._msgTransformer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static StompBridgeResources getStompBridgeResources() {
        if (_sbr != null) return _sbr;
        Class<StompServer> clazz = StompServer.class;
        synchronized (StompServer.class) {
            if (_sbr != null) return _sbr;
            _sbr = StompBridgeResources.getResources(Locale.getDefault());
            // ** MonitorExit[var0] (shouldn't be in output)
            return _sbr;
        }
    }
}

