/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.osgiweb;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.osgijavaeebase.JarHelper;
import org.glassfish.osgiweb.WARManifestProcessor;
import org.osgi.service.url.AbstractURLStreamHandlerService;

public class WebBundleURLStreamHandlerService
extends AbstractURLStreamHandlerService {
    private static final Logger logger = Logger.getLogger(WebBundleURLStreamHandlerService.class.getPackage().getName());
    private static String[] supportedQueryParamNames = new String[]{"Bundle-SymbolicName", "Bundle-Version", "Bundle-ManifestVersion", "Import-Package", "Export-Package", "Web-ContextPath", "Web-JSPExtractLocation"};

    public URLConnection openConnection(URL u) throws IOException {
        assert ("webbundle".equals(u.getProtocol()));
        try {
            URI embeddedURI = new URI(u.toURI().getSchemeSpecificPart());
            final URL embeddedURL = embeddedURI.toURL();
            final URLConnection con = embeddedURL.openConnection();
            return new URLConnection(embeddedURL){
                private Manifest m;

                public void connect() throws IOException {
                    con.connect();
                }

                public InputStream getInputStream() throws IOException {
                    this.connect();
                    this.m = WARManifestProcessor.processManifest(embeddedURL);
                    final PipedOutputStream pos = new PipedOutputStream();
                    PipedInputStream pis = new PipedInputStream(pos);
                    new Thread(){

                        public void run() {
                            JarHelper.write((URLConnection)con, (OutputStream)pos, (Manifest)m);
                        }
                    }.start();
                    return pis;
                }
            };
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    protected void setURL(URL u, String proto, String host, int port, String auth, String user, String path, String query, String ref) {
        logger.logp(Level.INFO, "WebBundleURLStreamHandlerService", "setURL() called with", "u = [{0}], proto = [{1}], host = [{2}], port = [{3}], auth = [{4}], user = [{5}], path = [{6}], query = [{7}], ref = [{7}]", new Object[]{u, proto, host, port, auth, user, path, query, ref});
        if (query != null) {
            int sep = query.indexOf("?");
            if (sep != -1) {
                String query2;
                String query1 = query.substring(0, sep);
                String string = query2 = query.length() > sep + 1 ? query.substring(sep + 1) : null;
                if (query2 != null) {
                    path = path.concat("?").concat(query1);
                    query = query2;
                }
            } else {
                String firstQueryParam;
                int eq = query.indexOf("=");
                String string = firstQueryParam = eq != -1 ? query.substring(0, eq) : query;
                if (!Arrays.asList(supportedQueryParamNames).contains(firstQueryParam)) {
                    path = path.concat("?").concat(query);
                    query = null;
                }
            }
            logger.logp(Level.INFO, "WebBundleURLStreamHandlerService", "setURL ", "new path = [{0}], new query = [{1}]", new Object[]{path, query});
        }
        super.setURL(u, proto, host, port, auth, user, path, query, ref);
    }
}

