/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.pfl.dynamic.codegen.impl;

import java.io.PrintStream;
import java.lang.reflect.Modifier;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import org.glassfish.pfl.dynamic.codegen.impl.AssignmentStatement;
import org.glassfish.pfl.dynamic.codegen.impl.Attribute;
import org.glassfish.pfl.dynamic.codegen.impl.BlockStatement;
import org.glassfish.pfl.dynamic.codegen.impl.BreakStatement;
import org.glassfish.pfl.dynamic.codegen.impl.CaseBranch;
import org.glassfish.pfl.dynamic.codegen.impl.ClassGeneratorImpl;
import org.glassfish.pfl.dynamic.codegen.impl.CodegenPrinter;
import org.glassfish.pfl.dynamic.codegen.impl.DefinitionStatement;
import org.glassfish.pfl.dynamic.codegen.impl.ExpressionInternal;
import org.glassfish.pfl.dynamic.codegen.impl.FieldGenerator;
import org.glassfish.pfl.dynamic.codegen.impl.IfStatement;
import org.glassfish.pfl.dynamic.codegen.impl.MethodGenerator;
import org.glassfish.pfl.dynamic.codegen.impl.Node;
import org.glassfish.pfl.dynamic.codegen.impl.ReturnStatement;
import org.glassfish.pfl.dynamic.codegen.impl.Statement;
import org.glassfish.pfl.dynamic.codegen.impl.SwitchStatement;
import org.glassfish.pfl.dynamic.codegen.impl.ThrowStatement;
import org.glassfish.pfl.dynamic.codegen.impl.TreeWalker;
import org.glassfish.pfl.dynamic.codegen.impl.TreeWalkerContext;
import org.glassfish.pfl.dynamic.codegen.impl.TryStatement;
import org.glassfish.pfl.dynamic.codegen.impl.VariableInternal;
import org.glassfish.pfl.dynamic.codegen.impl.WhileStatement;
import org.glassfish.pfl.dynamic.codegen.spi.Type;
import org.glassfish.pfl.dynamic.codegen.spi.Variable;

public final class Util {
    private Util() {
    }

    public static void close(Node node) {
        TreeWalkerContext context = new TreeWalkerContext();
        TreeWalker visitor = new TreeWalker(context){

            @Override
            public void blockStatementBeforeBodyStatement(BlockStatement arg, Statement stmt) {
                if (stmt instanceof DefinitionStatement) {
                    DefinitionStatement ds = (DefinitionStatement)DefinitionStatement.class.cast(stmt);
                    ((VariableInternal)ds.var()).close();
                }
            }

            @Override
            public void visitMethodGenerator(MethodGenerator arg) {
                for (Variable var : arg.arguments()) {
                    ((VariableInternal)var).close();
                }
            }

            @Override
            public void tryStatementBeforeBlock(TryStatement arg, Type type, Variable var, BlockStatement block) {
                ((VariableInternal)var).close();
            }
        };
        context.push(visitor);
        node.accept(visitor);
    }

    public static void checkScope(ExpressionInternal expr) {
        TreeWalkerContext context = new TreeWalkerContext();
        TreeWalker visitor = new TreeWalker(context){

            @Override
            public boolean preVariable(Variable arg) {
                if (!((VariableInternal)arg).isAvailable()) {
                    throw new IllegalStateException(arg + " is no longer in scope");
                }
                return false;
            }
        };
        context.push(visitor);
        expr.accept(visitor);
    }

    public static void checkTree(Node node, PrintStream pw) {
        TreeWalkerContext context = new TreeWalkerContext();
        final IdentityHashMap map = new IdentityHashMap();
        TreeWalker visitor = new TreeWalker(context){

            @Override
            public boolean preNode(Node arg) {
                Integer val = (Integer)map.get(arg);
                if (val == null) {
                    val = 1;
                } else {
                    Integer n = val;
                    Integer n2 = val = Integer.valueOf(val + 1);
                }
                map.put(arg, val);
                return false;
            }
        };
        context.push(visitor);
        node.accept(visitor);
        for (Map.Entry entry : map.entrySet()) {
            if ((Integer)entry.getValue() <= 1) continue;
            pw.print("Node " + entry.getKey() + " appeared " + entry.getValue() + " times in the AST");
        }
    }

    private static void displayAttributes(Node node, CodegenPrinter pr) {
        Set<Attribute<?>> attrs = Attribute.getAttributes(node);
        for (Attribute<?> attr : attrs) {
            String typeName = attr.type().getName();
            int lastIndex = typeName.lastIndexOf(46);
            if (lastIndex >= 0) {
                typeName = typeName.substring(lastIndex + 1);
            }
            Object obj = attr.get(node);
            String value = attr.get(node).toString();
            pr.nl().p("|__:").p(attr.name()).p(":").p(typeName).p("=").p(value);
            if (!(obj instanceof Node)) continue;
            pr.in();
            Util.displayAttributes((Node)Node.class.cast(obj), pr);
            pr.out();
        }
    }

    public static String getNodeIdString(Node obj) {
        return "@" + obj.id();
    }

    public static void display(Node node, final PrintStream pw) {
        TreeWalkerContext context = new TreeWalkerContext();
        TreeWalker visitor = new TreeWalker(context){
            final CodegenPrinter pr;
            {
                super(x0);
                this.pr = new CodegenPrinter(pw, 2, '.');
            }

            private boolean done(Node node) {
                Util.displayAttributes(node, this.pr);
                this.pr.in();
                return true;
            }

            @Override
            public boolean preNode(Node arg) {
                this.pr.nl().p("Node").p(Util.getNodeIdString(arg)).p("[").p(arg.toString()).p("]");
                return this.done(arg);
            }

            @Override
            public void postNode(Node arg) {
                this.pr.out();
            }

            @Override
            public boolean preClassGenerator(ClassGeneratorImpl arg) {
                this.pr.nl().p("ClassGenerator").p(Util.getNodeIdString(arg)).p("[").p(Modifier.toString(arg.modifiers())).p(" ").p(arg.isInterface() ? "interface" : "class").p(" ").p(arg.name()).p("]");
                return this.done(arg);
            }

            @Override
            public boolean preMethodGenerator(MethodGenerator arg) {
                this.pr.nl().p("MethodGenerator").p(Util.getNodeIdString(arg)).p("[").p(Modifier.toString(arg.modifiers())).p(" ").p(arg.returnType().name()).p(" ").p(arg.name()).p("]");
                return this.done(arg);
            }

            @Override
            public boolean preThrowStatement(ThrowStatement arg) {
                this.pr.nl().p("ThrowStatement").p(Util.getNodeIdString(arg));
                return this.done(arg);
            }

            @Override
            public boolean preAssignmentStatement(AssignmentStatement arg) {
                this.pr.nl().p("AssignmentStatement").p(Util.getNodeIdString(arg));
                return this.done(arg);
            }

            @Override
            public boolean preBlockStatement(BlockStatement arg) {
                this.pr.nl().p("BlockStatement").p(Util.getNodeIdString(arg));
                return this.done(arg);
            }

            @Override
            public boolean preCaseBranch(CaseBranch arg) {
                this.pr.nl().p("CaseBranch").p(Util.getNodeIdString(arg)).p("[").p(Integer.toString(arg.label())).p("]");
                return this.done(arg);
            }

            @Override
            public boolean preDefinitionStatement(DefinitionStatement arg) {
                this.pr.nl().p("DefinitionStatement").p(Util.getNodeIdString(arg));
                return this.done(arg);
            }

            @Override
            public boolean preIfStatement(IfStatement arg) {
                this.pr.nl().p("IfStatement").p(Util.getNodeIdString(arg));
                return this.done(arg);
            }

            @Override
            public void ifStatementBeforeTruePart(IfStatement arg) {
                this.pr.out().nl().p("IfStatement:true").in();
            }

            @Override
            public boolean ifStatementBeforeFalsePart(IfStatement arg) {
                this.pr.out().nl().p("IfStatement:false").in();
                return true;
            }

            @Override
            public boolean preBreakStatement(BreakStatement arg) {
                this.pr.nl().p("BreakStatement").p(Util.getNodeIdString(arg));
                return this.done(arg);
            }

            @Override
            public boolean preReturnStatement(ReturnStatement arg) {
                this.pr.nl().p("ReturnStatement").p(Util.getNodeIdString(arg));
                return this.done(arg);
            }

            @Override
            public boolean preSwitchStatement(SwitchStatement arg) {
                this.pr.nl().p("SwitchStatement").p(Util.getNodeIdString(arg));
                return this.done(arg);
            }

            @Override
            public boolean preTryStatement(TryStatement arg) {
                this.pr.nl().p("TryStatement").p(Util.getNodeIdString(arg));
                return this.done(arg);
            }

            @Override
            public void tryStatementBeforeBlock(TryStatement arg, Type type, Variable var, BlockStatement block) {
                VariableInternal ivar = (VariableInternal)var;
                this.pr.out().nl().p("TryStatement:catch[").p("type=").p(type.name()).p(",var=").p(ivar.ident()).p("]").in();
                ivar.accept(this);
            }

            @Override
            public boolean tryStatementBeforeFinalPart(TryStatement arg) {
                this.pr.out().nl().p("TryStatement:finally").in();
                return true;
            }

            @Override
            public boolean preWhileStatement(WhileStatement arg) {
                this.pr.nl().p("WhileStatement").p(Util.getNodeIdString(arg));
                return this.done(arg);
            }

            @Override
            public boolean preExpression(ExpressionInternal arg) {
                this.pr.nl().p(arg.toString());
                return this.done(arg);
            }

            @Override
            public boolean preFieldGenerator(FieldGenerator arg) {
                this.pr.nl().p(arg.toString());
                return this.done(arg);
            }
        };
        context.push(visitor);
        node.accept(visitor);
    }
}

