/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.pfl.test;

import java.io.File;
import java.io.FileOutputStream;
import org.glassfish.pfl.basic.contain.Pair;
import org.glassfish.pfl.test.JUnitReportWriter;
import org.glassfish.pfl.test.XMLJUnitReportWriter;

public class JUnitReportHelper {
    private final boolean DEBUG = Boolean.valueOf(System.getProperty("corba.test.junit.helper.debug"));
    private JUnitReportWriter writer;
    private String className;
    private String fileName;
    private JUnitReportWriter.TestDescription current = null;
    private boolean testComplete = false;
    private Counts counts = null;

    private void msg(String str) {
        if (this.DEBUG) {
            System.out.println("JUnitReportHelper: " + str);
        }
    }

    public JUnitReportHelper(String cname) {
        String processName = System.getProperty("corba.test.process.name");
        this.className = cname;
        this.fileName = processName != null ? cname + "." + processName : cname;
        this.msg("<init>: className = " + this.className + " fileName = " + this.fileName);
        String outdirName = System.getProperty("junit.report.dir");
        if (outdirName == null) {
            throw new RuntimeException("property junit.report.dir is not set");
        }
        File outdir = new File(outdirName);
        if (!outdir.exists()) {
            throw new RuntimeException(outdir + " does not exist");
        }
        if (!outdir.isDirectory()) {
            throw new RuntimeException(outdir + " is not a directory");
        }
        FileOutputStream os = null;
        try {
            File file = new File(outdir, this.fileName + ".xml");
            os = new FileOutputStream(file);
        }
        catch (Exception exc) {
            throw new RuntimeException(exc);
        }
        this.writer = new XMLJUnitReportWriter();
        this.writer.setOutput(os);
        this.writer.startTestSuite(this.fileName, System.getProperties());
    }

    private void checkCurrent() {
        if (this.current == null) {
            throw new RuntimeException("No current test set!");
        }
        if (this.testComplete) {
            System.out.println("Test " + (Object)((Object)this.current) + " has already been completed");
        }
        this.testComplete = true;
    }

    public void start(String name) {
        this.msg("Starting test " + name);
        if (this.current != null && !this.testComplete) {
            throw new RuntimeException("Trying to start test named " + name + " before current test " + (Object)((Object)this.current) + " has completed!");
        }
        this.testComplete = false;
        this.current = new JUnitReportWriter.TestDescription(name, this.className);
        this.writer.startTest(this.current);
    }

    public void pass() {
        this.msg("Test " + (Object)((Object)this.current) + " passed");
        this.checkCurrent();
        this.writer.endTest(this.current);
    }

    public void fail(String msg) {
        this.fail((Throwable)((Object)new AssertionError((Object)msg)));
    }

    public void fail(Throwable thr) {
        this.msg("Test " + (Object)((Object)this.current) + " failed with exception " + thr);
        this.checkCurrent();
        if (thr instanceof AssertionError) {
            this.writer.addFailure(this.current, thr);
        } else {
            this.writer.addError(this.current, thr);
        }
        this.writer.endTest(this.current);
    }

    public void pass(long duration) {
        this.msg("Test " + (Object)((Object)this.current) + " passed");
        this.checkCurrent();
        this.writer.endTest(this.current, duration);
    }

    public void fail(String msg, long duration) {
        this.fail((Throwable)((Object)new AssertionError((Object)msg)), duration);
    }

    public void fail(Throwable thr, long duration) {
        this.msg("Test " + (Object)((Object)this.current) + " failed with exception " + thr);
        this.checkCurrent();
        if (thr instanceof AssertionError) {
            this.writer.addFailure(this.current, thr);
        } else {
            this.writer.addError(this.current, thr);
        }
        this.writer.endTest(this.current, duration);
    }

    public Counts done() {
        boolean error;
        this.msg("Done called");
        boolean bl = error = this.current != null && !this.testComplete;
        if (error) {
            this.fail("Test suite terminating without terminating test " + (Object)((Object)this.current));
        }
        if (this.counts == null) {
            JUnitReportWriter.TestCounts tc = this.writer.endTestSuite();
            this.counts = new Counts(tc.pass(), tc.fail() + tc.error());
        }
        if (error) {
            throw new RuntimeException("Trying to terminate test suite before current test " + (Object)((Object)this.current) + " has completed!");
        }
        return this.counts;
    }

    public static class Counts
    extends Pair<Integer, Integer> {
        Counts(int numPass, int numFail) {
            super((Object)numPass, (Object)numFail);
        }

        public int numPass() {
            return (Integer)this.first();
        }

        public int numFail() {
            return (Integer)this.second();
        }
    }
}

