/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.cms.impl.common;

import com.sun.enterprise.ee.cms.core.DistributedStateCache;
import com.sun.enterprise.ee.cms.core.GMSMember;
import com.sun.enterprise.ee.cms.core.GroupLeadershipNotificationSignal;
import com.sun.enterprise.ee.cms.core.SignalAcquireException;
import com.sun.enterprise.ee.cms.core.SignalReleaseException;
import com.sun.enterprise.ee.cms.impl.common.GMSContext;
import com.sun.enterprise.ee.cms.impl.common.GMSContextFactory;
import com.sun.enterprise.ee.cms.logging.GMSLogDomain;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupLeadershipNotificationSignalImpl
implements GroupLeadershipNotificationSignal {
    protected static final Logger logger = GMSLogDomain.getLogger("ShoalLogger");
    private static final String MEMBER_DETAILS = "MEMBERDETAILS";
    private static GMSContext ctx;
    private final String memberToken;
    private final String groupName;
    private final long startTime;
    private final List<GMSMember> previousView;
    private final List<GMSMember> currentView;
    private final List<String> currentCoreMembers;
    private final List<String> allCurrentMembers;

    public GroupLeadershipNotificationSignalImpl(String memberToken, List<GMSMember> previousView, List<GMSMember> currentView, List<String> currentCoreMembers, List<String> allCurrentMembers, String groupName, long startTime) {
        this.memberToken = memberToken;
        this.previousView = previousView;
        this.currentView = currentView;
        this.currentCoreMembers = currentCoreMembers;
        this.allCurrentMembers = allCurrentMembers;
        this.groupName = groupName;
        this.startTime = startTime;
        ctx = GMSContextFactory.getGMSContext(groupName);
    }

    GroupLeadershipNotificationSignalImpl(GroupLeadershipNotificationSignal signal) {
        this(signal.getMemberToken(), signal.getPreviousView(), signal.getCurrentView(), signal.getCurrentCoreMembers(), signal.getAllCurrentMembers(), signal.getGroupName(), signal.getStartTime());
    }

    @Override
    public void acquire() throws SignalAcquireException {
    }

    @Override
    public void release() throws SignalReleaseException {
        if (this.previousView != null) {
            this.previousView.clear();
        }
        if (this.currentView != null) {
            this.currentView.clear();
        }
        if (this.currentCoreMembers != null) {
            this.currentCoreMembers.clear();
        }
        if (this.allCurrentMembers != null) {
            this.allCurrentMembers.clear();
        }
    }

    @Override
    public String getMemberToken() {
        return this.memberToken;
    }

    @Override
    public Map<Serializable, Serializable> getMemberDetails() {
        DistributedStateCache dsc;
        HashMap<Serializable, Serializable> ret = new HashMap();
        if (ctx == null) {
            ctx = GMSContextFactory.getGMSContext(this.groupName);
        }
        if ((dsc = ctx.getDistributedStateCache()) != null) {
            ret = dsc.getFromCacheForPattern(MEMBER_DETAILS, this.memberToken);
        } else {
            logger.log(Level.WARNING, "no.instance.dsc", new Object[]{this.memberToken});
        }
        return ret;
    }

    @Override
    public String getGroupName() {
        return this.groupName;
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }

    @Override
    public List<GMSMember> getPreviousView() {
        return this.previousView;
    }

    @Override
    public List<GMSMember> getCurrentView() {
        return this.currentView;
    }

    @Override
    public List<String> getCurrentCoreMembers() {
        return this.currentCoreMembers;
    }

    @Override
    public List<String> getAllCurrentMembers() {
        return this.allCurrentMembers;
    }
}

