/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.cms.impl.common;

import com.sun.enterprise.ee.cms.core.FailureNotificationSignal;
import com.sun.enterprise.ee.cms.core.FailureRecoverySignal;
import com.sun.enterprise.ee.cms.core.FailureSuspectedSignal;
import com.sun.enterprise.ee.cms.core.GroupLeadershipNotificationSignal;
import com.sun.enterprise.ee.cms.core.JoinNotificationSignal;
import com.sun.enterprise.ee.cms.core.JoinedAndReadyNotificationSignal;
import com.sun.enterprise.ee.cms.core.MessageSignal;
import com.sun.enterprise.ee.cms.core.PlannedShutdownSignal;
import com.sun.enterprise.ee.cms.core.Signal;
import com.sun.enterprise.ee.cms.impl.common.Router;
import com.sun.enterprise.ee.cms.impl.common.SignalPacket;
import com.sun.enterprise.ee.cms.logging.GMSLogDomain;
import java.util.concurrent.BlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SignalHandler
implements Runnable {
    private final BlockingQueue<SignalPacket> signalQueue;
    private final Router router;
    private Logger logger = GMSLogDomain.getLogger("ShoalLogger");
    private volatile boolean interrupted = false;

    public SignalHandler(BlockingQueue<SignalPacket> packetQueue, Router router) {
        this.signalQueue = packetQueue;
        this.router = router;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block10: {
            block7: while (true) {
                try {
                    while (!this.interrupted) {
                        try {
                            SignalPacket signalPacket = this.signalQueue.take();
                            if (signalPacket == null) continue block7;
                            Signal[] signals = signalPacket.getSignals();
                            if (signals != null) {
                                this.handleSignals(signals);
                                continue block7;
                            }
                            this.handleSignal(signalPacket.getSignal());
                            continue block7;
                        }
                        catch (InterruptedException e) {
                            this.logger.log(Level.FINEST, e.getLocalizedMessage());
                            this.interrupted = true;
                        }
                    }
                    break block10;
                }
                catch (Throwable e) {
                    this.logger.log(Level.SEVERE, "unhandled exception in thread " + Thread.currentThread().getName(), e);
                    break block10;
                }
            }
            finally {
                this.logger.log(Level.INFO, "SignalHandler task named " + Thread.currentThread().getName() + " exiting");
            }
        }
    }

    private void handleSignal(Signal signal) {
        this.analyzeSignal(signal);
    }

    private void handleSignals(Signal[] signals) {
        for (Signal signal : signals) {
            this.analyzeSignal(signal);
        }
    }

    private void analyzeSignal(Signal signal) {
        if (signal == null) {
            throw new IllegalArgumentException("Signal is null. Cannot analyze.");
        }
        this.logger.log(Level.FINEST, "SignalHandler : processing a received signal " + signal.getClass().getName());
        if (signal instanceof FailureRecoverySignal) {
            this.router.notifyFailureRecoveryAction((FailureRecoverySignal)signal);
        } else if (signal instanceof FailureNotificationSignal) {
            this.router.notifyFailureNotificationAction((FailureNotificationSignal)signal);
        } else if (signal instanceof MessageSignal) {
            this.router.notifyMessageAction((MessageSignal)signal);
        } else if (signal instanceof JoinNotificationSignal) {
            this.router.notifyJoinNotificationAction((JoinNotificationSignal)signal);
        } else if (signal instanceof PlannedShutdownSignal) {
            this.router.notifyPlannedShutdownAction((PlannedShutdownSignal)signal);
        } else if (signal instanceof FailureSuspectedSignal) {
            this.router.notifyFailureSuspectedAction((FailureSuspectedSignal)signal);
        } else if (signal instanceof JoinedAndReadyNotificationSignal) {
            this.router.notifyJoinedAndReadyNotificationAction((JoinedAndReadyNotificationSignal)signal);
        } else if (signal instanceof GroupLeadershipNotificationSignal) {
            this.router.notifyGroupLeadershipNotificationAction((GroupLeadershipNotificationSignal)signal);
        }
    }
}

