/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.cms.impl.jxta;

import com.sun.enterprise.ee.cms.core.DistributedStateCache;
import com.sun.enterprise.ee.cms.core.GMSConstants;
import com.sun.enterprise.ee.cms.core.GMSException;
import com.sun.enterprise.ee.cms.core.GroupHandle;
import com.sun.enterprise.ee.cms.core.GroupManagementService;
import com.sun.enterprise.ee.cms.impl.common.GMSContextBase;
import com.sun.enterprise.ee.cms.impl.common.ShutdownHelper;
import com.sun.enterprise.ee.cms.impl.jxta.CustomTagNames;
import com.sun.enterprise.ee.cms.impl.jxta.DistributedStateCacheImpl;
import com.sun.enterprise.ee.cms.impl.jxta.EventPacket;
import com.sun.enterprise.ee.cms.impl.jxta.GroupCommunicationProviderImpl;
import com.sun.enterprise.ee.cms.impl.jxta.GroupHandleImpl;
import com.sun.enterprise.ee.cms.impl.jxta.MessagePacket;
import com.sun.enterprise.ee.cms.impl.jxta.MessageWindow;
import com.sun.enterprise.ee.cms.impl.jxta.ViewWindow;
import com.sun.enterprise.ee.cms.spi.GMSMessage;
import com.sun.enterprise.ee.cms.spi.GroupCommunicationProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GMSContext
extends GMSContextBase {
    private ArrayBlockingQueue<EventPacket> viewQueue;
    private static final int MAX_VIEWS_IN_QUEUE = 200;
    private ArrayBlockingQueue<MessagePacket> messageQueue;
    private static final int MAX_MSGS_IN_QUEUE = 500;
    private ViewWindow viewWindow;
    private GroupCommunicationProvider groupCommunicationProvider;
    private DistributedStateCache distributedStateCache;
    private GroupHandle gh;
    private Properties configProperties;
    private boolean isGroupShutdown = false;
    private boolean isGroupStartup = false;
    private Thread viewWindowThread = null;
    private Thread messageWindowThread = null;

    public GMSContext(String serverToken, String groupName, GroupManagementService.MemberType memberType, Properties configProperties) {
        super(serverToken, groupName, memberType);
        this.configProperties = configProperties;
        this.groupCommunicationProvider = new GroupCommunicationProviderImpl(groupName);
        if (this.isWatchdog()) {
            this.viewQueue = null;
            this.viewWindow = null;
        } else {
            this.viewQueue = new ArrayBlockingQueue(200, Boolean.TRUE);
            this.viewWindow = new ViewWindow(groupName, this.viewQueue);
        }
        this.messageQueue = new ArrayBlockingQueue(500, Boolean.TRUE);
        this.gh = new GroupHandleImpl(groupName, serverToken);
        this.createDistributedStateCache();
        logger.log(Level.FINE, "gms.init");
    }

    @Override
    protected void createDistributedStateCache() {
        this.distributedStateCache = this.isWatchdog() ? null : DistributedStateCacheImpl.getInstance(this.groupName);
    }

    @Override
    public GroupHandle getGroupHandle() {
        return this.gh;
    }

    @Override
    public DistributedStateCache getDistributedStateCache() {
        if (this.distributedStateCache == null && !this.isWatchdog()) {
            this.createDistributedStateCache();
        }
        return this.distributedStateCache;
    }

    @Override
    public void join() throws GMSException {
        this.viewWindowThread = this.isWatchdog() ? null : new Thread((Runnable)this.viewWindow, "ViewWindowThread:" + this.groupName);
        MessageWindow messageWindow = new MessageWindow(this.groupName, this.messageQueue);
        this.messageWindowThread = new Thread((Runnable)messageWindow, "MessageWindowThread:" + this.groupName);
        this.messageWindowThread.start();
        if (this.viewWindowThread != null) {
            this.viewWindowThread.start();
        }
        HashMap<String, String> idMap = new HashMap<String, String>();
        idMap.put(CustomTagNames.MEMBER_TYPE.toString(), this.memberType);
        idMap.put(CustomTagNames.GROUP_NAME.toString(), this.groupName);
        idMap.put(CustomTagNames.START_TIME.toString(), this.startTime.toString());
        this.groupCommunicationProvider.initializeGroupCommunicationProvider(this.serverToken, this.groupName, idMap, this.configProperties);
        this.groupCommunicationProvider.join();
    }

    @Override
    public void leave(GMSConstants.shutdownType shutdownType2) {
        if (this.shutdownHelper.isGroupBeingShutdown(this.groupName)) {
            logger.log(Level.INFO, "shutdown.groupshutdown", new Object[]{this.groupName});
            this.groupCommunicationProvider.leave(true);
            this.isGroupShutdown = true;
            this.shutdownHelper.removeFromGroupShutdownList(this.groupName);
        } else {
            logger.log(Level.INFO, "shutdown.instanceshutdown", new Object[]{this.groupName});
            this.groupCommunicationProvider.leave(false);
        }
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }

    @Override
    public void announceGroupShutdown(String groupName, GMSConstants.shutdownState shutdownState2) {
        if (!this.getGroupCommunicationProvider().isGroupLeader()) {
            logger.log(Level.INFO, "Assuming group leadership to shutdown group: " + groupName);
            this.assumeGroupLeadership();
        }
        this.groupCommunicationProvider.announceClusterShutdown(new GMSMessage(GMSConstants.shutdownType.GROUP_SHUTDOWN.toString(), null, groupName, null));
    }

    @Override
    public void announceGroupStartup(String groupName, GMSConstants.groupStartupState startupState, List<String> memberTokens) {
        this.groupCommunicationProvider.announceGroupStartup(groupName, startupState, memberTokens);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addToSuspectList(String token) {
        boolean retval = false;
        ArrayList arrayList = this.suspectList;
        synchronized (arrayList) {
            if (!this.suspectList.contains(token)) {
                this.suspectList.add(token);
                retval = true;
            }
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeFromSuspectList(String token) {
        ArrayList arrayList = this.suspectList;
        synchronized (arrayList) {
            if (this.suspectList.contains(token)) {
                this.suspectList.remove(token);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isSuspected(String token) {
        boolean retval = false;
        ArrayList arrayList = this.suspectList;
        synchronized (arrayList) {
            if (this.suspectList.contains(token)) {
                retval = true;
            }
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getSuspectList() {
        ArrayList<String> retval;
        ArrayList arrayList = this.suspectList;
        synchronized (arrayList) {
            retval = new ArrayList<String>(this.suspectList);
        }
        return retval;
    }

    @Override
    public ShutdownHelper getShutdownHelper() {
        return this.shutdownHelper;
    }

    ArrayBlockingQueue<EventPacket> getViewQueue() {
        return this.viewQueue;
    }

    ArrayBlockingQueue<MessagePacket> getMessageQueue() {
        return this.messageQueue;
    }

    @Override
    public GroupCommunicationProvider getGroupCommunicationProvider() {
        return this.groupCommunicationProvider;
    }

    public ViewWindow getViewWindow() {
        return this.viewWindow;
    }

    @Override
    public void assumeGroupLeadership() {
        this.groupCommunicationProvider.assumeGroupLeadership();
    }

    @Override
    public boolean isGroupBeingShutdown(String groupName) {
        return this.isGroupShutdown || this.getShutdownHelper().isGroupBeingShutdown(groupName);
    }

    @Override
    public boolean isGroupStartup() {
        return this.isGroupStartup;
    }

    @Override
    public void setGroupStartup(boolean value) {
        this.isGroupStartup = value;
    }

    @Override
    public boolean isWatchdog() {
        return this.getMemberType() == GroupManagementService.MemberType.WATCHDOG;
    }
}

