/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.cms.tests;

import com.sun.enterprise.ee.cms.core.CallBack;
import com.sun.enterprise.ee.cms.core.GMSConstants;
import com.sun.enterprise.ee.cms.core.GMSException;
import com.sun.enterprise.ee.cms.core.GMSFactory;
import com.sun.enterprise.ee.cms.core.GroupHandle;
import com.sun.enterprise.ee.cms.core.GroupManagementService;
import com.sun.enterprise.ee.cms.core.JoinedAndReadyNotificationSignal;
import com.sun.enterprise.ee.cms.core.ServiceProviderConfigurationKeys;
import com.sun.enterprise.ee.cms.core.Signal;
import com.sun.enterprise.ee.cms.impl.client.JoinNotificationActionFactoryImpl;
import com.sun.enterprise.ee.cms.impl.client.JoinedAndReadyNotificationActionFactoryImpl;
import com.sun.enterprise.ee.cms.impl.common.GroupManagementServiceImpl;
import com.sun.enterprise.ee.cms.logging.GMSLogDomain;
import com.sun.enterprise.ee.cms.spi.MemberStates;
import com.sun.enterprise.ee.cms.tests.GMSClientService;
import com.sun.enterprise.jxtamgmt.JxtaUtil;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ApplicationServer
implements Runnable,
CallBack {
    private static final Logger logger = GMSLogDomain.getLogger("ShoalLogger");
    public GroupManagementService gms = null;
    private GMSClientService gcs1;
    private GMSClientService gcs2;
    private String serverName;
    private String groupName;
    private final GroupManagementService.MemberType memberType;
    private volatile boolean stopped = false;

    public ApplicationServer(String serverName, String groupName, GroupManagementService.MemberType memberType, Properties props) {
        this.serverName = serverName;
        this.groupName = groupName;
        this.memberType = memberType;
        GMSFactory.setGMSEnabledState(groupName, Boolean.TRUE);
        this.gms = (GroupManagementService)((Object)GMSFactory.startGMSModule(serverName, groupName, memberType, props));
        this.initClientServices(Boolean.valueOf(System.getProperty("MESSAGING_MODE", "true")));
    }

    private void initClientServices(boolean sendMessages) {
        this.gcs1 = new GMSClientService("EJBContainer", this.serverName, sendMessages);
        this.gcs2 = new GMSClientService("TransactionService", this.serverName, false);
    }

    public void run() {
        this.startGMS();
        this.addMemberDetails();
        this.startClientServices();
        logger.log(Level.FINE, "reporting joined and ready state...");
        this.gms.reportJoinedAndReadyState(this.groupName);
        try {
            Thread.sleep(Long.parseLong(System.getProperty("LIFEINMILLIS", "15000")));
        }
        catch (InterruptedException e) {
            logger.log(Level.SEVERE, e.getLocalizedMessage());
        }
        this.stopClientServices();
        this.stopGMS();
        System.exit(0);
    }

    private void addMemberDetails() {
        Hashtable details = new Hashtable();
        ArrayList ar1 = new ArrayList();
        ArrayList<String> ar2 = new ArrayList<String>();
        int port = 3700;
        int port1 = 3800;
        try {
            ar2.add(InetAddress.getLocalHost() + ":" + 3700);
            ar2.add(InetAddress.getLocalHost() + ":" + 3800);
        }
        catch (UnknownHostException e) {
            logger.log(Level.WARNING, e.getLocalizedMessage());
        }
        ar1.add(ar2);
        details.put("IIOPListenerEndPoints", ar1);
        try {
            ((GroupManagementServiceImpl)this.gms).setMemberDetails(this.serverName, details);
        }
        catch (GMSException e) {
            logger.log(Level.WARNING, e.getLocalizedMessage());
        }
    }

    public void startClientServices() {
        logger.log(Level.FINE, "ApplicationServer: Starting GMSClient");
        this.gcs1.start();
        this.gcs2.start();
    }

    public void startGMS() {
        logger.log(Level.FINE, "ApplicationServer: Starting GMS service");
        try {
            this.gms.addActionFactory(new JoinedAndReadyNotificationActionFactoryImpl(this));
            this.gms.addActionFactory(new JoinNotificationActionFactoryImpl(this));
            this.gms.join();
        }
        catch (GMSException e) {
            logger.log(Level.SEVERE, e.getLocalizedMessage());
        }
    }

    public void stopGMS() {
        logger.log(Level.FINE, "ApplicationServer: Stopping GMS service");
        this.gms.shutdown(GMSConstants.shutdownType.INSTANCE_SHUTDOWN);
    }

    private void stopClientServices() {
        logger.log(Level.FINE, "ApplicationServer: Stopping GMSClient");
        this.gcs1.stopClient();
        this.gcs2.stopClient();
        this.stopped = true;
    }

    public void sendMessage(String message) {
        GroupHandle gh = this.gms.getGroupHandle();
        try {
            gh.sendMessage(null, message.getBytes());
        }
        catch (GMSException e) {
            logger.log(Level.INFO, e.getLocalizedMessage());
        }
    }

    public void processNotification(Signal notification) {
        logger.fine("received a notification " + notification.getClass().getName());
        logger.info("processing notification " + notification.getClass().getName() + " for group " + notification.getGroupName() + " memberName=" + notification.getMemberToken());
        if (notification instanceof JoinedAndReadyNotificationSignal) {
            MemberStates state = this.gms.getGroupHandle().getMemberState(notification.getMemberToken());
            if (state != MemberStates.READY && state != MemberStates.ALIVEANDREADY) {
                logger.warning("incorrect memberstate inside of JoinedAndReadyNotification signal processing  expected: READY or ALIVEANDREADY, actual value: " + (Object)((Object)state));
            } else {
                logger.info("getMemberState(" + notification.getMemberToken() + ")=" + (Object)((Object)state));
            }
        }
    }

    public static void main(String[] args) {
        CLB clb = null;
        if (args.length > 0 && "--usage".equals(args[1])) {
            logger.log(Level.INFO, new StringBuffer().append("USAGE: java -DMEMBERTYPE <CORE|SPECTATOR|WATCHDOG>").append(" -DINSTANCEID=<instanceid>").append(" -DCLUSTERNAME=<clustername").append(" -DLIFEINMILLIS= <length of time for this demo").append(" -DMESSAGING_MODE=[true|false] ApplicationServer").append(" -DGETMEMBERSTATE=[true]").append(" -DGETMEMBERSTATE_THRESHOLD=[xxxx] ms").append(" -DGETMEMBERSTATE_TIMEOUT=[xxx] ms").append(" -DKILLINSTANCE=<anotherinstanceid>").toString());
        }
        JxtaUtil.setLogger(logger);
        JxtaUtil.setupLogHandler();
        String MEMBERTYPE_STRING = System.getProperty("MEMBERTYPE", "CORE").toUpperCase();
        GroupManagementService.MemberType memberType = GroupManagementService.MemberType.valueOf(MEMBERTYPE_STRING);
        Properties configProps = new Properties();
        configProps.put(ServiceProviderConfigurationKeys.MULTICASTADDRESS.toString(), System.getProperty("MULTICASTADDRESS", "229.9.1.1"));
        configProps.put(ServiceProviderConfigurationKeys.MULTICASTPORT.toString(), (Object)2299);
        logger.fine("Is initial host=" + System.getProperty("IS_INITIAL_HOST"));
        configProps.put(ServiceProviderConfigurationKeys.IS_BOOTSTRAPPING_NODE.toString(), System.getProperty("IS_INITIAL_HOST", "false"));
        if (System.getProperty("INITIAL_HOST_LIST") != null) {
            configProps.put(ServiceProviderConfigurationKeys.VIRTUAL_MULTICAST_URI_LIST.toString(), System.getProperty("INITIAL_HOST_LIST"));
        }
        configProps.put(ServiceProviderConfigurationKeys.FAILURE_DETECTION_RETRIES.toString(), "2");
        String bindInterfaceAddress = System.getProperty("BIND_INTERFACE_ADDRESS");
        if (bindInterfaceAddress != null) {
            configProps.put(ServiceProviderConfigurationKeys.BIND_INTERFACE_ADDRESS.toString(), bindInterfaceAddress);
        }
        ApplicationServer applicationServer = new ApplicationServer(System.getProperty("INSTANCEID"), System.getProperty("CLUSTERNAME"), memberType, configProps);
        if ("true".equals(System.getProperty("GETMEMBERSTATE"))) {
            boolean getMemberState = true;
            String threshold = System.getProperty("GETMEMBERSTATE_THRESHOLD", "3000");
            long getMemberStateThreshold = Long.parseLong(threshold);
            long getMemberStateTimeout = Long.parseLong(System.getProperty("GETMEMBERSTATE_TIMEOUT", "3000"));
            logger.fine("getMemberState=true threshold=" + getMemberStateThreshold + " timeout=" + getMemberStateTimeout);
            ApplicationServer applicationServer2 = applicationServer;
            applicationServer2.getClass();
            clb = applicationServer2.new CLB(getMemberState, getMemberStateThreshold, getMemberStateTimeout);
        }
        Thread appServThread = new Thread((Runnable)applicationServer, "ApplicationServer");
        appServThread.start();
        try {
            if (clb != null && !applicationServer.isWatchdog()) {
                Thread clbThread = new Thread(clb, "CLB");
                clbThread.start();
            }
            if (applicationServer.isWatchdog()) {
                try {
                    Thread.sleep(15000L);
                    String TOBEKILLED_MEMBER = "instance10";
                    GroupHandle gh = applicationServer.gms.getGroupHandle();
                    Runtime.getRuntime().exec("./killmember.sh instance10");
                    logger.info("killed member instance10");
                    gh.announceWatchdogObservedFailure("instance10");
                    logger.info("Killed instance10 and WATCHDOG notify group " + gh.toString() + " that instance10 has failed.");
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Unexpected exception while starting server instance for WATCHDOG to kill and report failed", e);
                }
            }
            appServThread.join();
        }
        catch (InterruptedException e) {
            logger.log(Level.SEVERE, e.getLocalizedMessage());
        }
    }

    boolean isWatchdog() {
        return this.memberType == GroupManagementService.MemberType.WATCHDOG;
    }

    public class CLB
    implements Runnable {
        boolean getMemberState;
        long threshold;
        long timeout;

        public CLB(boolean getMemberState, long threshold, long timeout) {
            this.getMemberState = getMemberState;
            this.threshold = threshold;
            this.timeout = timeout;
        }

        private void getAllMemberStates() {
            long startTime = System.currentTimeMillis();
            List<String> members = ApplicationServer.this.gms.getGroupHandle().getCurrentCoreMembers();
            logger.info("Enter getAllMemberStates currentMembers=" + members.size() + " threshold(ms)=" + this.threshold + " timeout(ms)=" + this.timeout);
            for (String member : members) {
                MemberStates state = ApplicationServer.this.gms.getGroupHandle().getMemberState(member, this.threshold, this.timeout);
                logger.info("getMemberState member=" + member + " state=" + (Object)((Object)state) + " threshold=" + this.threshold + " timeout=" + this.timeout);
            }
            logger.info("exit getAllMemberStates()  elapsed time=" + (System.currentTimeMillis() - startTime) + " ms " + "currentMembers#=" + members.size());
        }

        public void run() {
            while (this.getMemberState && !ApplicationServer.this.stopped) {
                this.getAllMemberStates();
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

