/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.cms.tests;

import com.sun.enterprise.ee.cms.core.CallBack;
import com.sun.enterprise.ee.cms.core.FailureNotificationSignal;
import com.sun.enterprise.ee.cms.core.FailureRecoverySignal;
import com.sun.enterprise.ee.cms.core.FailureSuspectedSignal;
import com.sun.enterprise.ee.cms.core.GMSException;
import com.sun.enterprise.ee.cms.core.GMSFactory;
import com.sun.enterprise.ee.cms.core.GroupHandle;
import com.sun.enterprise.ee.cms.core.GroupManagementService;
import com.sun.enterprise.ee.cms.core.JoinNotificationSignal;
import com.sun.enterprise.ee.cms.core.JoinedAndReadyNotificationSignal;
import com.sun.enterprise.ee.cms.core.PlannedShutdownSignal;
import com.sun.enterprise.ee.cms.core.Signal;
import com.sun.enterprise.ee.cms.core.SignalAcquireException;
import com.sun.enterprise.ee.cms.core.SignalReleaseException;
import com.sun.enterprise.ee.cms.impl.client.FailureNotificationActionFactoryImpl;
import com.sun.enterprise.ee.cms.impl.client.FailureRecoveryActionFactoryImpl;
import com.sun.enterprise.ee.cms.impl.client.JoinNotificationActionFactoryImpl;
import com.sun.enterprise.ee.cms.impl.client.JoinedAndReadyNotificationActionFactoryImpl;
import com.sun.enterprise.ee.cms.impl.client.MessageActionFactoryImpl;
import com.sun.enterprise.ee.cms.impl.client.PlannedShutdownActionFactoryImpl;
import com.sun.enterprise.ee.cms.logging.GMSLogDomain;
import java.io.Serializable;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GMSClientService
implements Runnable,
CallBack {
    private GroupManagementService gms;
    private Logger logger = GMSLogDomain.getLogger("ShoalLogger");
    private Thread flag;
    private String memberToken;
    private boolean sendMessages;
    private String serviceName;
    private static final int MILLIS = 4000;
    public static final String IIOP_MEMBER_DETAILS_KEY = "IIOPListenerEndPoints";

    public GMSClientService(String serviceName, String memberToken, boolean sendMessages) {
        this.sendMessages = sendMessages;
        this.serviceName = serviceName;
        this.memberToken = memberToken;
        try {
            this.gms = GMSFactory.getGMSModule();
        }
        catch (GMSException e) {
            this.logger.log(Level.WARNING, e.getLocalizedMessage());
        }
        this.gms.addActionFactory(new PlannedShutdownActionFactoryImpl(this));
        this.gms.addActionFactory(new JoinNotificationActionFactoryImpl(this));
        this.gms.addActionFactory(new FailureNotificationActionFactoryImpl(this));
        this.gms.addActionFactory(serviceName, new FailureRecoveryActionFactoryImpl(this));
        this.gms.addActionFactory(new MessageActionFactoryImpl(this), serviceName);
        this.gms.addActionFactory(new JoinedAndReadyNotificationActionFactoryImpl(this));
    }

    public void start() {
        this.flag = new Thread((Runnable)this, "GMSClient:" + this.serviceName);
        this.flag.start();
    }

    public void run() {
        GroupHandle gh = this.gms.getGroupHandle();
        while (gh.isFenced(this.serviceName, this.memberToken)) {
            try {
                this.logger.log(Level.FINEST, "Waiting for fence to be lowered");
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                this.logger.log(Level.WARNING, "Thread interrupted:" + e.getLocalizedMessage());
            }
        }
        this.logger.log(Level.INFO, this.serviceName + ":" + this.memberToken + ": is not fenced now, starting GMSclient:" + this.serviceName);
        this.logger.log(Level.INFO, "DUMPING:" + this.gms.getAllMemberDetails((Serializable)((Object)IIOP_MEMBER_DETAILS_KEY)));
    }

    public synchronized void processNotification(Signal notification) {
        this.logger.log(Level.FINEST, new StringBuffer().append(this.serviceName).append(": Notification Received from:").append(notification.getMemberToken()).append(":[").append(notification.toString()).append("] has been processed").toString());
        if (notification instanceof FailureRecoverySignal) {
            try {
                notification.acquire();
                this.extractMemberDetails(notification, notification.getMemberToken());
                Thread.sleep(4000L);
                notification.release();
            }
            catch (SignalAcquireException e) {
                this.logger.log(Level.WARNING, e.getLocalizedMessage());
            }
            catch (SignalReleaseException e) {
                this.logger.log(Level.INFO, e.getLocalizedMessage());
            }
            catch (InterruptedException e) {
                this.logger.log(Level.INFO, e.getLocalizedMessage());
            }
        } else if (notification instanceof JoinNotificationSignal) {
            String serverToken = notification.getMemberToken();
            this.logger.info("Received JoinNotificationSignal for member " + serverToken + " with state set to " + ((JoinNotificationSignal)notification).getMemberState().toString());
            this.extractMemberDetails(notification, serverToken);
        } else if (notification instanceof JoinedAndReadyNotificationSignal || notification instanceof FailureNotificationSignal || notification instanceof PlannedShutdownSignal || notification instanceof FailureSuspectedSignal) {
            String serverToken = notification.getMemberToken();
            this.logger.info("Received " + notification.toString() + " for member " + serverToken);
            this.extractMemberDetails(notification, serverToken);
        }
    }

    private void extractMemberDetails(Signal notification, String serverToken) {
        this.logger.log(Level.FINEST, this.serviceName + ":Now getting member details...");
        Map<Serializable, Serializable> memberDetails = notification.getMemberDetails();
        if (memberDetails.size() == 0) {
            this.logger.log(Level.FINEST, "No Details available");
        } else {
            this.logger.log(Level.FINEST, memberDetails.toString());
            for (Serializable key : memberDetails.keySet()) {
                this.logger.log(Level.FINEST, new StringBuffer().append("Got Member Details for ").append(serverToken).toString());
                this.logger.log(Level.FINEST, new StringBuffer().append("Key:").append(key).append(":Value:").append(memberDetails.get(key).toString()).toString());
            }
        }
    }

    public void stopClient() {
        this.flag = null;
    }
}

