/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.cms.tests.checkgroupshutdown;

import com.sun.enterprise.ee.cms.core.CallBack;
import com.sun.enterprise.ee.cms.core.GMSConstants;
import com.sun.enterprise.ee.cms.core.GMSException;
import com.sun.enterprise.ee.cms.core.GMSFactory;
import com.sun.enterprise.ee.cms.core.GroupManagementService;
import com.sun.enterprise.ee.cms.core.Signal;
import com.sun.enterprise.ee.cms.impl.client.FailureNotificationActionFactoryImpl;
import com.sun.enterprise.ee.cms.impl.client.FailureSuspectedActionFactoryImpl;
import com.sun.enterprise.ee.cms.impl.client.JoinNotificationActionFactoryImpl;
import com.sun.enterprise.ee.cms.impl.client.JoinedAndReadyNotificationActionFactoryImpl;
import com.sun.enterprise.ee.cms.impl.client.PlannedShutdownActionFactoryImpl;
import com.sun.enterprise.ee.cms.impl.common.GMSContextFactory;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CheckIfGroupShuttingDownTest
implements CallBack {
    static final Logger logger = Logger.getLogger("CheckIfGroupShuttingDownTest");
    final Object waitLock = new Object();
    final String group = "Group";

    public static void main(String[] args) {
        CheckIfGroupShuttingDownTest check = new CheckIfGroupShuttingDownTest();
        String serverName = System.getProperty("TYPE");
        try {
            check.runSimpleSample(serverName);
        }
        catch (GMSException e) {
            logger.log(Level.SEVERE, "Exception occured while joining group:" + e);
        }
    }

    private void runSimpleSample(String serverName) throws GMSException {
        logger.log(Level.INFO, "Starting CheckIfGroupShuttingDownTest....");
        GroupManagementService gms = this.initializeGMS(serverName, "Group");
        this.registerForGroupEvents(gms);
        this.joinGMSGroup("Group", gms);
        if (serverName.equals("C1")) {
            logger.info("SHUTDOWN : Is the group shutting down ? : " + gms.isGroupBeingShutdown("Group"));
        }
        try {
            this.waitForShutdown(10000);
        }
        catch (InterruptedException e) {
            logger.log(Level.WARNING, e.getMessage());
        }
        if (serverName.equals("DAS")) {
            GMSContextFactory.getGMSContext("Group").announceGroupShutdown("Group", GMSConstants.shutdownState.COMPLETED);
        }
        try {
            this.waitForShutdown(20000);
        }
        catch (InterruptedException e) {
            logger.log(Level.WARNING, e.getMessage());
        }
        if (serverName.equals("C1")) {
            logger.info("SHUTDOWN : Now is the group shutting down ? : " + gms.isGroupBeingShutdown("Group"));
        }
        this.leaveGroupAndShutdown(serverName, gms);
        if (serverName.equals("C1")) {
            logger.info("After leaveGroupAndShutdown : Now is the group shutting down ? : " + gms.isGroupBeingShutdown("Group"));
        }
        System.exit(0);
    }

    private GroupManagementService initializeGMS(String serverName, String groupName) {
        logger.log(Level.INFO, "Initializing Shoal for member: " + serverName + " group:" + groupName);
        return (GroupManagementService)((Object)GMSFactory.startGMSModule(serverName, groupName, GroupManagementService.MemberType.CORE, null));
    }

    private void registerForGroupEvents(GroupManagementService gms) {
        logger.log(Level.INFO, "Registering for group event notifications");
        gms.addActionFactory(new JoinNotificationActionFactoryImpl(this));
        gms.addActionFactory(new FailureSuspectedActionFactoryImpl(this));
        gms.addActionFactory(new FailureNotificationActionFactoryImpl(this));
        gms.addActionFactory(new PlannedShutdownActionFactoryImpl(this));
        gms.addActionFactory(new JoinedAndReadyNotificationActionFactoryImpl(this));
    }

    private void joinGMSGroup(String groupName, GroupManagementService gms) throws GMSException {
        logger.log(Level.INFO, "Joining Group " + groupName);
        gms.join();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForShutdown(int time) throws InterruptedException {
        logger.log(Level.INFO, "waiting for " + time + " ms");
        Object object = this.waitLock;
        synchronized (object) {
            this.waitLock.wait(time);
        }
    }

    private void leaveGroupAndShutdown(String serverName, GroupManagementService gms) {
        logger.log(Level.INFO, "Shutting down gms " + gms + "for server " + serverName);
        gms.shutdown(GMSConstants.shutdownType.GROUP_SHUTDOWN);
    }

    public void processNotification(Signal notification) {
        logger.info("calling processNotification()...");
    }
}

