/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.cms.tests.p2pmessagesend;

import com.sun.enterprise.ee.cms.core.CallBack;
import com.sun.enterprise.ee.cms.core.GMSConstants;
import com.sun.enterprise.ee.cms.core.GMSException;
import com.sun.enterprise.ee.cms.core.GMSFactory;
import com.sun.enterprise.ee.cms.core.GroupHandle;
import com.sun.enterprise.ee.cms.core.GroupManagementService;
import com.sun.enterprise.ee.cms.core.MessageSignal;
import com.sun.enterprise.ee.cms.core.Signal;
import com.sun.enterprise.ee.cms.core.SignalAcquireException;
import com.sun.enterprise.ee.cms.core.SignalReleaseException;
import com.sun.enterprise.ee.cms.impl.client.FailureNotificationActionFactoryImpl;
import com.sun.enterprise.ee.cms.impl.client.FailureSuspectedActionFactoryImpl;
import com.sun.enterprise.ee.cms.impl.client.JoinNotificationActionFactoryImpl;
import com.sun.enterprise.ee.cms.impl.client.JoinedAndReadyNotificationActionFactoryImpl;
import com.sun.enterprise.ee.cms.impl.client.MessageActionFactoryImpl;
import com.sun.enterprise.ee.cms.impl.client.PlannedShutdownActionFactoryImpl;
import com.sun.enterprise.ee.cms.impl.common.GMSContextFactory;
import com.sun.enterprise.ee.cms.impl.jxta.GMSContext;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;

public class P2PMessageSendAndReceive
implements CallBack {
    static final Logger logger = Logger.getLogger("P2PMessageSendAndReceive");
    final Object waitLock = new Object();
    private GMSContext ctx;
    final String group = "Group";

    public static void main(String[] args) {
        P2PMessageSendAndReceive p2pMsgSendReceive = new P2PMessageSendAndReceive();
        try {
            if (System.getProperty("TYPE").equals("sender")) {
                p2pMsgSendReceive.send();
            } else if (System.getProperty("TYPE").equals("receiver")) {
                p2pMsgSendReceive.receive();
            }
        }
        catch (GMSException e) {
            logger.log(Level.SEVERE, "Exception occured while joining group:" + e);
        }
    }

    private void send() throws GMSException {
        logger.log(Level.INFO, "Starting P2PMessageSendAndReceive....");
        String serverName = "C1";
        GroupManagementService gms = this.initializeGMS("C1", "Group");
        this.registerForGroupEvents(gms);
        this.joinGMSGroup("Group", gms);
        try {
            this.sendMessages(gms, "C1", "Group");
            this.waitForShutdown();
        }
        catch (InterruptedException e) {
            logger.log(Level.WARNING, e.getMessage());
        }
        this.leaveGroupAndShutdown("C1", gms);
        System.exit(0);
    }

    private void receive() throws GMSException {
        logger.log(Level.INFO, "Starting P2PMessageSendAndReceive....");
        String serverName = "C2";
        GroupManagementService gms = this.initializeGMS("C2", "Group");
        this.registerForGroupEvents(gms);
        this.joinGMSGroup("Group", gms);
        try {
            this.waitForShutdown();
        }
        catch (InterruptedException e) {
            logger.log(Level.WARNING, e.getMessage());
        }
        this.leaveGroupAndShutdown("C2", gms);
        System.exit(0);
    }

    private GroupManagementService initializeGMS(String serverName, String groupName) {
        logger.log(Level.INFO, "Initializing Shoal for member: " + serverName + " group:" + groupName);
        return (GroupManagementService)((Object)GMSFactory.startGMSModule(serverName, groupName, GroupManagementService.MemberType.CORE, null));
    }

    private void registerForGroupEvents(GroupManagementService gms) {
        logger.log(Level.INFO, "Registering for group event notifications");
        gms.addActionFactory(new JoinNotificationActionFactoryImpl(this));
        gms.addActionFactory(new FailureSuspectedActionFactoryImpl(this));
        gms.addActionFactory(new FailureNotificationActionFactoryImpl(this));
        gms.addActionFactory(new PlannedShutdownActionFactoryImpl(this));
        gms.addActionFactory(new JoinedAndReadyNotificationActionFactoryImpl(this));
        gms.addActionFactory(new MessageActionFactoryImpl(this), "SimpleSampleComponent");
    }

    private void joinGMSGroup(String groupName, GroupManagementService gms) throws GMSException {
        logger.log(Level.INFO, "Joining Group " + groupName);
        gms.join();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendMessages(GroupManagementService gms, String serverName, String groupName) throws InterruptedException, GMSException {
        logger.log(Level.INFO, "Sender : wait 10 secs to send 10 messages");
        Object object = this.waitLock;
        synchronized (object) {
            this.waitLock.wait(10000L);
        }
        GroupHandle gh = gms.getGroupHandle();
        logger.log(Level.INFO, "Sending messages...");
        for (int i = 0; i <= 10; ++i) {
            gh.sendMessage("SimpleSampleComponent", MessageFormat.format("P2PMsgSendReceive : message {0} from {1} to {2}", i, serverName, groupName).getBytes());
            logger.info("Message " + i + " sent from " + serverName + " to  " + groupName);
        }
    }

    private GMSContext getGMSContext() {
        if (this.ctx == null) {
            this.ctx = (GMSContext)GMSContextFactory.getGMSContext("Group");
        }
        return this.ctx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForShutdown() throws InterruptedException {
        logger.log(Level.INFO, "wait 30 secs to shutdown");
        Object object = this.waitLock;
        synchronized (object) {
            this.waitLock.wait(30000L);
        }
    }

    private void leaveGroupAndShutdown(String serverName, GroupManagementService gms) {
        logger.log(Level.INFO, "Shutting down gms " + gms + "for server " + serverName);
        gms.shutdown(GMSConstants.shutdownType.INSTANCE_SHUTDOWN);
    }

    public void processNotification(Signal signal) {
        logger.log(Level.INFO, "Received Notification of type : " + signal.getClass().getName());
        try {
            signal.acquire();
            logger.log(Level.INFO, "Source Member: " + signal.getMemberToken() + " group : " + signal.getGroupName());
            if (signal instanceof MessageSignal) {
                logger.log(Level.INFO, "Message: " + new String(((MessageSignal)signal).getMessage()));
            }
            signal.release();
        }
        catch (SignalAcquireException e) {
            logger.log(Level.WARNING, "Exception occured while acquiring signal" + e);
        }
        catch (SignalReleaseException e) {
            logger.log(Level.WARNING, "Exception occured while releasing signal" + e);
        }
    }
}

