/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.jxtamgmt;

import com.sun.enterprise.ee.cms.core.GMSConstants;
import com.sun.enterprise.ee.cms.core.GroupManagementService;
import com.sun.enterprise.ee.cms.core.MemberNotInViewException;
import com.sun.enterprise.ee.cms.impl.jxta.CustomTagNames;
import com.sun.enterprise.jxtamgmt.ClusterMessageListener;
import com.sun.enterprise.jxtamgmt.ClusterView;
import com.sun.enterprise.jxtamgmt.ClusterViewEvent;
import com.sun.enterprise.jxtamgmt.ClusterViewEventListener;
import com.sun.enterprise.jxtamgmt.ClusterViewManager;
import com.sun.enterprise.jxtamgmt.HealthMonitor;
import com.sun.enterprise.jxtamgmt.JxtaConfigConstants;
import com.sun.enterprise.jxtamgmt.JxtaUtil;
import com.sun.enterprise.jxtamgmt.MasterNode;
import com.sun.enterprise.jxtamgmt.NetworkManager;
import com.sun.enterprise.jxtamgmt.NetworkManagerRegistry;
import com.sun.enterprise.jxtamgmt.SystemAdvertisement;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.XMLDocument;
import net.jxta.endpoint.ByteArrayMessageElement;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.MessageElement;
import net.jxta.endpoint.TextDocumentMessageElement;
import net.jxta.exception.PeerGroupException;
import net.jxta.id.ID;
import net.jxta.impl.endpoint.tcp.TcpTransport;
import net.jxta.impl.pipe.BlockingWireOutputPipe;
import net.jxta.peer.PeerID;
import net.jxta.peergroup.PeerGroup;
import net.jxta.pipe.InputPipe;
import net.jxta.pipe.OutputPipe;
import net.jxta.pipe.PipeMsgEvent;
import net.jxta.pipe.PipeMsgListener;
import net.jxta.pipe.PipeService;
import net.jxta.protocol.PipeAdvertisement;
import net.jxta.protocol.RouteAdvertisement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClusterManager
implements PipeMsgListener {
    private static final Logger LOG = JxtaUtil.getLogger(ClusterManager.class.getName());
    private MasterNode masterNode = null;
    private ClusterViewManager clusterViewManager = null;
    private HealthMonitor healthMonitor = null;
    private NetworkManager netManager = null;
    private String groupName = null;
    private String instanceName = null;
    private String bindInterfaceAddress = null;
    private volatile boolean started = false;
    private volatile boolean stopped = true;
    private boolean loopbackMessages = false;
    private final Object closeLock = new Object();
    private SystemAdvertisement systemAdv = null;
    private static final String NODEADV = "NAD";
    private transient Map<String, String> identityMap;
    private transient Map<PeerID, RouteAdvertisement> routeCache = new ConcurrentHashMap<PeerID, RouteAdvertisement>();
    private PipeAdvertisement pipeAdv;
    private PipeService pipeService;
    private MessageElement sysAdvElement = null;
    private InputPipe inputPipe;
    private OutputPipe outputPipe;
    private static final String NAMESPACE = "CLUSTER_MANAGER";
    private PeerID myID;
    private static final String APPMESSAGE = "APPMESSAGE";
    private List<ClusterMessageListener> cmListeners;
    private volatile boolean stopping = false;
    private transient Map<ID, OutputPipe> pipeCache = new ConcurrentHashMap<ID, OutputPipe>();
    final Object MASTERBYFORCELOCK = new Object();
    private final String memberType;

    public ClusterManager(String groupName, String instanceName, Map<String, String> identityMap, Map props, List<ClusterViewEventListener> viewListeners, List<ClusterMessageListener> messageListeners) {
        this.memberType = identityMap.get(CustomTagNames.MEMBER_TYPE.toString());
        this.groupName = groupName;
        this.instanceName = instanceName;
        this.loopbackMessages = this.isLoopBackEnabled(props);
        this.netManager = new NetworkManager(groupName, instanceName, props);
        this.identityMap = identityMap;
        try {
            this.netManager.start();
        }
        catch (PeerGroupException pge) {
            LOG.log(Level.SEVERE, pge.getLocalizedMessage());
        }
        catch (IOException ioe) {
            LOG.log(Level.WARNING, ioe.getLocalizedMessage());
        }
        NetworkManagerRegistry.add(groupName, this.netManager);
        if (props != null && !props.isEmpty()) {
            this.bindInterfaceAddress = (String)props.get(JxtaConfigConstants.BIND_INTERFACE_ADDRESS.toString());
        }
        this.systemAdv = ClusterManager.createSystemAdv(this.netManager.getNetPeerGroup(), instanceName, identityMap, this.bindInterfaceAddress);
        LOG.log(Level.FINER, "Instance ID :" + this.getSystemAdvertisement().getID());
        if (this.isWatchdog()) {
            this.clusterViewManager = null;
            this.masterNode = null;
        } else {
            this.clusterViewManager = new ClusterViewManager(this.getSystemAdvertisement(), this, viewListeners);
            this.masterNode = new MasterNode(this, this.getDiscoveryTimeout(props), 1);
        }
        this.healthMonitor = new HealthMonitor(this, this.getFailureDetectionTimeout(props), this.getFailureDetectionRetries(props), this.getVerifyFailureTimeout(props), this.getFailureDetectionTcpRetransmitTimeout(props), this.getFailureDetectionTcpRetransmitPort(props));
        this.pipeService = this.netManager.getNetPeerGroup().getPipeService();
        this.myID = this.netManager.getNetPeerGroup().getPeerID();
        try {
            this.pipeAdv = this.createPipeAdv();
            this.outputPipe = this.pipeService.createOutputPipe(this.pipeAdv, 100L);
        }
        catch (IOException io) {
            LOG.log(Level.FINE, "Failed to create master outputPipe", io);
        }
        this.cmListeners = messageListeners;
        this.sysAdvElement = new TextDocumentMessageElement(NODEADV, (XMLDocument)this.getSystemAdvertisement().getDocument(MimeMediaType.XMLUTF8), null);
    }

    public boolean isWatchdog() {
        return GroupManagementService.MemberType.WATCHDOG.toString().equals(this.memberType);
    }

    private boolean isLoopBackEnabled(Map props) {
        Object lp;
        boolean loopback = false;
        if (props != null && !props.isEmpty() && (lp = props.get(JxtaConfigConstants.LOOPBACK.toString())) != null) {
            loopback = Boolean.parseBoolean((String)lp);
        }
        return loopback;
    }

    private long getDiscoveryTimeout(Map props) {
        Object dt;
        long discTimeout = 5000L;
        if (props != null && !props.isEmpty() && (dt = props.get(JxtaConfigConstants.DISCOVERY_TIMEOUT.toString())) != null) {
            discTimeout = Long.parseLong((String)dt);
        }
        return discTimeout;
    }

    private long getFailureDetectionTimeout(Map props) {
        Object ft;
        long failTimeout = 3000L;
        if (props != null && !props.isEmpty() && (ft = props.get(JxtaConfigConstants.FAILURE_DETECTION_TIMEOUT.toString())) != null) {
            failTimeout = Long.parseLong((String)ft);
        }
        return failTimeout;
    }

    private int getFailureDetectionRetries(Map props) {
        Object fr;
        int failRetry = 3;
        if (props != null && !props.isEmpty() && (fr = props.get(JxtaConfigConstants.FAILURE_DETECTION_RETRIES.toString())) != null) {
            failRetry = Integer.parseInt((String)fr);
        }
        return failRetry;
    }

    private long getFailureDetectionTcpRetransmitTimeout(Map props) {
        Object ft;
        long failTcpTimeout = 10000L;
        if (props != null && !props.isEmpty() && (ft = props.get(JxtaConfigConstants.FAILURE_DETECTION_TCP_RETRANSMIT_TIMEOUT.toString())) != null) {
            failTcpTimeout = Long.parseLong((String)ft);
        }
        return failTcpTimeout;
    }

    private int getFailureDetectionTcpRetransmitPort(Map props) {
        Object ft;
        int failTcpPort = 9000;
        if (props != null && !props.isEmpty() && (ft = props.get(JxtaConfigConstants.FAILURE_DETECTION_TCP_RETRANSMIT_PORT.toString())) != null) {
            failTcpPort = Integer.parseInt((String)ft);
        }
        return failTcpPort;
    }

    private long getVerifyFailureTimeout(Map props) {
        Object vt;
        long verifyTimeout = 2000L;
        if (props != null && !props.isEmpty() && (vt = props.get(JxtaConfigConstants.FAILURE_VERIFICATION_TIMEOUT.toString())) != null) {
            verifyTimeout = Long.parseLong((String)vt);
        }
        return verifyTimeout;
    }

    public void addClusteMessageListener(ClusterMessageListener listener) {
        this.cmListeners.add(listener);
    }

    public void removeClusterViewEventListener(ClusterMessageListener listener) {
        this.cmListeners.remove(listener);
    }

    public static void main(String[] argv) {
        JxtaUtil.setupLogHandler();
        LOG.setLevel(Level.FINEST);
        String name = System.getProperty("INAME", "instanceName");
        String groupName = System.getProperty("GNAME", "groupName");
        LOG.log(Level.FINER, "Instance Name :" + name);
        Map props = ClusterManager.getPropsForTest();
        Map<String, String> idMap = ClusterManager.getIdMap();
        ArrayList<ClusterViewEventListener> vListeners = new ArrayList<ClusterViewEventListener>();
        ArrayList<ClusterMessageListener> mListeners = new ArrayList<ClusterMessageListener>();
        vListeners.add(new ClusterViewEventListener(){

            public void clusterViewEvent(ClusterViewEvent event, ClusterView view) {
                LOG.log(Level.INFO, "event.message", new Object[]{event.getEvent().toString()});
                LOG.log(Level.INFO, "peer.involved", new Object[]{event.getAdvertisement().toString()});
                LOG.log(Level.INFO, "view.message", new Object[]{view.getPeerNamesInView().toString()});
            }
        });
        mListeners.add(new ClusterMessageListener(){

            public void handleClusterMessage(SystemAdvertisement id, Object message) {
                LOG.log(Level.INFO, id.getName());
                LOG.log(Level.INFO, message.toString());
            }
        });
        ClusterManager manager = new ClusterManager(groupName, name, idMap, props, vListeners, mListeners);
        manager.start();
        manager.waitForClose();
    }

    private static Map<String, String> getIdMap() {
        return new HashMap<String, String>();
    }

    private static Map getPropsForTest() {
        return new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stop(boolean isClusterShutdown) {
        if (!this.stopped) {
            this.stopping = true;
            this.healthMonitor.stop(isClusterShutdown);
            this.outputPipe.close();
            this.inputPipe.close();
            this.pipeCache.clear();
            if (!this.isWatchdog()) {
                this.masterNode.stop();
            }
            this.netManager.stop();
            NetworkManagerRegistry.remove(this.groupName);
            this.stopped = true;
            Object object = this.closeLock;
            synchronized (object) {
                this.closeLock.notify();
            }
        }
    }

    public synchronized void start() {
        if (!this.started) {
            try {
                this.inputPipe = this.pipeService.createInputPipe(this.pipeAdv, this);
            }
            catch (IOException ioe) {
                LOG.log(Level.SEVERE, "Failed to create service input pipe: " + ioe);
            }
            if (!this.isWatchdog()) {
                this.masterNode.start();
            }
            this.healthMonitor.start();
            this.started = true;
            this.stopped = false;
        }
    }

    public NetworkManager getNetworkManager() {
        return this.netManager;
    }

    public MasterNode getMasterNode() {
        return this.masterNode;
    }

    public HealthMonitor getHealthMonitor() {
        return this.healthMonitor;
    }

    public ClusterViewManager getClusterViewManager() {
        return this.clusterViewManager;
    }

    public PeerGroup getNetPeerGroup() {
        return this.netManager.getNetPeerGroup();
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public boolean isMaster() {
        return this.clusterViewManager.isMaster() && this.masterNode.isMasterAssigned();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForClose() {
        try {
            LOG.log(Level.FINER, "Waiting for close");
            Object object = this.closeLock;
            synchronized (object) {
                this.closeLock.wait();
            }
            this.stop(false);
            LOG.log(Level.FINER, "Good Bye");
        }
        catch (InterruptedException e) {
            LOG.log(Level.WARNING, e.getLocalizedMessage());
        }
    }

    public void removePipeFromCache(ID token) {
        this.pipeCache.remove(token);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean send(ID peerid, Serializable msg) throws IOException, MemberNotInViewException {
        boolean sent = false;
        if (this.stopping) return sent;
        Message message = new Message();
        message.addMessageElement(NAMESPACE, this.sysAdvElement);
        ByteArrayMessageElement bame = new ByteArrayMessageElement(APPMESSAGE, MimeMediaType.AOS, JxtaUtil.createByteArrayFromObject(msg), null);
        message.addMessageElement(NAMESPACE, bame);
        if (peerid == null) {
            LOG.log(Level.FINER, "Broadcasting Message");
            sent = JxtaUtil.send(this.outputPipe, message);
            if (sent) return sent;
            LOG.warning("ClusterManager.send: broadcast of message " + message + " failed." + " OutputPipe.send attempted resend " + 4 + " and they all returned false.");
            return sent;
        }
        if (!this.getClusterViewManager().containsKey(peerid)) {
            LOG.fine("ClusterManager.send : Cluster View does not contain " + peerid.toString() + " hence will not send message.");
            throw new MemberNotInViewException("Member " + peerid + " is not in the View anymore. Hence not performing sendMessage operation");
        }
        LOG.fine("ClusterManager.send : Cluster View contains " + peerid.toString());
        OutputPipe output = this.pipeCache.get(peerid);
        RouteAdvertisement route = null;
        int MAX_RETRIES = 2;
        IOException lastOne = null;
        for (int createOutputPipeAttempts = 0; output == null && createOutputPipeAttempts < 2; ++createOutputPipeAttempts) {
            route = this.getCachedRoute((PeerID)peerid);
            if (route != null) {
                try {
                    output = new BlockingWireOutputPipe(this.getNetPeerGroup(), this.pipeAdv, (PeerID)peerid, route);
                }
                catch (IOException ioe) {
                    lastOne = ioe;
                }
            }
            if (output != null) continue;
            try {
                output = this.pipeService.createOutputPipe(this.pipeAdv, Collections.singleton(peerid), 1L);
                if (!LOG.isLoggable(Level.FINE) || output == null) continue;
                LOG.fine("ClusterManager.send : adding output to cache without route creation : " + peerid);
                continue;
            }
            catch (IOException ioe) {
                lastOne = ioe;
            }
        }
        if (output != null) {
            this.pipeCache.put(peerid, output);
            sent = JxtaUtil.send(output, message);
            if (sent) return sent;
            LOG.warning("ClusterManager.send: message " + message + " not sent to " + peerid + " OutputPipe.send attempted resend " + 4 + " and they all returned false.");
            return sent;
        }
        LOG.log(Level.WARNING, "ClusterManager.send : sending of message " + message + " failed. Unable to create an OutputPipe for " + peerid + " route = " + route, lastOne);
        return sent;
    }

    private PipeAdvertisement createPipeAdv() {
        PipeAdvertisement pipeAdv = (PipeAdvertisement)AdvertisementFactory.newAdvertisement(PipeAdvertisement.getAdvertisementType());
        pipeAdv.setPipeID(this.getNetworkManager().getAppServicePipeID());
        pipeAdv.setType("JxtaPropagate");
        return pipeAdv;
    }

    @Override
    public void pipeMsgEvent(PipeMsgEvent event) {
        if (this.started && !this.stopping) {
            try {
                Object appMessage;
                Message msg = event.getMessage();
                if (msg == null) {
                    LOG.log(Level.WARNING, "Received a null message");
                    return;
                }
                LOG.log(Level.FINEST, "ClusterManager:Received a AppMessage ");
                MessageElement msgElement = msg.getMessageElement(NAMESPACE, NODEADV);
                if (msgElement == null) {
                    LOG.log(Level.WARNING, "Received an unknown message");
                    return;
                }
                StructuredDocument asDoc = StructuredDocumentFactory.newStructuredDocument(msgElement.getMimeType(), msgElement.getStream());
                SystemAdvertisement adv = new SystemAdvertisement(asDoc);
                PeerID srcPeerID = (PeerID)adv.getID();
                if (!this.loopbackMessages && srcPeerID.equals(this.myID)) {
                    LOG.log(Level.FINEST, "CLUSTERMANAGER:Discarding loopback message");
                    return;
                }
                msgElement = msg.getMessageElement(NAMESPACE, APPMESSAGE);
                if (msgElement != null && (appMessage = JxtaUtil.getObjectFromByteArray(msgElement)) != null) {
                    LOG.log(Level.FINEST, "ClusterManager: Notifying APPMessage Listeners of " + appMessage.toString() + "and adv = " + adv.getName());
                    this.notifyMessageListeners(adv, appMessage);
                }
            }
            catch (Throwable e) {
                LOG.log(Level.WARNING, e.getLocalizedMessage());
            }
        }
    }

    private void notifyMessageListeners(SystemAdvertisement senderSystemAdvertisement, Object appMessage) {
        for (ClusterMessageListener listener : this.cmListeners) {
            listener.handleClusterMessage(senderSystemAdvertisement, appMessage);
        }
    }

    public SystemAdvertisement getSystemAdvertisementForMember(ID id) {
        return this.clusterViewManager.get(id);
    }

    public SystemAdvertisement getSystemAdvertisement() {
        if (this.systemAdv == null) {
            this.systemAdv = ClusterManager.createSystemAdv(this.netManager.getNetPeerGroup(), this.instanceName, this.identityMap, this.bindInterfaceAddress);
        }
        return this.systemAdv;
    }

    public PeerID getNodeID() {
        return this.myID;
    }

    private static synchronized SystemAdvertisement createSystemAdv(PeerGroup group, String name, Map<String, String> customTags, String bindInterfaceAddress) {
        if (group == null) {
            throw new IllegalArgumentException("Group can not be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("instance name can not be null");
        }
        SystemAdvertisement sysAdv = new SystemAdvertisement();
        sysAdv.setID(group.getPeerID());
        sysAdv.setName(name);
        ClusterManager.setBindInterfaceAddress(sysAdv, bindInterfaceAddress, group);
        sysAdv.setOSName(System.getProperty("os.name"));
        sysAdv.setOSVersion(System.getProperty("os.version"));
        sysAdv.setOSArch(System.getProperty("os.arch"));
        sysAdv.setHWArch(System.getProperty("HOSTTYPE", System.getProperty("os.arch")));
        sysAdv.setHWVendor(System.getProperty("java.vm.vendor"));
        sysAdv.setCustomTags(customTags);
        return sysAdv;
    }

    private static void setBindInterfaceAddress(SystemAdvertisement sysAdv, String bindInterfaceAddress, PeerGroup group) {
        EndpointAddress bindInterfaceEndpointAddress = null;
        if (bindInterfaceAddress != null && !bindInterfaceAddress.equals("")) {
            String TCP_SCHEME = "tcp://";
            String PORT = ":4000";
            String bindInterfaceAddressURI = "tcp://" + bindInterfaceAddress + ":4000";
            try {
                bindInterfaceEndpointAddress = new EndpointAddress(bindInterfaceAddressURI);
            }
            catch (Exception e) {
                LOG.log(Level.WARNING, "invalid bindInterfaceEndpointAddress URI=" + bindInterfaceAddressURI + " computed from property " + JxtaConfigConstants.BIND_INTERFACE_ADDRESS.toString() + " value=" + bindInterfaceAddress, e);
            }
        }
        if (bindInterfaceEndpointAddress != null) {
            if (LOG.isLoggable(Level.CONFIG)) {
                LOG.config("Configured bindInterfaceEndpointAddress URI " + bindInterfaceEndpointAddress.toString() + " using property " + JxtaConfigConstants.BIND_INTERFACE_ADDRESS.toString() + " value=" + bindInterfaceAddress);
            }
            sysAdv.addEndpointAddress(bindInterfaceEndpointAddress);
        } else {
            TcpTransport tcpTransport = (TcpTransport)group.getEndpointService().getMessageTransport("tcp");
            Iterator<EndpointAddress> it = tcpTransport.getPublicAddresses();
            while (it.hasNext()) {
                sysAdv.addEndpointAddress(it.next());
            }
        }
    }

    public String getNodeState(ID peerID, long threshold, long timeout) {
        return this.getHealthMonitor().getMemberState((PeerID)peerID, threshold, timeout);
    }

    public ID getID(String name) {
        return this.netManager.getPeerID(name);
    }

    boolean isStopping() {
        return this.stopping;
    }

    public void takeOverMasterRole() {
        this.masterNode.takeOverMasterRole();
        this.waitFor(2000L);
    }

    public void setClusterStopping() {
        this.masterNode.setClusterStopping();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitFor(long msec) {
        try {
            Object object = this.MASTERBYFORCELOCK;
            synchronized (object) {
                this.MASTERBYFORCELOCK.wait(msec);
            }
        }
        catch (InterruptedException intr) {
            Thread.interrupted();
            LOG.log(Level.FINER, "Thread interrupted", intr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyNewMaster() {
        Object object = this.MASTERBYFORCELOCK;
        synchronized (object) {
            this.MASTERBYFORCELOCK.notify();
        }
    }

    public void reportJoinedAndReadyState() {
        this.healthMonitor.reportJoinedAndReadyState();
    }

    public void cacheRoute(RouteAdvertisement route) {
        this.routeCache.put(route.getDestPeerID(), route);
    }

    public RouteAdvertisement getCachedRoute(PeerID peerid) {
        return this.routeCache.get(peerid);
    }

    void removeRouteFromCache(ID token) {
        this.routeCache.remove(token);
    }

    void clearAllCaches() {
        this.routeCache.clear();
        this.pipeCache.clear();
    }

    public void groupStartup(GMSConstants.groupStartupState startupState, List<String> memberTokens) {
        this.getMasterNode().groupStartup(startupState, memberTokens);
    }

    public boolean isGroupStartup() {
        return this.getMasterNode().isGroupStartup();
    }

    public String getGroupName() {
        return this.groupName;
    }

    public boolean isDiscoveryInProgress() {
        return this.masterNode.isDiscoveryInProgress();
    }
}

