/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.jxtamgmt;

import com.sun.enterprise.ee.cms.impl.jxta.CustomTagNames;
import com.sun.enterprise.jxtamgmt.HealthMonitor;
import com.sun.enterprise.jxtamgmt.JxtaUtil;
import com.sun.enterprise.jxtamgmt.SystemAdvertisement;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import net.jxta.document.Attributable;
import net.jxta.document.Attribute;
import net.jxta.document.Document;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.StructuredDocumentUtils;
import net.jxta.document.StructuredTextDocument;
import net.jxta.document.TextElement;
import net.jxta.id.IDFactory;
import net.jxta.peer.PeerID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HealthMessage {
    private static final Logger LOG = JxtaUtil.getLogger(HealthMessage.class.getName());
    private List<Entry> entries;
    private PeerID srcID;
    private static final String entryTag = "Entry";
    private static final String srcTag = "src";
    private static final String stateTag = "state";
    private static final String seqIdTag = "seqId";

    public HealthMessage() {
    }

    public HealthMessage(InputStream stream, long hmSeqID) throws IOException {
        StructuredTextDocument doc = (StructuredTextDocument)StructuredDocumentFactory.newStructuredDocument(MimeMediaType.XMLUTF8, stream);
        this.initialize(doc, hmSeqID);
    }

    public HealthMessage(PeerID srcID, List<Entry> entries) {
        this.srcID = srcID;
        this.entries = entries;
    }

    public HealthMessage(Element root, long hmSeqID) {
        TextElement doc = (TextElement)root;
        if (!HealthMessage.getAdvertisementType().equals(doc.getName())) {
            throw new IllegalArgumentException("Could not construct : " + this.getClass().getName() + "from doc containing a " + doc.getName());
        }
        this.initialize(doc, hmSeqID);
    }

    public Document getDocument(MimeMediaType asMimeType) {
        StructuredDocument adv = StructuredDocumentFactory.newStructuredDocument(asMimeType, HealthMessage.getAdvertisementType());
        if (adv instanceof Attributable) {
            ((Attributable)((Object)adv)).addAttribute("xmlns:jxta", "http://jxta.org");
        }
        Object e = adv.createElement(srcTag, this.getSrcID().toString());
        JxtaUtil.appendChild(adv, e);
        Iterator<Entry> i$ = this.entries.iterator();
        while (i$.hasNext()) {
            Entry entry1;
            Entry entry = entry1 = i$.next();
            if (entry.id == null && entry.state == null) continue;
            e = adv.createElement(entryTag);
            JxtaUtil.appendChild(adv, e);
            ((Attributable)e).addAttribute(stateTag, entry.state);
            ((Attributable)e).addAttribute(seqIdTag, Long.toString(entry.seqID));
            StructuredTextDocument doc = (StructuredTextDocument)entry.adv.getDocument(asMimeType);
            StructuredDocumentUtils.copyElements(adv, e, doc);
        }
        return adv;
    }

    public List<Entry> getEntries() {
        return this.entries;
    }

    public PeerID getSrcID() {
        return this.srcID;
    }

    private void initialize(TextElement doc, long hmSeqID) {
        Enumeration elements = doc.getChildren();
        while (elements.hasMoreElements()) {
            TextElement elem = (TextElement)elements.nextElement();
            if (elem.getName().equals(srcTag)) {
                try {
                    URI id = new URI(elem.getTextValue());
                    this.setSrcID((PeerID)IDFactory.fromURI(id));
                    continue;
                }
                catch (URISyntaxException badID) {
                    throw new IllegalArgumentException("unknown ID format in advertisement: " + badID.getLocalizedMessage() + ' ' + elem.getTextValue());
                }
                catch (ClassCastException badID) {
                    throw new IllegalArgumentException("Id is not a known id type: " + badID.getLocalizedMessage() + ' ' + elem.getTextValue());
                }
            }
            if (!elem.getName().equals(entryTag)) continue;
            String state = "NA";
            Attribute stateAttr = ((Attributable)((Object)elem)).getAttribute(stateTag);
            if (stateAttr != null) {
                state = stateAttr.getValue();
            }
            Attribute seqIDAttr = ((Attributable)((Object)elem)).getAttribute(seqIdTag);
            long seqID = 0L;
            if (seqIDAttr != null) {
                seqID = Long.parseLong(seqIDAttr.getValue());
            } else {
                LOG.warning("missing sender's sequence id in xml representation of HealthMessage.Entry, generating hm sequence id on receiving side");
                seqID = hmSeqID;
            }
            Enumeration each = elem.getChildren();
            while (each.hasMoreElements()) {
                SystemAdvertisement adv = new SystemAdvertisement((TextElement)each.nextElement());
                Entry entry = new Entry(adv, state, seqID);
                this.add(entry);
            }
        }
        this.setEntries(this.entries);
    }

    public void setEntries(List<Entry> list) {
        this.entries = list;
    }

    public void add(Entry entry) {
        if (this.entries == null) {
            this.entries = new ArrayList<Entry>();
        }
        if (!this.entries.contains(entry)) {
            this.entries.add(entry);
        }
    }

    public void remove(Entry entry) {
        if (this.entries.contains(entry)) {
            this.entries.remove(this.entries.indexOf(entry));
        }
    }

    public void setSrcID(PeerID id) {
        this.srcID = id == null ? null : id;
    }

    public String toString() {
        StructuredTextDocument doc = (StructuredTextDocument)this.getDocument(MimeMediaType.XMLUTF8);
        return doc.toString();
    }

    public static String getAdvertisementType() {
        return "jxta:Health";
    }

    public static final class Entry
    implements Cloneable {
        final PeerID id;
        final SystemAdvertisement adv;
        String state;
        final long timestamp;
        final long seqID;
        transient long srcStartTime = 0L;

        public Entry(SystemAdvertisement adv, String state, long seqID) {
            this.state = state;
            this.adv = adv;
            this.id = (PeerID)adv.getID();
            this.timestamp = System.currentTimeMillis();
            this.seqID = seqID;
        }

        public Entry(Entry previousEntry, String newState) {
            this(previousEntry.adv, newState, previousEntry.seqID + 1L);
        }

        public Entry(Entry entry) {
            this(entry.adv, entry.state, entry.seqID);
        }

        public long getSeqID() {
            return this.seqID;
        }

        public long getSrcStartTime() {
            String startTime = null;
            if (this.srcStartTime == 0L) {
                try {
                    startTime = this.adv.getCustomTagValue(CustomTagNames.START_TIME.toString());
                }
                catch (NoSuchFieldException ex) {
                    LOG.warning("SystemAdvertisement is missing CustomTag START_TIME adv=" + this.adv.toString());
                }
                this.srcStartTime = startTime != null ? Long.parseLong(startTime) : -1L;
            }
            return this.srcStartTime;
        }

        public boolean isFromSameMember(Entry other) {
            return other != null && this.id.equals(other.id);
        }

        public boolean isFromSameMemberStartup(Entry other) {
            return other != null && this.id.equals(other.id) && this.getSrcStartTime() == other.getSrcStartTime();
        }

        public boolean isState(int theState) {
            return this.state.equals(HealthMonitor.states[theState]);
        }

        public boolean equals(Object obj) {
            return obj instanceof Entry && this == obj || obj != null && this.id.equals(((Entry)obj).id);
        }

        public int hashCode() {
            return this.id.hashCode() * 45191;
        }

        public String toString() {
            return "HealthMessage.Entry: Id = " + this.id.toString() + "; State = " + this.state + "; LastTimeStamp = " + this.timestamp + "sequence ID = " + this.seqID;
        }

        public Object clone() throws CloneNotSupportedException {
            return (Entry)super.clone();
        }
    }
}

