/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.jxtamgmt;

import com.sun.enterprise.ee.cms.core.GMSMember;
import com.sun.enterprise.ee.cms.core.GroupManagementService;
import com.sun.enterprise.ee.cms.impl.jxta.CustomTagNames;
import com.sun.enterprise.jxtamgmt.NetworkManagerProxy;
import com.sun.enterprise.jxtamgmt.NetworkManagerRegistry;
import com.sun.enterprise.jxtamgmt.NiceLogFormatter;
import com.sun.enterprise.jxtamgmt.SystemAdvertisement;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.logging.ConsoleHandler;
import java.util.logging.ErrorManager;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.MessageElement;
import net.jxta.endpoint.WireFormatMessage;
import net.jxta.endpoint.WireFormatMessageFactory;
import net.jxta.pipe.OutputPipe;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JxtaUtil {
    private static Logger LOG = Logger.getLogger(System.getProperty("JXTA_MGMT_LOGGER", "JxtaMgmt"));
    private static String jxtaLoggingPropertyValue = System.getProperty("net.jxta.logging.Logging");
    public static final int MAX_SEND_RETRIES = 4;

    private JxtaUtil() {
    }

    public static byte[] createByteArrayFromObject(Object object) {
        if (object == null) {
            return null;
        }
        try {
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            GZIPOutputStream gos = new GZIPOutputStream(outStream);
            ObjectOutputStream out = new ObjectOutputStream(gos);
            out.writeObject(object);
            gos.finish();
            gos.close();
            return outStream.toByteArray();
        }
        catch (IOException ex) {
            throw new IllegalArgumentException(ex.toString());
        }
    }

    public static <T> T getObjectFromByteArray(MessageElement element2) {
        if (element2 == null) {
            return null;
        }
        try {
            ObjectInputStream in = new ObjectInputStream(new GZIPInputStream(element2.getStream()));
            return (T)in.readObject();
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ex.toString());
        }
    }

    static Logger getLogger() {
        return LOG;
    }

    static Logger getLogger(String name) {
        return JxtaUtil.getLogger();
    }

    public static void setLogger(Logger logger) {
        LOG = logger;
    }

    public static void setupLogHandler() {
        ConsoleHandler consoleHandler = new ConsoleHandler();
        try {
            consoleHandler.setLevel(Level.ALL);
            consoleHandler.setFormatter(new NiceLogFormatter());
        }
        catch (SecurityException e) {
            new ErrorManager().error("Exception caught in setting up ConsoleHandler ", e, 0);
        }
        LOG.addHandler(consoleHandler);
        LOG.setUseParentHandlers(false);
        String level = System.getProperty("LOG_LEVEL", "FINEST");
        LOG.setLevel(Level.parse(level));
        Logger jxtaLogger = Logger.getLogger("net.jxta");
        for (Handler aHandler : jxtaLogger.getHandlers()) {
            jxtaLogger.removeHandler(aHandler);
        }
        String jxtaLoggingPropertyValue = System.getProperty("net.jxta.logging.Logging");
        if (jxtaLoggingPropertyValue == null) {
            System.setProperty("net.jxta.logging.Logging", Level.SEVERE.toString());
        }
        jxtaLogger.addHandler(consoleHandler);
    }

    public static void printMessageStats(Message msg, boolean verbose) {
        try {
            Message.ElementIterator it = msg.getMessageElements();
            LOG.log(Level.FINER, "------------------Begin Message---------------------");
            WireFormatMessage serialed = WireFormatMessageFactory.toWire(msg, new MimeMediaType("application/x-jxta-msg"), null);
            LOG.log(Level.FINER, "Message Size :" + serialed.getByteLength());
            while (it.hasNext()) {
                MessageElement el = it.next();
                String eName = el.getElementName();
                LOG.log(Level.FINER, "Element " + eName);
                if (!verbose) continue;
                LOG.log(Level.FINER, "[" + el + "]");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static NetworkManagerProxy getNetworkManagerProxy(String groupName) throws IllegalArgumentException {
        NetworkManagerProxy manager = NetworkManagerRegistry.getNetworkManagerProxy(groupName);
        if (manager != null) {
            return manager;
        }
        throw new IllegalArgumentException("Network Manager Proxy for GroupName " + groupName + "could not be located." + "Check if group has been created or enabled");
    }

    public static void appendChild(StructuredDocument adv, Element child) {
        adv.appendChild(child);
    }

    public static void configureJxtaLogging() {
        if (jxtaLoggingPropertyValue == null) {
            jxtaLoggingPropertyValue = Level.SEVERE.toString();
            System.setProperty("net.jxta.logging.Logging", jxtaLoggingPropertyValue);
            if (LOG.isLoggable(Level.CONFIG)) {
                LOG.config("gms configureJxtaLogging: set jxta logging to default of " + jxtaLoggingPropertyValue);
            }
        } else if (LOG.isLoggable(Level.CONFIG)) {
            LOG.config("gms configureJxtaLogging: found jxta system property net.jxta.logging.Logging is already configured to " + jxtaLoggingPropertyValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean send(OutputPipe pipe, Message msg) throws IOException {
        boolean sent = false;
        for (int i = 0; i < 4 && !sent; ++i) {
            OutputPipe outputPipe = pipe;
            synchronized (outputPipe) {
                sent = pipe.send(msg);
                continue;
            }
        }
        return sent;
    }

    public static GMSMember getGMSMember(SystemAdvertisement systemAdvertisement) {
        GMSMember member;
        try {
            member = new GMSMember(systemAdvertisement.getName(), systemAdvertisement.getCustomTagValue(CustomTagNames.MEMBER_TYPE.toString()), systemAdvertisement.getCustomTagValue(CustomTagNames.GROUP_NAME.toString()), Long.valueOf(systemAdvertisement.getCustomTagValue(CustomTagNames.START_TIME.toString())));
        }
        catch (NoSuchFieldException e) {
            LOG.log(Level.WARNING, new StringBuffer("SystemAdvertisement did not contain one of the ").append("specified tag values:").append(e.getLocalizedMessage()).toString());
            member = new GMSMember(systemAdvertisement.getName(), null, null, null);
        }
        return member;
    }

    public static boolean isWatchDog(SystemAdvertisement sysAdv) {
        GMSMember member = JxtaUtil.getGMSMember(sysAdv);
        return GroupManagementService.MemberType.WATCHDOG.toString().equalsIgnoreCase(member.getMemberType());
    }
}

