/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.jxtamgmt;

import com.sun.enterprise.jxtamgmt.ClusterManager;
import com.sun.enterprise.jxtamgmt.JxtaUtil;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.XMLDocument;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.MessageElement;
import net.jxta.endpoint.MessageTransport;
import net.jxta.endpoint.StringMessageElement;
import net.jxta.endpoint.TextDocumentMessageElement;
import net.jxta.id.ID;
import net.jxta.impl.endpoint.router.EndpointRouter;
import net.jxta.impl.endpoint.router.RouteControl;
import net.jxta.impl.pipe.BlockingWireOutputPipe;
import net.jxta.peer.PeerID;
import net.jxta.pipe.InputPipe;
import net.jxta.pipe.OutputPipe;
import net.jxta.pipe.PipeMsgEvent;
import net.jxta.pipe.PipeMsgListener;
import net.jxta.pipe.PipeService;
import net.jxta.protocol.PipeAdvertisement;
import net.jxta.protocol.RouteAdvertisement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LWRMulticast
implements PipeMsgListener {
    private static final Logger LOG = Logger.getLogger(LWRMulticast.class.getName());
    public static final String NAMESPACE = "JXTAMCAST";
    public static final String ACKTAG = "ACK";
    public static final String SEQTAG = "SEQ";
    public static final String SRCIDTAG = "SRCID";
    private transient PipeAdvertisement pipeAdv;
    private transient PipeService pipeSvc;
    private transient InputPipe in;
    private transient OutputPipe outputPipe;
    private transient boolean closed = false;
    private transient boolean bound = false;
    private transient long padding = 250L;
    private transient long timeout = 5000L + this.padding;
    private transient MessageElement srcElement = null;
    private transient AtomicLong sequence = new AtomicLong();
    private final Object ackLock = new Object();
    private transient int threshold = 0;
    private transient Set<PeerID> ackSet = new HashSet<PeerID>();
    private transient Set<PeerID> ackList = new HashSet<PeerID>();
    private transient ConcurrentHashMap<PeerID, OutputPipe> pipeCache = new ConcurrentHashMap();
    private RouteControl routeControl = null;
    private MessageElement routeAdvElement = null;
    private static final String ROUTEADV = "ROUTE";
    private long t0 = System.currentTimeMillis();
    private ClusterManager manager;
    private PeerID localPeerID;
    protected transient PipeMsgListener msgListener;

    public LWRMulticast(ClusterManager manager, PipeAdvertisement pipeAd, PipeMsgListener msgListener) throws IOException {
        this.joinGroup(manager, pipeAd, msgListener);
    }

    public void joinGroup(ClusterManager manager, PipeAdvertisement pipeAd, PipeMsgListener msgListener) throws IOException {
        if (pipeAd.getType() != null && !pipeAd.getType().equals("JxtaPropagate")) {
            throw new IOException("Only propagate pipe advertisements are supported");
        }
        if (pipeAd.getPipeID() == null) {
            throw new IOException("Invalid pipe advertisement");
        }
        if (msgListener == null) {
            throw new IllegalArgumentException("msgListener can not be null");
        }
        this.manager = manager;
        this.localPeerID = manager.getNetPeerGroup().getPeerID();
        this.srcElement = new StringMessageElement(SRCIDTAG, this.localPeerID.toString(), null);
        MessageTransport endpointRouter = manager.getNetPeerGroup().getEndpointService().getMessageTransport("jxta");
        if (endpointRouter != null) {
            this.routeControl = (RouteControl)endpointRouter.transportControl(EndpointRouter.GET_ROUTE_CONTROL, null);
            RouteAdvertisement route = this.routeControl.getMyLocalRoute();
            if (route != null) {
                this.routeAdvElement = new TextDocumentMessageElement(ROUTEADV, (XMLDocument)route.getDocument(MimeMediaType.XMLUTF8), null);
            }
        }
        if (this.routeAdvElement == null) {
            LOG.warning("LWRMulticast(): bad constraints endpointRouter= " + endpointRouter + " routeControl=" + this.routeControl + " routeAdvElement=" + this.routeAdvElement);
        }
        this.msgListener = msgListener;
        this.pipeAdv = pipeAd;
        this.pipeSvc = manager.getNetPeerGroup().getPipeService();
        this.in = this.pipeSvc.createInputPipe(pipeAd, this);
        this.outputPipe = this.pipeSvc.createOutputPipe(pipeAd, 1L);
        LOG.log(Level.FINEST, "Statring LWRMulticast on pipe id :" + this.pipeAdv.getID());
        this.bound = true;
    }

    public boolean isBound() {
        return this.bound;
    }

    public synchronized void close() {
        if (this.closed) {
            return;
        }
        this.bound = false;
        this.closed = true;
        this.in.close();
        this.outputPipe.close();
        this.in = null;
    }

    @Override
    public void pipeMsgEvent(PipeMsgEvent event) {
        Message message = event.getMessage();
        if (message == null) {
            return;
        }
        PeerID id = LWRMulticast.getSource(message);
        if (id != null && id.equals(this.localPeerID)) {
            return;
        }
        MessageElement element2 = message.getMessageElement(NAMESPACE, ACKTAG);
        if (element2 != null) {
            this.processAck(id, element2.toString());
        } else {
            element2 = message.getMessageElement(NAMESPACE, SEQTAG);
            if (element2 != null) {
                this.ackMessage(id, element2);
                try {
                    if (this.msgListener != null) {
                        LOG.log(Level.FINEST, "Calling message listener");
                        this.msgListener.pipeMsgEvent(event);
                    }
                }
                catch (Throwable th) {
                    LOG.log(Level.FINEST, "Exception occurred while calling message listener", th);
                }
            }
        }
        this.processRoute(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processAck(PeerID id, String seq) {
        LOG.log(Level.FINEST, "Processing ack for message sequence " + seq);
        if (!this.ackSet.contains(id)) {
            this.ackSet.add(id);
            if (this.ackSet.size() >= this.threshold) {
                Object object = this.ackLock;
                synchronized (object) {
                    this.ackLock.notifyAll();
                }
            }
        }
    }

    private void ackMessage(PeerID id, MessageElement seq) {
        LOG.log(Level.FINEST, "Ack'ing message Sequence :" + seq.toString());
        Message msg = new Message();
        msg.addMessageElement(NAMESPACE, this.srcElement);
        msg.addMessageElement(NAMESPACE, new StringMessageElement(ACKTAG, seq.toString(), null));
        try {
            this.send(id, msg);
        }
        catch (IOException io) {
            LOG.log(Level.FINEST, "I/O Error occured " + io.toString());
        }
    }

    public Set<PeerID> getAckList() {
        return this.ackList;
    }

    public synchronized long getSoTimeout() {
        return this.timeout;
    }

    public synchronized void setSoTimeout(long timeout) throws IOException {
        this.checkState();
        this.timeout = timeout + this.padding;
    }

    public synchronized boolean isClosed() {
        return this.closed;
    }

    private void checkState() throws IOException {
        if (this.isClosed()) {
            throw new IOException("LWRMulticast is closed");
        }
        if (!this.isBound()) {
            throw new IOException("LWRMulticast not bound");
        }
    }

    public static long getSequenceID(Message msg) {
        MessageElement sel = msg.getMessageElement(NAMESPACE, SEQTAG);
        if (sel != null) {
            return Long.parseLong(sel.toString());
        }
        return -1L;
    }

    public static PeerID getSource(Message msg) {
        String addrStr = null;
        PeerID id = null;
        MessageElement sel = msg.getMessageElement(NAMESPACE, SRCIDTAG);
        if (sel != null) {
            try {
                addrStr = new String(sel.getBytes(false), 0, (int)sel.getByteLength(), "UTF8");
            }
            catch (UnsupportedEncodingException uee) {
                LOG.log(Level.FINEST, "Encoding Error occured " + uee.toString());
            }
        }
        if (addrStr != null) {
            id = (PeerID)ID.create(URI.create(addrStr));
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(Message msg, int threshold) throws IOException {
        if (threshold < 0) {
            throw new IllegalArgumentException("Invalid threshold " + threshold + " must be >= 0");
        }
        if (this.routeAdvElement != null && this.routeControl != null && this.sequence.intValue() < 2) {
            msg.addMessageElement(NAMESPACE, this.routeAdvElement);
        }
        this.t0 = System.currentTimeMillis();
        this.threshold = threshold;
        msg.addMessageElement(NAMESPACE, this.srcElement);
        long seq = this.sequence.getAndIncrement();
        msg.addMessageElement(NAMESPACE, new StringMessageElement(SEQTAG, Long.toString(seq), null));
        Object object = this.ackLock;
        synchronized (object) {
            this.ackList.clear();
            LOG.log(Level.FINEST, "Sending message sequence #: " + seq + " Threshold :" + threshold);
            this.send((PeerID)null, msg);
            if (threshold == 0) {
                return;
            }
            try {
                this.ackLock.wait(this.timeout);
                if (this.ackSet.size() >= threshold) {
                    this.ackList = new HashSet<PeerID>(this.ackSet);
                    this.ackSet.clear();
                    return;
                }
            }
            catch (InterruptedException ie) {
                LOG.log(Level.FINEST, "Interrupted " + ie.toString());
            }
            this.ackList = new HashSet<PeerID>(this.ackSet);
            this.ackSet.clear();
            if (this.ackList.size() < threshold) {
                throw new SocketTimeoutException("Failed to receive minimum acknowledments of " + threshold + " received :" + this.ackList.size());
            }
        }
    }

    public boolean send(PeerID pid, Message msg) throws IOException {
        this.checkState();
        OutputPipe op = null;
        if (this.routeAdvElement != null && this.routeControl != null && this.sequence.intValue() < 2) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest("LWRMulticast.send(Message, int) - sending routeAdv=" + this.routeAdvElement);
            }
            msg.addMessageElement(NAMESPACE, this.routeAdvElement);
        }
        LOG.log(Level.FINEST, "Sending a message");
        if (pid != null) {
            if (!this.pipeCache.containsKey(pid)) {
                RouteAdvertisement route = this.manager.getCachedRoute(pid);
                if (route != null) {
                    op = new BlockingWireOutputPipe(this.manager.getNetPeerGroup(), this.pipeAdv, pid, route);
                }
                if (op == null) {
                    op = this.pipeSvc.createOutputPipe(this.pipeAdv, Collections.singleton(pid), 1L);
                }
                this.pipeCache.put(pid, op);
            } else {
                op = this.pipeCache.get(pid);
            }
            return JxtaUtil.send(op, msg);
        }
        return JxtaUtil.send(this.outputPipe, msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean send(Set<PeerID> ids, Message msg) throws IOException {
        boolean sent = false;
        this.checkState();
        this.threshold = ids.size();
        this.ackList.clear();
        this.ackSet.clear();
        if (this.routeAdvElement != null && this.routeControl != null && this.sequence.intValue() < 2) {
            msg.addMessageElement(NAMESPACE, this.routeAdvElement);
        }
        LOG.log(Level.FINEST, "Sending a message");
        if (!ids.isEmpty()) {
            OutputPipe op = this.pipeSvc.createOutputPipe(this.pipeAdv, ids, 1000L);
            try {
                sent = JxtaUtil.send(op, msg);
                Object var6_5 = null;
                op.close();
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                op.close();
                throw throwable;
            }
            if (!sent) {
                return sent;
            }
            Object object = this.ackLock;
            synchronized (object) {
                try {
                    this.ackLock.wait(this.timeout);
                    if (this.ackSet.size() >= this.threshold) {
                        this.ackList = new HashSet<PeerID>(this.ackSet);
                        this.ackSet.clear();
                        return sent;
                    }
                }
                catch (InterruptedException ie) {
                    LOG.log(Level.FINEST, "Interrupted " + ie.toString());
                }
                if (this.ackSet.size() < this.threshold) {
                    this.ackList = new HashSet<PeerID>(this.ackSet);
                    this.ackSet.clear();
                    throw new SocketTimeoutException("Failed to receive minimum acknowledments of " + this.threshold + " received :" + this.ackSet.size());
                }
            }
        }
        return sent;
    }

    private void processRoute(Message msg) {
        try {
            MessageElement routeElement = msg.getMessageElement(NAMESPACE, ROUTEADV);
            if (routeElement != null) {
                XMLDocument asDoc = (XMLDocument)StructuredDocumentFactory.newStructuredDocument(routeElement.getMimeType(), routeElement.getStream());
                RouteAdvertisement route = (RouteAdvertisement)AdvertisementFactory.newAdvertisement(asDoc);
                this.manager.cacheRoute(route);
                if (this.routeControl != null) {
                    this.routeControl.addRoute(route);
                }
                if (LOG.isLoggable(Level.FINER)) {
                    LOG.finer("cached following route from msg " + msg + " route=" + route);
                }
            }
        }
        catch (IOException io) {
            LOG.log(Level.WARNING, io.getLocalizedMessage(), io);
        }
    }
}

