/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.jxtamgmt;

import com.sun.enterprise.jxtamgmt.ClusterManager;
import com.sun.enterprise.jxtamgmt.ClusterMessageListener;
import com.sun.enterprise.jxtamgmt.ClusterViewEventListener;
import com.sun.enterprise.jxtamgmt.LWRMulticast;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import net.jxta.document.AdvertisementFactory;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.MessageElement;
import net.jxta.endpoint.StringMessageElement;
import net.jxta.peer.PeerID;
import net.jxta.peergroup.PeerGroup;
import net.jxta.pipe.PipeID;
import net.jxta.pipe.PipeMsgEvent;
import net.jxta.pipe.PipeMsgListener;
import net.jxta.pipe.PipeService;
import net.jxta.protocol.PipeAdvertisement;

public class LWRMulticastSenderTest
implements PipeMsgListener {
    public static final String GRAMTAG = "GRAM";
    public static final String NAMESPACE = "TEST";
    private static PeerGroup netPeerGroup = null;
    ClusterManager manager;
    private static final String completeLock = "completeLock";
    private static PipeAdvertisement pipeAdv = null;
    private static final PipeService pipeService = null;

    public PipeAdvertisement getPipeAdvertisement() {
        PipeID pipeID = this.manager.getNetworkManager().getPipeID("multicasttest");
        PipeAdvertisement advertisement = (PipeAdvertisement)AdvertisementFactory.newAdvertisement(PipeAdvertisement.getAdvertisementType());
        advertisement.setPipeID(pipeID);
        advertisement.setType("JxtaPropagate");
        advertisement.setName("LWRMulticastTest");
        return advertisement;
    }

    public void pipeMsgEvent(PipeMsgEvent event) {
        Message message = event.getMessage();
        if (message == null) {
            return;
        }
        MessageElement gel = message.getMessageElement(NAMESPACE, GRAMTAG);
        if (gel == null) {
            return;
        }
        System.out.println("Received a gram :" + gel.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForever() {
        try {
            System.out.println("Waiting for Messages.");
            String string = completeLock;
            synchronized (completeLock) {
                completeLock.wait();
                // ** MonitorExit[var1_1] (shouldn't be in output)
                System.out.println("Done.");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        LWRMulticastSenderTest client = new LWRMulticastSenderTest();
        LWRMulticast mcast = null;
        client.manager = new ClusterManager("testGroup", "sender", new HashMap<String, String>(), new HashMap(), new ArrayList<ClusterViewEventListener>(), new ArrayList<ClusterMessageListener>());
        pipeAdv = client.getPipeAdvertisement();
        try {
            client.manager.start();
            netPeerGroup = client.manager.getNetPeerGroup();
            System.out.println("Node ID :" + netPeerGroup.getPeerID().toString());
            mcast = new LWRMulticast(client.manager, pipeAdv, client);
            for (int i = 0; i < 5; ++i) {
                Message msg = new Message();
                msg.addMessageElement(NAMESPACE, new StringMessageElement(GRAMTAG, "Message" + i, null));
                mcast.send(msg, 1);
                Set<PeerID> ack = mcast.getAckList();
                System.out.println("Received " + ack.size() + " ack's");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-1);
        }
        mcast.close();
        client.manager.stop(false);
    }
}

