/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.jxtamgmt;

import com.sun.enterprise.jxtamgmt.ClusterManager;
import com.sun.enterprise.jxtamgmt.ClusterMessageListener;
import com.sun.enterprise.jxtamgmt.ClusterViewEventListener;
import com.sun.enterprise.jxtamgmt.LWRMulticast;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import net.jxta.document.AdvertisementFactory;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.StringMessageElement;
import net.jxta.id.IDFactory;
import net.jxta.peer.PeerID;
import net.jxta.peergroup.PeerGroup;
import net.jxta.pipe.PipeID;
import net.jxta.pipe.PipeMsgEvent;
import net.jxta.pipe.PipeMsgListener;
import net.jxta.protocol.PipeAdvertisement;

public class LWRMulticastTest
implements PipeMsgListener {
    public static final String PIPEIDSTR = "urn:jxta:uuid-59616261646162614E504720503250336FA944D18E8A4131AA74BB6F4FF85DEF04";
    private static PeerGroup netPeerGroup = null;
    private static PipeAdvertisement pipeAdv = null;
    private static ClusterManager manager = null;
    private static String groupName = "testGroup";
    private static String instanceName = "testInstance." + System.nanoTime();
    public static final String GRAMTAG = "GRAM";
    public static final String NAMESPACE = "TEST";
    private LWRMulticast mcast = null;

    public static PipeAdvertisement getPipeAdvertisement() {
        PipeID pipeID = null;
        try {
            pipeID = (PipeID)IDFactory.fromURI(new URI(PIPEIDSTR));
        }
        catch (URISyntaxException use) {
            use.printStackTrace();
        }
        PipeAdvertisement advertisement = (PipeAdvertisement)AdvertisementFactory.newAdvertisement(PipeAdvertisement.getAdvertisementType());
        advertisement.setPipeID(pipeID);
        advertisement.setType("JxtaPropagate");
        advertisement.setName("LWRMulticastTest");
        return advertisement;
    }

    public static String getGroupName() {
        return groupName;
    }

    public static String getInstanceName() {
        return instanceName;
    }

    public static void setGroupName(String _groupName) {
        if (manager != null) {
            groupName = _groupName;
        }
    }

    public static void setInstanceName(String _instanceName) {
        if (manager != null) {
            instanceName = _instanceName;
        }
    }

    public static boolean startManager() {
        if (manager != null) {
            return true;
        }
        pipeAdv = LWRMulticastTest.getPipeAdvertisement();
        manager = new ClusterManager(groupName, instanceName, new HashMap<String, String>(), new HashMap(), new ArrayList<ClusterViewEventListener>(), new ArrayList<ClusterMessageListener>());
        try {
            manager.start();
            netPeerGroup = manager.getNetworkManager().getNetPeerGroup();
            System.out.println("Network manager started.");
            System.out.println("Node ID :" + LWRMulticastTest.getNodeID());
        }
        catch (Exception e) {
            e.printStackTrace();
            manager = null;
            return false;
        }
        return true;
    }

    public static String getNodeID() {
        if (netPeerGroup != null) {
            return netPeerGroup.getPeerID().toString();
        }
        return null;
    }

    public static void stopManager() {
        if (manager != null) {
            manager.stop(false);
            manager = null;
        }
    }

    public void pipeMsgEvent(PipeMsgEvent event) {
        Message.ElementIterator iter = this.getMessageElements(event.getMessage());
        while (iter.hasNext()) {
            System.out.println("Received a gram :" + iter.next().toString());
        }
    }

    public LWRMulticastTest() {
        this(null);
    }

    public LWRMulticastTest(PipeMsgListener listener) {
        if (listener == null) {
            listener = this;
        }
        try {
            if (LWRMulticastTest.startManager()) {
                this.mcast = new LWRMulticast(manager, pipeAdv, listener);
                this.mcast.setSoTimeout(6000L);
            } else {
                System.out.println("Failed to start Network Manager");
            }
        }
        catch (Exception e) {
            this.mcast = null;
            e.printStackTrace();
        }
    }

    public int sendMessage(String msgString) {
        return this.sendMessage(msgString, 1);
    }

    public int sendMessage(String msgString, int numReceivers) {
        try {
            Message msg = new Message();
            msg.addMessageElement(NAMESPACE, new StringMessageElement(GRAMTAG, msgString, null));
            this.mcast.send(msg, numReceivers);
            Set<PeerID> ack = this.mcast.getAckList();
            return ack.size();
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    public Message.ElementIterator getMessageElements(Message message) {
        if (message != null) {
            return message.getMessageElements(NAMESPACE, "SEQ");
        }
        return null;
    }

    public void close() {
        this.mcast.close();
    }
}

