/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.jxtamgmt;

import com.sun.enterprise.ee.cms.core.GMSConstants;
import com.sun.enterprise.ee.cms.core.GMSMember;
import com.sun.enterprise.ee.cms.impl.common.GMSContextFactory;
import com.sun.enterprise.ee.cms.impl.jxta.CustomTagNames;
import com.sun.enterprise.ee.cms.impl.jxta.GMSContext;
import com.sun.enterprise.jxtamgmt.ClusterManager;
import com.sun.enterprise.jxtamgmt.ClusterView;
import com.sun.enterprise.jxtamgmt.ClusterViewEvent;
import com.sun.enterprise.jxtamgmt.ClusterViewEvents;
import com.sun.enterprise.jxtamgmt.ClusterViewManager;
import com.sun.enterprise.jxtamgmt.HealthMessage;
import com.sun.enterprise.jxtamgmt.JxtaUtil;
import com.sun.enterprise.jxtamgmt.SystemAdvertisement;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.XMLDocument;
import net.jxta.endpoint.ByteArrayMessageElement;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.MessageElement;
import net.jxta.endpoint.MessageTransport;
import net.jxta.endpoint.StringMessageElement;
import net.jxta.endpoint.TextDocumentMessageElement;
import net.jxta.id.ID;
import net.jxta.impl.endpoint.router.EndpointRouter;
import net.jxta.impl.endpoint.router.RouteControl;
import net.jxta.impl.pipe.BlockingWireOutputPipe;
import net.jxta.peer.PeerID;
import net.jxta.peergroup.PeerGroup;
import net.jxta.pipe.InputPipe;
import net.jxta.pipe.OutputPipe;
import net.jxta.pipe.PipeMsgEvent;
import net.jxta.pipe.PipeMsgListener;
import net.jxta.pipe.PipeService;
import net.jxta.protocol.PipeAdvertisement;
import net.jxta.protocol.RouteAdvertisement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MasterNode
implements PipeMsgListener,
Runnable {
    private static final Logger LOG = JxtaUtil.getLogger(MasterNode.class.getName());
    private static final Logger masterLogger = Logger.getLogger("ShoalLogger.MasterNode");
    private final ClusterManager manager;
    private InputPipe inputPipe;
    private OutputPipe outputPipe;
    private boolean masterAssigned = false;
    private volatile boolean discoveryInProgress = true;
    private ID localNodeID = ID.nullID;
    private final SystemAdvertisement sysAdv;
    private PipeAdvertisement pipeAdv = null;
    private final PipeService pipeService;
    private final MessageElement sysAdvElement;
    private MessageElement routeAdvElement = null;
    private volatile boolean started = false;
    private volatile boolean stop = false;
    private Thread thread = null;
    private ClusterViewManager clusterViewManager;
    private ClusterView discoveryView;
    private final AtomicLong masterViewID = new AtomicLong();
    final Object MASTERLOCK = new Object();
    private static final String CCNTL = "CCNTL";
    private static final String MASTERNODE = "MN";
    private static final String MASTERQUERY = "MQ";
    private static final String NODEQUERY = "NQ";
    private static final String MASTERNODERESPONSE = "MR";
    private static final String NODERESPONSE = "NR";
    private static final String NAMESPACE = "MASTER";
    private static final String NODEADV = "NAD";
    private static final String ROUTEADV = "ROUTE";
    private static final String AMASTERVIEW = "AMV";
    private static final String MASTERVIEWSEQ = "SEQ";
    private static final String GROUPSTARTING = "GS";
    private static final String GROUPSTARTUPCOMPLETE = "GSC";
    private int interval = 6;
    private long timeout = 10000L;
    private static final String VIEW_CHANGE_EVENT = "VCE";
    private RouteControl routeControl = null;
    private MessageTransport endpointRouter = null;
    private transient ConcurrentHashMap<ID, OutputPipe> pipeCache = new ConcurrentHashMap();
    private boolean groupStarting = false;
    private List<String> groupStartingMembers = null;
    private final Timer timer;
    private DelayedSetGroupStartingCompleteTask groupStartingTask = null;
    private static final long MAX_GROUPSTARTING_TIME = 240000L;
    private static final long GROUPSTARTING_COMPLETE_DELAY = 30000L;
    private boolean clusterStopping = false;
    final Object discoveryLock = new Object();
    private GMSContext ctx = null;

    MasterNode(ClusterManager manager, long timeout, int interval) {
        PeerGroup group = manager.getNetPeerGroup();
        this.pipeService = group.getPipeService();
        this.localNodeID = group.getPeerID();
        if (timeout > 0L) {
            this.timeout = timeout;
        }
        this.interval = interval;
        this.manager = manager;
        this.sysAdv = manager.getSystemAdvertisement();
        this.discoveryView = new ClusterView(this.sysAdv);
        this.sysAdvElement = new TextDocumentMessageElement(NODEADV, (XMLDocument)manager.getSystemAdvertisement().getDocument(MimeMediaType.XMLUTF8), null);
        this.endpointRouter = group.getEndpointService().getMessageTransport("jxta");
        if (this.endpointRouter != null) {
            this.routeControl = (RouteControl)this.endpointRouter.transportControl(EndpointRouter.GET_ROUTE_CONTROL, null);
            RouteAdvertisement route = this.routeControl.getMyLocalRoute();
            if (route != null) {
                this.routeAdvElement = new TextDocumentMessageElement(ROUTEADV, (XMLDocument)route.getDocument(MimeMediaType.XMLUTF8), null);
            }
        }
        if (this.routeAdvElement == null) {
            LOG.warning("MasterNode constructor: bad constraints endpointRouter= " + this.endpointRouter + " routeControl=" + this.routeControl + " routeAdvElement=" + this.routeAdvElement);
        } else if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("MasterNode() routeAdvElement=" + this.routeAdvElement);
        }
        try {
            this.pipeAdv = this.createPipeAdv();
            this.outputPipe = this.pipeService.createOutputPipe(this.pipeAdv, 0L);
        }
        catch (IOException io) {
            io.printStackTrace();
            LOG.log(Level.WARNING, "Failed to create master outputPipe : " + io);
        }
        this.timer = new Timer(true);
    }

    void removePipeFromCache(ID token) {
        this.pipeCache.remove(token);
    }

    void clearPipeCache() {
        this.pipeCache.clear();
    }

    long getTimeout() {
        return this.timeout * (long)this.interval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean checkMaster(SystemAdvertisement systemAdv) {
        if (this.masterAssigned && this.isMaster()) {
            LOG.log(Level.FINER, "checkMaster : clusterStopping() = " + this.clusterStopping);
            if (this.clusterStopping) {
                LOG.log(Level.FINER, "Resigning Master Node role in anticipation of a master node announcement");
                LOG.log(Level.FINER, "Accepting DAS as new master in the event of cluster stopping...");
                this.clusterViewManager.setMaster(systemAdv, false);
                this.masterAssigned = true;
                return false;
            }
            LOG.log(Level.FINER, "Master node role collision with " + systemAdv.getName() + " .... attempting to resolve");
            this.send(systemAdv.getID(), systemAdv.getName(), this.createMasterCollisionMessage());
            if (this.manager.getNodeID().toString().compareTo(systemAdv.getID().toString()) >= 0) {
                LOG.log(Level.FINER, "Affirming Master Node role");
            } else {
                LOG.log(Level.FINER, "Resigning Master Node role in anticipation of a master node announcement");
                this.clusterViewManager.setMaster(systemAdv, false);
            }
            return false;
        }
        this.clusterViewManager.setMaster(systemAdv, true);
        this.masterAssigned = true;
        Object object = this.MASTERLOCK;
        synchronized (object) {
            this.MASTERLOCK.notifyAll();
        }
        LOG.log(Level.FINE, "Discovered a Master node :" + systemAdv.getName());
        return true;
    }

    private Message createMasterCollisionMessage() {
        Message msg = this.createSelfNodeAdvertisement();
        StringMessageElement el = new StringMessageElement(CCNTL, this.localNodeID.toString(), null);
        msg.addMessageElement(NAMESPACE, el);
        LOG.log(Level.FINER, "Created a Master Collision Message");
        return msg;
    }

    private Message createSelfNodeAdvertisement() {
        Message msg = new Message();
        msg.addMessageElement(NAMESPACE, this.sysAdvElement);
        return msg;
    }

    private void sendSelfNodeAdvertisement(ID id, String name) {
        Message msg = this.createSelfNodeAdvertisement();
        LOG.log(Level.FINER, "Sending a Node Response Message ");
        StringMessageElement el = new StringMessageElement(NODERESPONSE, "noderesponse", null);
        msg.addMessageElement(NAMESPACE, el);
        this.send(id, name, msg);
    }

    private void sendGroupStartupComplete() {
        Message msg = this.createSelfNodeAdvertisement();
        LOG.log(Level.FINER, "Sending GroupStartupComplete Message for group:" + this.manager.getGroupName());
        StringMessageElement el = new StringMessageElement(GROUPSTARTUPCOMPLETE, "true", null);
        msg.addMessageElement(NAMESPACE, el);
        this.send(null, null, msg);
    }

    private Message createMasterQuery() {
        Message msg = this.createSelfNodeAdvertisement();
        StringMessageElement el = new StringMessageElement(MASTERQUERY, "query", null);
        msg.addMessageElement(NAMESPACE, el);
        this.addRoute(msg);
        LOG.log(Level.FINER, "Created a Master Node Query Message ");
        return msg;
    }

    void addRoute(Message msg) {
        if (this.routeAdvElement != null && this.routeControl != null) {
            msg.addMessageElement(NAMESPACE, this.routeAdvElement);
        } else if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("addRoute(): Did not add route to msg " + msg + " routeAdvElement=" + this.routeAdvElement + " routeControl=" + this.routeControl);
        }
    }

    private Message createNodeQuery() {
        Message msg = this.createSelfNodeAdvertisement();
        StringMessageElement el = new StringMessageElement(NODEQUERY, "nodequery", null);
        msg.addMessageElement(NAMESPACE, el);
        this.addRoute(msg);
        LOG.log(Level.FINER, "Created a Node Query Message ");
        return msg;
    }

    private Message createMasterResponse(boolean announcement, ID masterID) {
        Message msg = this.createSelfNodeAdvertisement();
        String type = MASTERNODE;
        if (!announcement) {
            type = MASTERNODERESPONSE;
        }
        StringMessageElement el = new StringMessageElement(type, masterID.toString(), null);
        msg.addMessageElement(NAMESPACE, el);
        if (this.groupStarting) {
            StringMessageElement e2 = new StringMessageElement(GROUPSTARTING, Boolean.toString(this.groupStarting), null);
            msg.addMessageElement(NAMESPACE, e2);
        }
        this.addRoute(msg);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "Created a Master Response Message with masterId = " + masterID.toString() + " groupStarting=" + Boolean.toString(this.groupStarting));
        }
        return msg;
    }

    private PipeAdvertisement createPipeAdv() {
        PipeAdvertisement pipeAdv = (PipeAdvertisement)AdvertisementFactory.newAdvertisement(PipeAdvertisement.getAdvertisementType());
        pipeAdv.setPipeID(this.manager.getNetworkManager().getMasterPipeID());
        pipeAdv.setType("JxtaPropagate");
        return pipeAdv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean discoverMaster() {
        this.masterViewID.set(this.clusterViewManager.getMasterViewID());
        long timeToWait = this.timeout;
        LOG.log(Level.FINER, "Attempting to discover a master node");
        Message query = this.createMasterQuery();
        this.send(null, null, query);
        LOG.log(Level.FINER, " waiting for " + this.timeout + " ms");
        try {
            Object object = this.MASTERLOCK;
            synchronized (object) {
                this.MASTERLOCK.wait(timeToWait);
            }
        }
        catch (InterruptedException intr) {
            Thread.interrupted();
            LOG.log(Level.FINER, "Thread interrupted", intr);
        }
        LOG.log(Level.FINE, "masterAssigned=" + this.masterAssigned);
        return this.masterAssigned;
    }

    boolean isMaster() {
        if (masterLogger.isLoggable(Level.FINER)) {
            masterLogger.log(Level.FINER, "isMaster :" + this.clusterViewManager.isMaster() + " MasterAssigned :" + this.masterAssigned + " View Size :" + this.clusterViewManager.getViewSize());
        } else {
            LOG.log(Level.FINER, "isMaster :" + this.clusterViewManager.isMaster() + " MasterAssigned :" + this.masterAssigned + " View Size :" + this.clusterViewManager.getViewSize());
        }
        return this.clusterViewManager.isMaster();
    }

    boolean isMasterAssigned() {
        return this.masterAssigned;
    }

    ID getMasterNodeID() {
        return this.clusterViewManager.getMaster().getID();
    }

    synchronized boolean isStarted() {
        return this.started;
    }

    void resetMaster() {
        LOG.log(Level.FINER, "Resetting Master view");
        this.masterAssigned = false;
    }

    SystemAdvertisement processNodeAdvertisement(Message msg) throws IOException {
        MessageElement msgElement = msg.getMessageElement(NAMESPACE, NODEADV);
        if (msgElement == null) {
            LOG.log(Level.WARNING, "Missing NODEADV message element");
            JxtaUtil.printMessageStats(msg, false);
            return null;
        }
        StructuredDocument asDoc = StructuredDocumentFactory.newStructuredDocument(msgElement.getMimeType(), msgElement.getStream());
        SystemAdvertisement adv = new SystemAdvertisement(asDoc);
        if (!adv.getID().equals(this.localNodeID)) {
            LOG.log(Level.FINER, "Received a System advertisment Name :" + adv.getName());
        }
        return adv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean processMasterNodeAnnouncement(Message msg, SystemAdvertisement source) throws IOException {
        GMSMember member = JxtaUtil.getGMSMember(source);
        MessageElement msgElement = msg.getMessageElement(NAMESPACE, MASTERNODE);
        if (msgElement == null) {
            return false;
        }
        this.processRoute(msg);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Received a Master Node Announcement from  member:" + member.getMemberToken() + " of group:" + member.getGroupName());
        }
        if (this.checkMaster(source) && (msgElement = msg.getMessageElement(NAMESPACE, AMASTERVIEW)) != null) {
            ArrayList newLocalView = (ArrayList)JxtaUtil.getObjectFromByteArray(msgElement);
            if (newLocalView != null) {
                LOG.log(Level.FINER, MessageFormat.format("Received an authoritative view from {0}, of size {1} resetting local view containing {2}", source.getName(), newLocalView.size(), this.clusterViewManager.getLocalView().getSize()));
            }
            long seqID = MasterNode.getLongFromMessage(msg, NAMESPACE, MASTERVIEWSEQ);
            msgElement = msg.getMessageElement(NAMESPACE, VIEW_CHANGE_EVENT);
            if (msgElement != null) {
                LOG.log(Level.FINE, "MasterNode:PMNA: Received Master View with Seq Id=" + seqID + "Current sequence is " + this.clusterViewManager.getMasterViewID());
                if (!this.isDiscoveryInProgress() && seqID <= this.clusterViewManager.getMasterViewID()) {
                    LOG.log(Level.WARNING, MessageFormat.format("Received an older clusterView sequence {0}. Current sequence :{1} discarding out of sequence view", seqID, this.clusterViewManager.getMasterViewID()));
                    return true;
                }
                ClusterViewEvent cvEvent = (ClusterViewEvent)JxtaUtil.getObjectFromByteArray(msgElement);
                assert (newLocalView != null);
                if (!newLocalView.contains(this.manager.getSystemAdvertisement())) {
                    LOG.log(Level.FINE, "New ClusterViewManager does not contain self. Publishing Self");
                    this.sendSelfNodeAdvertisement(source.getID(), null);
                    return true;
                }
                this.clusterViewManager.setMasterViewID(seqID);
                this.masterViewID.set(seqID);
                LOG.log(Level.FINE, "MN: New MasterViewID = " + this.clusterViewManager.getMasterViewID());
                this.clusterViewManager.addToView(newLocalView, true, cvEvent);
            } else {
                LOG.log(Level.WARNING, "New View Received without corresponding ViewChangeEvent details");
            }
        }
        Object object = this.MASTERLOCK;
        synchronized (object) {
            this.MASTERLOCK.notifyAll();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean processMasterNodeResponse(Message msg, SystemAdvertisement source) throws IOException {
        MessageElement msgElement = msg.getMessageElement(NAMESPACE, MASTERNODERESPONSE);
        if (msgElement == null) {
            return false;
        }
        LOG.log(Level.FINE, "Received a MasterNode Response from Name :" + source.getName());
        msgElement = msg.getMessageElement(NAMESPACE, GROUPSTARTING);
        if (msgElement != null) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "MNR indicates GroupStart for group: " + this.manager.getGroupName());
            }
            this.setGroupStarting(true);
            this.delayedSetGroupStarting(false, 240000L);
        }
        this.processRoute(msg);
        msgElement = msg.getMessageElement(NAMESPACE, AMASTERVIEW);
        if (msgElement == null) {
            this.clusterViewManager.setMaster(source, true);
            this.masterAssigned = true;
            return true;
        }
        ArrayList newLocalView = (ArrayList)JxtaUtil.getObjectFromByteArray(msgElement);
        msgElement = msg.getMessageElement(NAMESPACE, VIEW_CHANGE_EVENT);
        if (msgElement == null) {
            this.clusterViewManager.setMaster(source, true);
            this.masterAssigned = true;
            return true;
        }
        long seqID = MasterNode.getLongFromMessage(msg, NAMESPACE, MASTERVIEWSEQ);
        LOG.log(Level.FINE, "MasterNode:PMNR Received Master View with Seq Id=" + seqID);
        if (!this.isDiscoveryInProgress() && seqID <= this.clusterViewManager.getMasterViewID()) {
            this.clusterViewManager.setMaster(source, true);
            this.masterAssigned = true;
            LOG.log(Level.WARNING, MessageFormat.format("Received an older clusterView sequence {0} of size :{1} Current sequence :{2} discarding out of sequence view", seqID, newLocalView.size(), this.clusterViewManager.getMasterViewID()));
            return true;
        }
        LOG.log(Level.FINE, MessageFormat.format("Received a VIEW_CHANGE_EVENT from : {0}, seqID of :{1}, size :{2}  localSeqId : {3}", source.getName(), seqID, newLocalView.size(), this.clusterViewManager.getMasterViewID()));
        ClusterViewEvent cvEvent = (ClusterViewEvent)JxtaUtil.getObjectFromByteArray(msgElement);
        if (!newLocalView.contains(this.manager.getSystemAdvertisement())) {
            this.clusterViewManager.setMaster(source, true);
            this.masterAssigned = true;
            LOG.log(Level.FINE, "Received view does not contain self. Publishing self");
            this.sendSelfNodeAdvertisement(source.getID(), null);
            return true;
        }
        this.clusterViewManager.setMasterViewID(seqID);
        this.masterViewID.set(seqID);
        boolean masterChanged = this.clusterViewManager.setMaster(newLocalView, source);
        this.masterAssigned = true;
        if (masterChanged) {
            this.clusterViewManager.notifyListeners(cvEvent);
        } else {
            this.clusterViewManager.addToView(newLocalView, true, cvEvent);
        }
        Object object = this.MASTERLOCK;
        synchronized (object) {
            this.MASTERLOCK.notifyAll();
        }
        return true;
    }

    boolean processGroupStartupComplete(Message msg, SystemAdvertisement source) throws IOException {
        MessageElement msgElement = msg.getMessageElement(NAMESPACE, GROUPSTARTUPCOMPLETE);
        if (msgElement == null) {
            return false;
        }
        this.delayedSetGroupStarting(false, 30000L);
        return true;
    }

    boolean processChangeEvent(Message msg, SystemAdvertisement source) throws IOException {
        MessageElement msgElement = msg.getMessageElement(NAMESPACE, VIEW_CHANGE_EVENT);
        LOG.log(Level.FINER, "Inside processChangeEvent for group: " + this.manager.getGroupName());
        if (msgElement != null) {
            ClusterViewEvent cvEvent = (ClusterViewEvent)JxtaUtil.getObjectFromByteArray(msgElement);
            msgElement = msg.getMessageElement(NAMESPACE, AMASTERVIEW);
            if (msgElement != null && cvEvent != null) {
                long seqID;
                if (cvEvent.getEvent() == ClusterViewEvents.JOINED_AND_READY_EVENT && cvEvent.getAdvertisement().getID().equals(this.localNodeID)) {
                    this.manager.getHealthMonitor().setJoinedAndReadyReceived();
                }
                if ((seqID = MasterNode.getLongFromMessage(msg, NAMESPACE, MASTERVIEWSEQ)) <= this.clusterViewManager.getMasterViewID()) {
                    LOG.log(Level.WARNING, MessageFormat.format("Received a stale clusterview, older clusterview sequence {0}. Current sequence :{1} discarding out of sequence view.  Notified listeners of ChangeEvent={2} from {3} for group: {4}", seqID, this.clusterViewManager.getMasterViewID(), cvEvent.getEvent().toString(), cvEvent.getAdvertisement().getName(), this.manager.getGroupName()));
                    this.clusterViewManager.notifyListeners(cvEvent);
                    return true;
                }
                ArrayList newLocalView = (ArrayList)JxtaUtil.getObjectFromByteArray(msgElement);
                LOG.log(Level.FINER, MessageFormat.format("Received a new view of size :{0}, event :{1}", newLocalView.size(), cvEvent.getEvent().toString()));
                if (!newLocalView.contains(this.manager.getSystemAdvertisement())) {
                    LOG.log(Level.FINER, "Received ClusterViewManager does not contain self. Publishing Self");
                    this.sendSelfNodeAdvertisement(source.getID(), null);
                    return true;
                }
                this.clusterViewManager.setMasterViewID(seqID);
                this.masterViewID.set(seqID);
                this.clusterViewManager.addToView(newLocalView, true, cvEvent);
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean processMasterNodeQuery(Message msg, SystemAdvertisement adv, boolean isAdvAddedToView) throws IOException {
        MessageElement msgElement = msg.getMessageElement(NAMESPACE, MASTERQUERY);
        if (msgElement == null || adv == null) {
            return false;
        }
        this.processRoute(msg);
        if (this.isMaster() && this.masterAssigned) {
            LOG.log(Level.FINE, MessageFormat.format("Received a MasterNode Query from Name :{0} ID :{1}", adv.getName(), adv.getID()));
            if (isAdvAddedToView) {
                ClusterViewEvent cvEvent = new ClusterViewEvent(ClusterViewEvents.ADD_EVENT, adv);
                Message masterResponseMsg = this.createMasterResponse(false, this.localNodeID);
                AtomicLong atomicLong = this.masterViewID;
                synchronized (atomicLong) {
                    this.clusterViewManager.setMasterViewID(this.masterViewID.incrementAndGet());
                    this.addAuthoritativeView(masterResponseMsg);
                }
                this.clusterViewManager.notifyListeners(cvEvent);
                this.sendNewView(null, cvEvent, masterResponseMsg, false);
            } else {
                LOG.log(Level.FINER, "Node " + adv.getName() + " is already in the view. Hence not sending ADD_EVENT.");
            }
        }
        SystemAdvertisement madv = this.clusterViewManager.getMaster();
        SystemAdvertisement oldSysAdv = this.clusterViewManager.get(adv.getID());
        if (madv != null && adv != null && madv.getID().equals(adv.getID())) {
            if (this.confirmInstanceHasRestarted(oldSysAdv, adv)) {
                LOG.warning("Previously elected Master node " + madv.getName() + " has restarted. There was no failure notification sent out for it.");
                if (LOG.isLoggable(Level.FINER)) {
                    LOG.finer("MasterNode.processMasterNodeQuery() : clusterViewManager.getMaster().getID() = " + this.clusterViewManager.getMaster().getID());
                    LOG.finer("MasterNode.processMasterNodeQuery() : adv.getID() = " + adv.getID());
                    LOG.finer("MasterNode.processMasterNodeQuery() : clusterViewManager.getMaster().getname() = " + this.clusterViewManager.getMaster().getName());
                    LOG.finer("MasterNode.processMasterNodeQuery() : adv.getID() = " + adv.getName());
                }
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("MasterNode.processMasterNodeQuery() : re-electing the master...");
                }
                this.manager.getClusterViewManager().remove(adv);
                this.manager.getClusterViewManager().add(adv);
                this.resetMaster();
                this.appointMasterNode();
            } else {
                LOG.fine("MasterNode.processMasterNodeQuery() : master node did not restart as suspected");
            }
        } else {
            this.confirmInstanceHasRestarted(oldSysAdv, adv);
        }
        return true;
    }

    boolean confirmInstanceHasRestarted(SystemAdvertisement oldSysAdv, SystemAdvertisement newSysAdv) {
        if (oldSysAdv != null && newSysAdv != null) {
            LOG.fine("MasterNode.confirmInstanceHasRestarted() : oldSysAdv.getName() = " + oldSysAdv.getName());
            long cachedAdvStartTime = -1L;
            try {
                cachedAdvStartTime = Long.valueOf(oldSysAdv.getCustomTagValue(CustomTagNames.START_TIME.toString()));
                LOG.fine("MasterNode.confirmInstanceHasRestarted() : cachedAdvStartTime = " + cachedAdvStartTime);
            }
            catch (NoSuchFieldException ex) {
                LOG.fine("MasterNode.confirmInstanceHasRestarted : Could not find the START_TIME field in the cached system advertisement");
                return false;
            }
            if (cachedAdvStartTime != -1L) {
                long currentAdvStartTime = -1L;
                try {
                    currentAdvStartTime = Long.valueOf(newSysAdv.getCustomTagValue(CustomTagNames.START_TIME.toString()));
                }
                catch (NoSuchFieldException ex) {
                    LOG.fine("MasterNode.confirmInstanceHasRestarted : Could not find the START_TIME field in the current system advertisement");
                    return false;
                }
                LOG.fine("MasterNode.confirmInstanceHasRestarted() : currentAdvStartTime = " + currentAdvStartTime);
                if (currentAdvStartTime != cachedAdvStartTime) {
                    this.manager.getHealthMonitor().cleanAllCaches(oldSysAdv.getName());
                    LOG.log(Level.WARNING, MessageFormat.format("Instance {0} was restarted at  {1,time,full} on {1,date}.", newSysAdv.getName(), new Date(currentAdvStartTime)));
                    LOG.log(Level.WARNING, MessageFormat.format("Note that there was no Failure notification sent out for this instance that was previously started at  {0,time,full} on {0,date}", new Date(cachedAdvStartTime)));
                    return true;
                }
                LOG.fine("MasterNode.confirmInstanceHasRestarted : currentAdvStartTime and cachedAdvStartTime have the same value = " + new Date(cachedAdvStartTime) + " .Instance " + newSysAdv.getName() + "was not restarted.");
                return false;
            }
            LOG.fine("MasterNode.confirmInstanceHasRestarted : cachedAdvStartTime does not havea valid value = " + cachedAdvStartTime);
            return false;
        }
        LOG.fine("MasterNode.confirmInstanceHasRestarted : oldSysAdv or newSysAdv is null");
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean processNodeQuery(Message msg, SystemAdvertisement adv, boolean isAdvAddedToView) throws IOException {
        MessageElement msgElement = msg.getMessageElement(NAMESPACE, NODEQUERY);
        if (msgElement == null || adv == null) {
            return false;
        }
        this.processRoute(msg);
        LOG.log(Level.FINER, MessageFormat.format("Received a Node Query from Name :{0} ID :{1}", adv.getName(), adv.getID()));
        if (this.isMaster() && this.masterAssigned) {
            LOG.log(Level.FINE, MessageFormat.format("Received a Node Query from Name :{0} ID :{1}", adv.getName(), adv.getID()));
            if (isAdvAddedToView) {
                ClusterViewEvent cvEvent = new ClusterViewEvent(ClusterViewEvents.ADD_EVENT, adv);
                Message responseMsg = this.createMasterResponse(false, this.localNodeID);
                AtomicLong atomicLong = this.masterViewID;
                synchronized (atomicLong) {
                    this.clusterViewManager.setMasterViewID(this.masterViewID.incrementAndGet());
                    this.addAuthoritativeView(responseMsg);
                }
                this.clusterViewManager.notifyListeners(cvEvent);
                this.sendNewView(null, cvEvent, responseMsg, false);
            } else {
                LOG.log(Level.FINER, "Node " + adv.getName() + " is already in the view. Hence not sending ADD_EVENT.");
            }
        } else {
            Message response = this.createSelfNodeAdvertisement();
            StringMessageElement el = new StringMessageElement(NODERESPONSE, "noderesponse", null);
            response.addMessageElement(NAMESPACE, el);
            LOG.log(Level.FINER, "Sending Node response to  :" + adv.getName());
            this.send(adv.getID(), null, response);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean processNodeResponse(Message msg, SystemAdvertisement adv, boolean isAdvAddedToView) throws IOException {
        MessageElement msgElement = msg.getMessageElement(NAMESPACE, NODERESPONSE);
        if (msgElement == null || adv == null) {
            return false;
        }
        this.processRoute(msg);
        if (this.isMaster() && this.masterAssigned) {
            LOG.log(Level.FINE, MessageFormat.format("Received a Node Response from Name :{0} ID :{1}", adv.getName(), adv.getID()));
            if (isAdvAddedToView) {
                ClusterViewEvent cvEvent = new ClusterViewEvent(ClusterViewEvents.ADD_EVENT, adv);
                Message responseMsg = this.createMasterResponse(false, this.localNodeID);
                AtomicLong atomicLong = this.masterViewID;
                synchronized (atomicLong) {
                    this.clusterViewManager.setMasterViewID(this.masterViewID.incrementAndGet());
                    this.addAuthoritativeView(responseMsg);
                }
                this.clusterViewManager.notifyListeners(cvEvent);
                this.sendNewView(null, cvEvent, responseMsg, false);
            } else {
                LOG.log(Level.FINER, "Node " + adv.getName() + " is already in the view. Hence not sending ADD_EVENT.");
            }
        }
        return true;
    }

    void processRoute(Message msg) {
        LOG.log(Level.FINER, "Inside processRoute...");
        try {
            MessageElement routeElement = msg.getMessageElement(NAMESPACE, ROUTEADV);
            if (routeElement != null) {
                XMLDocument asDoc = (XMLDocument)StructuredDocumentFactory.newStructuredDocument(routeElement.getMimeType(), routeElement.getStream());
                RouteAdvertisement route = (RouteAdvertisement)AdvertisementFactory.newAdvertisement(asDoc);
                this.manager.cacheRoute(route);
                if (this.routeControl != null) {
                    this.routeControl.addRoute(route);
                }
                if (LOG.isLoggable(Level.FINER)) {
                    LOG.finer("cached following route from msg " + msg + " route=" + route);
                }
            }
        }
        catch (IOException io) {
            io.printStackTrace();
            LOG.log(Level.WARNING, io.getLocalizedMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean processMasterNodeCollision(Message msg, SystemAdvertisement adv) throws IOException {
        MessageElement msgElement = msg.getMessageElement(NAMESPACE, CCNTL);
        if (msgElement == null) {
            return false;
        }
        LOG.log(Level.FINER, MessageFormat.format("Received a MasterNode Collision from Name :{0} ID :{1}", adv.getName(), adv.getID()));
        SystemAdvertisement madv = this.manager.getSystemAdvertisement();
        LOG.log(Level.FINER, "Candidate Master :" + madv.getName());
        if (madv.getID().toString().compareTo(adv.getID().toString()) >= 0) {
            LOG.log(Level.FINER, "Affirming Master Node role");
            Object object = this.MASTERLOCK;
            synchronized (object) {
                this.clusterViewManager.setMasterViewID(this.masterViewID.incrementAndGet());
                this.announceMaster(this.manager.getSystemAdvertisement());
                this.MASTERLOCK.notifyAll();
            }
        } else {
            LOG.log(Level.FINER, "Resigning Master Node role");
            this.clusterViewManager.setMaster(adv, true);
        }
        return true;
    }

    void probeNode(HealthMessage.Entry entry) throws IOException {
        if (this.isMaster() && this.masterAssigned) {
            LOG.log(Level.FINER, "Probing ID = " + entry.id + ", name = " + entry.adv.getName());
            this.send(entry.id, null, this.createNodeQuery());
        }
    }

    @Override
    public void pipeMsgEvent(PipeMsgEvent event) {
        boolean result = false;
        LOG.log(Level.FINEST, "Received a message inside  pipeMsgEvent");
        if (this.manager.isStopping()) {
            LOG.log(Level.FINE, "Since this Peer is Stopping, returning without processing incoming master node message. ");
            return;
        }
        if (this.isStarted()) {
            Message msg = event.getMessage();
            if (msg == null) {
                LOG.log(Level.WARNING, "Received a null message");
                return;
            }
            try {
                SystemAdvertisement adv = this.processNodeAdvertisement(msg);
                if (adv != null && adv.getID().equals(this.localNodeID)) {
                    LOG.log(Level.FINEST, "Discarding loopback message");
                    return;
                }
                if (adv != null) {
                    if (this.isMaster() && this.masterAssigned) {
                        result = this.clusterViewManager.add(adv);
                    } else if (this.discoveryInProgress) {
                        result = false;
                        this.discoveryView.add(adv);
                    }
                }
                if (this.processMasterNodeQuery(msg, adv, result)) {
                    return;
                }
                if (this.processMasterNodeResponse(msg, adv)) {
                    return;
                }
                if (this.processMasterNodeAnnouncement(msg, adv)) {
                    return;
                }
                if (this.processMasterNodeCollision(msg, adv)) {
                    return;
                }
                if (this.processChangeEvent(msg, adv)) {
                    return;
                }
                if (this.processNodeQuery(msg, adv, result)) {
                    return;
                }
                if (this.processNodeResponse(msg, adv, result)) {
                    return;
                }
                if (this.processGroupStartupComplete(msg, adv)) {
                    return;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                LOG.log(Level.WARNING, e.getLocalizedMessage());
            }
            LOG.log(Level.FINER, MessageFormat.format("ClusterViewManager contains {0} entries", this.clusterViewManager.getViewSize()));
        } else {
            LOG.log(Level.FINER, "Started : " + this.isStarted());
        }
    }

    private void announceMaster(SystemAdvertisement adv) {
        Message msg = this.createMasterResponse(true, adv.getID());
        ClusterViewEvent cvEvent = new ClusterViewEvent(ClusterViewEvents.MASTER_CHANGE_EVENT, adv);
        if (this.masterAssigned && this.isMaster()) {
            LOG.log(Level.INFO, MessageFormat.format("Announcing Master Node designation for member: {1} of group: {2}. Local view contains {0} entries", this.clusterViewManager.getViewSize(), this.manager.getInstanceName(), this.manager.getGroupName()));
            this.sendNewView(null, cvEvent, msg, true);
        }
    }

    @Override
    public void run() {
        this.startMasterNodeDiscovery();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startMasterNodeDiscovery() {
        Object object = this;
        synchronized (object) {
            this.clusterViewManager.start();
        }
        if (this.masterAssigned) {
            this.discoveryInProgress = false;
            object = this.discoveryLock;
            synchronized (object) {
                this.discoveryLock.notifyAll();
            }
            return;
        }
        for (int count = 0; !this.stop && count < this.interval && !this.discoverMaster(); ++count) {
        }
        if (!this.masterAssigned) {
            LOG.log(Level.FINER, "MN Discovery timeout, appointing master");
            this.appointMasterNode();
        }
        LOG.log(Level.FINEST, "startMasterNodeDiscovery making discoveryInProgress false");
        this.discoveryInProgress = false;
        object = this.discoveryLock;
        synchronized (object) {
            this.discoveryLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void appointMasterNode() {
        if (this.masterAssigned) {
            return;
        }
        LOG.log(Level.FINER, "MasterNode: discoveryInProgress=" + this.discoveryInProgress);
        SystemAdvertisement madv = this.discoveryInProgress ? this.discoveryView.getMasterCandidate() : this.clusterViewManager.getMasterCandidate();
        LOG.log(Level.FINER, "MasterNode: Master Candidate=" + madv.getName());
        this.clusterViewManager.setMaster(madv, false);
        this.masterAssigned = true;
        if (madv.getID().equals(this.localNodeID)) {
            LOG.log(Level.FINER, "MasterNode: Setting myself as MasterNode ");
            this.clusterViewManager.setMasterViewID(this.masterViewID.incrementAndGet());
            LOG.log(Level.FINER, "MasterNode: masterViewId =" + this.masterViewID);
            if (this.discoveryInProgress) {
                List<SystemAdvertisement> list = this.discoveryView.getView();
                ClusterViewEvent cvEvent = new ClusterViewEvent(ClusterViewEvents.MASTER_CHANGE_EVENT, madv);
                this.clusterViewManager.addToView(list, true, cvEvent);
            } else {
                LOG.log(Level.FINER, "MasterNode: Notifying Local Listeners of  Master Change");
                ClusterViewEvent cvEvent = new ClusterViewEvent(ClusterViewEvents.MASTER_CHANGE_EVENT, madv);
                this.clusterViewManager.notifyListeners(cvEvent);
            }
        }
        this.discoveryView.clear();
        this.discoveryView.add(this.sysAdv);
        Object object = this.MASTERLOCK;
        synchronized (object) {
            if (madv.getID().equals(this.localNodeID)) {
                LOG.log(Level.INFO, "Assuming Master Node designation member:" + madv.getName() + " for group:" + this.manager.getGroupName());
                if (this.clusterViewManager.getViewSize() > 1) {
                    LOG.log(Level.FINER, "MasterNode: announcing MasterNode assumption ");
                    this.announceMaster(this.manager.getSystemAdvertisement());
                }
                this.MASTERLOCK.notifyAll();
            }
        }
    }

    private void send(ID peerid, String name, Message msg) {
        try {
            if (peerid != null) {
                LOG.log(Level.FINER, "Unicasting Message to :" + name + "ID=" + peerid);
                OutputPipe output = this.pipeCache.get(peerid);
                if (output == null) {
                    RouteAdvertisement route = this.manager.getCachedRoute((PeerID)peerid);
                    if (route != null) {
                        output = new BlockingWireOutputPipe(this.manager.getNetPeerGroup(), this.pipeAdv, (PeerID)peerid, route);
                    }
                    if (output == null) {
                        output = this.pipeService.createOutputPipe(this.pipeAdv, Collections.singleton(peerid), 1L);
                    }
                    this.pipeCache.putIfAbsent(peerid, output);
                } else if (output.isClosed()) {
                    output = this.pipeService.createOutputPipe(this.pipeAdv, Collections.singleton(peerid), 1L);
                    this.pipeCache.put(peerid, output);
                }
                boolean sent = JxtaUtil.send(output, msg);
                if (!sent) {
                    LOG.log(Level.WARNING, "OutputPipe.send unexpectedly returned false sending messge " + msg + " to instance " + name);
                }
            } else {
                LOG.log(Level.FINER, "Broadcasting Message");
                boolean sent = JxtaUtil.send(this.outputPipe, msg);
                if (!sent) {
                    LOG.log(Level.WARNING, "OutputPipe.send unexpectedly returned false broadcasting messge " + msg + " to cluster");
                }
            }
        }
        catch (IOException io) {
            LOG.log(Level.FINEST, "Failed to send message", io);
        }
    }

    void sendNewView(ID toID, ClusterViewEvent event, Message msg, boolean includeView) {
        if (includeView) {
            this.addAuthoritativeView(msg);
        }
        ByteArrayMessageElement cvEvent = new ByteArrayMessageElement(VIEW_CHANGE_EVENT, MimeMediaType.AOS, JxtaUtil.createByteArrayFromObject(event), null);
        LOG.log(Level.FINER, MessageFormat.format("Created a view element of size {0}bytes", cvEvent.getByteLength()));
        msg.addMessageElement(NAMESPACE, cvEvent);
        LOG.log(Level.FINER, "Sending new authoritative cluster view to group, event :" + event.getEvent().toString() + " viewSeqId: " + this.clusterViewManager.getMasterViewID());
        this.send(toID, null, msg);
    }

    void addAuthoritativeView(Message msg) {
        List<SystemAdvertisement> view = this.clusterViewManager.getLocalView().getView();
        LOG.log(Level.FINER, "MasterNode: Adding Authoritative View of size " + view.size() + "  to view message");
        ByteArrayMessageElement bame = new ByteArrayMessageElement(AMASTERVIEW, MimeMediaType.AOS, JxtaUtil.createByteArrayFromObject(view), null);
        msg.addMessageElement(NAMESPACE, bame);
        LOG.log(Level.FINER, MessageFormat.format("Created an Authoritative view element of size {0}bytes", bame.getByteLength()));
        MasterNode.addLongToMessage(msg, NAMESPACE, MASTERVIEWSEQ, this.masterViewID.longValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void stop() {
        LOG.log(Level.FINER, "Stopping MasterNode");
        this.outputPipe.close();
        this.inputPipe.close();
        this.pipeCache.clear();
        this.discoveryView.clear();
        this.thread = null;
        this.masterAssigned = false;
        this.started = false;
        this.stop = true;
        this.discoveryInProgress = false;
        Object object = this.discoveryLock;
        synchronized (object) {
            this.discoveryLock.notifyAll();
        }
    }

    synchronized void start() {
        LOG.log(Level.FINER, "Starting MasterNode");
        this.clusterViewManager = this.manager.getClusterViewManager();
        try {
            this.started = true;
            this.inputPipe = this.pipeService.createInputPipe(this.pipeAdv, this);
        }
        catch (IOException ioe) {
            LOG.log(Level.SEVERE, "Failed to create service input pipe" + ioe);
        }
        this.thread = new Thread((Runnable)this, "MasterNode");
        this.thread.setDaemon(true);
        this.thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void viewChanged(ClusterViewEvent event) {
        if (this.isMaster() && this.masterAssigned) {
            this.clusterViewManager.notifyListeners(event);
            Message msg = this.createSelfNodeAdvertisement();
            AtomicLong atomicLong = this.masterViewID;
            synchronized (atomicLong) {
                this.clusterViewManager.setMasterViewID(this.masterViewID.incrementAndGet());
                this.addAuthoritativeView(msg);
            }
            this.sendNewView(null, event, msg, false);
        }
    }

    private static void addLongToMessage(Message message, String nameSpace, String elemName, long data) {
        message.addMessageElement(nameSpace, new StringMessageElement(elemName, Long.toString(data), null));
    }

    private static long getLongFromMessage(Message message, String nameSpace, String elemName) throws NumberFormatException {
        String seqStr = message.getMessageElement(nameSpace, elemName).toString();
        if (seqStr != null) {
            return Long.parseLong(message.getMessageElement(nameSpace, elemName).toString());
        }
        return -1L;
    }

    RouteControl getRouteControl() {
        if (this.routeControl == null) {
            this.routeControl = (RouteControl)this.endpointRouter.transportControl(EndpointRouter.GET_ROUTE_CONTROL, null);
        }
        return this.routeControl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void takeOverMasterRole() {
        Object object = this.MASTERLOCK;
        synchronized (object) {
            SystemAdvertisement madv = this.clusterViewManager.get(this.localNodeID);
            LOG.log(Level.FINER, "MasterNode: Forcefully becoming the Master..." + madv.getName());
            this.clusterViewManager.setMaster(madv, false);
            this.masterAssigned = true;
            this.clusterViewManager.setMasterViewID(this.masterViewID.incrementAndGet());
            LOG.log(Level.FINER, "MasterNode: becomeMaster () : masterViewId =" + this.masterViewID);
            LOG.log(Level.FINER, "MasterNode: becomeMaster () : Notifying Local Listeners of  Master Change");
            ClusterViewEvent cvEvent = new ClusterViewEvent(ClusterViewEvents.MASTER_CHANGE_EVENT, madv);
            this.clusterViewManager.notifyListeners(cvEvent);
            this.discoveryView.clear();
            this.discoveryView.add(this.sysAdv);
            if (this.clusterViewManager.getViewSize() > 1) {
                LOG.log(Level.FINER, "MasterNode: becomeMaster () : announcing MasterNode assumption ");
                this.announceMaster(this.manager.getSystemAdvertisement());
            }
            this.MASTERLOCK.notifyAll();
            this.manager.notifyNewMaster();
        }
    }

    void setClusterStopping() {
        this.clusterStopping = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ClusterViewEvent sendReadyEventView(SystemAdvertisement adv) {
        ClusterViewEvent cvEvent = new ClusterViewEvent(ClusterViewEvents.JOINED_AND_READY_EVENT, adv);
        LOG.log(Level.FINEST, MessageFormat.format("Sending to Group, Joined and Ready Event View for peer :{0}", adv.getName()));
        Message msg = this.createSelfNodeAdvertisement();
        AtomicLong atomicLong = this.masterViewID;
        synchronized (atomicLong) {
            this.clusterViewManager.setMasterViewID(this.masterViewID.incrementAndGet());
            this.addAuthoritativeView(msg);
        }
        this.sendNewView(null, cvEvent, msg, false);
        return cvEvent;
    }

    boolean isDiscoveryInProgress() {
        return this.discoveryInProgress;
    }

    void setGroupStarting(boolean value) {
        this.groupStarting = value;
        this.getGMSContext().setGroupStartup(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void delayedSetGroupStarting(boolean value, long delaySet) {
        Timer timer = this.timer;
        synchronized (timer) {
            if (this.groupStartingTask != null) {
                this.groupStartingTask.cancel();
            }
            this.groupStartingTask = new DelayedSetGroupStartingCompleteTask(delaySet);
            this.timer.schedule((TimerTask)this.groupStartingTask, delaySet);
        }
    }

    public boolean isGroupStartup() {
        return this.groupStarting;
    }

    void groupStartup(GMSConstants.groupStartupState startupState, List<String> memberTokens) {
        StringBuffer sb = new StringBuffer();
        this.groupStartingMembers = memberTokens;
        switch (startupState) {
            case INITIATED: {
                this.setGroupStarting(true);
                sb.append(" Starting Members: ");
                break;
            }
            case COMPLETED_FAILED: {
                this.setGroupStarting(false);
                sb.append(" Failed Members: ");
                if (!this.isMaster() || !this.isMasterAssigned()) break;
                this.sendGroupStartupComplete();
                break;
            }
            case COMPLETED_SUCCESS: {
                this.setGroupStarting(false);
                sb.append(" Started Members: ");
                if (!this.isMaster() || !this.isMasterAssigned()) break;
                this.sendGroupStartupComplete();
            }
        }
        for (String member : memberTokens) {
            sb.append(member).append(",");
        }
        LOG.info("GroupStart for group: " + this.getGMSContext().getGroupName() + " State:" + startupState.toString() + sb);
    }

    private GMSContext getGMSContext() {
        if (this.ctx == null) {
            this.ctx = (GMSContext)GMSContextFactory.getGMSContext(this.manager.getGroupName());
        }
        return this.ctx;
    }

    class DelayedSetGroupStartingCompleteTask
    extends TimerTask {
        private final long delay;

        public DelayedSetGroupStartingCompleteTask(long delay) {
            this.delay = delay;
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer("GroupStartupCompleteTask scheduled in " + delay + " ms");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (this.delay == 240000L) {
                LOG.warning("missed GroupStartupComplete message. Timed out group startup after 240 secs");
            }
            Timer timer = MasterNode.this.timer;
            synchronized (timer) {
                MasterNode.this.setGroupStarting(false);
                MasterNode.this.groupStartingTask = null;
            }
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Received GroupStartupComplete for group:" + MasterNode.this.manager.getGroupName() + " delay(ms)=" + this.delay);
            }
        }
    }
}

