/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.jxtamgmt;

import com.sun.enterprise.jxtamgmt.JxtaConfigConstants;
import com.sun.enterprise.jxtamgmt.JxtaUtil;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.MimeMediaType;
import net.jxta.document.XMLDocument;
import net.jxta.exception.PeerGroupException;
import net.jxta.id.IDFactory;
import net.jxta.impl.endpoint.mcast.McastTransport;
import net.jxta.impl.peergroup.StdPeerGroupParamAdv;
import net.jxta.peer.PeerID;
import net.jxta.peergroup.NetPeerGroupFactory;
import net.jxta.peergroup.PeerGroup;
import net.jxta.peergroup.PeerGroupID;
import net.jxta.peergroup.WorldPeerGroupFactory;
import net.jxta.pipe.PipeID;
import net.jxta.platform.NetworkConfigurator;
import net.jxta.protocol.ConfigParams;
import net.jxta.protocol.ModuleImplAdvertisement;
import net.jxta.protocol.PipeAdvertisement;
import net.jxta.rendezvous.RendezVousService;
import net.jxta.rendezvous.RendezvousEvent;
import net.jxta.rendezvous.RendezvousListener;

public class NetworkManager
implements RendezvousListener {
    private static final Logger LOG = JxtaUtil.getLogger();
    private static MessageDigest digest;
    private PeerGroup netPeerGroup;
    private boolean started = false;
    private boolean stopped = false;
    private RendezVousService rendezvous;
    private String groupName = "defaultGroup";
    private String instanceName;
    private static final String PREFIX = "SHOAL";
    private final Object networkConnectLock = new Object();
    private static final Object digestLock;
    private static final File home;
    private static File storeHome;
    private PipeID socketID;
    private static PipeID pipeID;
    private static WorldPeerGroupFactory wpgf;
    private PeerGroup worldPG = null;
    private static String SOCKETSEED;
    private static String PIPESEED;
    private static String HEALTHSEED;
    private static String MASTERSEED;
    private static String SESSIONQUERYSEED;
    private static String APPSERVICESEED;
    private String mcastAddress;
    private int mcastPort = 0;
    private static final int DEFAULT_MULTICAST_POOLSIZE = 300;
    private int multicastPoolsize = 300;
    private List<String> rendezvousSeedURIs = new ArrayList<String>();
    private boolean isRendezvousSeed = false;
    private String tcpAddress;
    private Hashtable<String, PeerID> instanceToPeerIdMap = new Hashtable();

    public NetworkManager(String groupName, String instanceName, Map properties) {
        JxtaUtil.configureJxtaLogging();
        this.groupName = groupName;
        this.instanceName = instanceName;
        this.socketID = this.getSocketID(instanceName);
        pipeID = this.getPipeID(instanceName);
        if (properties != null && !properties.isEmpty()) {
            Object isVirtualMulticastNode;
            Object virtualMulticastURIList;
            Object mp;
            String ma = (String)properties.get(JxtaConfigConstants.MULTICASTADDRESS.toString());
            if (ma != null) {
                this.mcastAddress = ma;
            }
            if ((mp = properties.get(JxtaConfigConstants.MULTICASTPORT.toString())) != null) {
                if (mp instanceof String) {
                    this.mcastPort = Integer.parseInt((String)mp);
                } else if (mp instanceof Integer) {
                    this.mcastPort = (Integer)mp;
                }
            }
            if ((virtualMulticastURIList = properties.get(JxtaConfigConstants.VIRTUAL_MULTICAST_URI_LIST.toString())) != null) {
                if (((String)virtualMulticastURIList).indexOf(",") > 0) {
                    String[] addresses = ((String)virtualMulticastURIList).split(",");
                    if (addresses.length > 0) {
                        this.rendezvousSeedURIs = Arrays.asList(addresses);
                    }
                } else {
                    this.rendezvousSeedURIs.add((String)virtualMulticastURIList);
                }
                LOG.config("VIRTUAL_MULTICAST_URI_LIST=" + virtualMulticastURIList + " rendezvousSeedURIs.get(0)=" + this.rendezvousSeedURIs.get(1));
            }
            if ((isVirtualMulticastNode = properties.get(JxtaConfigConstants.IS_BOOTSTRAPPING_NODE.toString())) != null) {
                this.isRendezvousSeed = Boolean.parseBoolean((String)isVirtualMulticastNode);
                LOG.config("IS_BOOTSTRAPPING_NODE (isRendezvousSeed) is set to " + this.isRendezvousSeed);
            }
            this.tcpAddress = (String)properties.get(JxtaConfigConstants.BIND_INTERFACE_ADDRESS.toString());
            this.multicastPoolsize = 300;
            Object multicastPoolsizeString = properties.get(JxtaConfigConstants.MULTICAST_POOLSIZE.toString());
            if (multicastPoolsizeString == null) {
                multicastPoolsizeString = System.getProperty("jxtaMulticastPoolsize");
            }
            if (multicastPoolsizeString != null) {
                try {
                    this.multicastPoolsize = Integer.parseInt((String)multicastPoolsizeString);
                }
                catch (NumberFormatException nfe) {
                    LOG.warning("Invalid value for Shoal property to configure jxta " + JxtaConfigConstants.MULTICAST_POOLSIZE.toString() + "=" + (String)multicastPoolsizeString);
                }
                if (this.multicastPoolsize < 300) {
                    this.multicastPoolsize = 300;
                }
            }
        }
        try {
            this.initWPGF(instanceName);
        }
        catch (PeerGroupException e) {
            LOG.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] hash(String expression) {
        byte[] digArray;
        if (expression == null) {
            throw new IllegalArgumentException("Invalid null expression");
        }
        Object object = digestLock;
        synchronized (object) {
            if (digest == null) {
                try {
                    digest = MessageDigest.getInstance("SHA1");
                }
                catch (NoSuchAlgorithmException ex) {
                    LOG.log(Level.WARNING, ex.getLocalizedMessage());
                }
            }
            digest.reset();
            try {
                digArray = digest.digest(expression.getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException impossible) {
                LOG.log(Level.WARNING, "digestEncoding unsupported:" + impossible.getLocalizedMessage() + ":returning digest with default encoding");
                digArray = digest.digest(expression.getBytes());
            }
        }
        return digArray;
    }

    public PipeID getPipeID(String instanceName) {
        String seed = instanceName + PIPESEED;
        return IDFactory.newPipeID(PeerGroupID.defaultNetPeerGroupID, NetworkManager.hash(seed.toLowerCase()));
    }

    public PipeID getSocketID(String instanceName) {
        String seed = instanceName + SOCKETSEED;
        return IDFactory.newPipeID(PeerGroupID.defaultNetPeerGroupID, NetworkManager.hash(seed.toLowerCase()));
    }

    public PeerID getPeerID(String instanceName) {
        PeerID id = this.instanceToPeerIdMap.get(instanceName);
        if (id == null) {
            id = IDFactory.newPeerID(PeerGroupID.worldPeerGroupID, NetworkManager.hash(PREFIX + instanceName.toUpperCase()));
            this.instanceToPeerIdMap.put(instanceName, id);
        }
        return id;
    }

    public PeerGroupID getPeerGroupID(String groupName) {
        if (this.mcastAddress == null && this.mcastPort <= 0) {
            return IDFactory.newPeerGroupID(PeerGroupID.defaultNetPeerGroupID, NetworkManager.hash(PREFIX + groupName.toLowerCase()));
        }
        return IDFactory.newPeerGroupID(PeerGroupID.defaultNetPeerGroupID, NetworkManager.hash(PREFIX + groupName.toLowerCase() + this.mcastAddress + this.mcastPort));
    }

    public PipeID getHealthPipeID() {
        return IDFactory.newPipeID(this.getInfraPeerGroupID(), NetworkManager.hash(HEALTHSEED.toLowerCase()));
    }

    public PipeID getMasterPipeID() {
        return IDFactory.newPipeID(this.getInfraPeerGroupID(), NetworkManager.hash(MASTERSEED.toLowerCase()));
    }

    public PipeID getSessionQueryPipeID() {
        return IDFactory.newPipeID(this.getInfraPeerGroupID(), NetworkManager.hash(SESSIONQUERYSEED.toLowerCase()));
    }

    public PipeID getAppServicePipeID() {
        return IDFactory.newPipeID(this.getInfraPeerGroupID(), NetworkManager.hash(APPSERVICESEED.toLowerCase()));
    }

    private PipeAdvertisement getTemplatePipeAdvertisement(String instanceName) {
        PipeAdvertisement advertisement = (PipeAdvertisement)AdvertisementFactory.newAdvertisement(PipeAdvertisement.getAdvertisementType());
        advertisement.setType("JxtaUnicast");
        advertisement.setName(instanceName);
        return advertisement;
    }

    public PipeAdvertisement getSocketAdvertisement(String instanceName) {
        PipeAdvertisement advertisement = this.getTemplatePipeAdvertisement(instanceName);
        advertisement.setPipeID(this.getSocketID(instanceName));
        return advertisement;
    }

    public PipeAdvertisement getPipeAdvertisement(String instanceName) {
        PipeAdvertisement advertisement = this.getTemplatePipeAdvertisement(instanceName);
        advertisement.setPipeID(this.getPipeID(instanceName));
        return advertisement;
    }

    public PeerGroupID getInfraPeerGroupID() {
        return this.getPeerGroupID(this.groupName);
    }

    public synchronized void start() throws PeerGroupException, IOException {
        if (this.started) {
            return;
        }
        this.startDomain();
    }

    private static void clearCache(File rootDir) {
        try {
            if (rootDir.exists()) {
                File[] list;
                if (LOG.isLoggable(Level.FINER)) {
                    LOG.finer("clearCache(" + rootDir + ")");
                }
                for (File aList : list = rootDir.listFiles()) {
                    if (aList.isDirectory()) {
                        NetworkManager.clearCache(aList);
                        continue;
                    }
                    boolean value = aList.delete();
                    if (value || !LOG.isLoggable(Level.FINE)) continue;
                    LOG.fine("failed to deleted cache file " + aList);
                }
            } else if (LOG.isLoggable(Level.FINER)) {
                LOG.finer("clearCache(" + rootDir + ") on non-exsistent directory");
            }
            rootDir.delete();
        }
        catch (Throwable t) {
            LOG.log(Level.WARNING, "Unable to clear " + rootDir.toString(), t);
        }
    }

    public synchronized void stop() {
        if (this.stopped && !this.started) {
            return;
        }
        try {
            this.rendezvous.removeListener(this);
            this.netPeerGroup.stopApp();
            this.netPeerGroup.unref();
            this.netPeerGroup = null;
            this.instanceToPeerIdMap.clear();
        }
        catch (Throwable th) {
            LOG.log(Level.FINEST, th.getLocalizedMessage());
        }
        this.stopped = true;
        this.started = false;
    }

    public PeerGroup getNetPeerGroup() {
        return this.netPeerGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitForRendezvousConnection(long timeout) {
        long timeoutAt;
        if (0L == timeout) {
            timeout = Long.MAX_VALUE;
        }
        if ((timeoutAt = System.currentTimeMillis() + timeout) <= 0L) {
            timeoutAt = Long.MAX_VALUE;
        }
        while (this.started && !this.stopped && !this.rendezvous.isConnectedToRendezVous() && !this.rendezvous.isRendezVous()) {
            LOG.fine("rendezvous.isRendezVous() = " + this.rendezvous.isRendezVous() + "rendezvous.isConnectedToRendezVous() = " + this.rendezvous.isConnectedToRendezVous());
            try {
                long waitFor = timeoutAt - System.currentTimeMillis();
                if (waitFor > 0L) {
                    Object object = this.networkConnectLock;
                    synchronized (object) {
                        this.networkConnectLock.wait(timeout);
                        continue;
                    }
                }
                break;
            }
            catch (InterruptedException e) {
                Thread.interrupted();
                break;
            }
        }
        LOG.fine("outside while loop -> rendezvous.isRendezVous() = " + this.rendezvous.isRendezVous() + "rendezvous.isConnectedToRendezVous() = " + this.rendezvous.isConnectedToRendezVous());
        return this.rendezvous.isConnectedToRendezVous() || this.rendezvous.isRendezVous();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rendezvousEvent(RendezvousEvent event) {
        if (event.getType() == 0 || event.getType() == 1 || event.getType() == 8) {
            Object object = this.networkConnectLock;
            synchronized (object) {
                this.networkConnectLock.notifyAll();
            }
        }
    }

    public PeerID getPeerID() {
        if (this.stopped && !this.started) {
            return null;
        }
        return this.netPeerGroup.getPeerID();
    }

    boolean isStarted() {
        return !this.stopped && this.started;
    }

    PipeID getSocketID() {
        return this.socketID;
    }

    public PipeID getPipeID() {
        return pipeID;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public File getHome() {
        return home;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initWPGF(String instanceName) throws PeerGroupException {
        Class<NetworkManager> clazz = NetworkManager.class;
        synchronized (NetworkManager.class) {
            if (null == wpgf) {
                NetworkConfigurator worldGroupConfig;
                storeHome = new File(home, instanceName);
                if (LOG.isLoggable(Level.CONFIG)) {
                    LOG.config("initWPGF storeHome=" + storeHome);
                }
                NetworkManager.clearCache(storeHome);
                if (this.isRendezvousSeed && this.rendezvousSeedURIs.size() > 0) {
                    worldGroupConfig = new NetworkConfigurator(3472, storeHome.toURI());
                    String myPort = this.rendezvousSeedURIs.get(0);
                    LOG.fine("myPort is " + myPort);
                    myPort = myPort.substring(myPort.lastIndexOf(":") + 1, myPort.length());
                    LOG.fine("myPort is " + myPort);
                    worldGroupConfig.setTcpPort(Integer.parseInt(myPort));
                    worldGroupConfig.setTcpStartPort(Integer.parseInt(myPort));
                    worldGroupConfig.setTcpEndPort(Integer.parseInt(myPort));
                } else {
                    worldGroupConfig = NetworkConfigurator.newAdHocConfiguration(storeHome.toURI());
                    worldGroupConfig.setTcpStartPort(9701);
                    worldGroupConfig.setTcpEndPort(9999);
                }
                worldGroupConfig.setName(instanceName);
                worldGroupConfig.setPeerID(this.getPeerID(instanceName));
                worldGroupConfig.setUseMulticast(false);
                if (this.tcpAddress != null && !this.tcpAddress.equals("")) {
                    try {
                        InetAddress usingInterface = InetAddress.getByName(this.tcpAddress);
                    }
                    catch (UnknownHostException failed) {
                        LOG.warning("GMS bind-interface-address property set to unknown host " + this.tcpAddress + ", using default of AnyAddress");
                        worldGroupConfig.setTcpInterfaceAddress(this.tcpAddress);
                    }
                    worldGroupConfig.setTcpInterfaceAddress(this.tcpAddress);
                }
                ConfigParams config = worldGroupConfig.getPlatformConfig();
                wpgf = new WorldPeerGroupFactory(config, storeHome.toURI());
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    private PeerGroup startDomain() throws PeerGroupException {
        ModuleImplAdvertisement npgImplAdv;
        NetworkConfigurator config;
        if (this.isRendezvousSeed && this.rendezvousSeedURIs.size() > 0) {
            config = new NetworkConfigurator(3472, storeHome.toURI());
            String myPort = this.rendezvousSeedURIs.get(0);
            LOG.fine("myPort is " + myPort);
            myPort = myPort.substring(myPort.lastIndexOf(":") + 1, myPort.length());
            LOG.fine("myPort is " + myPort);
            config.setTcpPort(Integer.parseInt(myPort));
            config.setTcpStartPort(Integer.parseInt(myPort));
            config.setTcpEndPort(Integer.parseInt(myPort));
        } else {
            config = new NetworkConfigurator(5576, storeHome.toURI());
            config.setTcpStartPort(9701);
            config.setTcpEndPort(9999);
        }
        config.setPeerID(this.getPeerID(this.instanceName));
        config.setName(this.instanceName);
        config.setDescription("Created by Jxta Cluster Management NetworkManager");
        config.setInfrastructureID(this.getInfraPeerGroupID());
        config.setInfrastructureName(this.groupName);
        LOG.fine("Rendezvous seed?:" + this.isRendezvousSeed);
        if (!this.rendezvousSeedURIs.isEmpty()) {
            LOG.fine("Setting Rendezvous seeding uri's to network configurator:" + this.rendezvousSeedURIs);
            config.setRendezvousSeeds(new HashSet<String>(this.rendezvousSeedURIs));
            config.setUseOnlyRendezvousSeeds(true);
            LOG.fine("Setting Relay seeding uri's to network configurator:" + this.rendezvousSeedURIs);
            config.setRelaySeedingURIs(new HashSet<String>(this.rendezvousSeedURIs));
            config.setUseOnlyRelaySeeds(true);
        }
        config.setUseMulticast(true);
        config.setMulticastSize(65536);
        config.setInfrastructureDescriptionStr(this.groupName + " Infrastructure Group Name");
        if (this.mcastAddress != null) {
            config.setMulticastAddress(this.mcastAddress);
        }
        if (this.mcastPort > 0) {
            config.setMulticastPort(this.mcastPort);
        }
        if (this.multicastPoolsize != 0) {
            config.setMulticastPoolSize(this.multicastPoolsize);
            if (LOG.isLoggable(Level.CONFIG)) {
                LOG.config("set jxta Multicast Poolsize to " + config.getMulticastPoolSize());
            }
        }
        if (this.tcpAddress != null && !this.tcpAddress.equals("")) {
            config.setTcpInterfaceAddress(this.tcpAddress);
            config.setMulticastInterface(this.tcpAddress);
        }
        if (LOG.isLoggable(Level.CONFIG)) {
            LOG.config("node config adv = " + config.getPlatformConfig().toString());
        }
        PeerGroup worldPG = this.getWorldPeerGroup();
        try {
            npgImplAdv = worldPG.getAllPurposePeerGroupImplAdvertisement();
            npgImplAdv.setModuleSpecID(PeerGroup.allPurposePeerGroupSpecID);
            StdPeerGroupParamAdv params = new StdPeerGroupParamAdv(npgImplAdv.getParam());
            params.addProto(McastTransport.MCAST_TRANSPORT_CLASSID, McastTransport.MCAST_TRANSPORT_SPECID);
            npgImplAdv.setParam((XMLDocument)params.getDocument(MimeMediaType.XMLUTF8));
        }
        catch (Exception failed) {
            throw new PeerGroupException("Could not construct domain ModuleImplAdvertisement", failed);
        }
        ConfigParams cfg = config.getPlatformConfig();
        NetPeerGroupFactory factory = new NetPeerGroupFactory(worldPG, cfg, npgImplAdv);
        this.netPeerGroup = factory.getInterface();
        this.rendezvous = this.netPeerGroup.getRendezVousService();
        this.rendezvous.addListener(this);
        this.stopped = false;
        this.started = true;
        if (!this.rendezvousSeedURIs.isEmpty()) {
            this.waitForRendezvousConnection(30000L);
        }
        LOG.fine("Connected to the bootstrapping node?: " + (this.rendezvous.isConnectedToRendezVous() || this.rendezvous.isRendezVous()));
        return this.netPeerGroup;
    }

    private synchronized PeerGroup getWorldPeerGroup() {
        if (this.worldPG == null) {
            this.worldPG = wpgf.getInterface();
        }
        return this.worldPG;
    }

    static {
        digestLock = new Object();
        home = new File(System.getProperty("JXTA_HOME", ".shoal"));
        SOCKETSEED = "SHOALsocket";
        PIPESEED = "SHOALBIDI";
        HEALTHSEED = "SHOALHEALTH";
        MASTERSEED = "SHOALMASTER";
        SESSIONQUERYSEED = "SHOALSESSIONQ";
        APPSERVICESEED = "APPSERVICE";
    }
}

