/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.jxtamgmt;

import com.sun.enterprise.jxtamgmt.JxtaUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.document.Advertisement;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.Attributable;
import net.jxta.document.Document;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.StructuredTextDocument;
import net.jxta.document.TextElement;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.id.ID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SystemAdvertisement
extends Advertisement
implements Comparable,
Cloneable,
Serializable {
    private String hwarch;
    private String hwvendor;
    private ID id = ID.nullID;
    private String name;
    private String osname;
    private String osversion;
    private String osarch;
    private List<String> endpointAddresses = null;
    private HashMap<String, String> customTags = null;
    private static final String OSNameTag = "OSName";
    private static final String OSVersionTag = "OSVer";
    private static final String OSarchTag = "osarch";
    private static final String hwarchTag = "hwarch";
    private static final String hwvendorTag = "hwvendor";
    private static final String idTag = "ID";
    private static final String ipTag = "ip";
    private static final String nameTag = "name";
    private static final String[] fields = new String[]{"ID", "name", "hwarch"};
    private static final Logger LOG = JxtaUtil.getLogger(SystemAdvertisement.class.getName());

    public SystemAdvertisement() {
    }

    public SystemAdvertisement(Element root) {
        TextElement doc = (TextElement)root;
        if (!SystemAdvertisement.getAdvertisementType().equals(doc.getName())) {
            throw new IllegalArgumentException("Could not construct : " + this.getClass().getName() + "from doc containing a " + doc.getName());
        }
        this.initialize(doc);
    }

    public SystemAdvertisement(InputStream stream) throws IOException {
        StructuredTextDocument doc = (StructuredTextDocument)StructuredDocumentFactory.newStructuredDocument(MimeMediaType.XMLUTF8, stream);
        this.initialize(doc);
    }

    public void setHWArch(String hwarch) {
        this.hwarch = hwarch;
    }

    public void setOSArch(String osarch) {
        this.osarch = osarch;
    }

    public void setHWVendor(String hwvendor) {
        this.hwvendor = hwvendor;
    }

    public void setID(ID id) {
        this.id = id == null ? null : id;
    }

    public void addEndpointAddress(EndpointAddress value) {
        if (this.endpointAddresses == null) {
            this.endpointAddresses = new ArrayList<String>();
        }
        this.endpointAddresses.add(value.toString());
    }

    public void setEndpointAddresses(List<String> endpoints) {
        if (this.endpointAddresses == null) {
            this.endpointAddresses = new ArrayList<String>();
        }
        this.endpointAddresses.addAll(endpoints);
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setOSName(String osname) {
        this.osname = osname;
    }

    public void setOSVersion(String osversion) {
        this.osversion = osversion;
    }

    public void setCustomTags(Map<String, String> tags) {
        if (this.customTags == null) {
            this.customTags = new HashMap();
        }
        this.customTags.putAll(tags);
    }

    public Map<String, String> getCustomTags() {
        return (HashMap)this.customTags.clone();
    }

    public void setCustomTag(String tag, String value) {
        if (this.customTags == null) {
            this.customTags = new HashMap();
        }
        this.customTags.put(tag, value);
    }

    @Override
    public Document getDocument(MimeMediaType asMimeType) {
        StructuredDocument adv = StructuredDocumentFactory.newStructuredDocument(asMimeType, SystemAdvertisement.getAdvertisementType());
        if (adv instanceof Attributable) {
            ((Attributable)((Object)adv)).addAttribute("xmlns:jxta", "http://jxta.org");
        }
        Object e = adv.createElement(idTag, this.getID().toString());
        JxtaUtil.appendChild(adv, e);
        e = adv.createElement(nameTag, this.getName().trim());
        JxtaUtil.appendChild(adv, e);
        e = adv.createElement(OSNameTag, this.getOSName().trim());
        JxtaUtil.appendChild(adv, e);
        e = adv.createElement(OSVersionTag, this.getOSVersion().trim());
        JxtaUtil.appendChild(adv, e);
        e = adv.createElement(OSarchTag, this.getOSArch().trim());
        JxtaUtil.appendChild(adv, e);
        if (this.endpointAddresses != null && !this.endpointAddresses.isEmpty()) {
            for (String address : this.getEndpointAddresses()) {
                e = adv.createElement(ipTag, address.toString());
                JxtaUtil.appendChild(adv, e);
            }
        }
        e = adv.createElement(hwarchTag, this.getHWArch().trim());
        JxtaUtil.appendChild(adv, e);
        e = adv.createElement(hwvendorTag, this.getHWVendor().trim());
        JxtaUtil.appendChild(adv, e);
        if (this.customTags != null && !this.customTags.isEmpty()) {
            for (String key : this.customTags.keySet()) {
                e = adv.createElement(key, this.customTags.get(key));
                JxtaUtil.appendChild(adv, e);
            }
        }
        return adv;
    }

    public String getHWArch() {
        return this.hwarch;
    }

    public String getOSArch() {
        return this.osarch;
    }

    public String getHWVendor() {
        return this.hwvendor;
    }

    @Override
    public ID getID() {
        return this.id == null ? null : this.id;
    }

    public List<String> getEndpointAddresses() {
        return this.endpointAddresses;
    }

    public List<URI> getURIs() {
        List<String> endpoints = this.getEndpointAddresses();
        ArrayList<URI> uriList = new ArrayList<URI>(endpoints.size());
        for (int i = 0; i < endpoints.size(); ++i) {
            try {
                uriList.add(new URI(endpoints.get(i)));
                continue;
            }
            catch (URISyntaxException e) {
                if (!LOG.isLoggable(Level.FINE)) continue;
                LOG.log(Level.FINE, "Exception occurred : ", e);
            }
        }
        return uriList;
    }

    public String getName() {
        return this.name;
    }

    public String getOSName() {
        return this.osname;
    }

    public String getOSVersion() {
        return this.osversion;
    }

    public String getCustomTagValue(String tagName) throws NoSuchFieldException {
        if (this.customTags != null) {
            return this.customTags.get(tagName);
        }
        throw new NoSuchFieldException(tagName);
    }

    @Override
    public SystemAdvertisement clone() throws CloneNotSupportedException {
        try {
            SystemAdvertisement likeMe = (SystemAdvertisement)super.clone();
            likeMe.setID(this.getID());
            likeMe.setName(this.getName());
            likeMe.setOSName(this.getName());
            likeMe.setOSVersion(this.getOSVersion());
            likeMe.setOSArch(this.getOSArch());
            if (this.endpointAddresses != null && !this.endpointAddresses.isEmpty()) {
                likeMe.setEndpointAddresses(this.getEndpointAddresses());
            }
            likeMe.setHWArch(this.getHWArch());
            likeMe.setHWVendor(this.getHWVendor());
            if (this.customTags != null && !this.customTags.isEmpty()) {
                likeMe.setCustomTags(this.getCustomTags());
            }
            return likeMe;
        }
        catch (CloneNotSupportedException impossible) {
            throw new Error("Object.clone() threw CloneNotSupportedException", impossible);
        }
    }

    protected void handleElement(TextElement elem) {
        if (elem.getName().equals(idTag)) {
            this.setID(ID.create(URI.create(elem.getTextValue())));
        } else if (elem.getName().equals(nameTag)) {
            this.setName(elem.getTextValue());
        } else if (elem.getName().equals(OSNameTag)) {
            this.setOSName(elem.getTextValue());
        } else if (elem.getName().equals(OSVersionTag)) {
            this.setOSVersion(elem.getTextValue());
        } else if (elem.getName().equals(OSarchTag)) {
            this.setOSArch(elem.getTextValue());
        } else if (elem.getName().equals(ipTag)) {
            this.addEndpointAddress(new EndpointAddress(elem.getTextValue()));
        } else if (elem.getName().equals(hwarchTag)) {
            this.setHWArch(elem.getTextValue());
        } else if (elem.getName().equals(hwvendorTag)) {
            this.setHWVendor(elem.getTextValue());
        } else {
            this.setCustomTag(elem.getName(), elem.getTextValue());
        }
    }

    protected void initialize(Element root) {
        if (!TextElement.class.isInstance(root)) {
            throw new IllegalArgumentException(this.getClass().getName() + " only supports TextElement");
        }
        TextElement doc = (TextElement)root;
        if (!doc.getName().equals(SystemAdvertisement.getAdvertisementType())) {
            throw new IllegalArgumentException(new StringBuffer().append("Could not construct : ").append(this.getClass().getName()).append("from doc containing a ").append(doc.getName()).toString());
        }
        Enumeration elements = doc.getChildren();
        while (elements.hasMoreElements()) {
            TextElement elem = (TextElement)elements.nextElement();
            this.handleElement(elem);
        }
    }

    @Override
    public final String[] getIndexFields() {
        return fields;
    }

    public boolean equals(Object obj) {
        boolean retVal = false;
        if (this == obj) {
            retVal = true;
        } else if (obj instanceof SystemAdvertisement) {
            SystemAdvertisement adv = (SystemAdvertisement)obj;
            retVal = this.getID().equals(adv.getID());
        }
        return retVal;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.getID().hashCode();
        String name = this.getName();
        if (name != null) {
            result = 37 * result + name.hashCode();
        }
        return result;
    }

    public int compareTo(Object other) {
        return this.getID().toString().compareTo(other.toString());
    }

    public static String getAdvertisementType() {
        return "jxta:System";
    }

    public static class Instantiator
    implements AdvertisementFactory.Instantiator {
        public String getAdvertisementType() {
            return SystemAdvertisement.getAdvertisementType();
        }

        public Advertisement newInstance() {
            return new SystemAdvertisement();
        }

        public Advertisement newInstance(Element root) {
            return new SystemAdvertisement(root);
        }
    }
}

