/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.shoal.jointest;

import com.sun.enterprise.ee.cms.core.CallBack;
import com.sun.enterprise.ee.cms.core.GMSConstants;
import com.sun.enterprise.ee.cms.core.GMSException;
import com.sun.enterprise.ee.cms.core.GMSFactory;
import com.sun.enterprise.ee.cms.core.GroupManagementService;
import com.sun.enterprise.ee.cms.core.JoinNotificationSignal;
import com.sun.enterprise.ee.cms.core.Signal;
import com.sun.enterprise.ee.cms.impl.client.JoinNotificationActionFactoryImpl;
import com.sun.enterprise.ee.cms.logging.GMSLogDomain;
import com.sun.enterprise.jxtamgmt.JxtaUtil;
import java.util.Properties;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SimpleJoinTest {
    private static final Logger logger = GMSLogDomain.getLogger("ShoalLogger");
    private final String group = "TestGroup";

    public static void main(String[] args) {
        JxtaUtil.setLogger(logger);
        JxtaUtil.setupLogHandler();
        SimpleJoinTest check = new SimpleJoinTest();
        try {
            check.runSimpleSample();
        }
        catch (GMSException e) {
            logger.log(Level.SEVERE, "Exception occured while joining group:" + e);
        }
    }

    private void runSimpleSample() throws GMSException {
        logger.log(Level.INFO, "Starting SimpleJoinTest....");
        String serverName = UUID.randomUUID().toString();
        GroupManagementService gms = this.initializeGMS(serverName, "TestGroup");
        logger.log(Level.INFO, "Registering for group event notifications");
        gms.addActionFactory(new JoinNotificationActionFactoryImpl(new JoinNotificationCallBack(serverName)));
        logger.log(Level.INFO, "Joining Group TestGroup");
        gms.join();
    }

    private GroupManagementService initializeGMS(String serverName, String groupName) {
        logger.log(Level.INFO, "Initializing Shoal for member: " + serverName + " group:" + groupName);
        return (GroupManagementService)((Object)GMSFactory.startGMSModule(serverName, groupName, GroupManagementService.MemberType.CORE, new Properties()));
    }

    private void leaveGroupAndShutdown(String serverName, GroupManagementService gms) {
        logger.log(Level.INFO, "Shutting down gms " + gms + "for server " + serverName);
        gms.shutdown(GMSConstants.shutdownType.INSTANCE_SHUTDOWN);
    }

    private class JoinNotificationCallBack
    implements CallBack {
        private String serverName;

        public JoinNotificationCallBack(String serverName) {
            this.serverName = serverName;
        }

        public void processNotification(Signal notification) {
            if (!(notification instanceof JoinNotificationSignal)) {
                logger.log(Level.SEVERE, "received unkown notification type:" + notification);
            }
            logger.log(Level.INFO, "***JoinNotification received: ServerName = " + this.serverName + ", Signal.getMemberToken() = " + notification.getMemberToken());
        }
    }
}

