/*
 * Decompiled with CFR 0.152.
 */
package net;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.text.MessageFormat;

public class TestClient {
    private static final long RUNS = 10L;
    private int SO_TO_VALUE = 500;
    private int SO_TO_INCREMENT = 500;

    public void run() {
        try {
            System.out.println("Connecting to the server");
            Socket socket = new Socket();
            InetSocketAddress address = new InetSocketAddress(InetAddress.getLocalHost(), 9000);
            System.out.println(MessageFormat.format("Setting SO TO to :{0}ms", this.SO_TO_VALUE));
            socket.setSoTimeout(this.SO_TO_VALUE);
            long start = System.currentTimeMillis();
            socket.bind(address);
            System.out.println(MessageFormat.format("Connected Socket in {0}ms", System.currentTimeMillis() - start));
            System.out.println("closing connection");
            socket.close();
            this.SO_TO_VALUE += this.SO_TO_INCREMENT;
        }
        catch (IOException io) {
            io.printStackTrace();
        }
    }

    private void stop() {
    }

    public static void main(String[] args) {
        try {
            Thread.currentThread().setName(TestClient.class.getName() + ".main()");
            TestClient testClient = new TestClient();
            int i = 1;
            while ((long)i <= 10L) {
                System.out.println("Run #" + i);
                testClient.run();
                ++i;
            }
            testClient.stop();
        }
        catch (Throwable e) {
            System.out.flush();
            System.err.println("Failed : " + e);
            e.printStackTrace(System.err);
            System.exit(-1);
        }
    }
}

