/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.document;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.endpoint.MessageElement;
import net.jxta.endpoint.TextMessageElement;
import net.jxta.logging.Logging;
import net.jxta.util.ClassFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StructuredDocumentFactory
extends ClassFactory<MimeMediaType, Instantiator> {
    private static final Logger LOG = Logger.getLogger(StructuredDocumentFactory.class.getName());
    private static final StructuredDocumentFactory factory = new StructuredDocumentFactory();
    private final Map<MimeMediaType, Instantiator> encodings = new HashMap<MimeMediaType, Instantiator>();
    private final Map<String, MimeMediaType> extToMime = new HashMap<String, MimeMediaType>();
    private final Map<MimeMediaType, String> mimeToExt = new HashMap<MimeMediaType, String>();
    private boolean loadedProperty = false;

    private StructuredDocumentFactory() {
    }

    private synchronized boolean loadProviders() {
        if (StructuredDocumentFactory.factory.loadedProperty) {
            return true;
        }
        StructuredDocumentFactory.factory.loadedProperty = this.registerProviders(StructuredDocument.class.getName());
        return StructuredDocumentFactory.factory.loadedProperty;
    }

    @Override
    protected Map<MimeMediaType, Instantiator> getAssocTable() {
        return this.encodings;
    }

    @Override
    protected Class<MimeMediaType> getClassForKey() {
        return MimeMediaType.class;
    }

    @Override
    protected Class<Instantiator> getClassOfInstantiators() {
        return Instantiator.class;
    }

    @Override
    protected boolean registerAssoc(String className) {
        boolean registeredSomething;
        block3: {
            registeredSomething = false;
            LOG.finer("Registering : " + className);
            try {
                MimeMediaType[] mimeTypes;
                Class<?> docClass = Class.forName(className);
                Instantiator instantiator = (Instantiator)docClass.getField("INSTANTIATOR").get(null);
                for (MimeMediaType mimeType : mimeTypes = instantiator.getSupportedMimeTypes()) {
                    LOG.finer("   Registering Type : " + mimeType.getMimeMediaType());
                    registeredSomething |= StructuredDocumentFactory.registerInstantiator(mimeType, instantiator);
                }
            }
            catch (Exception all) {
                if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) break block3;
                LOG.log(Level.WARNING, "Failed to register '" + className + "'", all);
            }
        }
        return registeredSomething;
    }

    public static String getFileExtensionForMimeType(MimeMediaType mimetype) {
        factory.loadProviders();
        return StructuredDocumentFactory.factory.mimeToExt.get(mimetype.getBaseMimeMediaType());
    }

    public static MimeMediaType getMimeTypeForFileExtension(String extension) {
        factory.loadProviders();
        MimeMediaType result = StructuredDocumentFactory.factory.extToMime.get(extension);
        return result;
    }

    public static boolean registerInstantiator(MimeMediaType mimetype, Instantiator instantiator) {
        boolean registered = factory.registerAssoc(mimetype.getBaseMimeMediaType(), instantiator);
        if (registered) {
            Instantiator.ExtensionMapping[] extensions = instantiator.getSupportedFileExtensions();
            for (int eachExt = 0; eachExt < extensions.length; ++eachExt) {
                if (null == extensions[eachExt].getMimeMediaType()) continue;
                StructuredDocumentFactory.factory.extToMime.put(extensions[eachExt].getExtension(), extensions[eachExt].getMimeMediaType().intern());
                StructuredDocumentFactory.factory.mimeToExt.put(extensions[eachExt].getMimeMediaType(), extensions[eachExt].getExtension());
                StructuredDocumentFactory.factory.mimeToExt.put(extensions[eachExt].getMimeMediaType().getBaseMimeMediaType(), extensions[eachExt].getExtension());
            }
        }
        return registered;
    }

    public static StructuredDocument newStructuredDocument(MimeMediaType mimetype, String doctype) {
        factory.loadProviders();
        Instantiator instantiator = (Instantiator)factory.getInstantiator(mimetype.getBaseMimeMediaType());
        return instantiator.newInstance(mimetype, doctype);
    }

    public static StructuredDocument newStructuredDocument(MimeMediaType mimetype, String doctype, String value) {
        factory.loadProviders();
        Instantiator instantiator = (Instantiator)factory.getInstantiator(mimetype.getBaseMimeMediaType());
        return instantiator.newInstance(mimetype, doctype, value);
    }

    public static StructuredDocument newStructuredDocument(MimeMediaType mimetype, InputStream stream) throws IOException {
        factory.loadProviders();
        Instantiator instantiator = (Instantiator)factory.getInstantiator(mimetype.getBaseMimeMediaType());
        return instantiator.newInstance(mimetype, stream);
    }

    public static StructuredDocument newStructuredDocument(MimeMediaType mimetype, Reader reader) throws IOException {
        factory.loadProviders();
        Instantiator instantiator = (Instantiator)factory.getInstantiator(mimetype.getBaseMimeMediaType());
        if (!(instantiator instanceof TextInstantiator)) {
            if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                LOG.warning("Document Class '" + instantiator.getClass().getName() + "' associated with '" + mimetype + "' is not a text oriented document");
            }
            throw new UnsupportedOperationException("Document Class '" + instantiator.getClass().getName() + "' associated with '" + mimetype + "' is not a text oriented document");
        }
        return ((TextInstantiator)instantiator).newInstance(mimetype, reader);
    }

    public static StructuredDocument newStructuredDocument(MessageElement element2) throws IOException {
        factory.loadProviders();
        Instantiator instantiator = (Instantiator)factory.getInstantiator(element2.getMimeType().getBaseMimeMediaType());
        if (instantiator instanceof TextInstantiator && element2 instanceof TextMessageElement) {
            return ((TextInstantiator)instantiator).newInstance(element2.getMimeType(), ((TextMessageElement)element2).getReader());
        }
        return instantiator.newInstance(element2.getMimeType(), element2.getStream());
    }

    public static interface TextInstantiator
    extends Instantiator {
        public StructuredDocument newInstance(MimeMediaType var1, Reader var2) throws IOException;
    }

    public static interface Instantiator {
        public MimeMediaType[] getSupportedMimeTypes();

        public ExtensionMapping[] getSupportedFileExtensions();

        public StructuredDocument newInstance(MimeMediaType var1, String var2);

        public StructuredDocument newInstance(MimeMediaType var1, String var2, String var3);

        public StructuredDocument newInstance(MimeMediaType var1, InputStream var2) throws IOException;

        public static class ExtensionMapping {
            private final String extension;
            private final MimeMediaType mimetype;

            public ExtensionMapping(String extension, MimeMediaType mimetype) {
                this.extension = extension;
                this.mimetype = null != mimetype ? mimetype.intern() : null;
            }

            public boolean equals(Object target) {
                if (this == target) {
                    return true;
                }
                if (target instanceof ExtensionMapping) {
                    ExtensionMapping likeMe = (ExtensionMapping)target;
                    if (!this.extension.equals(likeMe.extension)) {
                        return false;
                    }
                    if (null == this.mimetype && null == likeMe.mimetype) {
                        return true;
                    }
                    if (null == this.mimetype || null == likeMe.mimetype) {
                        return false;
                    }
                    return this.mimetype.equals(likeMe.mimetype);
                }
                return false;
            }

            public int hashCode() {
                int hash = this.extension.hashCode();
                if (null != this.mimetype) {
                    hash ^= this.mimetype.hashCode();
                }
                return hash;
            }

            public String toString() {
                return this.extension + " -> " + (null != this.mimetype ? this.mimetype.toString() : "<null>");
            }

            public String getExtension() {
                return this.extension;
            }

            public MimeMediaType getMimeMediaType() {
                return this.mimetype;
            }
        }
    }
}

