/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.document;

import java.util.Enumeration;
import net.jxta.document.Attributable;
import net.jxta.document.Attribute;
import net.jxta.document.Document;
import net.jxta.document.Element;
import net.jxta.document.StructuredDocument;
import net.jxta.document.StructuredDocumentFactory;

public final class StructuredDocumentUtils {
    private StructuredDocumentUtils() {
    }

    public static void copyChildren(StructuredDocument intoDoc, Element intoElement, Element from) {
        Enumeration eachChild = from.getChildren();
        while (eachChild.hasMoreElements()) {
            Element aChild = (Element)eachChild.nextElement();
            Object newElement = intoDoc.createElement(aChild.getKey(), aChild.getValue());
            intoElement.appendChild(newElement);
            if (aChild instanceof Attributable && newElement instanceof Attributable) {
                Enumeration<Attribute> eachAttrib = ((Attributable)((Object)aChild)).getAttributes();
                while (eachAttrib.hasMoreElements()) {
                    Attribute anAttrib = eachAttrib.nextElement();
                    ((Attributable)newElement).addAttribute(anAttrib.getName(), anAttrib.getValue());
                }
            }
            StructuredDocumentUtils.copyChildren(intoDoc, newElement, aChild);
        }
    }

    public static Element copyElements(StructuredDocument intoDoc, Element intoElement, Element from, Object newName) {
        Object newElement = intoDoc.createElement(newName, from.getValue());
        intoElement.appendChild(newElement);
        boolean hasType = false;
        if (newElement instanceof Attributable) {
            if (from instanceof Attributable) {
                Enumeration<Attribute> eachAttrib = ((Attributable)((Object)from)).getAttributes();
                while (eachAttrib.hasMoreElements()) {
                    Attribute anAttrib = eachAttrib.nextElement();
                    String attribName = anAttrib.getName();
                    if (attribName.equals("type")) {
                        hasType = true;
                    }
                    ((Attributable)newElement).addAttribute(attribName, anAttrib.getValue());
                }
            }
            String origName = from.getKey().toString();
            if (!hasType && !newName.equals(origName) && from instanceof Document) {
                ((Attributable)newElement).addAttribute("type", origName.toString());
            }
        }
        StructuredDocumentUtils.copyChildren(intoDoc, newElement, from);
        return newElement;
    }

    public static Element copyElements(StructuredDocument intoDoc, Element intoElement, Element from) {
        return StructuredDocumentUtils.copyElements(intoDoc, intoElement, from, from.getKey());
    }

    public static StructuredDocument copyAsDocument(Element from) {
        StructuredDocument result;
        Object value = from.getValue();
        if (value == null) {
            result = StructuredDocumentFactory.newStructuredDocument(from.getRoot().getMimeType(), from.getKey().toString());
        } else {
            result = StructuredDocumentFactory.newStructuredDocument(from.getRoot().getMimeType(), from.getKey().toString(), value.toString());
            value = null;
        }
        if (from instanceof Attributable && result instanceof Attributable) {
            Enumeration<Attribute> eachAttrib = ((Attributable)((Object)from)).getAttributes();
            while (eachAttrib.hasMoreElements()) {
                Attribute anAttrib = eachAttrib.nextElement();
                ((Attributable)((Object)result)).addAttribute(anAttrib.getName(), anAttrib.getValue());
            }
        }
        StructuredDocumentUtils.copyChildren(result, result, from);
        return result;
    }
}

