/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.endpoint;

import java.io.IOException;
import java.io.InterruptedIOException;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.Messenger;
import net.jxta.endpoint.OutgoingMessageEvent;
import net.jxta.endpoint.OutgoingMessageEventListener;
import net.jxta.util.AbstractSimpleSelectable;
import net.jxta.util.SimpleSelectable;

public abstract class AbstractMessenger
extends AbstractSimpleSelectable
implements Messenger {
    protected static final long DEFAULT_MTU = Long.parseLong(System.getProperty("net.jxta.MTU", "65536"));
    protected final EndpointAddress dstAddress;
    private Object stateLock;

    public AbstractMessenger(EndpointAddress dest) {
        this.dstAddress = dest;
    }

    public String toString() {
        return super.toString() + " {" + this.dstAddress + "}";
    }

    protected void setStateLock(Object stateLock) {
        this.stateLock = stateLock;
    }

    @Deprecated
    public final boolean isIdle() {
        return false;
    }

    @Deprecated
    public final boolean isSynchronous() {
        return false;
    }

    public final EndpointAddress getDestinationAddress() {
        return this.dstAddress;
    }

    @Deprecated
    public final EndpointAddress getDestinationAddressObject() {
        return this.dstAddress;
    }

    public long getMTU() {
        return DEFAULT_MTU;
    }

    public boolean isClosed() {
        return (this.getState() & 0x3FF) == 0;
    }

    public final void flush() throws IOException {
        int currentState = 0;
        try {
            currentState = this.waitState(458767, 0L);
        }
        catch (InterruptedException ie) {
            InterruptedIOException iio = new InterruptedIOException("flush() interrupted");
            iio.initCause(ie);
            throw iio;
        }
        if ((currentState & 0x403FF) != 0) {
            return;
        }
        throw new IOException("Messenger was unexpectedly closed.");
    }

    public final boolean sendMessage(Message msg) throws IOException {
        return this.sendMessage(msg, null, null);
    }

    public void sendMessage(Message msg, String service, String serviceParam, OutgoingMessageEventListener listener) {
        throw new UnsupportedOperationException("This legacy method is not supported by this messenger.");
    }

    public final boolean sendMessage(Message msg, String rService, String rServiceParam) throws IOException {
        boolean ret = this.sendMessageN(msg, rService, rServiceParam);
        Object failed = msg.getMessageProperty(Messenger.class);
        if (failed == null) {
            return ret;
        }
        if (failed == OutgoingMessageEvent.SUCCESS) {
            return true;
        }
        Throwable throwable = failed instanceof Throwable ? (Throwable)failed : ((OutgoingMessageEvent)failed).getFailure();
        if (throwable == null) {
            return false;
        }
        if (throwable instanceof IOException) {
            throw (IOException)throwable;
        }
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
        IOException failure = new IOException("Failure sending message");
        failure.initCause(throwable);
        throw failure;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int waitState(int wantedStates, long timeout) throws InterruptedException {
        Object object = this.stateLock;
        synchronized (object) {
            long start;
            long end;
            if (timeout == 0L) {
                while ((wantedStates & this.getState()) == 0) {
                    this.stateLock.wait();
                }
                return this.getState();
            }
            if (timeout < 0L) {
                this.stateLock.wait(timeout);
            }
            if ((end = (start = System.currentTimeMillis()) + timeout) < start) {
                end = Long.MAX_VALUE;
            }
            long left = end - start;
            while (left > 0L && (wantedStates & this.getState()) == 0) {
                this.stateLock.wait(left);
                left = end - System.currentTimeMillis();
            }
            return this.getState();
        }
    }

    public void itemChanged(SimpleSelectable changedObject) {
        this.notifyChange();
    }
}

