/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.endpoint;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import net.jxta.endpoint.ChannelMessenger;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.Messenger;
import net.jxta.endpoint.MessengerState;
import net.jxta.endpoint.OutgoingMessageEvent;
import net.jxta.peergroup.PeerGroupID;

public abstract class AsyncChannelMessenger
extends ChannelMessenger {
    private boolean inputClosed = false;
    private boolean outputClosed = false;
    private DeferredAction deferredAction = DeferredAction.ACTION_NONE;
    private final BlockingQueue<PendingMessage> queue;
    private final AsyncChannelMessengerState stateMachine;

    public AsyncChannelMessenger(EndpointAddress baseAddress, PeerGroupID redirection, String origService, String origServiceParam, int queueSize, boolean connected) {
        super(baseAddress, redirection, origService, origServiceParam);
        this.stateMachine = new AsyncChannelMessengerState(connected);
        this.queue = new ArrayBlockingQueue<PendingMessage>(queueSize);
        this.setStateLock(this.stateMachine);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void close() {
        DeferredAction action;
        AsyncChannelMessengerState asyncChannelMessengerState = this.stateMachine;
        synchronized (asyncChannelMessengerState) {
            this.stateMachine.closeEvent();
            action = this.eventCalled(true);
        }
        this.notifyChange();
        this.performDeferredAction(action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean sendMessageCommon(Message msg, String rService, String rServiceParam) throws IOException, InterruptedException {
        String service = this.effectiveService(rService);
        String serviceParam = this.effectiveParam(rService, rServiceParam);
        boolean queued = true;
        boolean change = false;
        DeferredAction action = DeferredAction.ACTION_NONE;
        AsyncChannelMessengerState asyncChannelMessengerState = this.stateMachine;
        synchronized (asyncChannelMessengerState) {
            if (this.inputClosed) {
                throw new IOException("This messenger is closed. It cannot be used to send messages.");
            }
            boolean wasEmpty = this.queue.isEmpty();
            if (this.queue.remainingCapacity() > 1) {
                this.queue.put(new PendingMessage(msg, service, serviceParam));
                if (wasEmpty) {
                    change = true;
                    this.stateMachine.msgsEvent();
                    action = this.eventCalled(false);
                }
            } else if (1 == this.queue.remainingCapacity()) {
                this.queue.put(new PendingMessage(msg, service, serviceParam));
                this.stateMachine.saturatedEvent();
                action = this.eventCalled(false);
                change = true;
            } else {
                queued = false;
            }
        }
        if (queued && change) {
            this.notifyChange();
        }
        this.performDeferredAction(action);
        if ((this.stateMachine.getState() & 0x30) != 0) {
            this.resolPendingImpl();
        }
        return queued;
    }

    public final boolean sendMessageN(Message msg, String rService, String rServiceParam) {
        try {
            if (this.sendMessageCommon(msg, rService, rServiceParam)) {
                return true;
            }
            msg.setMessageProperty(Messenger.class, OutgoingMessageEvent.OVERFLOW);
        }
        catch (IOException oie) {
            msg.setMessageProperty(Messenger.class, new OutgoingMessageEvent(msg, oie));
        }
        catch (InterruptedException interrupted) {
            msg.setMessageProperty(Messenger.class, new OutgoingMessageEvent(msg, interrupted));
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void sendMessageB(Message msg, String rService, String rServiceParam) throws IOException {
        try {
            while (true) {
                if (this.sendMessageCommon(msg, rService, rServiceParam)) {
                    return;
                }
                if (this.queue.isEmpty()) {
                    Thread.yield();
                }
                AsyncChannelMessengerState asyncChannelMessengerState = this.stateMachine;
                synchronized (asyncChannelMessengerState) {
                    this.stateMachine.wait();
                }
            }
        }
        catch (InterruptedException ie) {
            InterruptedIOException iie = new InterruptedIOException("Message send interrupted");
            iie.initCause(ie);
            throw iie;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void resolve() {
        DeferredAction action;
        AsyncChannelMessengerState asyncChannelMessengerState = this.stateMachine;
        synchronized (asyncChannelMessengerState) {
            this.stateMachine.resolveEvent();
            action = this.eventCalled(true);
        }
        this.notifyChange();
        this.performDeferredAction(action);
    }

    public final int getState() {
        return this.stateMachine.getState();
    }

    public final Messenger getChannelMessenger(PeerGroupID redirection, String service, String serviceParam) {
        return null;
    }

    private void performDeferredAction(DeferredAction action) {
        switch (action) {
            case ACTION_SEND: {
                this.startImpl();
                break;
            }
            case ACTION_CONNECT: {
                this.connectImpl();
            }
        }
    }

    private DeferredAction eventCalled(boolean notifyAll) {
        DeferredAction action = this.deferredAction;
        this.deferredAction = DeferredAction.ACTION_NONE;
        if (notifyAll) {
            this.stateMachine.notifyAll();
        } else {
            this.stateMachine.notify();
        }
        return action;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void up() {
        DeferredAction action;
        AsyncChannelMessengerState asyncChannelMessengerState = this.stateMachine;
        synchronized (asyncChannelMessengerState) {
            this.stateMachine.upEvent();
            action = this.eventCalled(true);
        }
        this.notifyChange();
        this.performDeferredAction(action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void down() {
        DeferredAction action;
        AsyncChannelMessengerState asyncChannelMessengerState = this.stateMachine;
        synchronized (asyncChannelMessengerState) {
            this.stateMachine.downEvent();
            action = this.eventCalled(true);
        }
        this.notifyChange();
        this.performDeferredAction(action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PendingMessage peek() {
        PendingMessage theMsg;
        DeferredAction action = DeferredAction.ACTION_NONE;
        AsyncChannelMessengerState asyncChannelMessengerState = this.stateMachine;
        synchronized (asyncChannelMessengerState) {
            theMsg = (PendingMessage)this.queue.peek();
            if (theMsg == null) {
                this.stateMachine.idleEvent();
                action = this.eventCalled(false);
                return null;
            }
            if (this.outputClosed) {
                this.stateMachine.downEvent();
                action = this.eventCalled(true);
                theMsg = null;
            }
        }
        this.notifyChange();
        this.performDeferredAction(action);
        return theMsg;
    }

    protected int size() {
        return this.queue.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean poll() {
        boolean result;
        DeferredAction action;
        AsyncChannelMessengerState asyncChannelMessengerState = this.stateMachine;
        synchronized (asyncChannelMessengerState) {
            this.queue.poll();
            if (this.queue.peek() == null) {
                this.stateMachine.idleEvent();
                action = this.eventCalled(false);
                result = false;
            } else {
                this.stateMachine.msgsEvent();
                action = this.eventCalled(false);
                result = true;
            }
        }
        this.notifyChange();
        this.performDeferredAction(action);
        return result;
    }

    protected abstract void startImpl();

    protected abstract void connectImpl();

    protected abstract void resolPendingImpl();

    protected static class PendingMessage {
        final Message msg;
        final String service;
        final String param;
        Throwable failure;

        PendingMessage(Message msg, String service, String param) {
            this.msg = msg;
            this.service = service;
            this.param = param;
            this.failure = null;
        }
    }

    private class AsyncChannelMessengerState
    extends MessengerState {
        protected AsyncChannelMessengerState(boolean connected) {
            super(connected);
        }

        protected void connectAction() {
            AsyncChannelMessenger.this.deferredAction = DeferredAction.ACTION_CONNECT;
        }

        protected void startAction() {
            AsyncChannelMessenger.this.deferredAction = DeferredAction.ACTION_SEND;
        }

        protected void closeInputAction() {
            AsyncChannelMessenger.this.inputClosed = true;
        }

        protected void closeOutputAction() {
            AsyncChannelMessenger.this.outputClosed = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void failAllAction() {
            while (true) {
                PendingMessage theMsg = null;
                AsyncChannelMessengerState asyncChannelMessengerState = AsyncChannelMessenger.this.stateMachine;
                synchronized (asyncChannelMessengerState) {
                    theMsg = (PendingMessage)AsyncChannelMessenger.this.queue.poll();
                }
                if (theMsg == null) {
                    return;
                }
                Message currentMsg = theMsg.msg;
                Throwable currentFailure = theMsg.failure;
                if (currentFailure == null) {
                    currentFailure = new IOException("Messenger unexpectedly closed");
                }
                OutgoingMessageEvent event = new OutgoingMessageEvent(currentMsg, currentFailure);
                currentMsg.setMessageProperty(Messenger.class, event);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum DeferredAction {
        ACTION_NONE,
        ACTION_SEND,
        ACTION_CONNECT;

    }
}

